% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKR.R
\name{get_modcomp}
\alias{get_modcomp}
\alias{getKR}
\alias{getSAT}
\title{Extract (or "get") components from a \code{KRmodcomp} object.}
\usage{
getKR(
  object,
  name = c("ndf", "ddf", "Fstat", "p.value", "F.scaling", "FstatU", "p.valueU", "aux")
)

getSAT(object, name = c("ndf", "ddf", "Fstat", "p.value"))
}
\arguments{
\item{object}{A \code{KRmodcomp} object, which is the result of the
\code{KRmodcomp} function}

\item{name}{The available slots. If \code{name} is missing or \code{NULL}
then everything is returned.}
}
\description{
Extract (or "get") components from a \code{KRmodcomp} object,
which is the result of the \code{KRmodcomp} function.
}
\examples{

data(beets, package='pbkrtest')
lg <- lmer(sugpct ~ block + sow + harvest + (1|block:harvest), 
              data=beets, REML=FALSE)
sm <- update(lg, .~. - harvest)
modcomp <- KRmodcomp(lg, sm)
getKR(modcomp, "ddf") # get denominator degrees of freedom.


}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
Models - The R Package pbkrtest., Journal of Statistical Software,
58(10), 1-30., \url{https://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{KRmodcomp}}, \code{\link{PBmodcomp}},
\code{\link{vcovAdj}}
}
\author{
Søren Højsgaard \email{sorenh@math.aau.dk}
}
\keyword{utilities}
