% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\docType{class}
\name{MutabilityModel-class}
\alias{MutabilityModel-class}
\alias{MutabilityModel}
\alias{print,MutabilityModel-method}
\alias{MutabilityModel-method}
\alias{as.data.frame,MutabilityModel-method}
\title{S4 class defining a mutability model}
\usage{
\S4method{print}{MutabilityModel}(x)

\S4method{as.data.frame}{MutabilityModel}(x)
}
\arguments{
\item{x}{\code{MutabilityModel} object.}
}
\description{
\code{MutabilityModel} defines a data structure for the 5-mer motif-based SHM targeting
mutability model.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{numeric vector containing 5-mer mutability estimates}

\item{\code{source}}{character vector annotating whether the mutability was
inferred or directly measured.}

\item{\code{numMutS}}{a number indicating the number of silent mutations used for 
estimating mutability}

\item{\code{numMutR}}{a number indicating the number of replacement mutations used 
for estimating mutability}
}}

