## How to update plugins using rkwarddev scripts

Here's a quick-and-dirty summary what you would do after you changed one of these scripts according to your needs. We'll not go into details about `rkwarddev` in general, as that is covered in both the _Introduction to Writing Plugins for RKWard_ and the vignette in the `rkwarddev` package.

### Generally expected behaviour

All scripts use `tempdir()` as the default output directory. Therefore, it should be safe to just run the script an see what happens... the worst case would be it ruins your running session, because when the tempdir is removed when RKWard is closed, at its next start it will automatically remove the no longer existing plugin from its configuration automatically.

If the script completes successfully and uses `rk.plugin.skeleton(..., load=TRUE)`, RKWard should immediately detect the new plugin and try to activate it right away. The new plugin should not conflict with its built-in predecessor, but you will most likely see both plugins at once (i.e., duplicate menu entries), so you should look for your changes to make sure you're testing the right one.

### How to make changes permanent

If you are happy with the new plugin and would like to update the current one with it, just copy the generated files from `$TEMPDIR/$NAME_OF_PLUGIN/inst/rkward/plugins/` to the respective directory below `$RKWARD_SOURCES/rkward/plugins/`. As long as you didn't add new files (i.e., new dialogs), that should do it.

Otherwise, the according pluginmap files must be edited by hand, unfortunately. You can copy the relevant bits from the autogenerated `$TEMPDIR/$NAME_OF_PLUGIN/inst/rkward/$NAME_OF_PLUGIN.pluginmap`, but you should probably adjust some of the generated IDs to fit the usual scheme in RKWard's plugin maps. This step cannot be done automatically.
