
###############################################
# Define procedure for the help panel
###############################################

# Help Panel Bitmaps
#-------------------
createBitmap iraf_logo 45 45 {
0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff,
0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff,
0xff, 0x3f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xf0, 0xff, 0xff, 0xff,
0xff, 0x3f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xe0, 0xff, 0xff, 0xff,
0xff, 0x3f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xc0, 0xff, 0xff, 0xff,
0xff, 0x3f, 0x80, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x80, 0xfc, 0xff, 0xff,
0xff, 0x3f, 0x84, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x84, 0xf4, 0xff, 0xff,
0xff, 0x1b, 0x04, 0x09, 0x00, 0xfc, 0xff, 0x11, 0x04, 0x11, 0xf8, 0xff,
0x7f, 0x10, 0x04, 0x21, 0xc0, 0xff, 0x1f, 0x10, 0x04, 0x41, 0xf0, 0xff,
0x00, 0x18, 0x04, 0x01, 0xe0, 0xff, 0x00, 0x18, 0x00, 0x81, 0xc0, 0xff,
0x00, 0x08, 0x00, 0x01, 0xe0, 0xff, 0x07, 0x08, 0x00, 0x01, 0xf1, 0xff,
0x1f, 0x08, 0x80, 0x21, 0xf0, 0xff, 0xff, 0x08, 0xc0, 0x41, 0xf4, 0xff,
0xff, 0x08, 0xc0, 0x41, 0xf8, 0xff, 0xff, 0x09, 0xc0, 0xc1, 0xf0, 0xff,
0xff, 0x0b, 0x80, 0xc1, 0xf1, 0xff, 0xff, 0x07, 0x80, 0x81, 0xe1, 0xff,
0xff, 0x07, 0x80, 0x01, 0xc1, 0xff, 0xff, 0x07, 0x00, 0x01, 0xc0, 0xff,
0xff, 0x07, 0xc2, 0x05, 0x81, 0xff, 0xff, 0x07, 0xf2, 0x07, 0x81, 0xff,
0xff, 0x07, 0xf2, 0x17, 0x03, 0xff, 0xff, 0x03, 0xfa, 0x7f, 0x02, 0xfe,
0xff, 0x03, 0xfe, 0xff, 0x02, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x03, 0xfc,
0xff, 0x03, 0xff, 0xff, 0x07, 0xfc, 0xff, 0x83, 0xff, 0xff, 0x0f, 0xf8,
0xff, 0xc1, 0xff, 0xff, 0x3f, 0xf0, 0xff, 0xe1, 0xff, 0xff, 0x7f, 0xf8,
0xff, 0xf1, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xe0,
0xff, 0xf8, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xe7,
0xff, 0xfc, 0xff, 0xff, 0xff, 0xef}; send helpIRAFLogo "set bitmap iraf_logo"
 
createBitmap noao_logo 45 45 {
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xfe, 0xff, 0xff,
0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf8, 0xff, 0xff,
0xff, 0xff, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf8, 0xff, 0xff,
0xff, 0x7f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf8, 0xff, 0xff,
0xff, 0xff, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf8, 0xff, 0xff,
0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x03, 0xfe, 0xff, 0xff,
0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff,
0xff, 0xff, 0x03, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x03, 0xfe, 0xff, 0xff,
0xff, 0xff, 0x01, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0xff,
0xff, 0xff, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf0, 0xff, 0xff,
0xff, 0x7f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xe0, 0xff, 0xff,
0xff, 0x3f, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0xff,
0xff, 0x1f, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x80, 0xff, 0xff,
0xff, 0x0f, 0x00, 0x80, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff,
0xff, 0x03, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfe, 0xff,
0xff, 0x01, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x01, 0x00, 0x00, 0xfc, 0xff,
0xff, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0xf8, 0xff,
0x7f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xf0, 0xff,
0x3f, 0x00, 0x00, 0x00, 0xe0, 0xff}; send helpNOAOLogo "set bitmap noao_logo"
  
send helpInfo1 set label $version

# Stuff for keeping track of visited anchors.
set links       { 0 }
set linkIndex     0
set visited(0)  empty

proc Help args \
{
    global help_up
    if {$help_up == 0} {
	send client help
    } else {
	send help_panel unmap
	set help_up 0
    } 
}

proc helpPanel args \
{
    global help_up
    if {$help_up} {
	send help_panel unmap
	set help_up 0
    } else {
	send help_panel map
	set help_up 1
    }
}

proc panelHelp args \
{
    Help
} ; send panelHelp addCallback panelHelp

proc helpQuit args \
{
    global help_up
    send help_panel unmap
    set help_up 0
}; send helpClose addCallback helpQuit

proc getHelpText { param old new } \
{
    send helpText setText $new
    helpPanel
}; send help addCallback getHelpText

proc anchorSelected {widget cbtype event text href args} \
{
    global visited links linkIndex
    set anchID [send helpText anchorToId $href]
    set visited($href) 1
    if {$linkIndex == 0} {
	send helpBack setSensitive True
	if {[lindex $links 1] != $anchID} {
	    set links { 0 }
	    send helpForward setSensitive False
	}
    }
    if {$linkIndex > 0 && [lindex $links [expr $linkIndex + 1]] != $anchID} {
	set links [lrange $links 0 $linkIndex]
    }
    if {[lindex $links [expr $linkIndex + 1]] != $anchID} {
	lappend links $anchID
	incr linkIndex
    } else {
	send helpForward setSensitive False
	incr linkIndex
    }
    if {$linkIndex == [expr [llength $links] - 1]} {
	send helpForward setSensitive False
    }
    send helpText gotoId $anchID
    send helpText retestAnchors
}; send helpText addCallback anchorSelected anchor     

proc testAnchor {widget cbtype href} \
{
    global visited
    return [info exists visited($href)]
}; send helpText addCallback testAnchor testAnchor


# Callbacks to position forwards and backwards in link list.
proc hlpForward args \
{
    global links linkIndex
    incr linkIndex
    if {$linkIndex <= [llength $links]} {
	set anchID [lindex $links $linkIndex]
	send helpText gotoId $anchID
	send helpText retestAnchors
	if {$linkIndex == [expr [llength $links] - 1]} {
	    send helpForward setSensitive False
	    send helpBack setSensitive True
	} else {
	    send helpBack setSensitive True
	}
    } else {
	incr linkIndex -1
    }
}; send helpForward addCallback hlpForward
       
proc hlpBack args \
{
    global links linkIndex
    incr linkIndex -1
    if {$linkIndex >= 0} {
	set anchID [lindex $links $linkIndex]
	send helpText gotoId $anchID
	send helpText retestAnchors
	if {$linkIndex == 0} { send helpBack setSensitive False   }
	if {$linkIndex >= 0} { send helpForward setSensitive True }
    } else {
	incr linkIndex 1
    }
}; send helpBack addCallback hlpBack

proc hlpHome args \
{
    global links linkIndex
    set links { 0 }
    set linkIndex  0
    send helpText gotoId 0
    send helpForward setSensitive False
    send helpBack setSensitive False
}; send helpHome addCallback hlpHome


proc helpFind args \
{
    set phrase  [send hfEntry get string]

    if { $phrase != "" } {
        if {[send helpText searchText $phrase start end forward caseless] > 0} {
            set elid [lindex [lindex $start 0] 0]
            set id   [max 1 [expr $elid - 10] ]
            send helpText gotoId $id
            send helpText setSelection $start $end
        } else {
            send warnText set label "Search string not found."
            send warning map
        }
    } else {
        send warnText set label "Warning: No search phrase entered."
        send warning map
    }
} ; foreach w { hfEntry hfFind } { send $w addCallback helpFind }

send hfClear addCallback { send hfEntry set string "" }

