#if defined(CONFIG_SUPERMOUNT) || defined(CONFIG_SUPERMOUNT_MODULE)

static inline int
supermount_usage_count(kdev_t kdev, int count)
{
	struct block_device *bdev = bdget(kdev_t_to_nr(kdev));

	count -= atomic_read(&bdev->bd_supermount);
	if (count < 0)
		count = 0;
	bdput(bdev);

	return count;
}

static inline int
dev_is_supermounted(kdev_t kdev)
{
	int rc = 0;
	struct block_device *bdev = bdget(kdev_t_to_nr(kdev));

	rc = atomic_read(&bdev->bd_supermount) > 0;
	bdput(bdev);

	return rc;
}

#else

static inline int
supermount_usage_count(kdev_t kdev, int count)
{
	return count;
}

static inline int
dev_is_supermounted(kdev_t kdev)
{
	return 0;
}

#endif /* SUPERMOUNT */
