
# define __REG16(x)	(*((volatile u16 *)IO_ADDRESS(x)))

#define MMC_STR_STP_CLK  __REG16(IMX_MMC_BASE + 0x00)
#define MMC_STATUS       __REG16(IMX_MMC_BASE + 0x04)
#define MMC_CLK_RATE     __REG16(IMX_MMC_BASE + 0x08)
#define MMC_CMD_DAT_CONT __REG16(IMX_MMC_BASE + 0x0C)
#define MMC_RES_TO       __REG16(IMX_MMC_BASE + 0x10)
#define MMC_READ_TO      __REG16(IMX_MMC_BASE + 0x14)
#define MMC_BLK_LEN      __REG16(IMX_MMC_BASE + 0x18)
#define MMC_NOB          __REG16(IMX_MMC_BASE + 0x1C)
#define MMC_REV_NO       __REG16(IMX_MMC_BASE + 0x20)
#define MMC_INT_MASK     __REG16(IMX_MMC_BASE + 0x24)
#define MMC_CMD          __REG16(IMX_MMC_BASE + 0x28)
#define MMC_ARGH         __REG16(IMX_MMC_BASE + 0x2C)
#define MMC_ARGL         __REG16(IMX_MMC_BASE + 0x30)
#define MMC_RES_FIFO     __REG16(IMX_MMC_BASE + 0x34)
#define MMC_BUFFER_ACCESS __REG16(IMX_MMC_BASE + 0x38)
#define MMC_BUFFER_ACCESS_OFS 0x38


#define STR_STP_CLK_ENDIAN              (1<<5)
#define STR_STP_CLK_RESET               (1<<3)
#define STR_STP_CLK_ENABLE              (1<<2)
#define STR_STP_CLK_START_CLK           (1<<1)
#define STR_STP_CLK_STOP_CLK            (1<<0)
#define STATUS_CARD_PRESENCE            (1<<15)
#define STATUS_SDIO_INT_ACTIVE          (1<<14)
#define STATUS_END_CMD_RESP             (1<<13)
#define STATUS_WRITE_OP_DONE            (1<<12)
#define STATUS_DATA_TRANS_DONE          (1<<11)
#define STATUS_WR_CRC_ERROR_CODE_MASK   (3<<10)
#define STATUS_CARD_BUS_CLK_RUN         (1<<8)
#define STATUS_APPL_BUFF_FF             (1<<7)
#define STATUS_APPL_BUFF_FE             (1<<6)
#define STATUS_RESP_CRC_ERR             (1<<5)
#define STATUS_CRC_READ_ERR             (1<<3)
#define STATUS_CRC_WRITE_ERR            (1<<2)
#define STATUS_TIME_OUT_RESP            (1<<1)
#define STATUS_TIME_OUT_READ            (1<<0)
#define STATUS_ERR_MASK                 0x2f
#define CLK_RATE_PRESCALER(x)           ((x) & 0x7)
#define CLK_RATE_CLK_RATE(x)            (((x) & 0x7) << 3)
#define CMD_DAT_CONT_CMD_RESP_LONG_OFF  (1<<12)
#define CMD_DAT_CONT_STOP_READWAIT      (1<<11)
#define CMD_DAT_CONT_START_READWAIT     (1<<10)
#define CMD_DAT_CONT_BUS_WIDTH_1        (0<<8)
#define CMD_DAT_CONT_BUS_WIDTH_4        (2<<8)
#define CMD_DAT_CONT_INIT               (1<<7)
#define CMD_DAT_CONT_BUSY               (1<<6)
#define CMD_DAT_CONT_STREAM_BLOCK       (1<<5)
#define CMD_DAT_CONT_WRITE              (1<<4)
#define CMD_DAT_CONT_DATA_ENABLE        (1<<3)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R1 (1)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R2 (2)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R3 (3)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R4 (4)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R5 (5)
#define CMD_DAT_CONT_RESPONSE_FORMAT_R6 (6)
#define INT_MASK_AUTO_CARD_DETECT       (1<<6)
#define INT_MASK_DAT0_EN                (1<<5)
#define INT_MASK_SDIO                   (1<<4)
#define INT_MASK_BUF_READY              (1<<3)
#define INT_MASK_END_CMD_RES            (1<<2)
#define INT_MASK_WRITE_OP_DONE          (1<<1)
#define INT_MASK_DATA_TRAN              (1<<0)
#define INT_ALL                         (0x7f)
