/*
 * sh7377 processor support - PFC hardware block
 *
 * Copyright (C) 2010  NISHIMOTO Hiroki
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <mach/sh7377.h>

#define CPU_ALL_PORT(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx), PORT_90(fn, pfx, sfx),		\
	PORT_10(fn, pfx##10, sfx),				\
	PORT_1(fn, pfx##110, sfx), PORT_1(fn, pfx##111, sfx),	\
	PORT_1(fn, pfx##112, sfx), PORT_1(fn, pfx##113, sfx),	\
	PORT_1(fn, pfx##114, sfx), PORT_1(fn, pfx##115, sfx),	\
	PORT_1(fn, pfx##116, sfx), PORT_1(fn, pfx##117, sfx),	\
	PORT_1(fn, pfx##118, sfx),				\
	PORT_1(fn, pfx##128, sfx), PORT_1(fn, pfx##129, sfx),	\
	PORT_10(fn, pfx##13, sfx), PORT_10(fn, pfx##14, sfx),	\
	PORT_10(fn, pfx##15, sfx),				\
	PORT_1(fn, pfx##160, sfx), PORT_1(fn, pfx##161, sfx),	\
	PORT_1(fn, pfx##162, sfx), PORT_1(fn, pfx##163, sfx),	\
	PORT_1(fn, pfx##164, sfx),				\
	PORT_1(fn, pfx##192, sfx), PORT_1(fn, pfx##193, sfx),	\
	PORT_1(fn, pfx##194, sfx), PORT_1(fn, pfx##195, sfx),	\
	PORT_1(fn, pfx##196, sfx), PORT_1(fn, pfx##197, sfx),	\
	PORT_1(fn, pfx##198, sfx), PORT_1(fn, pfx##199, sfx),	\
	PORT_10(fn, pfx##20, sfx), PORT_10(fn, pfx##21, sfx),	\
	PORT_10(fn, pfx##22, sfx), PORT_10(fn, pfx##23, sfx),	\
	PORT_10(fn, pfx##24, sfx), PORT_10(fn, pfx##25, sfx),	\
	PORT_1(fn, pfx##260, sfx), PORT_1(fn, pfx##261, sfx),	\
	PORT_1(fn, pfx##262, sfx), PORT_1(fn, pfx##263, sfx),	\
	PORT_1(fn, pfx##264, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PORT_ALL(DATA), /* PORT0_DATA -> PORT264_DATA */
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PORT_ALL(IN), /* PORT0_IN -> PORT264_IN */
	PINMUX_INPUT_END,

	PINMUX_INPUT_PULLUP_BEGIN,
	PORT_ALL(IN_PU), /* PORT0_IN_PU -> PORT264_IN_PU */
	PINMUX_INPUT_PULLUP_END,

	PINMUX_INPUT_PULLDOWN_BEGIN,
	PORT_ALL(IN_PD), /* PORT0_IN_PD -> PORT264_IN_PD */
	PINMUX_INPUT_PULLDOWN_END,

	PINMUX_OUTPUT_BEGIN,
	PORT_ALL(OUT), /* PORT0_OUT -> PORT264_OUT */
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PORT_ALL(FN_IN), /* PORT0_FN_IN -> PORT264_FN_IN */
	PORT_ALL(FN_OUT), /* PORT0_FN_OUT -> PORT264_FN_OUT */
	PORT_ALL(FN0), /* PORT0_FN0 -> PORT264_FN0 */
	PORT_ALL(FN1), /* PORT0_FN1 -> PORT264_FN1 */
	PORT_ALL(FN2), /* PORT0_FN2 -> PORT264_FN2 */
	PORT_ALL(FN3), /* PORT0_FN3 -> PORT264_FN3 */
	PORT_ALL(FN4), /* PORT0_FN4 -> PORT264_FN4 */
	PORT_ALL(FN5), /* PORT0_FN5 -> PORT264_FN5 */
	PORT_ALL(FN6), /* PORT0_FN6 -> PORT264_FN6 */
	PORT_ALL(FN7), /* PORT0_FN7 -> PORT264_FN7 */

	MSELBCR_MSEL17_1, MSELBCR_MSEL17_0,
	MSELBCR_MSEL16_1, MSELBCR_MSEL16_0,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* Special Pull-up / Pull-down Functions */
	PORT66_KEYIN0_PU_MARK, PORT67_KEYIN1_PU_MARK,
	PORT68_KEYIN2_PU_MARK, PORT69_KEYIN3_PU_MARK,
	PORT70_KEYIN4_PU_MARK, PORT71_KEYIN5_PU_MARK,
	PORT72_KEYIN6_PU_MARK,

	/* 55-1 */
	VBUS_0_MARK,
	CPORT0_MARK,
	CPORT1_MARK,
	CPORT2_MARK,
	CPORT3_MARK,
	CPORT4_MARK,
	CPORT5_MARK,
	CPORT6_MARK,
	CPORT7_MARK,
	CPORT8_MARK,
	CPORT9_MARK,
	CPORT10_MARK,
	CPORT11_MARK, SIN2_MARK,
	CPORT12_MARK, XCTS2_MARK,
	CPORT13_MARK, RFSPO4_MARK,
	CPORT14_MARK, RFSPO5_MARK,
	CPORT15_MARK, SCIFA0_SCK_MARK, GPS_AGC2_MARK,
	CPORT16_MARK, SCIFA0_TXD_MARK, GPS_AGC3_MARK,
	CPORT17_IC_OE_MARK, SOUT2_MARK,
	CPORT18_MARK, XRTS2_MARK, PORT19_VIO_CKO2_MARK,
	CPORT19_MPORT1_MARK,
	CPORT20_MARK, RFSPO6_MARK,
	CPORT21_MARK, STATUS0_MARK,
	CPORT22_MARK, STATUS1_MARK,
	CPORT23_MARK, STATUS2_MARK, RFSPO7_MARK,
	B_SYNLD1_MARK,
	B_SYNLD2_MARK, SYSENMSK_MARK,
	XMAINPS_MARK,
	XDIVPS_MARK,
	XIDRST_MARK,
	IDCLK_MARK, IC_DP_MARK,
	IDIO_MARK, IC_DM_MARK,
	SOUT1_MARK, SCIFA4_TXD_MARK, M02_BERDAT_MARK,
	SIN1_MARK, SCIFA4_RXD_MARK, XWUP_MARK,
	XRTS1_MARK, SCIFA4_RTS_MARK, M03_BERCLK_MARK,
	XCTS1_MARK, SCIFA4_CTS_MARK,
	PCMCLKO_MARK,
	SYNC8KO_MARK,

	/* 55-2 */
	DNPCM_A_MARK,
	UPPCM_A_MARK,
	VACK_MARK,
	XTALB1L_MARK,
	GPS_AGC1_MARK, SCIFA0_RTS_MARK,
	GPS_AGC4_MARK, SCIFA0_RXD_MARK,
	GPS_PWRDOWN_MARK, SCIFA0_CTS_MARK,
	GPS_IM_MARK,
	GPS_IS_MARK,
	GPS_QM_MARK,
	GPS_QS_MARK,
	FMSOCK_MARK, PORT49_IRDA_OUT_MARK, PORT49_IROUT_MARK,
	FMSOOLR_MARK, BBIF2_TSYNC2_MARK, TPU2TO2_MARK, IPORT3_MARK,
	FMSIOLR_MARK,
	FMSOOBT_MARK, BBIF2_TSCK2_MARK, TPU2TO3_MARK, OPORT1_MARK,
	FMSIOBT_MARK,
	FMSOSLD_MARK, BBIF2_TXD2_MARK, OPORT2_MARK,
	FMSOILR_MARK, PORT53_IRDA_IN_MARK, TPU3TO3_MARK, OPORT3_MARK,
	FMSIILR_MARK,
	FMSOIBT_MARK, PORT54_IRDA_FIRSEL_MARK, TPU3TO2_MARK, FMSIIBT_MARK,
	FMSISLD_MARK, MFG0_OUT1_MARK, TPU0TO0_MARK,
	A0_EA0_MARK, BS_MARK,
	A12_EA12_MARK, PORT58_VIO_CKOR_MARK, TPU4TO2_MARK,
	A13_EA13_MARK, PORT59_IROUT_MARK, MFG0_OUT2_MARK, TPU0TO1_MARK,
	A14_EA14_MARK, PORT60_KEYOUT5_MARK,
	A15_EA15_MARK, PORT61_KEYOUT4_MARK,
	A16_EA16_MARK, PORT62_KEYOUT3_MARK, MSIOF0_SS1_MARK,
	A17_EA17_MARK, PORT63_KEYOUT2_MARK, MSIOF0_TSYNC_MARK,
	A18_EA18_MARK, PORT64_KEYOUT1_MARK, MSIOF0_TSCK_MARK,
	A19_EA19_MARK, PORT65_KEYOUT0_MARK, MSIOF0_TXD_MARK,
	A20_EA20_MARK, PORT66_KEYIN0_MARK, MSIOF0_RSCK_MARK,
	A21_EA21_MARK, PORT67_KEYIN1_MARK, MSIOF0_RSYNC_MARK,
	A22_EA22_MARK, PORT68_KEYIN2_MARK, MSIOF0_MCK0_MARK,
	A23_EA23_MARK, PORT69_KEYIN3_MARK, MSIOF0_MCK1_MARK,
	A24_EA24_MARK, PORT70_KEYIN4_MARK, MSIOF0_RXD_MARK,
	A25_EA25_MARK, PORT71_KEYIN5_MARK, MSIOF0_SS2_MARK,
	A26_MARK, PORT72_KEYIN6_MARK,
	D0_ED0_NAF0_MARK,
	D1_ED1_NAF1_MARK,
	D2_ED2_NAF2_MARK,
	D3_ED3_NAF3_MARK,
	D4_ED4_NAF4_MARK,
	D5_ED5_NAF5_MARK,
	D6_ED6_NAF6_MARK,
	D7_ED7_NAF7_MARK,
	D8_ED8_NAF8_MARK,
	D9_ED9_NAF9_MARK,
	D10_ED10_NAF10_MARK,
	D11_ED11_NAF11_MARK,
	D12_ED12_NAF12_MARK,
	D13_ED13_NAF13_MARK,
	D14_ED14_NAF14_MARK,
	D15_ED15_NAF15_MARK,
	CS4_MARK,
	CS5A_MARK, FMSICK_MARK,
	CS5B_MARK, FCE1_MARK,

	/* 55-3 */
	CS6B_MARK, XCS2_MARK, CS6A_MARK, DACK0_MARK,
	FCE0_MARK,
	WAIT_MARK, DREQ0_MARK,
	RD_XRD_MARK,
	WE0_XWR0_FWE_MARK,
	WE1_XWR1_MARK,
	FRB_MARK,
	CKO_MARK,
	NBRSTOUT_MARK,
	NBRST_MARK,
	GPS_EPPSIN_MARK,
	LATCHPULSE_MARK,
	LTESIGNAL_MARK,
	LEGACYSTATE_MARK,
	TCKON_MARK,
	VIO_VD_MARK, PORT128_KEYOUT0_MARK, IPORT0_MARK,
	VIO_HD_MARK, PORT129_KEYOUT1_MARK, IPORT1_MARK,
	VIO_D0_MARK, PORT130_KEYOUT2_MARK, PORT130_MSIOF2_RXD_MARK,
	VIO_D1_MARK, PORT131_KEYOUT3_MARK, PORT131_MSIOF2_SS1_MARK,
	VIO_D2_MARK, PORT132_KEYOUT4_MARK, PORT132_MSIOF2_SS2_MARK,
	VIO_D3_MARK, PORT133_KEYOUT5_MARK, PORT133_MSIOF2_TSYNC_MARK,
	VIO_D4_MARK, PORT134_KEYIN0_MARK, PORT134_MSIOF2_TXD_MARK,
	VIO_D5_MARK, PORT135_KEYIN1_MARK, PORT135_MSIOF2_TSCK_MARK,
	VIO_D6_MARK, PORT136_KEYIN2_MARK,
	VIO_D7_MARK, PORT137_KEYIN3_MARK,
	VIO_D8_MARK, M9_SLCD_A01_MARK, PORT138_FSIAOMC_MARK,
	VIO_D9_MARK, M10_SLCD_CK1_MARK, PORT139_FSIAOLR_MARK,
	VIO_D10_MARK, M11_SLCD_SO1_MARK, TPU0TO2_MARK, PORT140_FSIAOBT_MARK,
	VIO_D11_MARK, M12_SLCD_CE1_MARK, TPU0TO3_MARK, PORT141_FSIAOSLD_MARK,
	VIO_D12_MARK, M13_BSW_MARK, PORT142_FSIACK_MARK,
	VIO_D13_MARK, M14_GSW_MARK, PORT143_FSIAILR_MARK,
	VIO_D14_MARK, M15_RSW_MARK, PORT144_FSIAIBT_MARK,
	VIO_D15_MARK, TPU1TO3_MARK, PORT145_FSIAISLD_MARK,
	VIO_CLK_MARK, PORT146_KEYIN4_MARK, IPORT2_MARK,
	VIO_FIELD_MARK, PORT147_KEYIN5_MARK,
	VIO_CKO_MARK, PORT148_KEYIN6_MARK,
	A27_MARK, RDWR_XWE_MARK, MFG0_IN1_MARK,
	MFG0_IN2_MARK,
	TS_SPSYNC3_MARK, MSIOF2_RSCK_MARK,
	TS_SDAT3_MARK, MSIOF2_RSYNC_MARK,
	TPU1TO2_MARK, TS_SDEN3_MARK, PORT153_MSIOF2_SS1_MARK,
	SOUT3_MARK, SCIFA2_TXD1_MARK, MSIOF2_MCK0_MARK,
	SIN3_MARK, SCIFA2_RXD1_MARK, MSIOF2_MCK1_MARK,
	XRTS3_MARK, SCIFA2_RTS1_MARK, PORT156_MSIOF2_SS2_MARK,
	XCTS3_MARK, SCIFA2_CTS1_MARK, PORT157_MSIOF2_RXD_MARK,

	/* 55-4 */
	DINT_MARK, SCIFA2_SCK1_MARK, TS_SCK3_MARK,
	PORT159_SCIFB_SCK_MARK, PORT159_SCIFA5_SCK_MARK, NMI_MARK,
	PORT160_SCIFB_TXD_MARK, PORT160_SCIFA5_TXD_MARK, SOUT0_MARK,
	PORT161_SCIFB_CTS_MARK, PORT161_SCIFA5_CTS_MARK, XCTS0_MARK,
	MFG3_IN2_MARK,
	PORT162_SCIFB_RXD_MARK, PORT162_SCIFA5_RXD_MARK, SIN0_MARK,
	MFG3_IN1_MARK,
	PORT163_SCIFB_RTS_MARK, PORT163_SCIFA5_RTS_MARK, XRTS0_MARK,
	MFG3_OUT1_MARK, TPU3TO0_MARK,
	LCDD0_MARK, PORT192_KEYOUT0_MARK, EXT_CKI_MARK,
	LCDD1_MARK, PORT193_KEYOUT1_MARK, PORT193_SCIFA5_CTS_MARK,
	BBIF2_TSYNC1_MARK,
	LCDD2_MARK, PORT194_KEYOUT2_MARK, PORT194_SCIFA5_RTS_MARK,
	BBIF2_TSCK1_MARK,
	LCDD3_MARK, PORT195_KEYOUT3_MARK, PORT195_SCIFA5_RXD_MARK,
	BBIF2_TXD1_MARK,
	LCDD4_MARK, PORT196_KEYOUT4_MARK, PORT196_SCIFA5_TXD_MARK,
	LCDD5_MARK, PORT197_KEYOUT5_MARK, PORT197_SCIFA5_SCK_MARK,
	MFG2_OUT2_MARK,
	TPU2TO1_MARK,
	LCDD6_MARK, XWR2_MARK,
	LCDD7_MARK, TPU4TO1_MARK, MFG4_OUT2_MARK, XWR3_MARK,
	LCDD8_MARK, PORT200_KEYIN0_MARK, VIO_DR0_MARK, D16_MARK, ED16_MARK,
	LCDD9_MARK, PORT201_KEYIN1_MARK, VIO_DR1_MARK, D17_MARK, ED17_MARK,
	LCDD10_MARK, PORT202_KEYIN2_MARK, VIO_DR2_MARK, D18_MARK, ED18_MARK,
	LCDD11_MARK, PORT203_KEYIN3_MARK, VIO_DR3_MARK, D19_MARK, ED19_MARK,
	LCDD12_MARK, PORT204_KEYIN4_MARK, VIO_DR4_MARK, D20_MARK, ED20_MARK,
	LCDD13_MARK, PORT205_KEYIN5_MARK, VIO_DR5_MARK, D21_MARK, ED21_MARK,
	LCDD14_MARK, PORT206_KEYIN6_MARK, VIO_DR6_MARK, D22_MARK, ED22_MARK,
	LCDD15_MARK, PORT207_MSIOF0L_SS1_MARK, PORT207_KEYOUT0_MARK,
	VIO_DR7_MARK, D23_MARK, ED23_MARK,
	LCDD16_MARK, PORT208_MSIOF0L_SS2_MARK, PORT208_KEYOUT1_MARK,
	VIO_VDR_MARK, D24_MARK, ED24_MARK,
	LCDD17_MARK, PORT209_KEYOUT2_MARK, VIO_HDR_MARK, D25_MARK, ED25_MARK,
	LCDD18_MARK, DREQ2_MARK, PORT210_MSIOF0L_SS1_MARK, D26_MARK, ED26_MARK,
	LCDD19_MARK, PORT211_MSIOF0L_SS2_MARK, D27_MARK, ED27_MARK,
	LCDD20_MARK, TS_SPSYNC1_MARK, MSIOF0L_MCK0_MARK, D28_MARK, ED28_MARK,
	LCDD21_MARK, TS_SDAT1_MARK, MSIOF0L_MCK1_MARK, D29_MARK, ED29_MARK,
	LCDD22_MARK, TS_SDEN1_MARK, MSIOF0L_RSCK_MARK, D30_MARK, ED30_MARK,
	LCDD23_MARK, TS_SCK1_MARK, MSIOF0L_RSYNC_MARK, D31_MARK, ED31_MARK,
	LCDDCK_MARK, LCDWR_MARK, PORT216_KEYOUT3_MARK, VIO_CLKR_MARK,
	LCDRD_MARK, DACK2_MARK, MSIOF0L_TSYNC_MARK,
	LCDHSYN_MARK, LCDCS_MARK, LCDCS2_MARK, DACK3_MARK,
	PORT218_VIO_CKOR_MARK, PORT218_KEYOUT4_MARK,
	LCDDISP_MARK, LCDRS_MARK, DREQ3_MARK, MSIOF0L_TSCK_MARK,
	LCDVSYN_MARK, LCDVSYN2_MARK, PORT220_KEYOUT5_MARK,
	LCDLCLK_MARK, DREQ1_MARK, PWEN_MARK, MSIOF0L_RXD_MARK,
	LCDDON_MARK, LCDDON2_MARK, DACK1_MARK, OVCN_MARK, MSIOF0L_TXD_MARK,
	SCIFA1_TXD_MARK, OVCN2_MARK,
	EXTLP_MARK, SCIFA1_SCK_MARK, USBTERM_MARK, PORT226_VIO_CKO2_MARK,
	SCIFA1_RTS_MARK, IDIN_MARK,
	SCIFA1_RXD_MARK,
	SCIFA1_CTS_MARK, MFG1_IN1_MARK,
	MSIOF1_TXD_MARK, SCIFA2_TXD2_MARK, PORT230_FSIAOMC_MARK,
	MSIOF1_TSYNC_MARK, SCIFA2_CTS2_MARK, PORT231_FSIAOLR_MARK,
	MSIOF1_TSCK_MARK, SCIFA2_SCK2_MARK, PORT232_FSIAOBT_MARK,
	MSIOF1_RXD_MARK, SCIFA2_RXD2_MARK, GPS_VCOTRIG_MARK,
	PORT233_FSIACK_MARK,
	MSIOF1_RSCK_MARK, SCIFA2_RTS2_MARK, PORT234_FSIAOSLD_MARK,
	MSIOF1_RSYNC_MARK, OPORT0_MARK, MFG1_IN2_MARK, PORT235_FSIAILR_MARK,
	MSIOF1_MCK0_MARK, I2C_SDA2_MARK, PORT236_FSIAIBT_MARK,
	MSIOF1_MCK1_MARK, I2C_SCL2_MARK, PORT237_FSIAISLD_MARK,
	MSIOF1_SS1_MARK, EDBGREQ3_MARK,

	/* 55-5 */
	MSIOF1_SS2_MARK,
	SCIFA6_TXD_MARK,
	PORT241_IRDA_OUT_MARK, PORT241_IROUT_MARK, MFG4_OUT1_MARK,
	TPU4TO0_MARK,
	PORT242_IRDA_IN_MARK, MFG4_IN2_MARK,
	PORT243_IRDA_FIRSEL_MARK, PORT243_VIO_CKO2_MARK,
	PORT244_SCIFA5_CTS_MARK, MFG2_IN1_MARK, PORT244_SCIFB_CTS_MARK,
	PORT244_MSIOF2_RXD_MARK,
	PORT245_SCIFA5_RTS_MARK, MFG2_IN2_MARK, PORT245_SCIFB_RTS_MARK,
	PORT245_MSIOF2_TXD_MARK,
	PORT246_SCIFA5_RXD_MARK, MFG1_OUT1_MARK, PORT246_SCIFB_RXD_MARK,
	TPU1TO0_MARK,
	PORT247_SCIFA5_TXD_MARK, MFG3_OUT2_MARK, PORT247_SCIFB_TXD_MARK,
	TPU3TO1_MARK,
	PORT248_SCIFA5_SCK_MARK, MFG2_OUT1_MARK, PORT248_SCIFB_SCK_MARK,
	TPU2TO0_MARK,
	PORT248_MSIOF2_TSCK_MARK,
	PORT249_IROUT_MARK, MFG4_IN1_MARK, PORT249_MSIOF2_TSYNC_MARK,
	SDHICLK0_MARK, TCK2_SWCLK_MC0_MARK,
	SDHICD0_MARK,
	SDHID0_0_MARK, TMS2_SWDIO_MC0_MARK,
	SDHID0_1_MARK, TDO2_SWO0_MC0_MARK,
	SDHID0_2_MARK, TDI2_MARK,
	SDHID0_3_MARK, RTCK2_SWO1_MC0_MARK,
	SDHICMD0_MARK, TRST2_MARK,
	SDHIWP0_MARK, EDBGREQ2_MARK,
	SDHICLK1_MARK, TCK3_SWCLK_MC1_MARK,
	SDHID1_0_MARK, M11_SLCD_SO2_MARK, TS_SPSYNC2_MARK,
	TMS3_SWDIO_MC1_MARK,
	SDHID1_1_MARK, M9_SLCD_A02_MARK, TS_SDAT2_MARK, TDO3_SWO0_MC1_MARK,
	SDHID1_2_MARK, M10_SLCD_CK2_MARK, TS_SDEN2_MARK, TDI3_MARK,
	SDHID1_3_MARK, M12_SLCD_CE2_MARK, TS_SCK2_MARK, RTCK3_SWO1_MC1_MARK,
	SDHICMD1_MARK, TRST3_MARK,
	RESETOUTS_MARK,
	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {
	/* specify valid pin states for each pin in GPIO mode */
	/* 55-1 (GPIO) */
	PORT_DATA_I_PD(0), PORT_DATA_I_PU(1),
	PORT_DATA_I_PU(2), PORT_DATA_I_PU(3),
	PORT_DATA_I_PU(4), PORT_DATA_I_PU(5),
	PORT_DATA_I_PU(6), PORT_DATA_I_PU(7),
	PORT_DATA_I_PU(8), PORT_DATA_I_PU(9),
	PORT_DATA_I_PU(10), PORT_DATA_I_PU(11),
	PORT_DATA_IO_PU(12), PORT_DATA_IO_PU(13),
	PORT_DATA_IO_PU_PD(14), PORT_DATA_IO_PU_PD(15),
	PORT_DATA_O(16), PORT_DATA_IO(17),
	PORT_DATA_O(18), PORT_DATA_O(19),
	PORT_DATA_O(20), PORT_DATA_O(21),
	PORT_DATA_O(22), PORT_DATA_O(23),
	PORT_DATA_O(24), PORT_DATA_I_PD(25),
	PORT_DATA_I_PD(26), PORT_DATA_O(27),
	PORT_DATA_O(28), PORT_DATA_O(29),
	PORT_DATA_IO(30), PORT_DATA_IO_PU(31),
	PORT_DATA_IO_PD(32), PORT_DATA_I_PU(33),
	PORT_DATA_IO_PD(34), PORT_DATA_I_PU_PD(35),
	PORT_DATA_O(36), PORT_DATA_IO(37),

	/* 55-2 (GPIO) */
	PORT_DATA_O(38), PORT_DATA_I_PU(39),
	PORT_DATA_I_PU_PD(40), PORT_DATA_O(41),
	PORT_DATA_IO_PD(42), PORT_DATA_IO_PD(43),
	PORT_DATA_IO_PD(44), PORT_DATA_I_PD(45),
	PORT_DATA_I_PD(46), PORT_DATA_I_PD(47),
	PORT_DATA_I_PD(48), PORT_DATA_IO_PU_PD(49),
	PORT_DATA_IO_PD(50), PORT_DATA_IO_PD(51),
	PORT_DATA_O(52), PORT_DATA_IO_PU_PD(53),
	PORT_DATA_IO_PU_PD(54), PORT_DATA_IO_PD(55),
	PORT_DATA_I_PU_PD(56), PORT_DATA_IO(57),
	PORT_DATA_IO(58), PORT_DATA_IO(59),
	PORT_DATA_IO(60), PORT_DATA_IO(61),
	PORT_DATA_IO_PD(62), PORT_DATA_IO_PD(63),
	PORT_DATA_IO_PD(64), PORT_DATA_IO_PD(65),
	PORT_DATA_IO_PU_PD(66), PORT_DATA_IO_PU_PD(67),
	PORT_DATA_IO_PU_PD(68), PORT_DATA_IO_PU_PD(69),
	PORT_DATA_IO_PU_PD(70), PORT_DATA_IO_PU_PD(71),
	PORT_DATA_IO_PU_PD(72), PORT_DATA_I_PU_PD(73),
	PORT_DATA_IO_PU(74), PORT_DATA_IO_PU(75),
	PORT_DATA_IO_PU(76), PORT_DATA_IO_PU(77),
	PORT_DATA_IO_PU(78), PORT_DATA_IO_PU(79),
	PORT_DATA_IO_PU(80), PORT_DATA_IO_PU(81),
	PORT_DATA_IO_PU(82), PORT_DATA_IO_PU(83),
	PORT_DATA_IO_PU(84), PORT_DATA_IO_PU(85),
	PORT_DATA_IO_PU(86), PORT_DATA_IO_PU(87),
	PORT_DATA_IO_PU(88), PORT_DATA_IO_PU(89),
	PORT_DATA_O(90), PORT_DATA_IO_PU(91),
	PORT_DATA_O(92),

	/* 55-3 (GPIO) */
	PORT_DATA_IO_PU(93),
	PORT_DATA_O(94),
	PORT_DATA_I_PU_PD(95),
	PORT_DATA_IO(96), PORT_DATA_IO(97),
	PORT_DATA_IO(98), PORT_DATA_I_PU(99),
	PORT_DATA_O(100), PORT_DATA_O(101),
	PORT_DATA_I_PU(102), PORT_DATA_IO_PD(103),
	PORT_DATA_I_PD(104), PORT_DATA_I_PD(105),
	PORT_DATA_I_PD(106), PORT_DATA_I_PD(107),
	PORT_DATA_I_PD(108), PORT_DATA_IO_PD(109),
	PORT_DATA_IO_PD(110), PORT_DATA_I_PD(111),
	PORT_DATA_IO_PD(112), PORT_DATA_IO_PD(113),
	PORT_DATA_IO_PD(114), PORT_DATA_I_PD(115),
	PORT_DATA_I_PD(116), PORT_DATA_IO_PD(117),
	PORT_DATA_I_PD(118), PORT_DATA_IO_PD(128),
	PORT_DATA_IO_PD(129), PORT_DATA_IO_PD(130),
	PORT_DATA_IO_PD(131), PORT_DATA_IO_PD(132),
	PORT_DATA_IO_PD(133), PORT_DATA_IO_PU_PD(134),
	PORT_DATA_IO_PU_PD(135), PORT_DATA_IO_PU_PD(136),
	PORT_DATA_IO_PU_PD(137), PORT_DATA_IO_PD(138),
	PORT_DATA_IO_PD(139), PORT_DATA_IO_PD(140),
	PORT_DATA_IO_PD(141), PORT_DATA_IO_PD(142),
	PORT_DATA_IO_PD(143), PORT_DATA_IO_PU_PD(144),
	PORT_DATA_IO_PD(145), PORT_DATA_IO_PU_PD(146),
	PORT_DATA_IO_PU_PD(147), PORT_DATA_IO_PU_PD(148),
	PORT_DATA_IO_PU_PD(149), PORT_DATA_I_PD(150),
	PORT_DATA_IO_PU_PD(151), PORT_DATA_IO_PD(152),
	PORT_DATA_IO_PD(153), PORT_DATA_IO_PD(154),
	PORT_DATA_I_PD(155), PORT_DATA_IO_PU_PD(156),
	PORT_DATA_I_PD(157), PORT_DATA_IO_PD(158),

	/* 55-4 (GPIO) */
	PORT_DATA_IO_PU_PD(159), PORT_DATA_IO_PU_PD(160),
	PORT_DATA_I_PU_PD(161), PORT_DATA_I_PU_PD(162),
	PORT_DATA_IO_PU_PD(163), PORT_DATA_I_PU_PD(164),
	PORT_DATA_IO_PD(192), PORT_DATA_IO_PD(193),
	PORT_DATA_IO_PD(194), PORT_DATA_IO_PD(195),
	PORT_DATA_IO_PD(196), PORT_DATA_IO_PD(197),
	PORT_DATA_IO_PD(198), PORT_DATA_IO_PD(199),
	PORT_DATA_IO_PU_PD(200), PORT_DATA_IO_PU_PD(201),
	PORT_DATA_IO_PU_PD(202), PORT_DATA_IO_PU_PD(203),
	PORT_DATA_IO_PU_PD(204), PORT_DATA_IO_PU_PD(205),
	PORT_DATA_IO_PU_PD(206), PORT_DATA_IO_PD(207),
	PORT_DATA_IO_PD(208), PORT_DATA_IO_PD(209),
	PORT_DATA_IO_PD(210), PORT_DATA_IO_PD(211),
	PORT_DATA_IO_PD(212), PORT_DATA_IO_PD(213),
	PORT_DATA_IO_PD(214), PORT_DATA_IO_PD(215),
	PORT_DATA_IO_PD(216), PORT_DATA_IO_PD(217),
	PORT_DATA_O(218), PORT_DATA_IO_PD(219),
	PORT_DATA_IO_PD(220), PORT_DATA_IO_PD(221),
	PORT_DATA_IO_PU_PD(222),
	PORT_DATA_I_PU_PD(223), PORT_DATA_I_PU_PD(224),
	PORT_DATA_IO_PU_PD(225), PORT_DATA_O(226),
	PORT_DATA_IO_PU_PD(227), PORT_DATA_I_PD(228),
	PORT_DATA_I_PD(229), PORT_DATA_IO(230),
	PORT_DATA_IO_PD(231), PORT_DATA_IO_PU_PD(232),
	PORT_DATA_I_PD(233), PORT_DATA_IO_PU_PD(234),
	PORT_DATA_IO_PU_PD(235), PORT_DATA_IO_PU_PD(236),
	PORT_DATA_IO_PD(237), PORT_DATA_IO_PU_PD(238),

	/* 55-5 (GPIO) */
	PORT_DATA_IO_PU_PD(239), PORT_DATA_IO_PU_PD(240),
	PORT_DATA_O(241), PORT_DATA_I_PD(242),
	PORT_DATA_IO_PU_PD(243), PORT_DATA_IO_PU_PD(244),
	PORT_DATA_IO_PU_PD(245), PORT_DATA_IO_PU_PD(246),
	PORT_DATA_IO_PU_PD(247), PORT_DATA_IO_PU_PD(248),
	PORT_DATA_IO_PU_PD(249), PORT_DATA_IO_PD(250),
	PORT_DATA_IO_PU_PD(251), PORT_DATA_IO_PU_PD(252),
	PORT_DATA_IO_PU_PD(253), PORT_DATA_IO_PU_PD(254),
	PORT_DATA_IO_PU_PD(255), PORT_DATA_IO_PU_PD(256),
	PORT_DATA_IO_PU_PD(257), PORT_DATA_IO_PD(258),
	PORT_DATA_IO_PU_PD(259), PORT_DATA_IO_PU_PD(260),
	PORT_DATA_IO_PU_PD(261), PORT_DATA_IO_PU_PD(262),
	PORT_DATA_IO_PU_PD(263),

	/* Special Pull-up / Pull-down Functions */
	PINMUX_DATA(PORT66_KEYIN0_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT66_FN2, PORT66_IN_PU),
	PINMUX_DATA(PORT67_KEYIN1_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT67_FN2, PORT67_IN_PU),
	PINMUX_DATA(PORT68_KEYIN2_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT68_FN2, PORT68_IN_PU),
	PINMUX_DATA(PORT69_KEYIN3_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT69_FN2, PORT69_IN_PU),
	PINMUX_DATA(PORT70_KEYIN4_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT70_FN2, PORT70_IN_PU),
	PINMUX_DATA(PORT71_KEYIN5_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT71_FN2, PORT71_IN_PU),
	PINMUX_DATA(PORT72_KEYIN6_PU_MARK, MSELBCR_MSEL17_0, MSELBCR_MSEL16_0,
				PORT72_FN2, PORT72_IN_PU),


	/* 55-1 (FN) */
	PINMUX_DATA(VBUS_0_MARK, PORT0_FN1),
	PINMUX_DATA(CPORT0_MARK, PORT1_FN1),
	PINMUX_DATA(CPORT1_MARK, PORT2_FN1),
	PINMUX_DATA(CPORT2_MARK, PORT3_FN1),
	PINMUX_DATA(CPORT3_MARK, PORT4_FN1),
	PINMUX_DATA(CPORT4_MARK, PORT5_FN1),
	PINMUX_DATA(CPORT5_MARK, PORT6_FN1),
	PINMUX_DATA(CPORT6_MARK, PORT7_FN1),
	PINMUX_DATA(CPORT7_MARK, PORT8_FN1),
	PINMUX_DATA(CPORT8_MARK, PORT9_FN1),
	PINMUX_DATA(CPORT9_MARK, PORT10_FN1),
	PINMUX_DATA(CPORT10_MARK, PORT11_FN1),
	PINMUX_DATA(CPORT11_MARK, PORT12_FN1),
	PINMUX_DATA(SIN2_MARK, PORT12_FN2),
	PINMUX_DATA(CPORT12_MARK, PORT13_FN1),
	PINMUX_DATA(XCTS2_MARK, PORT13_FN2),
	PINMUX_DATA(CPORT13_MARK, PORT14_FN1),
	PINMUX_DATA(RFSPO4_MARK, PORT14_FN2),
	PINMUX_DATA(CPORT14_MARK, PORT15_FN1),
	PINMUX_DATA(RFSPO5_MARK, PORT15_FN2),
	PINMUX_DATA(CPORT15_MARK, PORT16_FN1),
	PINMUX_DATA(SCIFA0_SCK_MARK, PORT16_FN2),
	PINMUX_DATA(GPS_AGC2_MARK, PORT16_FN3),
	PINMUX_DATA(CPORT16_MARK, PORT17_FN1),
	PINMUX_DATA(SCIFA0_TXD_MARK, PORT17_FN2),
	PINMUX_DATA(GPS_AGC3_MARK, PORT17_FN3),
	PINMUX_DATA(CPORT17_IC_OE_MARK, PORT18_FN1),
	PINMUX_DATA(SOUT2_MARK, PORT18_FN2),
	PINMUX_DATA(CPORT18_MARK, PORT19_FN1),
	PINMUX_DATA(XRTS2_MARK, PORT19_FN2),
	PINMUX_DATA(PORT19_VIO_CKO2_MARK, PORT19_FN3),
	PINMUX_DATA(CPORT19_MPORT1_MARK, PORT20_FN1),
	PINMUX_DATA(CPORT20_MARK, PORT21_FN1),
	PINMUX_DATA(RFSPO6_MARK, PORT21_FN2),
	PINMUX_DATA(CPORT21_MARK, PORT22_FN1),
	PINMUX_DATA(STATUS0_MARK, PORT22_FN2),
	PINMUX_DATA(CPORT22_MARK, PORT23_FN1),
	PINMUX_DATA(STATUS1_MARK, PORT23_FN2),
	PINMUX_DATA(CPORT23_MARK, PORT24_FN1),
	PINMUX_DATA(STATUS2_MARK, PORT24_FN2),
	PINMUX_DATA(RFSPO7_MARK, PORT24_FN3),
	PINMUX_DATA(B_SYNLD1_MARK, PORT25_FN1),
	PINMUX_DATA(B_SYNLD2_MARK, PORT26_FN1),
	PINMUX_DATA(SYSENMSK_MARK, PORT26_FN2),
	PINMUX_DATA(XMAINPS_MARK, PORT27_FN1),
	PINMUX_DATA(XDIVPS_MARK, PORT28_FN1),
	PINMUX_DATA(XIDRST_MARK, PORT29_FN1),
	PINMUX_DATA(IDCLK_MARK, PORT30_FN1),
	PINMUX_DATA(IC_DP_MARK, PORT30_FN2),
	PINMUX_DATA(IDIO_MARK, PORT31_FN1),
	PINMUX_DATA(IC_DM_MARK, PORT31_FN2),
	PINMUX_DATA(SOUT1_MARK, PORT32_FN1),
	PINMUX_DATA(SCIFA4_TXD_MARK, PORT32_FN2),
	PINMUX_DATA(M02_BERDAT_MARK, PORT32_FN3),
	PINMUX_DATA(SIN1_MARK, PORT33_FN1),
	PINMUX_DATA(SCIFA4_RXD_MARK, PORT33_FN2),
	PINMUX_DATA(XWUP_MARK, PORT33_FN3),
	PINMUX_DATA(XRTS1_MARK, PORT34_FN1),
	PINMUX_DATA(SCIFA4_RTS_MARK, PORT34_FN2),
	PINMUX_DATA(M03_BERCLK_MARK, PORT34_FN3),
	PINMUX_DATA(XCTS1_MARK, PORT35_FN1),
	PINMUX_DATA(SCIFA4_CTS_MARK, PORT35_FN2),
	PINMUX_DATA(PCMCLKO_MARK, PORT36_FN1),
	PINMUX_DATA(SYNC8KO_MARK, PORT37_FN1),

	/* 55-2 (FN) */
	PINMUX_DATA(DNPCM_A_MARK, PORT38_FN1),
	PINMUX_DATA(UPPCM_A_MARK, PORT39_FN1),
	PINMUX_DATA(VACK_MARK, PORT40_FN1),
	PINMUX_DATA(XTALB1L_MARK, PORT41_FN1),
	PINMUX_DATA(GPS_AGC1_MARK, PORT42_FN1),
	PINMUX_DATA(SCIFA0_RTS_MARK, PORT42_FN2),
	PINMUX_DATA(GPS_AGC4_MARK, PORT43_FN1),
	PINMUX_DATA(SCIFA0_RXD_MARK, PORT43_FN2),
	PINMUX_DATA(GPS_PWRDOWN_MARK, PORT44_FN1),
	PINMUX_DATA(SCIFA0_CTS_MARK, PORT44_FN2),
	PINMUX_DATA(GPS_IM_MARK, PORT45_FN1),
	PINMUX_DATA(GPS_IS_MARK, PORT46_FN1),
	PINMUX_DATA(GPS_QM_MARK, PORT47_FN1),
	PINMUX_DATA(GPS_QS_MARK, PORT48_FN1),
	PINMUX_DATA(FMSOCK_MARK, PORT49_FN1),
	PINMUX_DATA(PORT49_IRDA_OUT_MARK, PORT49_FN2),
	PINMUX_DATA(PORT49_IROUT_MARK, PORT49_FN3),
	PINMUX_DATA(FMSOOLR_MARK, PORT50_FN1),
	PINMUX_DATA(BBIF2_TSYNC2_MARK, PORT50_FN2),
	PINMUX_DATA(TPU2TO2_MARK, PORT50_FN3),
	PINMUX_DATA(IPORT3_MARK, PORT50_FN4),
	PINMUX_DATA(FMSIOLR_MARK, PORT50_FN5),
	PINMUX_DATA(FMSOOBT_MARK, PORT51_FN1),
	PINMUX_DATA(BBIF2_TSCK2_MARK, PORT51_FN2),
	PINMUX_DATA(TPU2TO3_MARK, PORT51_FN3),
	PINMUX_DATA(OPORT1_MARK, PORT51_FN4),
	PINMUX_DATA(FMSIOBT_MARK, PORT51_FN5),
	PINMUX_DATA(FMSOSLD_MARK, PORT52_FN1),
	PINMUX_DATA(BBIF2_TXD2_MARK, PORT52_FN2),
	PINMUX_DATA(OPORT2_MARK, PORT52_FN3),
	PINMUX_DATA(FMSOILR_MARK, PORT53_FN1),
	PINMUX_DATA(PORT53_IRDA_IN_MARK, PORT53_FN2),
	PINMUX_DATA(TPU3TO3_MARK, PORT53_FN3),
	PINMUX_DATA(OPORT3_MARK, PORT53_FN4),
	PINMUX_DATA(FMSIILR_MARK, PORT53_FN5),
	PINMUX_DATA(FMSOIBT_MARK, PORT54_FN1),
	PINMUX_DATA(PORT54_IRDA_FIRSEL_MARK, PORT54_FN2),
	PINMUX_DATA(TPU3TO2_MARK, PORT54_FN3),
	PINMUX_DATA(FMSIIBT_MARK, PORT54_FN4),
	PINMUX_DATA(FMSISLD_MARK, PORT55_FN1),
	PINMUX_DATA(MFG0_OUT1_MARK, PORT55_FN2),
	PINMUX_DATA(TPU0TO0_MARK, PORT55_FN3),
	PINMUX_DATA(A0_EA0_MARK, PORT57_FN1),
	PINMUX_DATA(BS_MARK, PORT57_FN2),
	PINMUX_DATA(A12_EA12_MARK, PORT58_FN1),
	PINMUX_DATA(PORT58_VIO_CKOR_MARK, PORT58_FN2),
	PINMUX_DATA(TPU4TO2_MARK, PORT58_FN3),
	PINMUX_DATA(A13_EA13_MARK, PORT59_FN1),
	PINMUX_DATA(PORT59_IROUT_MARK, PORT59_FN2),
	PINMUX_DATA(MFG0_OUT2_MARK, PORT59_FN3),
	PINMUX_DATA(TPU0TO1_MARK, PORT59_FN4),
	PINMUX_DATA(A14_EA14_MARK, PORT60_FN1),
	PINMUX_DATA(PORT60_KEYOUT5_MARK, PORT60_FN2),
	PINMUX_DATA(A15_EA15_MARK, PORT61_FN1),
	PINMUX_DATA(PORT61_KEYOUT4_MARK, PORT61_FN2),
	PINMUX_DATA(A16_EA16_MARK, PORT62_FN1),
	PINMUX_DATA(PORT62_KEYOUT3_MARK, PORT62_FN2),
	PINMUX_DATA(MSIOF0_SS1_MARK, PORT62_FN3),
	PINMUX_DATA(A17_EA17_MARK, PORT63_FN1),
	PINMUX_DATA(PORT63_KEYOUT2_MARK, PORT63_FN2),
	PINMUX_DATA(MSIOF0_TSYNC_MARK, PORT63_FN3),
	PINMUX_DATA(A18_EA18_MARK, PORT64_FN1),
	PINMUX_DATA(PORT64_KEYOUT1_MARK, PORT64_FN2),
	PINMUX_DATA(MSIOF0_TSCK_MARK, PORT64_FN3),
	PINMUX_DATA(A19_EA19_MARK, PORT65_FN1),
	PINMUX_DATA(PORT65_KEYOUT0_MARK, PORT65_FN2),
	PINMUX_DATA(MSIOF0_TXD_MARK, PORT65_FN3),
	PINMUX_DATA(A20_EA20_MARK, PORT66_FN1),
	PINMUX_DATA(PORT66_KEYIN0_MARK, PORT66_FN2),
	PINMUX_DATA(MSIOF0_RSCK_MARK, PORT66_FN3),
	PINMUX_DATA(A21_EA21_MARK, PORT67_FN1),
	PINMUX_DATA(PORT67_KEYIN1_MARK, PORT67_FN2),
	PINMUX_DATA(MSIOF0_RSYNC_MARK, PORT67_FN3),
	PINMUX_DATA(A22_EA22_MARK, PORT68_FN1),
	PINMUX_DATA(PORT68_KEYIN2_MARK, PORT68_FN2),
	PINMUX_DATA(MSIOF0_MCK0_MARK, PORT68_FN3),
	PINMUX_DATA(A23_EA23_MARK, PORT69_FN1),
	PINMUX_DATA(PORT69_KEYIN3_MARK, PORT69_FN2),
	PINMUX_DATA(MSIOF0_MCK1_MARK, PORT69_FN3),
	PINMUX_DATA(A24_EA24_MARK, PORT70_FN1),
	PINMUX_DATA(PORT70_KEYIN4_MARK, PORT70_FN2),
	PINMUX_DATA(MSIOF0_RXD_MARK, PORT70_FN3),
	PINMUX_DATA(A25_EA25_MARK, PORT71_FN1),
	PINMUX_DATA(PORT71_KEYIN5_MARK, PORT71_FN2),
	PINMUX_DATA(MSIOF0_SS2_MARK, PORT71_FN3),
	PINMUX_DATA(A26_MARK, PORT72_FN1),
	PINMUX_DATA(PORT72_KEYIN6_MARK, PORT72_FN2),
	PINMUX_DATA(D0_ED0_NAF0_MARK, PORT74_FN1),
	PINMUX_DATA(D1_ED1_NAF1_MARK, PORT75_FN1),
	PINMUX_DATA(D2_ED2_NAF2_MARK, PORT76_FN1),
	PINMUX_DATA(D3_ED3_NAF3_MARK, PORT77_FN1),
	PINMUX_DATA(D4_ED4_NAF4_MARK, PORT78_FN1),
	PINMUX_DATA(D5_ED5_NAF5_MARK, PORT79_FN1),
	PINMUX_DATA(D6_ED6_NAF6_MARK, PORT80_FN1),
	PINMUX_DATA(D7_ED7_NAF7_MARK, PORT81_FN1),
	PINMUX_DATA(D8_ED8_NAF8_MARK, PORT82_FN1),
	PINMUX_DATA(D9_ED9_NAF9_MARK, PORT83_FN1),
	PINMUX_DATA(D10_ED10_NAF10_MARK, PORT84_FN1),
	PINMUX_DATA(D11_ED11_NAF11_MARK, PORT85_FN1),
	PINMUX_DATA(D12_ED12_NAF12_MARK, PORT86_FN1),
	PINMUX_DATA(D13_ED13_NAF13_MARK, PORT87_FN1),
	PINMUX_DATA(D14_ED14_NAF14_MARK, PORT88_FN1),
	PINMUX_DATA(D15_ED15_NAF15_MARK, PORT89_FN1),
	PINMUX_DATA(CS4_MARK, PORT90_FN1),
	PINMUX_DATA(CS5A_MARK, PORT91_FN1),
	PINMUX_DATA(FMSICK_MARK, PORT91_FN2),
	PINMUX_DATA(CS5B_MARK, PORT92_FN1),
	PINMUX_DATA(FCE1_MARK, PORT92_FN2),

	/* 55-3 (FN) */
	PINMUX_DATA(CS6B_MARK, PORT93_FN1),
	PINMUX_DATA(XCS2_MARK, PORT93_FN2),
	PINMUX_DATA(CS6A_MARK, PORT93_FN3),
	PINMUX_DATA(DACK0_MARK, PORT93_FN4),
	PINMUX_DATA(FCE0_MARK, PORT94_FN1),
	PINMUX_DATA(WAIT_MARK, PORT95_FN1),
	PINMUX_DATA(DREQ0_MARK, PORT95_FN2),
	PINMUX_DATA(RD_XRD_MARK, PORT96_FN1),
	PINMUX_DATA(WE0_XWR0_FWE_MARK, PORT97_FN1),
	PINMUX_DATA(WE1_XWR1_MARK, PORT98_FN1),
	PINMUX_DATA(FRB_MARK, PORT99_FN1),
	PINMUX_DATA(CKO_MARK, PORT100_FN1),
	PINMUX_DATA(NBRSTOUT_MARK, PORT101_FN1),
	PINMUX_DATA(NBRST_MARK, PORT102_FN1),
	PINMUX_DATA(GPS_EPPSIN_MARK, PORT106_FN1),
	PINMUX_DATA(LATCHPULSE_MARK, PORT110_FN1),
	PINMUX_DATA(LTESIGNAL_MARK, PORT111_FN1),
	PINMUX_DATA(LEGACYSTATE_MARK, PORT112_FN1),
	PINMUX_DATA(TCKON_MARK, PORT118_FN1),
	PINMUX_DATA(VIO_VD_MARK, PORT128_FN1),
	PINMUX_DATA(PORT128_KEYOUT0_MARK, PORT128_FN2),
	PINMUX_DATA(IPORT0_MARK, PORT128_FN3),
	PINMUX_DATA(VIO_HD_MARK, PORT129_FN1),
	PINMUX_DATA(PORT129_KEYOUT1_MARK, PORT129_FN2),
	PINMUX_DATA(IPORT1_MARK, PORT129_FN3),
	PINMUX_DATA(VIO_D0_MARK, PORT130_FN1),
	PINMUX_DATA(PORT130_KEYOUT2_MARK, PORT130_FN2),
	PINMUX_DATA(PORT130_MSIOF2_RXD_MARK, PORT130_FN3),
	PINMUX_DATA(VIO_D1_MARK, PORT131_FN1),
	PINMUX_DATA(PORT131_KEYOUT3_MARK, PORT131_FN2),
	PINMUX_DATA(PORT131_MSIOF2_SS1_MARK, PORT131_FN3),
	PINMUX_DATA(VIO_D2_MARK, PORT132_FN1),
	PINMUX_DATA(PORT132_KEYOUT4_MARK, PORT132_FN2),
	PINMUX_DATA(PORT132_MSIOF2_SS2_MARK, PORT132_FN3),
	PINMUX_DATA(VIO_D3_MARK, PORT133_FN1),
	PINMUX_DATA(PORT133_KEYOUT5_MARK, PORT133_FN2),
	PINMUX_DATA(PORT133_MSIOF2_TSYNC_MARK, PORT133_FN3),
	PINMUX_DATA(VIO_D4_MARK, PORT134_FN1),
	PINMUX_DATA(PORT134_KEYIN0_MARK, PORT134_FN2),
	PINMUX_DATA(PORT134_MSIOF2_TXD_MARK, PORT134_FN3),
	PINMUX_DATA(VIO_D5_MARK, PORT135_FN1),
	PINMUX_DATA(PORT135_KEYIN1_MARK, PORT135_FN2),
	PINMUX_DATA(PORT135_MSIOF2_TSCK_MARK, PORT135_FN3),
	PINMUX_DATA(VIO_D6_MARK, PORT136_FN1),
	PINMUX_DATA(PORT136_KEYIN2_MARK, PORT136_FN2),
	PINMUX_DATA(VIO_D7_MARK, PORT137_FN1),
	PINMUX_DATA(PORT137_KEYIN3_MARK, PORT137_FN2),
	PINMUX_DATA(VIO_D8_MARK, PORT138_FN1),
	PINMUX_DATA(M9_SLCD_A01_MARK, PORT138_FN2),
	PINMUX_DATA(PORT138_FSIAOMC_MARK, PORT138_FN3),
	PINMUX_DATA(VIO_D9_MARK, PORT139_FN1),
	PINMUX_DATA(M10_SLCD_CK1_MARK, PORT139_FN2),
	PINMUX_DATA(PORT139_FSIAOLR_MARK, PORT139_FN3),
	PINMUX_DATA(VIO_D10_MARK, PORT140_FN1),
	PINMUX_DATA(M11_SLCD_SO1_MARK, PORT140_FN2),
	PINMUX_DATA(TPU0TO2_MARK, PORT140_FN3),
	PINMUX_DATA(PORT140_FSIAOBT_MARK, PORT140_FN4),
	PINMUX_DATA(VIO_D11_MARK, PORT141_FN1),
	PINMUX_DATA(M12_SLCD_CE1_MARK, PORT141_FN2),
	PINMUX_DATA(TPU0TO3_MARK, PORT141_FN3),
	PINMUX_DATA(PORT141_FSIAOSLD_MARK, PORT141_FN4),
	PINMUX_DATA(VIO_D12_MARK, PORT142_FN1),
	PINMUX_DATA(M13_BSW_MARK, PORT142_FN2),
	PINMUX_DATA(PORT142_FSIACK_MARK, PORT142_FN3),
	PINMUX_DATA(VIO_D13_MARK, PORT143_FN1),
	PINMUX_DATA(M14_GSW_MARK, PORT143_FN2),
	PINMUX_DATA(PORT143_FSIAILR_MARK, PORT143_FN3),
	PINMUX_DATA(VIO_D14_MARK, PORT144_FN1),
	PINMUX_DATA(M15_RSW_MARK, PORT144_FN2),
	PINMUX_DATA(PORT144_FSIAIBT_MARK, PORT144_FN3),
	PINMUX_DATA(VIO_D15_MARK, PORT145_FN1),
	PINMUX_DATA(TPU1TO3_MARK, PORT145_FN2),
	PINMUX_DATA(PORT145_FSIAISLD_MARK, PORT145_FN3),
	PINMUX_DATA(VIO_CLK_MARK, PORT146_FN1),
	PINMUX_DATA(PORT146_KEYIN4_MARK, PORT146_FN2),
	PINMUX_DATA(IPORT2_MARK, PORT146_FN3),
	PINMUX_DATA(VIO_FIELD_MARK, PORT147_FN1),
	PINMUX_DATA(PORT147_KEYIN5_MARK, PORT147_FN2),
	PINMUX_DATA(VIO_CKO_MARK, PORT148_FN1),
	PINMUX_DATA(PORT148_KEYIN6_MARK, PORT148_FN2),
	PINMUX_DATA(A27_MARK, PORT149_FN1),
	PINMUX_DATA(RDWR_XWE_MARK, PORT149_FN2),
	PINMUX_DATA(MFG0_IN1_MARK, PORT149_FN3),
	PINMUX_DATA(MFG0_IN2_MARK, PORT150_FN1),
	PINMUX_DATA(TS_SPSYNC3_MARK, PORT151_FN1),
	PINMUX_DATA(MSIOF2_RSCK_MARK, PORT151_FN2),
	PINMUX_DATA(TS_SDAT3_MARK, PORT152_FN1),
	PINMUX_DATA(MSIOF2_RSYNC_MARK, PORT152_FN2),
	PINMUX_DATA(TPU1TO2_MARK, PORT153_FN1),
	PINMUX_DATA(TS_SDEN3_MARK, PORT153_FN2),
	PINMUX_DATA(PORT153_MSIOF2_SS1_MARK, PORT153_FN3),
	PINMUX_DATA(SOUT3_MARK, PORT154_FN1),
	PINMUX_DATA(SCIFA2_TXD1_MARK, PORT154_FN2),
	PINMUX_DATA(MSIOF2_MCK0_MARK, PORT154_FN3),
	PINMUX_DATA(SIN3_MARK, PORT155_FN1),
	PINMUX_DATA(SCIFA2_RXD1_MARK, PORT155_FN2),
	PINMUX_DATA(MSIOF2_MCK1_MARK, PORT155_FN3),
	PINMUX_DATA(XRTS3_MARK, PORT156_FN1),
	PINMUX_DATA(SCIFA2_RTS1_MARK, PORT156_FN2),
	PINMUX_DATA(PORT156_MSIOF2_SS2_MARK, PORT156_FN3),
	PINMUX_DATA(XCTS3_MARK, PORT157_FN1),
	PINMUX_DATA(SCIFA2_CTS1_MARK, PORT157_FN2),
	PINMUX_DATA(PORT157_MSIOF2_RXD_MARK, PORT157_FN3),

	/* 55-4 (FN) */
	PINMUX_DATA(DINT_MARK, PORT158_FN1),
	PINMUX_DATA(SCIFA2_SCK1_MARK, PORT158_FN2),
	PINMUX_DATA(TS_SCK3_MARK, PORT158_FN3),
	PINMUX_DATA(PORT159_SCIFB_SCK_MARK, PORT159_FN1),
	PINMUX_DATA(PORT159_SCIFA5_SCK_MARK, PORT159_FN2),
	PINMUX_DATA(NMI_MARK, PORT159_FN3),
	PINMUX_DATA(PORT160_SCIFB_TXD_MARK, PORT160_FN1),
	PINMUX_DATA(PORT160_SCIFA5_TXD_MARK, PORT160_FN2),
	PINMUX_DATA(SOUT0_MARK, PORT160_FN3),
	PINMUX_DATA(PORT161_SCIFB_CTS_MARK, PORT161_FN1),
	PINMUX_DATA(PORT161_SCIFA5_CTS_MARK, PORT161_FN2),
	PINMUX_DATA(XCTS0_MARK, PORT161_FN3),
	PINMUX_DATA(MFG3_IN2_MARK, PORT161_FN4),
	PINMUX_DATA(PORT162_SCIFB_RXD_MARK, PORT162_FN1),
	PINMUX_DATA(PORT162_SCIFA5_RXD_MARK, PORT162_FN2),
	PINMUX_DATA(SIN0_MARK, PORT162_FN3),
	PINMUX_DATA(MFG3_IN1_MARK, PORT162_FN4),
	PINMUX_DATA(PORT163_SCIFB_RTS_MARK, PORT163_FN1),
	PINMUX_DATA(PORT163_SCIFA5_RTS_MARK, PORT163_FN2),
	PINMUX_DATA(XRTS0_MARK, PORT163_FN3),
	PINMUX_DATA(MFG3_OUT1_MARK, PORT163_FN4),
	PINMUX_DATA(TPU3TO0_MARK, PORT163_FN5),
	PINMUX_DATA(LCDD0_MARK, PORT192_FN1),
	PINMUX_DATA(PORT192_KEYOUT0_MARK, PORT192_FN2),
	PINMUX_DATA(EXT_CKI_MARK, PORT192_FN3),
	PINMUX_DATA(LCDD1_MARK, PORT193_FN1),
	PINMUX_DATA(PORT193_KEYOUT1_MARK, PORT193_FN2),
	PINMUX_DATA(PORT193_SCIFA5_CTS_MARK, PORT193_FN3),
	PINMUX_DATA(BBIF2_TSYNC1_MARK, PORT193_FN4),
	PINMUX_DATA(LCDD2_MARK, PORT194_FN1),
	PINMUX_DATA(PORT194_KEYOUT2_MARK, PORT194_FN2),
	PINMUX_DATA(PORT194_SCIFA5_RTS_MARK, PORT194_FN3),
	PINMUX_DATA(BBIF2_TSCK1_MARK, PORT194_FN4),
	PINMUX_DATA(LCDD3_MARK, PORT195_FN1),
	PINMUX_DATA(PORT195_KEYOUT3_MARK, PORT195_FN2),
	PINMUX_DATA(PORT195_SCIFA5_RXD_MARK, PORT195_FN3),
	PINMUX_DATA(BBIF2_TXD1_MARK, PORT195_FN4),
	PINMUX_DATA(LCDD4_MARK, PORT196_FN1),
	PINMUX_DATA(PORT196_KEYOUT4_MARK, PORT196_FN2),
	PINMUX_DATA(PORT196_SCIFA5_TXD_MARK, PORT196_FN3),
	PINMUX_DATA(LCDD5_MARK, PORT197_FN1),
	PINMUX_DATA(PORT197_KEYOUT5_MARK, PORT197_FN2),
	PINMUX_DATA(PORT197_SCIFA5_SCK_MARK, PORT197_FN3),
	PINMUX_DATA(MFG2_OUT2_MARK, PORT197_FN4),
	PINMUX_DATA(LCDD6_MARK, PORT198_FN1),
	PINMUX_DATA(LCDD7_MARK, PORT199_FN1),
	PINMUX_DATA(TPU4TO1_MARK, PORT199_FN2),
	PINMUX_DATA(MFG4_OUT2_MARK, PORT199_FN3),
	PINMUX_DATA(LCDD8_MARK, PORT200_FN1),
	PINMUX_DATA(PORT200_KEYIN0_MARK, PORT200_FN2),
	PINMUX_DATA(VIO_DR0_MARK, PORT200_FN3),
	PINMUX_DATA(D16_MARK, PORT200_FN4),
	PINMUX_DATA(LCDD9_MARK, PORT201_FN1),
	PINMUX_DATA(PORT201_KEYIN1_MARK, PORT201_FN2),
	PINMUX_DATA(VIO_DR1_MARK, PORT201_FN3),
	PINMUX_DATA(D17_MARK, PORT201_FN4),
	PINMUX_DATA(LCDD10_MARK, PORT202_FN1),
	PINMUX_DATA(PORT202_KEYIN2_MARK, PORT202_FN2),
	PINMUX_DATA(VIO_DR2_MARK, PORT202_FN3),
	PINMUX_DATA(D18_MARK, PORT202_FN4),
	PINMUX_DATA(LCDD11_MARK, PORT203_FN1),
	PINMUX_DATA(PORT203_KEYIN3_MARK, PORT203_FN2),
	PINMUX_DATA(VIO_DR3_MARK, PORT203_FN3),
	PINMUX_DATA(D19_MARK, PORT203_FN4),
	PINMUX_DATA(LCDD12_MARK, PORT204_FN1),
	PINMUX_DATA(PORT204_KEYIN4_MARK, PORT204_FN2),
	PINMUX_DATA(VIO_DR4_MARK, PORT204_FN3),
	PINMUX_DATA(D20_MARK, PORT204_FN4),
	PINMUX_DATA(LCDD13_MARK, PORT205_FN1),
	PINMUX_DATA(PORT205_KEYIN5_MARK, PORT205_FN2),
	PINMUX_DATA(VIO_DR5_MARK, PORT205_FN3),
	PINMUX_DATA(D21_MARK, PORT205_FN4),
	PINMUX_DATA(LCDD14_MARK, PORT206_FN1),
	PINMUX_DATA(PORT206_KEYIN6_MARK, PORT206_FN2),
	PINMUX_DATA(VIO_DR6_MARK, PORT206_FN3),
	PINMUX_DATA(D22_MARK, PORT206_FN4),
	PINMUX_DATA(LCDD15_MARK, PORT207_FN1),
	PINMUX_DATA(PORT207_MSIOF0L_SS1_MARK, PORT207_FN2),
	PINMUX_DATA(PORT207_KEYOUT0_MARK, PORT207_FN3),
	PINMUX_DATA(VIO_DR7_MARK, PORT207_FN4),
	PINMUX_DATA(D23_MARK, PORT207_FN5),
	PINMUX_DATA(LCDD16_MARK, PORT208_FN1),
	PINMUX_DATA(PORT208_MSIOF0L_SS2_MARK, PORT208_FN2),
	PINMUX_DATA(PORT208_KEYOUT1_MARK, PORT208_FN3),
	PINMUX_DATA(VIO_VDR_MARK, PORT208_FN4),
	PINMUX_DATA(D24_MARK, PORT208_FN5),
	PINMUX_DATA(LCDD17_MARK, PORT209_FN1),
	PINMUX_DATA(PORT209_KEYOUT2_MARK, PORT209_FN2),
	PINMUX_DATA(VIO_HDR_MARK, PORT209_FN3),
	PINMUX_DATA(D25_MARK, PORT209_FN4),
	PINMUX_DATA(LCDD18_MARK, PORT210_FN1),
	PINMUX_DATA(DREQ2_MARK, PORT210_FN2),
	PINMUX_DATA(PORT210_MSIOF0L_SS1_MARK, PORT210_FN3),
	PINMUX_DATA(D26_MARK, PORT210_FN4),
	PINMUX_DATA(LCDD19_MARK, PORT211_FN1),
	PINMUX_DATA(PORT211_MSIOF0L_SS2_MARK, PORT211_FN2),
	PINMUX_DATA(D27_MARK, PORT211_FN3),
	PINMUX_DATA(LCDD20_MARK, PORT212_FN1),
	PINMUX_DATA(TS_SPSYNC1_MARK, PORT212_FN2),
	PINMUX_DATA(MSIOF0L_MCK0_MARK, PORT212_FN3),
	PINMUX_DATA(D28_MARK, PORT212_FN4),
	PINMUX_DATA(LCDD21_MARK, PORT213_FN1),
	PINMUX_DATA(TS_SDAT1_MARK, PORT213_FN2),
	PINMUX_DATA(MSIOF0L_MCK1_MARK, PORT213_FN3),
	PINMUX_DATA(D29_MARK, PORT213_FN4),
	PINMUX_DATA(LCDD22_MARK, PORT214_FN1),
	PINMUX_DATA(TS_SDEN1_MARK, PORT214_FN2),
	PINMUX_DATA(MSIOF0L_RSCK_MARK, PORT214_FN3),
	PINMUX_DATA(D30_MARK, PORT214_FN4),
	PINMUX_DATA(LCDD23_MARK, PORT215_FN1),
	PINMUX_DATA(TS_SCK1_MARK, PORT215_FN2),
	PINMUX_DATA(MSIOF0L_RSYNC_MARK, PORT215_FN3),
	PINMUX_DATA(D31_MARK, PORT215_FN4),
	PINMUX_DATA(LCDDCK_MARK, PORT216_FN1),
	PINMUX_DATA(LCDWR_MARK, PORT216_FN2),
	PINMUX_DATA(PORT216_KEYOUT3_MARK, PORT216_FN3),
	PINMUX_DATA(VIO_CLKR_MARK, PORT216_FN4),
	PINMUX_DATA(LCDRD_MARK, PORT217_FN1),
	PINMUX_DATA(DACK2_MARK, PORT217_FN2),
	PINMUX_DATA(MSIOF0L_TSYNC_MARK, PORT217_FN3),
	PINMUX_DATA(LCDHSYN_MARK, PORT218_FN1),
	PINMUX_DATA(LCDCS_MARK, PORT218_FN2),
	PINMUX_DATA(LCDCS2_MARK, PORT218_FN3),
	PINMUX_DATA(DACK3_MARK, PORT218_FN4),
	PINMUX_DATA(PORT218_VIO_CKOR_MARK, PORT218_FN5),
	PINMUX_DATA(PORT218_KEYOUT4_MARK, PORT218_FN6),
	PINMUX_DATA(LCDDISP_MARK, PORT219_FN1),
	PINMUX_DATA(LCDRS_MARK, PORT219_FN2),
	PINMUX_DATA(DREQ3_MARK, PORT219_FN3),
	PINMUX_DATA(MSIOF0L_TSCK_MARK, PORT219_FN4),
	PINMUX_DATA(LCDVSYN_MARK, PORT220_FN1),
	PINMUX_DATA(LCDVSYN2_MARK, PORT220_FN2),
	PINMUX_DATA(PORT220_KEYOUT5_MARK, PORT220_FN3),
	PINMUX_DATA(LCDLCLK_MARK, PORT221_FN1),
	PINMUX_DATA(DREQ1_MARK, PORT221_FN2),
	PINMUX_DATA(PWEN_MARK, PORT221_FN3),
	PINMUX_DATA(MSIOF0L_RXD_MARK, PORT221_FN4),
	PINMUX_DATA(LCDDON_MARK, PORT222_FN1),
	PINMUX_DATA(LCDDON2_MARK, PORT222_FN2),
	PINMUX_DATA(DACK1_MARK, PORT222_FN3),
	PINMUX_DATA(OVCN_MARK, PORT222_FN4),
	PINMUX_DATA(MSIOF0L_TXD_MARK, PORT222_FN5),
	PINMUX_DATA(SCIFA1_TXD_MARK, PORT225_FN1),
	PINMUX_DATA(OVCN2_MARK, PORT225_FN2),
	PINMUX_DATA(EXTLP_MARK, PORT226_FN1),
	PINMUX_DATA(SCIFA1_SCK_MARK, PORT226_FN2),
	PINMUX_DATA(USBTERM_MARK, PORT226_FN3),
	PINMUX_DATA(PORT226_VIO_CKO2_MARK, PORT226_FN4),
	PINMUX_DATA(SCIFA1_RTS_MARK, PORT227_FN1),
	PINMUX_DATA(IDIN_MARK, PORT227_FN2),
	PINMUX_DATA(SCIFA1_RXD_MARK, PORT228_FN1),
	PINMUX_DATA(SCIFA1_CTS_MARK, PORT229_FN1),
	PINMUX_DATA(MFG1_IN1_MARK, PORT229_FN2),
	PINMUX_DATA(MSIOF1_TXD_MARK, PORT230_FN1),
	PINMUX_DATA(SCIFA2_TXD2_MARK, PORT230_FN2),
	PINMUX_DATA(PORT230_FSIAOMC_MARK, PORT230_FN3),
	PINMUX_DATA(MSIOF1_TSYNC_MARK, PORT231_FN1),
	PINMUX_DATA(SCIFA2_CTS2_MARK, PORT231_FN2),
	PINMUX_DATA(PORT231_FSIAOLR_MARK, PORT231_FN3),
	PINMUX_DATA(MSIOF1_TSCK_MARK, PORT232_FN1),
	PINMUX_DATA(SCIFA2_SCK2_MARK, PORT232_FN2),
	PINMUX_DATA(PORT232_FSIAOBT_MARK, PORT232_FN3),
	PINMUX_DATA(MSIOF1_RXD_MARK, PORT233_FN1),
	PINMUX_DATA(SCIFA2_RXD2_MARK, PORT233_FN2),
	PINMUX_DATA(GPS_VCOTRIG_MARK, PORT233_FN3),
	PINMUX_DATA(PORT233_FSIACK_MARK, PORT233_FN4),
	PINMUX_DATA(MSIOF1_RSCK_MARK, PORT234_FN1),
	PINMUX_DATA(SCIFA2_RTS2_MARK, PORT234_FN2),
	PINMUX_DATA(PORT234_FSIAOSLD_MARK, PORT234_FN3),
	PINMUX_DATA(MSIOF1_RSYNC_MARK, PORT235_FN1),
	PINMUX_DATA(OPORT0_MARK, PORT235_FN2),
	PINMUX_DATA(MFG1_IN2_MARK, PORT235_FN3),
	PINMUX_DATA(PORT235_FSIAILR_MARK, PORT235_FN4),
	PINMUX_DATA(MSIOF1_MCK0_MARK, PORT236_FN1),
	PINMUX_DATA(I2C_SDA2_MARK, PORT236_FN2),
	PINMUX_DATA(PORT236_FSIAIBT_MARK, PORT236_FN3),
	PINMUX_DATA(MSIOF1_MCK1_MARK, PORT237_FN1),
	PINMUX_DATA(I2C_SCL2_MARK, PORT237_FN2),
	PINMUX_DATA(PORT237_FSIAISLD_MARK, PORT237_FN3),
	PINMUX_DATA(MSIOF1_SS1_MARK, PORT238_FN1),
	PINMUX_DATA(EDBGREQ3_MARK, PORT238_FN2),

	/* 55-5 (FN) */
	PINMUX_DATA(MSIOF1_SS2_MARK, PORT239_FN1),
	PINMUX_DATA(SCIFA6_TXD_MARK, PORT240_FN1),
	PINMUX_DATA(PORT241_IRDA_OUT_MARK, PORT241_FN1),
	PINMUX_DATA(PORT241_IROUT_MARK, PORT241_FN2),
	PINMUX_DATA(MFG4_OUT1_MARK, PORT241_FN3),
	PINMUX_DATA(TPU4TO0_MARK, PORT241_FN4),
	PINMUX_DATA(PORT242_IRDA_IN_MARK, PORT242_FN1),
	PINMUX_DATA(MFG4_IN2_MARK, PORT242_FN2),
	PINMUX_DATA(PORT243_IRDA_FIRSEL_MARK, PORT243_FN1),
	PINMUX_DATA(PORT243_VIO_CKO2_MARK, PORT243_FN2),
	PINMUX_DATA(PORT244_SCIFA5_CTS_MARK, PORT244_FN1),
	PINMUX_DATA(MFG2_IN1_MARK, PORT244_FN2),
	PINMUX_DATA(PORT244_SCIFB_CTS_MARK, PORT244_FN3),
	PINMUX_DATA(PORT245_SCIFA5_RTS_MARK, PORT245_FN1),
	PINMUX_DATA(MFG2_IN2_MARK, PORT245_FN2),
	PINMUX_DATA(PORT245_SCIFB_RTS_MARK, PORT245_FN3),
	PINMUX_DATA(PORT246_SCIFA5_RXD_MARK, PORT246_FN1),
	PINMUX_DATA(MFG1_OUT1_MARK, PORT246_FN2),
	PINMUX_DATA(PORT246_SCIFB_RXD_MARK, PORT246_FN3),
	PINMUX_DATA(TPU1TO0_MARK, PORT246_FN4),
	PINMUX_DATA(PORT247_SCIFA5_TXD_MARK, PORT247_FN1),
	PINMUX_DATA(MFG3_OUT2_MARK, PORT247_FN2),
	PINMUX_DATA(PORT247_SCIFB_TXD_MARK, PORT247_FN3),
	PINMUX_DATA(TPU3TO1_MARK, PORT247_FN4),
	PINMUX_DATA(PORT248_SCIFA5_SCK_MARK, PORT248_FN1),
	PINMUX_DATA(MFG2_OUT1_MARK, PORT248_FN2),
	PINMUX_DATA(PORT248_SCIFB_SCK_MARK, PORT248_FN3),
	PINMUX_DATA(TPU2TO0_MARK, PORT248_FN4),
	PINMUX_DATA(PORT249_IROUT_MARK, PORT249_FN1),
	PINMUX_DATA(MFG4_IN1_MARK, PORT249_FN2),
	PINMUX_DATA(SDHICLK0_MARK, PORT250_FN1),
	PINMUX_DATA(TCK2_SWCLK_MC0_MARK, PORT250_FN2),
	PINMUX_DATA(SDHICD0_MARK, PORT251_FN1),
	PINMUX_DATA(SDHID0_0_MARK, PORT252_FN1),
	PINMUX_DATA(TMS2_SWDIO_MC0_MARK, PORT252_FN2),
	PINMUX_DATA(SDHID0_1_MARK, PORT253_FN1),
	PINMUX_DATA(TDO2_SWO0_MC0_MARK, PORT253_FN2),
	PINMUX_DATA(SDHID0_2_MARK, PORT254_FN1),
	PINMUX_DATA(TDI2_MARK, PORT254_FN2),
	PINMUX_DATA(SDHID0_3_MARK, PORT255_FN1),
	PINMUX_DATA(RTCK2_SWO1_MC0_MARK, PORT255_FN2),
	PINMUX_DATA(SDHICMD0_MARK, PORT256_FN1),
	PINMUX_DATA(TRST2_MARK, PORT256_FN2),
	PINMUX_DATA(SDHIWP0_MARK, PORT257_FN1),
	PINMUX_DATA(EDBGREQ2_MARK, PORT257_FN2),
	PINMUX_DATA(SDHICLK1_MARK, PORT258_FN1),
	PINMUX_DATA(TCK3_SWCLK_MC1_MARK, PORT258_FN2),
	PINMUX_DATA(SDHID1_0_MARK, PORT259_FN1),
	PINMUX_DATA(M11_SLCD_SO2_MARK, PORT259_FN2),
	PINMUX_DATA(TS_SPSYNC2_MARK, PORT259_FN3),
	PINMUX_DATA(TMS3_SWDIO_MC1_MARK, PORT259_FN4),
	PINMUX_DATA(SDHID1_1_MARK, PORT260_FN1),
	PINMUX_DATA(M9_SLCD_A02_MARK, PORT260_FN2),
	PINMUX_DATA(TS_SDAT2_MARK, PORT260_FN3),
	PINMUX_DATA(TDO3_SWO0_MC1_MARK, PORT260_FN4),
	PINMUX_DATA(SDHID1_2_MARK, PORT261_FN1),
	PINMUX_DATA(M10_SLCD_CK2_MARK, PORT261_FN2),
	PINMUX_DATA(TS_SDEN2_MARK, PORT261_FN3),
	PINMUX_DATA(TDI3_MARK, PORT261_FN4),
	PINMUX_DATA(SDHID1_3_MARK, PORT262_FN1),
	PINMUX_DATA(M12_SLCD_CE2_MARK, PORT262_FN2),
	PINMUX_DATA(TS_SCK2_MARK, PORT262_FN3),
	PINMUX_DATA(RTCK3_SWO1_MC1_MARK, PORT262_FN4),
	PINMUX_DATA(SDHICMD1_MARK, PORT263_FN1),
	PINMUX_DATA(TRST3_MARK, PORT263_FN2),
	PINMUX_DATA(RESETOUTS_MARK, PORT264_FN1),
};

static struct pinmux_gpio pinmux_gpios[] = {
	/* 55-1 -> 55-5 (GPIO) */
	GPIO_PORT_ALL(),

	/* Special Pull-up / Pull-down Functions */
	GPIO_FN(PORT66_KEYIN0_PU), GPIO_FN(PORT67_KEYIN1_PU),
	GPIO_FN(PORT68_KEYIN2_PU), GPIO_FN(PORT69_KEYIN3_PU),
	GPIO_FN(PORT70_KEYIN4_PU), GPIO_FN(PORT71_KEYIN5_PU),
	GPIO_FN(PORT72_KEYIN6_PU),

	/* 55-1 (FN) */
	GPIO_FN(VBUS_0),
	GPIO_FN(CPORT0),
	GPIO_FN(CPORT1),
	GPIO_FN(CPORT2),
	GPIO_FN(CPORT3),
	GPIO_FN(CPORT4),
	GPIO_FN(CPORT5),
	GPIO_FN(CPORT6),
	GPIO_FN(CPORT7),
	GPIO_FN(CPORT8),
	GPIO_FN(CPORT9),
	GPIO_FN(CPORT10),
	GPIO_FN(CPORT11), GPIO_FN(SIN2),
	GPIO_FN(CPORT12), GPIO_FN(XCTS2),
	GPIO_FN(CPORT13), GPIO_FN(RFSPO4),
	GPIO_FN(CPORT14), GPIO_FN(RFSPO5),
	GPIO_FN(CPORT15), GPIO_FN(SCIFA0_SCK), GPIO_FN(GPS_AGC2),
	GPIO_FN(CPORT16), GPIO_FN(SCIFA0_TXD), GPIO_FN(GPS_AGC3),
	GPIO_FN(CPORT17_IC_OE), GPIO_FN(SOUT2),
	GPIO_FN(CPORT18), GPIO_FN(XRTS2), GPIO_FN(PORT19_VIO_CKO2),
	GPIO_FN(CPORT19_MPORT1),
	GPIO_FN(CPORT20), GPIO_FN(RFSPO6),
	GPIO_FN(CPORT21), GPIO_FN(STATUS0),
	GPIO_FN(CPORT22), GPIO_FN(STATUS1),
	GPIO_FN(CPORT23), GPIO_FN(STATUS2), GPIO_FN(RFSPO7),
	GPIO_FN(B_SYNLD1),
	GPIO_FN(B_SYNLD2), GPIO_FN(SYSENMSK),
	GPIO_FN(XMAINPS),
	GPIO_FN(XDIVPS),
	GPIO_FN(XIDRST),
	GPIO_FN(IDCLK), GPIO_FN(IC_DP),
	GPIO_FN(IDIO), GPIO_FN(IC_DM),
	GPIO_FN(SOUT1), GPIO_FN(SCIFA4_TXD), GPIO_FN(M02_BERDAT),
	GPIO_FN(SIN1), GPIO_FN(SCIFA4_RXD), GPIO_FN(XWUP),
	GPIO_FN(XRTS1), GPIO_FN(SCIFA4_RTS), GPIO_FN(M03_BERCLK),
	GPIO_FN(XCTS1), GPIO_FN(SCIFA4_CTS),
	GPIO_FN(PCMCLKO),
	GPIO_FN(SYNC8KO),

	/* 55-2 (FN) */
	GPIO_FN(DNPCM_A),
	GPIO_FN(UPPCM_A),
	GPIO_FN(VACK),
	GPIO_FN(XTALB1L),
	GPIO_FN(GPS_AGC1), GPIO_FN(SCIFA0_RTS),
	GPIO_FN(GPS_AGC4), GPIO_FN(SCIFA0_RXD),
	GPIO_FN(GPS_PWRDOWN), GPIO_FN(SCIFA0_CTS),
	GPIO_FN(GPS_IM),
	GPIO_FN(GPS_IS),
	GPIO_FN(GPS_QM),
	GPIO_FN(GPS_QS),
	GPIO_FN(FMSOCK), GPIO_FN(PORT49_IRDA_OUT), GPIO_FN(PORT49_IROUT),
	GPIO_FN(FMSOOLR), GPIO_FN(BBIF2_TSYNC2), GPIO_FN(TPU2TO2),
	GPIO_FN(IPORT3), GPIO_FN(FMSIOLR),
	GPIO_FN(FMSOOBT), GPIO_FN(BBIF2_TSCK2), GPIO_FN(TPU2TO3),
	GPIO_FN(OPORT1), GPIO_FN(FMSIOBT),
	GPIO_FN(FMSOSLD), GPIO_FN(BBIF2_TXD2), GPIO_FN(OPORT2),
	GPIO_FN(FMSOILR), GPIO_FN(PORT53_IRDA_IN), GPIO_FN(TPU3TO3),
	GPIO_FN(OPORT3), GPIO_FN(FMSIILR),
	GPIO_FN(FMSOIBT), GPIO_FN(PORT54_IRDA_FIRSEL), GPIO_FN(TPU3TO2),
	GPIO_FN(FMSIIBT),
	GPIO_FN(FMSISLD), GPIO_FN(MFG0_OUT1), GPIO_FN(TPU0TO0),
	GPIO_FN(A0_EA0), GPIO_FN(BS),
	GPIO_FN(A12_EA12), GPIO_FN(PORT58_VIO_CKOR), GPIO_FN(TPU4TO2),
	GPIO_FN(A13_EA13), GPIO_FN(PORT59_IROUT), GPIO_FN(MFG0_OUT2),
	GPIO_FN(TPU0TO1),
	GPIO_FN(A14_EA14), GPIO_FN(PORT60_KEYOUT5),
	GPIO_FN(A15_EA15), GPIO_FN(PORT61_KEYOUT4),
	GPIO_FN(A16_EA16), GPIO_FN(PORT62_KEYOUT3), GPIO_FN(MSIOF0_SS1),
	GPIO_FN(A17_EA17), GPIO_FN(PORT63_KEYOUT2), GPIO_FN(MSIOF0_TSYNC),
	GPIO_FN(A18_EA18), GPIO_FN(PORT64_KEYOUT1), GPIO_FN(MSIOF0_TSCK),
	GPIO_FN(A19_EA19), GPIO_FN(PORT65_KEYOUT0), GPIO_FN(MSIOF0_TXD),
	GPIO_FN(A20_EA20), GPIO_FN(PORT66_KEYIN0), GPIO_FN(MSIOF0_RSCK),
	GPIO_FN(A21_EA21), GPIO_FN(PORT67_KEYIN1), GPIO_FN(MSIOF0_RSYNC),
	GPIO_FN(A22_EA22), GPIO_FN(PORT68_KEYIN2), GPIO_FN(MSIOF0_MCK0),
	GPIO_FN(A23_EA23), GPIO_FN(PORT69_KEYIN3), GPIO_FN(MSIOF0_MCK1),
	GPIO_FN(A24_EA24), GPIO_FN(PORT70_KEYIN4), GPIO_FN(MSIOF0_RXD),
	GPIO_FN(A25_EA25), GPIO_FN(PORT71_KEYIN5), GPIO_FN(MSIOF0_SS2),
	GPIO_FN(A26), GPIO_FN(PORT72_KEYIN6),
	GPIO_FN(D0_ED0_NAF0),
	GPIO_FN(D1_ED1_NAF1),
	GPIO_FN(D2_ED2_NAF2),
	GPIO_FN(D3_ED3_NAF3),
	GPIO_FN(D4_ED4_NAF4),
	GPIO_FN(D5_ED5_NAF5),
	GPIO_FN(D6_ED6_NAF6),
	GPIO_FN(D7_ED7_NAF7),
	GPIO_FN(D8_ED8_NAF8),
	GPIO_FN(D9_ED9_NAF9),
	GPIO_FN(D10_ED10_NAF10),
	GPIO_FN(D11_ED11_NAF11),
	GPIO_FN(D12_ED12_NAF12),
	GPIO_FN(D13_ED13_NAF13),
	GPIO_FN(D14_ED14_NAF14),
	GPIO_FN(D15_ED15_NAF15),
	GPIO_FN(CS4),
	GPIO_FN(CS5A), GPIO_FN(FMSICK),

	/* 55-3 (FN) */
	GPIO_FN(CS5B), GPIO_FN(FCE1),
	GPIO_FN(CS6B), GPIO_FN(XCS2), GPIO_FN(CS6A), GPIO_FN(DACK0),
	GPIO_FN(FCE0),
	GPIO_FN(WAIT), GPIO_FN(DREQ0),
	GPIO_FN(RD_XRD),
	GPIO_FN(WE0_XWR0_FWE),
	GPIO_FN(WE1_XWR1),
	GPIO_FN(FRB),
	GPIO_FN(CKO),
	GPIO_FN(NBRSTOUT),
	GPIO_FN(NBRST),
	GPIO_FN(GPS_EPPSIN),
	GPIO_FN(LATCHPULSE),
	GPIO_FN(LTESIGNAL),
	GPIO_FN(LEGACYSTATE),
	GPIO_FN(TCKON),
	GPIO_FN(VIO_VD), GPIO_FN(PORT128_KEYOUT0), GPIO_FN(IPORT0),
	GPIO_FN(VIO_HD), GPIO_FN(PORT129_KEYOUT1), GPIO_FN(IPORT1),
	GPIO_FN(VIO_D0), GPIO_FN(PORT130_KEYOUT2), GPIO_FN(PORT130_MSIOF2_RXD),
	GPIO_FN(VIO_D1), GPIO_FN(PORT131_KEYOUT3), GPIO_FN(PORT131_MSIOF2_SS1),
	GPIO_FN(VIO_D2), GPIO_FN(PORT132_KEYOUT4), GPIO_FN(PORT132_MSIOF2_SS2),
	GPIO_FN(VIO_D3), GPIO_FN(PORT133_KEYOUT5),
	GPIO_FN(PORT133_MSIOF2_TSYNC),
	GPIO_FN(VIO_D4), GPIO_FN(PORT134_KEYIN0), GPIO_FN(PORT134_MSIOF2_TXD),
	GPIO_FN(VIO_D5), GPIO_FN(PORT135_KEYIN1), GPIO_FN(PORT135_MSIOF2_TSCK),
	GPIO_FN(VIO_D6), GPIO_FN(PORT136_KEYIN2),
	GPIO_FN(VIO_D7), GPIO_FN(PORT137_KEYIN3),
	GPIO_FN(VIO_D8), GPIO_FN(M9_SLCD_A01), GPIO_FN(PORT138_FSIAOMC),
	GPIO_FN(VIO_D9), GPIO_FN(M10_SLCD_CK1), GPIO_FN(PORT139_FSIAOLR),
	GPIO_FN(VIO_D10), GPIO_FN(M11_SLCD_SO1), GPIO_FN(TPU0TO2),
	GPIO_FN(PORT140_FSIAOBT),
	GPIO_FN(VIO_D11), GPIO_FN(M12_SLCD_CE1), GPIO_FN(TPU0TO3),
	GPIO_FN(PORT141_FSIAOSLD),
	GPIO_FN(VIO_D12), GPIO_FN(M13_BSW), GPIO_FN(PORT142_FSIACK),
	GPIO_FN(VIO_D13), GPIO_FN(M14_GSW), GPIO_FN(PORT143_FSIAILR),
	GPIO_FN(VIO_D14), GPIO_FN(M15_RSW), GPIO_FN(PORT144_FSIAIBT),
	GPIO_FN(VIO_D15), GPIO_FN(TPU1TO3), GPIO_FN(PORT145_FSIAISLD),
	GPIO_FN(VIO_CLK), GPIO_FN(PORT146_KEYIN4), GPIO_FN(IPORT2),
	GPIO_FN(VIO_FIELD), GPIO_FN(PORT147_KEYIN5),
	GPIO_FN(VIO_CKO), GPIO_FN(PORT148_KEYIN6),
	GPIO_FN(A27), GPIO_FN(RDWR_XWE), GPIO_FN(MFG0_IN1),
	GPIO_FN(MFG0_IN2),
	GPIO_FN(TS_SPSYNC3), GPIO_FN(MSIOF2_RSCK),
	GPIO_FN(TS_SDAT3), GPIO_FN(MSIOF2_RSYNC),
	GPIO_FN(TPU1TO2), GPIO_FN(TS_SDEN3), GPIO_FN(PORT153_MSIOF2_SS1),
	GPIO_FN(SOUT3), GPIO_FN(SCIFA2_TXD1), GPIO_FN(MSIOF2_MCK0),
	GPIO_FN(SIN3), GPIO_FN(SCIFA2_RXD1), GPIO_FN(MSIOF2_MCK1),
	GPIO_FN(XRTS3), GPIO_FN(SCIFA2_RTS1), GPIO_FN(PORT156_MSIOF2_SS2),
	GPIO_FN(XCTS3), GPIO_FN(SCIFA2_CTS1), GPIO_FN(PORT157_MSIOF2_RXD),

	/* 55-4 (FN) */
	GPIO_FN(DINT), GPIO_FN(SCIFA2_SCK1), GPIO_FN(TS_SCK3),
	GPIO_FN(PORT159_SCIFB_SCK), GPIO_FN(PORT159_SCIFA5_SCK), GPIO_FN(NMI),
	GPIO_FN(PORT160_SCIFB_TXD), GPIO_FN(PORT160_SCIFA5_TXD), GPIO_FN(SOUT0),
	GPIO_FN(PORT161_SCIFB_CTS), GPIO_FN(PORT161_SCIFA5_CTS), GPIO_FN(XCTS0),
	GPIO_FN(MFG3_IN2),
	GPIO_FN(PORT162_SCIFB_RXD), GPIO_FN(PORT162_SCIFA5_RXD), GPIO_FN(SIN0),
	GPIO_FN(MFG3_IN1),
	GPIO_FN(PORT163_SCIFB_RTS), GPIO_FN(PORT163_SCIFA5_RTS), GPIO_FN(XRTS0),
	GPIO_FN(MFG3_OUT1), GPIO_FN(TPU3TO0),
	GPIO_FN(LCDD0), GPIO_FN(PORT192_KEYOUT0), GPIO_FN(EXT_CKI),
	GPIO_FN(LCDD1), GPIO_FN(PORT193_KEYOUT1), GPIO_FN(PORT193_SCIFA5_CTS),
	GPIO_FN(BBIF2_TSYNC1),
	GPIO_FN(LCDD2), GPIO_FN(PORT194_KEYOUT2), GPIO_FN(PORT194_SCIFA5_RTS),
	GPIO_FN(BBIF2_TSCK1),
	GPIO_FN(LCDD3), GPIO_FN(PORT195_KEYOUT3), GPIO_FN(PORT195_SCIFA5_RXD),
	GPIO_FN(BBIF2_TXD1),
	GPIO_FN(LCDD4), GPIO_FN(PORT196_KEYOUT4), GPIO_FN(PORT196_SCIFA5_TXD),
	GPIO_FN(LCDD5), GPIO_FN(PORT197_KEYOUT5), GPIO_FN(PORT197_SCIFA5_SCK),
	GPIO_FN(MFG2_OUT2),
	GPIO_FN(LCDD6),
	GPIO_FN(LCDD7), GPIO_FN(TPU4TO1), GPIO_FN(MFG4_OUT2),
	GPIO_FN(LCDD8), GPIO_FN(PORT200_KEYIN0), GPIO_FN(VIO_DR0),
	GPIO_FN(D16),
	GPIO_FN(LCDD9), GPIO_FN(PORT201_KEYIN1), GPIO_FN(VIO_DR1),
	GPIO_FN(D17),
	GPIO_FN(LCDD10), GPIO_FN(PORT202_KEYIN2), GPIO_FN(VIO_DR2),
	GPIO_FN(D18),
	GPIO_FN(LCDD11), GPIO_FN(PORT203_KEYIN3), GPIO_FN(VIO_DR3),
	GPIO_FN(D19),
	GPIO_FN(LCDD12), GPIO_FN(PORT204_KEYIN4), GPIO_FN(VIO_DR4),
	GPIO_FN(D20),
	GPIO_FN(LCDD13), GPIO_FN(PORT205_KEYIN5), GPIO_FN(VIO_DR5),
	GPIO_FN(D21),
	GPIO_FN(LCDD14), GPIO_FN(PORT206_KEYIN6), GPIO_FN(VIO_DR6),
	GPIO_FN(D22),
	GPIO_FN(LCDD15), GPIO_FN(PORT207_MSIOF0L_SS1), GPIO_FN(PORT207_KEYOUT0),
	GPIO_FN(VIO_DR7), GPIO_FN(D23),
	GPIO_FN(LCDD16), GPIO_FN(PORT208_MSIOF0L_SS2), GPIO_FN(PORT208_KEYOUT1),
	GPIO_FN(VIO_VDR), GPIO_FN(D24),
	GPIO_FN(LCDD17), GPIO_FN(PORT209_KEYOUT2), GPIO_FN(VIO_HDR),
	GPIO_FN(D25),
	GPIO_FN(LCDD18), GPIO_FN(DREQ2), GPIO_FN(PORT210_MSIOF0L_SS1),
	GPIO_FN(D26),
	GPIO_FN(LCDD19), GPIO_FN(PORT211_MSIOF0L_SS2), GPIO_FN(D27),
	GPIO_FN(LCDD20), GPIO_FN(TS_SPSYNC1), GPIO_FN(MSIOF0L_MCK0),
	GPIO_FN(D28),
	GPIO_FN(LCDD21), GPIO_FN(TS_SDAT1), GPIO_FN(MSIOF0L_MCK1),
	GPIO_FN(D29),
	GPIO_FN(LCDD22), GPIO_FN(TS_SDEN1), GPIO_FN(MSIOF0L_RSCK),
	GPIO_FN(D30),
	GPIO_FN(LCDD23), GPIO_FN(TS_SCK1), GPIO_FN(MSIOF0L_RSYNC),
	GPIO_FN(D31),
	GPIO_FN(LCDDCK), GPIO_FN(LCDWR), GPIO_FN(PORT216_KEYOUT3),
	GPIO_FN(VIO_CLKR),
	GPIO_FN(LCDRD), GPIO_FN(DACK2), GPIO_FN(MSIOF0L_TSYNC),
	GPIO_FN(LCDHSYN), GPIO_FN(LCDCS), GPIO_FN(LCDCS2), GPIO_FN(DACK3),
	GPIO_FN(PORT218_VIO_CKOR), GPIO_FN(PORT218_KEYOUT4),
	GPIO_FN(LCDDISP), GPIO_FN(LCDRS), GPIO_FN(DREQ3), GPIO_FN(MSIOF0L_TSCK),
	GPIO_FN(LCDVSYN), GPIO_FN(LCDVSYN2), GPIO_FN(PORT220_KEYOUT5),
	GPIO_FN(LCDLCLK), GPIO_FN(DREQ1), GPIO_FN(PWEN), GPIO_FN(MSIOF0L_RXD),
	GPIO_FN(LCDDON), GPIO_FN(LCDDON2), GPIO_FN(DACK1), GPIO_FN(OVCN),
	GPIO_FN(MSIOF0L_TXD),
	GPIO_FN(SCIFA1_TXD), GPIO_FN(OVCN2),
	GPIO_FN(EXTLP), GPIO_FN(SCIFA1_SCK), GPIO_FN(USBTERM),
	GPIO_FN(PORT226_VIO_CKO2),
	GPIO_FN(SCIFA1_RTS), GPIO_FN(IDIN),
	GPIO_FN(SCIFA1_RXD),
	GPIO_FN(SCIFA1_CTS), GPIO_FN(MFG1_IN1),
	GPIO_FN(MSIOF1_TXD), GPIO_FN(SCIFA2_TXD2), GPIO_FN(PORT230_FSIAOMC),
	GPIO_FN(MSIOF1_TSYNC), GPIO_FN(SCIFA2_CTS2), GPIO_FN(PORT231_FSIAOLR),
	GPIO_FN(MSIOF1_TSCK), GPIO_FN(SCIFA2_SCK2), GPIO_FN(PORT232_FSIAOBT),
	GPIO_FN(MSIOF1_RXD), GPIO_FN(SCIFA2_RXD2), GPIO_FN(GPS_VCOTRIG),
	GPIO_FN(PORT233_FSIACK),
	GPIO_FN(MSIOF1_RSCK), GPIO_FN(SCIFA2_RTS2), GPIO_FN(PORT234_FSIAOSLD),
	GPIO_FN(MSIOF1_RSYNC), GPIO_FN(OPORT0), GPIO_FN(MFG1_IN2),
	GPIO_FN(PORT235_FSIAILR),
	GPIO_FN(MSIOF1_MCK0), GPIO_FN(I2C_SDA2), GPIO_FN(PORT236_FSIAIBT),
	GPIO_FN(MSIOF1_MCK1), GPIO_FN(I2C_SCL2), GPIO_FN(PORT237_FSIAISLD),
	GPIO_FN(MSIOF1_SS1), GPIO_FN(EDBGREQ3),

	/* 55-5 (FN) */
	GPIO_FN(MSIOF1_SS2),
	GPIO_FN(SCIFA6_TXD),
	GPIO_FN(PORT241_IRDA_OUT), GPIO_FN(PORT241_IROUT), GPIO_FN(MFG4_OUT1),
	GPIO_FN(TPU4TO0),
	GPIO_FN(PORT242_IRDA_IN), GPIO_FN(MFG4_IN2),
	GPIO_FN(PORT243_IRDA_FIRSEL), GPIO_FN(PORT243_VIO_CKO2),
	GPIO_FN(PORT244_SCIFA5_CTS), GPIO_FN(MFG2_IN1),
	GPIO_FN(PORT244_SCIFB_CTS),
	GPIO_FN(PORT245_SCIFA5_RTS), GPIO_FN(MFG2_IN2),
	GPIO_FN(PORT245_SCIFB_RTS),
	GPIO_FN(PORT246_SCIFA5_RXD), GPIO_FN(MFG1_OUT1),
	GPIO_FN(PORT246_SCIFB_RXD), GPIO_FN(TPU1TO0),
	GPIO_FN(PORT247_SCIFA5_TXD), GPIO_FN(MFG3_OUT2),
	GPIO_FN(PORT247_SCIFB_TXD), GPIO_FN(TPU3TO1),
	GPIO_FN(PORT248_SCIFA5_SCK), GPIO_FN(MFG2_OUT1),
	GPIO_FN(PORT248_SCIFB_SCK), GPIO_FN(TPU2TO0),
	GPIO_FN(PORT249_IROUT), GPIO_FN(MFG4_IN1),
	GPIO_FN(SDHICLK0), GPIO_FN(TCK2_SWCLK_MC0),
	GPIO_FN(SDHICD0),
	GPIO_FN(SDHID0_0), GPIO_FN(TMS2_SWDIO_MC0),
	GPIO_FN(SDHID0_1), GPIO_FN(TDO2_SWO0_MC0),
	GPIO_FN(SDHID0_2), GPIO_FN(TDI2),
	GPIO_FN(SDHID0_3), GPIO_FN(RTCK2_SWO1_MC0),
	GPIO_FN(SDHICMD0), GPIO_FN(TRST2),
	GPIO_FN(SDHIWP0), GPIO_FN(EDBGREQ2),
	GPIO_FN(SDHICLK1), GPIO_FN(TCK3_SWCLK_MC1),
	GPIO_FN(SDHID1_0), GPIO_FN(M11_SLCD_SO2), GPIO_FN(TS_SPSYNC2),
	GPIO_FN(TMS3_SWDIO_MC1),
	GPIO_FN(SDHID1_1), GPIO_FN(M9_SLCD_A02), GPIO_FN(TS_SDAT2),
	GPIO_FN(TDO3_SWO0_MC1),
	GPIO_FN(SDHID1_2), GPIO_FN(M10_SLCD_CK2), GPIO_FN(TS_SDEN2),
	GPIO_FN(TDI3),
	GPIO_FN(SDHID1_3), GPIO_FN(M12_SLCD_CE2), GPIO_FN(TS_SCK2),
	GPIO_FN(RTCK3_SWO1_MC1),
	GPIO_FN(SDHICMD1), GPIO_FN(TRST3),
	GPIO_FN(RESETOUTS),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	PORTCR(0, 0xe6050000), /* PORT0CR */
	PORTCR(1, 0xe6050001), /* PORT1CR */
	PORTCR(2, 0xe6050002), /* PORT2CR */
	PORTCR(3, 0xe6050003), /* PORT3CR */
	PORTCR(4, 0xe6050004), /* PORT4CR */
	PORTCR(5, 0xe6050005), /* PORT5CR */
	PORTCR(6, 0xe6050006), /* PORT6CR */
	PORTCR(7, 0xe6050007), /* PORT7CR */
	PORTCR(8, 0xe6050008), /* PORT8CR */
	PORTCR(9, 0xe6050009), /* PORT9CR */

	PORTCR(10, 0xe605000a), /* PORT10CR */
	PORTCR(11, 0xe605000b), /* PORT11CR */
	PORTCR(12, 0xe605000c), /* PORT12CR */
	PORTCR(13, 0xe605000d), /* PORT13CR */
	PORTCR(14, 0xe605000e), /* PORT14CR */
	PORTCR(15, 0xe605000f), /* PORT15CR */
	PORTCR(16, 0xe6050010), /* PORT16CR */
	PORTCR(17, 0xe6050011), /* PORT17CR */
	PORTCR(18, 0xe6050012), /* PORT18CR */
	PORTCR(19, 0xe6050013), /* PORT19CR */

	PORTCR(20, 0xe6050014), /* PORT20CR */
	PORTCR(21, 0xe6050015), /* PORT21CR */
	PORTCR(22, 0xe6050016), /* PORT22CR */
	PORTCR(23, 0xe6050017), /* PORT23CR */
	PORTCR(24, 0xe6050018), /* PORT24CR */
	PORTCR(25, 0xe6050019), /* PORT25CR */
	PORTCR(26, 0xe605001a), /* PORT26CR */
	PORTCR(27, 0xe605001b), /* PORT27CR */
	PORTCR(28, 0xe605001c), /* PORT28CR */
	PORTCR(29, 0xe605001d), /* PORT29CR */

	PORTCR(30, 0xe605001e), /* PORT30CR */
	PORTCR(31, 0xe605001f), /* PORT31CR */
	PORTCR(32, 0xe6050020), /* PORT32CR */
	PORTCR(33, 0xe6050021), /* PORT33CR */
	PORTCR(34, 0xe6050022), /* PORT34CR */
	PORTCR(35, 0xe6050023), /* PORT35CR */
	PORTCR(36, 0xe6050024), /* PORT36CR */
	PORTCR(37, 0xe6050025), /* PORT37CR */
	PORTCR(38, 0xe6050026), /* PORT38CR */
	PORTCR(39, 0xe6050027), /* PORT39CR */

	PORTCR(40, 0xe6050028), /* PORT40CR */
	PORTCR(41, 0xe6050029), /* PORT41CR */
	PORTCR(42, 0xe605002a), /* PORT42CR */
	PORTCR(43, 0xe605002b), /* PORT43CR */
	PORTCR(44, 0xe605002c), /* PORT44CR */
	PORTCR(45, 0xe605002d), /* PORT45CR */
	PORTCR(46, 0xe605002e), /* PORT46CR */
	PORTCR(47, 0xe605002f), /* PORT47CR */
	PORTCR(48, 0xe6050030), /* PORT48CR */
	PORTCR(49, 0xe6050031), /* PORT49CR */

	PORTCR(50, 0xe6050032), /* PORT50CR */
	PORTCR(51, 0xe6050033), /* PORT51CR */
	PORTCR(52, 0xe6050034), /* PORT52CR */
	PORTCR(53, 0xe6050035), /* PORT53CR */
	PORTCR(54, 0xe6050036), /* PORT54CR */
	PORTCR(55, 0xe6050037), /* PORT55CR */
	PORTCR(56, 0xe6050038), /* PORT56CR */
	PORTCR(57, 0xe6050039), /* PORT57CR */
	PORTCR(58, 0xe605003a), /* PORT58CR */
	PORTCR(59, 0xe605003b), /* PORT59CR */

	PORTCR(60, 0xe605003c), /* PORT60CR */
	PORTCR(61, 0xe605003d), /* PORT61CR */
	PORTCR(62, 0xe605003e), /* PORT62CR */
	PORTCR(63, 0xe605003f), /* PORT63CR */
	PORTCR(64, 0xe6050040), /* PORT64CR */
	PORTCR(65, 0xe6050041), /* PORT65CR */
	PORTCR(66, 0xe6050042), /* PORT66CR */
	PORTCR(67, 0xe6050043), /* PORT67CR */
	PORTCR(68, 0xe6050044), /* PORT68CR */
	PORTCR(69, 0xe6050045), /* PORT69CR */

	PORTCR(70, 0xe6050046), /* PORT70CR */
	PORTCR(71, 0xe6050047), /* PORT71CR */
	PORTCR(72, 0xe6050048), /* PORT72CR */
	PORTCR(73, 0xe6050049), /* PORT73CR */
	PORTCR(74, 0xe605004a), /* PORT74CR */
	PORTCR(75, 0xe605004b), /* PORT75CR */
	PORTCR(76, 0xe605004c), /* PORT76CR */
	PORTCR(77, 0xe605004d), /* PORT77CR */
	PORTCR(78, 0xe605004e), /* PORT78CR */
	PORTCR(79, 0xe605004f), /* PORT79CR */

	PORTCR(80, 0xe6050050), /* PORT80CR */
	PORTCR(81, 0xe6050051), /* PORT81CR */
	PORTCR(82, 0xe6050052), /* PORT82CR */
	PORTCR(83, 0xe6050053), /* PORT83CR */
	PORTCR(84, 0xe6050054), /* PORT84CR */
	PORTCR(85, 0xe6050055), /* PORT85CR */
	PORTCR(86, 0xe6050056), /* PORT86CR */
	PORTCR(87, 0xe6050057), /* PORT87CR */
	PORTCR(88, 0xe6050058), /* PORT88CR */
	PORTCR(89, 0xe6050059), /* PORT89CR */

	PORTCR(90, 0xe605005a), /* PORT90CR */
	PORTCR(91, 0xe605005b), /* PORT91CR */
	PORTCR(92, 0xe605005c), /* PORT92CR */
	PORTCR(93, 0xe605005d), /* PORT93CR */
	PORTCR(94, 0xe605005e), /* PORT94CR */
	PORTCR(95, 0xe605005f), /* PORT95CR */
	PORTCR(96, 0xe6050060), /* PORT96CR */
	PORTCR(97, 0xe6050061), /* PORT97CR */
	PORTCR(98, 0xe6050062), /* PORT98CR */
	PORTCR(99, 0xe6050063), /* PORT99CR */

	PORTCR(100, 0xe6050064), /* PORT100CR */
	PORTCR(101, 0xe6050065), /* PORT101CR */
	PORTCR(102, 0xe6050066), /* PORT102CR */
	PORTCR(103, 0xe6050067), /* PORT103CR */
	PORTCR(104, 0xe6050068), /* PORT104CR */
	PORTCR(105, 0xe6050069), /* PORT105CR */
	PORTCR(106, 0xe605006a), /* PORT106CR */
	PORTCR(107, 0xe605006b), /* PORT107CR */
	PORTCR(108, 0xe605006c), /* PORT108CR */
	PORTCR(109, 0xe605006d), /* PORT109CR */

	PORTCR(110, 0xe605006e), /* PORT110CR */
	PORTCR(111, 0xe605006f), /* PORT111CR */
	PORTCR(112, 0xe6050070), /* PORT112CR */
	PORTCR(113, 0xe6050071), /* PORT113CR */
	PORTCR(114, 0xe6050072), /* PORT114CR */
	PORTCR(115, 0xe6050073), /* PORT115CR */
	PORTCR(116, 0xe6050074), /* PORT116CR */
	PORTCR(117, 0xe6050075), /* PORT117CR */
	PORTCR(118, 0xe6050076), /* PORT118CR */

	PORTCR(128, 0xe6051080), /* PORT128CR */
	PORTCR(129, 0xe6051081), /* PORT129CR */

	PORTCR(130, 0xe6051082), /* PORT130CR */
	PORTCR(131, 0xe6051083), /* PORT131CR */
	PORTCR(132, 0xe6051084), /* PORT132CR */
	PORTCR(133, 0xe6051085), /* PORT133CR */
	PORTCR(134, 0xe6051086), /* PORT134CR */
	PORTCR(135, 0xe6051087), /* PORT135CR */
	PORTCR(136, 0xe6051088), /* PORT136CR */
	PORTCR(137, 0xe6051089), /* PORT137CR */
	PORTCR(138, 0xe605108a), /* PORT138CR */
	PORTCR(139, 0xe605108b), /* PORT139CR */

	PORTCR(140, 0xe605108c), /* PORT140CR */
	PORTCR(141, 0xe605108d), /* PORT141CR */
	PORTCR(142, 0xe605108e), /* PORT142CR */
	PORTCR(143, 0xe605108f), /* PORT143CR */
	PORTCR(144, 0xe6051090), /* PORT144CR */
	PORTCR(145, 0xe6051091), /* PORT145CR */
	PORTCR(146, 0xe6051092), /* PORT146CR */
	PORTCR(147, 0xe6051093), /* PORT147CR */
	PORTCR(148, 0xe6051094), /* PORT148CR */
	PORTCR(149, 0xe6051095), /* PORT149CR */

	PORTCR(150, 0xe6051096), /* PORT150CR */
	PORTCR(151, 0xe6051097), /* PORT151CR */
	PORTCR(152, 0xe6051098), /* PORT152CR */
	PORTCR(153, 0xe6051099), /* PORT153CR */
	PORTCR(154, 0xe605109a), /* PORT154CR */
	PORTCR(155, 0xe605109b), /* PORT155CR */
	PORTCR(156, 0xe605109c), /* PORT156CR */
	PORTCR(157, 0xe605109d), /* PORT157CR */
	PORTCR(158, 0xe605109e), /* PORT158CR */
	PORTCR(159, 0xe605109f), /* PORT159CR */

	PORTCR(160, 0xe60510a0), /* PORT160CR */
	PORTCR(161, 0xe60510a1), /* PORT161CR */
	PORTCR(162, 0xe60510a2), /* PORT162CR */
	PORTCR(163, 0xe60510a3), /* PORT163CR */
	PORTCR(164, 0xe60510a4), /* PORT164CR */

	PORTCR(192, 0xe60520c0), /* PORT192CR */
	PORTCR(193, 0xe60520c1), /* PORT193CR */
	PORTCR(194, 0xe60520c2), /* PORT194CR */
	PORTCR(195, 0xe60520c3), /* PORT195CR */
	PORTCR(196, 0xe60520c4), /* PORT196CR */
	PORTCR(197, 0xe60520c5), /* PORT197CR */
	PORTCR(198, 0xe60520c6), /* PORT198CR */
	PORTCR(199, 0xe60520c7), /* PORT199CR */

	PORTCR(200, 0xe60520c8), /* PORT200CR */
	PORTCR(201, 0xe60520c9), /* PORT201CR */
	PORTCR(202, 0xe60520ca), /* PORT202CR */
	PORTCR(203, 0xe60520cb), /* PORT203CR */
	PORTCR(204, 0xe60520cc), /* PORT204CR */
	PORTCR(205, 0xe60520cd), /* PORT205CR */
	PORTCR(206, 0xe60520ce), /* PORT206CR */
	PORTCR(207, 0xe60520cf), /* PORT207CR */
	PORTCR(208, 0xe60520d0), /* PORT208CR */
	PORTCR(209, 0xe60520d1), /* PORT209CR */

	PORTCR(210, 0xe60520d2), /* PORT210CR */
	PORTCR(211, 0xe60520d3), /* PORT211CR */
	PORTCR(212, 0xe60520d4), /* PORT212CR */
	PORTCR(213, 0xe60520d5), /* PORT213CR */
	PORTCR(214, 0xe60520d6), /* PORT214CR */
	PORTCR(215, 0xe60520d7), /* PORT215CR */
	PORTCR(216, 0xe60520d8), /* PORT216CR */
	PORTCR(217, 0xe60520d9), /* PORT217CR */
	PORTCR(218, 0xe60520da), /* PORT218CR */
	PORTCR(219, 0xe60520db), /* PORT219CR */

	PORTCR(220, 0xe60520dc), /* PORT220CR */
	PORTCR(221, 0xe60520dd), /* PORT221CR */
	PORTCR(222, 0xe60520de), /* PORT222CR */
	PORTCR(223, 0xe60520df), /* PORT223CR */
	PORTCR(224, 0xe60520e0), /* PORT224CR */
	PORTCR(225, 0xe60520e1), /* PORT225CR */
	PORTCR(226, 0xe60520e2), /* PORT226CR */
	PORTCR(227, 0xe60520e3), /* PORT227CR */
	PORTCR(228, 0xe60520e4), /* PORT228CR */
	PORTCR(229, 0xe60520e5), /* PORT229CR */

	PORTCR(230, 0xe60520e6), /* PORT230CR */
	PORTCR(231, 0xe60520e7), /* PORT231CR */
	PORTCR(232, 0xe60520e8), /* PORT232CR */
	PORTCR(233, 0xe60520e9), /* PORT233CR */
	PORTCR(234, 0xe60520ea), /* PORT234CR */
	PORTCR(235, 0xe60520eb), /* PORT235CR */
	PORTCR(236, 0xe60520ec), /* PORT236CR */
	PORTCR(237, 0xe60520ed), /* PORT237CR */
	PORTCR(238, 0xe60520ee), /* PORT238CR */
	PORTCR(239, 0xe60520ef), /* PORT239CR */

	PORTCR(240, 0xe60520f0), /* PORT240CR */
	PORTCR(241, 0xe60520f1), /* PORT241CR */
	PORTCR(242, 0xe60520f2), /* PORT242CR */
	PORTCR(243, 0xe60520f3), /* PORT243CR */
	PORTCR(244, 0xe60520f4), /* PORT244CR */
	PORTCR(245, 0xe60520f5), /* PORT245CR */
	PORTCR(246, 0xe60520f6), /* PORT246CR */
	PORTCR(247, 0xe60520f7), /* PORT247CR */
	PORTCR(248, 0xe60520f8), /* PORT248CR */
	PORTCR(249, 0xe60520f9), /* PORT249CR */

	PORTCR(250, 0xe60520fa), /* PORT250CR */
	PORTCR(251, 0xe60520fb), /* PORT251CR */
	PORTCR(252, 0xe60520fc), /* PORT252CR */
	PORTCR(253, 0xe60520fd), /* PORT253CR */
	PORTCR(254, 0xe60520fe), /* PORT254CR */
	PORTCR(255, 0xe60520ff), /* PORT255CR */
	PORTCR(256, 0xe6052100), /* PORT256CR */
	PORTCR(257, 0xe6052101), /* PORT257CR */
	PORTCR(258, 0xe6052102), /* PORT258CR */
	PORTCR(259, 0xe6052103), /* PORT259CR */

	PORTCR(260, 0xe6052104), /* PORT260CR */
	PORTCR(261, 0xe6052105), /* PORT261CR */
	PORTCR(262, 0xe6052106), /* PORT262CR */
	PORTCR(263, 0xe6052107), /* PORT263CR */
	PORTCR(264, 0xe6052108), /* PORT264CR */

	{ PINMUX_CFG_REG("MSELBCR", 0xe6058024, 32, 1) {
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			MSELBCR_MSEL17_0, MSELBCR_MSEL17_1,
			MSELBCR_MSEL16_0, MSELBCR_MSEL16_1,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ },
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PORTL031_000DR", 0xe6054000, 32) {
			PORT31_DATA, PORT30_DATA, PORT29_DATA, PORT28_DATA,
			PORT27_DATA, PORT26_DATA, PORT25_DATA, PORT24_DATA,
			PORT23_DATA, PORT22_DATA, PORT21_DATA, PORT20_DATA,
			PORT19_DATA, PORT18_DATA, PORT17_DATA, PORT16_DATA,
			PORT15_DATA, PORT14_DATA, PORT13_DATA, PORT12_DATA,
			PORT11_DATA, PORT10_DATA, PORT9_DATA, PORT8_DATA,
			PORT7_DATA, PORT6_DATA, PORT5_DATA, PORT4_DATA,
			PORT3_DATA, PORT2_DATA, PORT1_DATA, PORT0_DATA }
	},
	{ PINMUX_DATA_REG("PORTL063_032DR", 0xe6054004, 32) {
			PORT63_DATA, PORT62_DATA, PORT61_DATA, PORT60_DATA,
			PORT59_DATA, PORT58_DATA, PORT57_DATA, PORT56_DATA,
			PORT55_DATA, PORT54_DATA, PORT53_DATA, PORT52_DATA,
			PORT51_DATA, PORT50_DATA, PORT49_DATA, PORT48_DATA,
			PORT47_DATA, PORT46_DATA, PORT45_DATA, PORT44_DATA,
			PORT43_DATA, PORT42_DATA, PORT41_DATA, PORT40_DATA,
			PORT39_DATA, PORT38_DATA, PORT37_DATA, PORT36_DATA,
			PORT35_DATA, PORT34_DATA, PORT33_DATA, PORT32_DATA }
	},
	{ PINMUX_DATA_REG("PORTL095_064DR", 0xe6054008, 32) {
			PORT95_DATA, PORT94_DATA, PORT93_DATA, PORT92_DATA,
			PORT91_DATA, PORT90_DATA, PORT89_DATA, PORT88_DATA,
			PORT87_DATA, PORT86_DATA, PORT85_DATA, PORT84_DATA,
			PORT83_DATA, PORT82_DATA, PORT81_DATA, PORT80_DATA,
			PORT79_DATA, PORT78_DATA, PORT77_DATA, PORT76_DATA,
			PORT75_DATA, PORT74_DATA, PORT73_DATA, PORT72_DATA,
			PORT71_DATA, PORT70_DATA, PORT69_DATA, PORT68_DATA,
			PORT67_DATA, PORT66_DATA, PORT65_DATA, PORT64_DATA }
	},
	{ PINMUX_DATA_REG("PORTD127_096DR", 0xe605400C, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, PORT118_DATA, PORT117_DATA, PORT116_DATA,
			PORT115_DATA, PORT114_DATA, PORT113_DATA, PORT112_DATA,
			PORT111_DATA, PORT110_DATA, PORT109_DATA, PORT108_DATA,
			PORT107_DATA, PORT106_DATA, PORT105_DATA, PORT104_DATA,
			PORT103_DATA, PORT102_DATA, PORT101_DATA, PORT100_DATA,
			PORT99_DATA, PORT98_DATA, PORT97_DATA, PORT96_DATA }
	},
	{ PINMUX_DATA_REG("PORTD159_128DR", 0xe6055000, 32) {
			PORT159_DATA, PORT158_DATA, PORT157_DATA, PORT156_DATA,
			PORT155_DATA, PORT154_DATA, PORT153_DATA, PORT152_DATA,
			PORT151_DATA, PORT150_DATA, PORT149_DATA, PORT148_DATA,
			PORT147_DATA, PORT146_DATA, PORT145_DATA, PORT144_DATA,
			PORT143_DATA, PORT142_DATA, PORT141_DATA, PORT140_DATA,
			PORT139_DATA, PORT138_DATA, PORT137_DATA, PORT136_DATA,
			PORT135_DATA, PORT134_DATA, PORT133_DATA, PORT132_DATA,
			PORT131_DATA, PORT130_DATA, PORT129_DATA, PORT128_DATA }
	},
	{ PINMUX_DATA_REG("PORTR191_160DR", 0xe6055004, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, PORT164_DATA,
			PORT163_DATA, PORT162_DATA, PORT161_DATA, PORT160_DATA }
	},
	{ PINMUX_DATA_REG("PORTR223_192DR", 0xe6056000, 32) {
			PORT223_DATA, PORT222_DATA, PORT221_DATA, PORT220_DATA,
			PORT219_DATA, PORT218_DATA, PORT217_DATA, PORT216_DATA,
			PORT215_DATA, PORT214_DATA, PORT213_DATA, PORT212_DATA,
			PORT211_DATA, PORT210_DATA, PORT209_DATA, PORT208_DATA,
			PORT207_DATA, PORT206_DATA, PORT205_DATA, PORT204_DATA,
			PORT203_DATA, PORT202_DATA, PORT201_DATA, PORT200_DATA,
			PORT199_DATA, PORT198_DATA, PORT197_DATA, PORT196_DATA,
			PORT195_DATA, PORT194_DATA, PORT193_DATA, PORT192_DATA }
	},
	{ PINMUX_DATA_REG("PORTU255_224DR", 0xe6056004, 32) {
			PORT255_DATA, PORT254_DATA, PORT253_DATA, PORT252_DATA,
			PORT251_DATA, PORT250_DATA, PORT249_DATA, PORT248_DATA,
			PORT247_DATA, PORT246_DATA, PORT245_DATA, PORT244_DATA,
			PORT243_DATA, PORT242_DATA, PORT241_DATA, PORT240_DATA,
			PORT239_DATA, PORT238_DATA, PORT237_DATA, PORT236_DATA,
			PORT235_DATA, PORT234_DATA, PORT233_DATA, PORT232_DATA,
			PORT231_DATA, PORT230_DATA, PORT229_DATA, PORT228_DATA,
			PORT227_DATA, PORT226_DATA, PORT225_DATA, PORT224_DATA }
	},
	{ PINMUX_DATA_REG("PORTU287_256DR", 0xe6056008, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, PORT264_DATA,
			PORT263_DATA, PORT262_DATA, PORT261_DATA, PORT260_DATA,
			PORT259_DATA, PORT258_DATA, PORT257_DATA, PORT256_DATA }
	},
	{ },
};

static struct pinmux_info sh7377_pinmux_info = {
	.name = "sh7377_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.input_pu = { PINMUX_INPUT_PULLUP_BEGIN, PINMUX_INPUT_PULLUP_END },
	.input_pd = { PINMUX_INPUT_PULLDOWN_BEGIN, PINMUX_INPUT_PULLDOWN_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PORT0,
	.last_gpio = GPIO_FN_RESETOUTS,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

void sh7377_pinmux_init(void)
{
	register_pinmux(&sh7377_pinmux_info);
}
