// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2017 Oracle.  All Rights Reserved.
 * Author: Darrick J. Wong <darrick.wong@oracle.com>
 */
#ifndef __XFS_SCRUB_DABTREE_H__
#define __XFS_SCRUB_DABTREE_H__

/* dir/attr btree */

struct xfs_scrub_da_btree {
	struct xfs_da_args		dargs;
	xfs_dahash_t			hashes[XFS_DA_NODE_MAXDEPTH];
	int				maxrecs[XFS_DA_NODE_MAXDEPTH];
	struct xfs_da_state		*state;
	struct xfs_scrub_context	*sc;
	void				*private;

	/*
	 * Lowest and highest directory block address in which we expect
	 * to find dir/attr btree node blocks.  For a directory this
	 * (presumably) means between LEAF_OFFSET and FREE_OFFSET; for
	 * attributes there is no limit.
	 */
	xfs_dablk_t			lowest;
	xfs_dablk_t			highest;

	int				tree_level;
};

typedef int (*xfs_scrub_da_btree_rec_fn)(struct xfs_scrub_da_btree *ds,
		int level, void *rec);

/* Check for da btree operation errors. */
bool xfs_scrub_da_process_error(struct xfs_scrub_da_btree *ds, int level, int *error);

/* Check for da btree corruption. */
void xfs_scrub_da_set_corrupt(struct xfs_scrub_da_btree *ds, int level);

int xfs_scrub_da_btree_hash(struct xfs_scrub_da_btree *ds, int level,
			    __be32 *hashp);
int xfs_scrub_da_btree(struct xfs_scrub_context *sc, int whichfork,
		       xfs_scrub_da_btree_rec_fn scrub_fn, void *private);

#endif /* __XFS_SCRUB_DABTREE_H__ */
