/* SPDX-License-Identifier: GPL-2.0 OR MIT */
/* Copyright (c) 2024 Imagination Technologies Ltd. */

#ifndef PVR_ROGUE_RISCV_H
#define PVR_ROGUE_RISCV_H

#include "pvr_rogue_cr_defs.h"

#include <linux/bitops.h>
#include <linux/sizes.h>
#include <linux/types.h>

#define ROGUE_RISCVFW_REGION_SIZE SZ_256M
#define ROGUE_RISCVFW_REGION_SHIFT __ffs(ROGUE_RISCVFW_REGION_SIZE)

enum rogue_riscvfw_region {
	ROGUE_RISCV_REGION__RESERVED_0 = 0,
	ROGUE_RISCV_REGION__RESERVED_1,
	ROGUE_RISCV_REGION_SOCIF,
	ROGUE_RISCV_REGION__RESERVED_3,
	ROGUE_RISCV_REGION__RESERVED_4,
	ROGUE_RISCV_REGION_BOOTLDR_DATA,
	ROGUE_RISCV_REGION_SHARED_CACHED_DATA,
	ROGUE_RISCV_REGION__RESERVED_7,
	ROGUE_RISCV_REGION_COREMEM,
	ROGUE_RISCV_REGION__RESERVED_9,
	ROGUE_RISCV_REGION__RESERVED_A,
	ROGUE_RISCV_REGION__RESERVED_B,
	ROGUE_RISCV_REGION_BOOTLDR_CODE,
	ROGUE_RISCV_REGION_SHARED_UNCACHED_DATA,
	ROGUE_RISCV_REGION__RESERVED_E,
	ROGUE_RISCV_REGION__RESERVED_F,

	ROGUE_RISCV_REGION__COUNT,
};

#define ROGUE_RISCVFW_REGION_BASE(r) ((u32)(ROGUE_RISCV_REGION_##r) << ROGUE_RISCVFW_REGION_SHIFT)
#define ROGUE_RISCVFW_REGION_REMAP_CR(r) \
	(ROGUE_CR_FWCORE_ADDR_REMAP_CONFIG0 + (u32)(ROGUE_RISCV_REGION_##r) * 8U)

#endif /* PVR_ROGUE_RISCV_H */
