/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.jdbc23;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import org.postgresql.PGConnection;
import org.postgresql.PGStatement;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc23PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private final boolean autoCommit;
    private final boolean isXA;
    private static String[] fatalClasses = new String[]{"08", "53", "57P01", "57P02", "57P03", "58", "60", "99", "F0", "XX"};

    public AbstractJdbc23PooledConnection(Connection con, boolean autoCommit, boolean isXA) {
        this.con = con;
        this.autoCommit = autoCommit;
        this.isXA = isXA;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
        }
        finally {
            this.con = null;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler handler;
        if (this.con == null) {
            PSQLException sqlException = new PSQLException(GT.tr("This PooledConnection has already been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            this.fireConnectionFatalError(sqlException);
            throw sqlException;
        }
        try {
            if (this.last != null) {
                this.last.close();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.con.clearWarnings();
            }
            if (!this.isXA) {
                this.con.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sqlException) {
            this.fireConnectionFatalError(sqlException);
            throw (SQLException)sqlException.fillInStackTrace();
        }
        this.last = handler = new ConnectionHandler(this.con);
        Connection proxyCon = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, PGConnection.class}, (InvocationHandler)handler);
        this.last.setProxy(proxyCon);
        return proxyCon;
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = this.createConnectionEvent(null);
            }
            listener.connectionClosed(evt);
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = this.createConnectionEvent(e);
            }
            listener.connectionErrorOccurred(evt);
        }
    }

    protected abstract ConnectionEvent createConnectionEvent(SQLException var1);

    private static boolean isFatalState(String state) {
        if (state == null) {
            return true;
        }
        if (state.length() < 2) {
            return true;
        }
        for (int i = 0; i < fatalClasses.length; ++i) {
            if (!state.startsWith(fatalClasses[i])) continue;
            return true;
        }
        return false;
    }

    private void fireConnectionError(SQLException e) {
        if (!AbstractJdbc23PooledConnection.isFatalState(e.getSQLState())) {
            return;
        }
        this.fireConnectionFatalError(e);
    }

    private class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler con, Statement st) {
            this.con = con;
            this.st = st;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(System.identityHashCode(proxy));
                }
                if (method.getName().equals("equals")) {
                    return new Boolean(proxy == args[0]);
                }
                return method.invoke((Object)this.st, args);
            }
            if (method.getName().equals("close")) {
                if (this.st == null || this.con.isClosed()) {
                    return null;
                }
                try {
                    this.st.close();
                }
                finally {
                    this.con = null;
                    this.st = null;
                }
                return null;
            }
            if (this.st == null || this.con.isClosed()) {
                throw new PSQLException(GT.tr("Statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, args);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof SQLException) {
                    AbstractJdbc23PooledConnection.this.fireConnectionError((SQLException)te);
                }
                throw te;
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;

        public ConnectionHandler(Connection con) {
            this.con = con;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("equals")) {
                    return new Boolean(proxy == args[0]);
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(System.identityHashCode(proxy));
                }
                try {
                    return method.invoke((Object)this.con, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null && !method.getName().equals("close")) {
                throw new PSQLException(this.automatic ? GT.tr("Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed.") : GT.tr("Connection has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            if (method.getName().equals("close")) {
                if (this.con == null) {
                    return null;
                }
                SQLException ex = null;
                if (!AbstractJdbc23PooledConnection.this.isXA && !this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        ex = e;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                this.proxy = null;
                AbstractJdbc23PooledConnection.this.last = null;
                AbstractJdbc23PooledConnection.this.fireConnectionClosed();
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            try {
                if (method.getName().equals("createStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Statement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, st));
                }
                if (method.getName().equals("prepareCall")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CallableStatement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, st));
                }
                if (method.getName().equals("prepareStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, st));
                }
                return method.invoke((Object)this.con, args);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof SQLException) {
                    AbstractJdbc23PooledConnection.this.fireConnectionError((SQLException)te);
                }
                throw te;
            }
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection proxy) {
            this.proxy = proxy;
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
            this.proxy = null;
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }
}

