# This spec file and ancilliary files are licensed in accordance with
# The pgAdmin license.
# In this file you can find the default build package list macros.  
# These can be overridden
# by defining on the rpm command line:
# rpm --define 'macroname value' ... to change the value of the macro.

Summary:	Graphical client for PostgreSQL
Name:		pgadmin3
Version:        1.10.3
Release:        1
License:        BSD
Group:          Applications/Databases
URL:		http://www.pgadmin.org/
Packager:	pgAdmin project <pgadmin-hackers@postgresql.org>
Source:		pgadmin3-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
BuildRequires:	postgresql-devel
Requires:	postgresql

%define wxGTK2_version 2.8
%define withwxconfig wx-config
%define desktop_vendor pgadmin

%define beta 0
%{?beta:%define __os_install_post /usr/lib/rpm/brp-compress}

%description
pgAdmin III is a powerful administration and development 
platform for the PostgreSQL database, free for any use.
It is designed to answer the needs of all users,
from writing simple SQL queries to developing complex 
databases. The graphical interface supports all PostgreSQL 
features and makes administration easy. 

The application also includes a query builder, an SQL 
editor, a server-side code editor and much more. 

%prep
%setup -q -n %{name}-%{version}

%build
%configure --disable-debug  --with-wx-version=2.8
make all

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
strip --strip-debug %{buildroot}/%{_bindir}/%{name}
chmod +x $RPM_BUILD_ROOT/%{_bindir}/pgadmin3

cp -f ./pgadmin/include/images/elephant32.xpm %{buildroot}/%{_datadir}/%{name}/%{name}.xpm
cp -f ./pkg/%{name}.desktop %{buildroot}/%{_datadir}/%{name}/%{name}.desktop

mkdir -p %{buildroot}/%{_datadir}/applications

desktop-file-install --vendor %{desktop_vendor} --delete-original  --dir %{buildroot}/%{_datadir}/applications --add-category X-Red-Hat-Base --add-category Application --add-category Development %{buildroot}/%{_datadir}/%{name}/%{name}.desktop

%clean
rm -rf %{buildroot}

%files
%defattr(-, root, root)
%{_bindir}/*
%{_datadir}/%{name}
%{_datadir}/applications

%changelog
* Thu Dec 12 2006 Hiroshi Saito <z-saito@guitar.ocn.ne.jp>
- 1.6.2 on OpenSUSE

* Tue Jun 21 2005 Vasilev Max <max@stranger-team.ru>
- minor spec fix
- build with PostgreSQL 8.0.3 header (current in 9.3)

* Sun Jun 18 2005 Vasilev Max <max@stranger-team.ru>
- up to date wx to 2.6.1 (use only GTK part)
- up to date version to 1.2.2

* Wed Apr 6 2005 Vasilev Max <max@stranger-team.ru>
- up to date wx to 2.6.0
- up to date version to 1.2.1

* Thu Feb 8 2005 Vasilev Max <max@stranger-team.ru>
- fix requieres and description
- build with PortgreSQL 8.0.1

* Thu Feb 8 2005 Vasilev Max <max@stranger-team.ru>
- fix spec for AMD64

* Mon Nov 29 2004 Devrim GUNDUZ <devrim@gunduz.org>
- 1.2.0 Gold

* Wed Nov 17 2004 Devrim GUNDUZ <devrim@gunduz.org>
- 1.2.0 RC2

* Mon Nov 15 2004 Devrim GUNDUZ <devrim@gunduz.org>
- 1.2.0 RC1 rebuilt
- Fixed spec file so that beta and rc tags will be considered. (Note: AFAICS my previous rpms were broken :( )

* Thu Nov 4 2004 Devrim GUNDUZ <devrim@gunduz.org>
- 1.2.0 RC1

* Mon Jun 10 2003 Jean-Michel POURE <pgadmin-hackers@postgresql.org>
- Initial build

