//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: frmHelp.h,v 1.7.2.1 2005/01/10 15:30:25 dpage Exp $
// Copyright (C) 2002 - 2005, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// frmHelp.h - Help Screen
//
//////////////////////////////////////////////////////////////////////////


#ifndef __FRMHELP
#define __FRMHELP

#include "wx/wxhtml.h"


class ctlHelpWindow;
class frmMain;
class frmHelp : public pgFrame
{
public:
    frmHelp(wxWindow *fr);
    ~frmHelp();
    static bool LoadLocalDoc(wxWindow *wnd, const wxString &page, char **icon=0);
    static bool LoadSqlDoc(wxWindow *wnd, const wxString &page, char **icon=0);

    bool Load(const wxString &page, char **icon=0);
    void OnLinkClicked(const wxHtmlLinkInfo& link);

private:
    void OnBack(wxCommandEvent &ev);
    void OnRefresh(wxCommandEvent &ev);
    void OnForward(wxCommandEvent &ev);
    void CheckToolBar();

    frmMain *mainForm;
    ctlHelpWindow *htmlWindow;
    wxString currentPage;

    DECLARE_EVENT_TABLE();
};

class ctlHelpWindow : public wxHtmlWindow 
{
public:
    ctlHelpWindow(frmHelp *frm);

private:
    void OnLinkClicked(const wxHtmlLinkInfo& link);
    frmHelp *helpForm;
};

#endif
