//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: dlgView.cpp,v 1.10.2.1 2005/01/10 15:30:25 dpage Exp $
// Copyright (C) 2002 - 2005, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// dlgView.cpp - PostgreSQL View Property
//
//////////////////////////////////////////////////////////////////////////

// wxWindows headers
#include <wx/wx.h>

// App headers
#include "pgAdmin3.h"
#include "misc.h"
#include "pgDefs.h"

#include "ctlSQLBox.h"
#include "dlgView.h"
#include "pgView.h"
#include "pgCollection.h"


// Images
#include "images/view.xpm"


// pointer to controls
#define pnlDefinition   CTRL_PANEL("pnlDefinition")
#define txtSqlBox       CTRL_SQLBOX("txtSqlBox")



BEGIN_EVENT_TABLE(dlgView, dlgSecurityProperty)
    EVT_STC_MODIFIED(XRCID("txtSqlBox"),            dlgProperty::OnChangeStc)
END_EVENT_TABLE();


dlgView::dlgView(frmMain *frame, pgView *node, pgSchema *sch)
: dlgSecurityProperty(frame, node, wxT("dlgView"), wxT("INSERT,SELECT,UPDATE,DELETE,RULE,REFERENCE,TRIGGER"), "arwdRxt")
{
    SetIcon(wxIcon(view_xpm));
    schema=sch;
    view=node;
}


pgObject *dlgView::GetObject()
{
    return view;
}


int dlgView::Go(bool modal)
{
    AddGroups();
    AddUsers();

    if (view)
    {
        // edit mode

        oldDefinition=view->GetFormattedDefinition();
        txtSqlBox->SetText(oldDefinition);
    }
    else
    {
        // create mode
    }

    return dlgSecurityProperty::Go(modal);
}


pgObject *dlgView::CreateObject(pgCollection *collection)
{
    pgObject *obj=pgView::ReadObjects(collection, 0, 
        wxT("\n   AND c.relname=") + qtString(txtName->GetValue()) +
        wxT("\n   AND c.relnamespace=") + schema->GetOidStr());
    return obj;
}


void dlgView::CheckChange()
{
    wxString name=GetName();
    if (view)
    {
        EnableOK(txtComment->GetValue() != view->GetComment()
              || txtSqlBox->GetText() != oldDefinition
              || cbOwner->GetValue() != view->GetOwner()
              || name != view->GetName());
    }
    else
    {
        bool enable=true;

        CheckValid(enable, !name.IsEmpty(), _("Please specify name."));
        CheckValid(enable, txtSqlBox->GetText().Length() > 14 , _("Please enter function definition."));

        EnableOK(enable);
    }
}


wxString dlgView::GetSql()
{
    wxString sql, name=GetName();


    if (view)
    {
        // edit mode

        if (name != view->GetName())
        {
            sql += wxT("ALTER TABLE ") + view->GetQuotedFullIdentifier()
                +  wxT(" RENAME TO ") + qtIdent(name) + wxT(";\n");
        }
        if (cbOwner->GetValue() != view->GetOwner())
            sql += wxT("ALTER TABLE ") + qtIdent(name)
                +  wxT(" OWNER TO ") + qtIdent(cbOwner->GetValue()) + wxT(";\n");
    }

    if (!view || txtSqlBox->GetText() != oldDefinition)
    {
        sql += wxT("CREATE OR REPLACE VIEW ") + schema->GetQuotedPrefix() + qtIdent(name) + wxT(" AS\n")
            + txtSqlBox->GetText()
            + wxT(";\n");
    }

    sql +=  GetGrant(wxT("arwdRxt"), wxT("TABLE ") + schema->GetQuotedPrefix() + qtIdent(name));

    AppendComment(sql, wxT("VIEW"), schema, view);
    return sql;
}

