//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: dlgColumn.h 4410 2005-08-21 11:53:02Z andreas $
// Copyright (C) 2002 - 2005, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// dlgColumn.h - Column property 
//
//////////////////////////////////////////////////////////////////////////


#ifndef __DLG_COLUMNPROP
#define __DLG_COLUMNPROP

#include "dlgProperty.h"

class pgColumn;
class pgTable;

class dlgColumn : public dlgTypeProperty
{
public:
    dlgColumn(pgaFactory *factory, frmMain *frame, pgColumn *column, pgTable *parentNode);

    void CheckChange();
    wxString GetSql();
    pgObject *CreateObject(pgCollection *collection);
    pgObject *GetObject();
    wxString GetDefinition();
    wxString GetPreviousDefinition() { return previousDefinition; }
	wxString GetComment() {	return txtComment->GetValue(); }
	wxString GetStatistics() {	return CTRL_TEXT("txtAttstattarget")->GetValue(); }

    int Go(bool modal);


private:
    pgColumn *column;
    pgTable *table;
    void OnSelChangeTyp(wxCommandEvent &ev);
 
    wxString previousDefinition;
    wxArrayString sequences;

    DECLARE_EVENT_TABLE();
};


#endif
