//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: pgCast.h 4403 2005-08-15 08:58:47Z andreas $
// Copyright (C) 2002 - 2005, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// pgCast.h PostgreSQL Cast
//
//////////////////////////////////////////////////////////////////////////

#ifndef PGCAST_H
#define PGCAST_H


// App headers
#include "pgDatabase.h"

class pgCollection;
class pgCastFactory : public pgDatabaseObjFactory
{
public:
    pgCastFactory();
    virtual dlgProperty *CreateDialog(frmMain *frame, pgObject *node, pgObject *parent);
    virtual pgObject *CreateObjects(pgCollection *obj, ctlTree *browser, const wxString &restr=wxEmptyString);
};
extern pgCastFactory castFactory;


class pgCast : public pgDatabaseObject
{
public:
    pgCast(const wxString& newName = wxT(""));
    ~pgCast();

    void ShowTreeDetail(ctlTree *browser, frmMain *form=0, ctlListView *properties=0, ctlSQLBox *sqlPane=0);

    bool CanDropCascaded() { return true; }

    bool GetSystemObject() const { return GetOid() <= GetConnection()->GetLastSystemOID(); }
    wxString GetSourceType() const { return sourceType; }
    void iSetSourceType(const wxString& s) { sourceType=s; }
    wxString GetTargetType() const { return targetType; }
    void iSetTargetType(const wxString& s) { targetType=s; }
    wxString GetSourceNamespace() const { return sourceNamespace; }
    void iSetSourceNamespace(const wxString& s) { sourceNamespace=s; }
    wxString GetTargetNamespace() const { return targetNamespace; }
    void iSetTargetNamespace(const wxString& s) { targetNamespace=s; }
    OID GetSourceTypeOid() const { return sourceTypeOid; }
    void iSetSourceTypeOid(const OID o) { sourceTypeOid=o; }
    OID GetTargetTypeOid() const { return targetTypeOid; }
    void iSetTargetTypeOid(const OID o) { targetTypeOid=o; }
    wxString GetCastFunction() const { return castFunction; }
    void iSetCastFunction(const wxString& s) { castFunction=s; }
    wxString GetCastNamespace() const { return castNamespace; }
    void iSetCastNamespace(const wxString& s) { castNamespace=s; }
    
    wxString GetCastContext() const { return castContext; }
    void iSetCastContext(const wxString& s) { castContext=s; }

    bool DropObject(wxFrame *frame, ctlTree *browser, bool cascaded);
    wxString GetSql(ctlTree *browser);
    pgObject *Refresh(ctlTree *browser, const wxTreeItemId item);

private:
    wxString sourceType, sourceNamespace, targetType, targetNamespace, 
             castFunction, castContext, castNamespace;
    OID sourceTypeOid, targetTypeOid;
};

#endif
