//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: ctlSQLBox.h 5572 2006-10-30 10:45:47Z dpage $
// Copyright (C) 2002 - 2006, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// ctlSQLBox.h - SQL syntax highlighting textbox
//
//////////////////////////////////////////////////////////////////////////

#ifndef CTLSQLBOX_H
#define CTLSQLBOX_H

// wxWindows headers
#include <wx/wx.h>
#include <wx/stc/stc.h>
#include <wx/fdrepdlg.h>

#include "pgConn.h"
#include "dlgFindReplace.h"

// Class declarations
class ctlSQLBox : public wxStyledTextCtrl
{
    static wxString sqlKeywords;

public:
    ctlSQLBox(wxWindow *parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0);
    ctlSQLBox();
    ~ctlSQLBox();

    void Create(wxWindow *parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0);

	void SetDatabase(pgConn *db);

    void OnKeyDown(wxKeyEvent& event);
	void OnAutoComplete(wxCommandEvent& event);
    void OnSearchReplace(wxCommandEvent& event);
	void OnKillFocus(wxFocusEvent& event);

    void Find(const wxString &find, bool wholeWord, bool matchCase, bool useRegexps, bool startAtTop, bool reverse);
    void Replace(const wxString &find, const wxString &replace, bool wholeWord, bool matchCase, bool useRegexps, bool startAtTop, bool reverse);
    void ReplaceAll(const wxString &find, const wxString &replace, bool wholeWord, bool matchCase, bool useRegexps);
    bool DoFind(const wxString &find, const wxString &replace, bool doReplace, bool wholeWord, bool matchCase, bool useRegexps, bool startAtTop, bool reverse);
    
    DECLARE_DYNAMIC_CLASS(ctlSQLBox)
    DECLARE_EVENT_TABLE()
		
private:

    void OnPositionStc(wxStyledTextEvent& event);

    dlgFindReplace* m_dlgFindReplace;
	pgConn *m_database;
    wxString lastFindString;
    int lastFindPos;
	
};


#endif
