//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: frmIndexcheck.h 5827 2007-01-04 16:35:14Z dpage $
// Copyright (C) 2002 - 2007, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// frmIndexcheck.h - Index checker dialogue
//
//////////////////////////////////////////////////////////////////////////

#ifndef __FRMINDEXCHECK_H
#define __FRMINDEXCHECK_H

#include "dlgClasses.h"
#include "base/factory.h"


// Class declarations
class frmIndexcheck : public ExecutionDialog
{
public:
    frmIndexcheck(frmMain *form, pgObject *_object);
    ~frmIndexcheck();

    wxString GetHelpPage() const;
    wxString GetSql();
    void Go();
    
private:
    void OnPageSelect(wxNotebookEvent& event);
    void OnCheckAll(wxCommandEvent &event);
    void OnUncheckAll(wxCommandEvent &event);

    void AddObjects(const wxString &where);
    
    ctlSQLBox *sqlPane;
    wxNotebook *nbNotebook;

    DECLARE_EVENT_TABLE()
};


class indexCheckFactory : public contextActionFactory
{
public:
    indexCheckFactory(menuFactoryList *list, wxMenu *mnu, wxToolBar *toolbar);
    wxWindow *StartDialog(frmMain *form, pgObject *obj);
    bool CheckEnable(pgObject *obj);
};

#endif
