/*-------------------------------------------------------------------------
 *
 * keywords.h
 *	  lexical token lookup for reserved words in postgres SQL
 *
 *
 * Portions Copyright (c) 1996-2006, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/parser/keywords.h,v 1.21 2006/03/05 15:58:57 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */

///////////////////////////////////////////////////////////////////////////
//
// pgAdmin note: This file is based on src/include/parser/keywords.h from
//               PostgreSQL. It should be periodically updated to include 
//               new keywords. struct ScanKeyword and the declaration of 
//               ScanKeywordLookup originate in this file, whilst the enum
//               yytokentype is copied from src/include/parser/parse.h
//
//               This file is under the BSD licence, per PostgreSQL.
///////////////////////////////////////////////////////////////////////////

#ifndef KEYWORDS_H
#define KEYWORDS_H

typedef struct ScanKeyword
{
	const char *name;
	int			value;
} ScanKeyword;

extern const ScanKeyword *ScanKeywordLookup(const char *text);

/* Put the tokens into the symbol table, so that GDB and other debuggers
  know about them.  */
enum yytokentype {
    ABORT_P = 258,
    ABSOLUTE_P = 259,
    ACCESS = 260,
    ACTION = 261,
    ADD_P = 262,
    ADMIN = 263,
    AFTER = 264,
    AGGREGATE = 265,
    ALL = 266,
    ALSO = 267,
    ALTER = 268,
    ANALYSE = 269,
    ANALYZE = 270,
    AND = 271,
    ANY = 272,
    ARRAY = 273,
    AS = 274,
    ASC = 275,
    ASSERTION = 276,
    ASSIGNMENT = 277,
    ASYMMETRIC = 278,
    AT = 279,
    AUTHORIZATION = 280,
    BACKWARD = 281,
    BEFORE = 282,
    BEGIN_P = 283,
    BETWEEN = 284,
    BIGINT = 285,
    BINARY = 286,
    BIT = 287,
    BOOLEAN_P = 288,
    BOTH = 289,
    BY = 290,
    CACHE = 291,
    CALLED = 292,
    CASCADE = 293,
    CASCADED = 294,
    CASE = 295,
    CAST = 296,
    CHAIN = 297,
    CHAR_P = 298,
    CHARACTER = 299,
    CHARACTERISTICS = 300,
    CHECK = 301,
    CHECKPOINT = 302,
    CLASS = 303,
    CLOSE = 304,
    CLUSTER = 305,
    COALESCE = 306,
    COLLATE = 307,
    COLUMN = 308,
    COMMENT = 309,
    COMMIT = 310,
    COMMITTED = 311,
    CONCURRENTLY = 312,
    CONNECTION = 313,
    CONSTRAINT = 314,
    CONSTRAINTS = 315,
    CONVERSION_P = 316,
    CONVERT = 317,
    COPY = 318,
    CREATE = 319,
    CREATEDB = 320,
    CREATEROLE = 321,
    CREATEUSER = 322,
    CROSS = 323,
    CSV = 324,
    CURRENT_DATE = 325,
    CURRENT_ROLE = 326,
    CURRENT_TIME = 327,
    CURRENT_TIMESTAMP = 328,
    CURRENT_USER = 329,
    CURSOR = 330,
    CYCLE = 331,
    DATABASE = 332,
    DAY_P = 333,
    DEALLOCATE = 334,
    DEC = 335,
    DECIMAL_P = 336,
    DECLARE = 337,
    DEFAULT = 338,
    DEFAULTS = 339,
    DEFERRABLE = 340,
    DEFERRED = 341,
    DEFINER = 342,
    DELETE_P = 343,
    DELIMITER = 344,
    DELIMITERS = 345,
    DESC = 346,
    DISABLE_P = 347,
    DISTINCT = 348,
    DO = 349,
    DOMAIN_P = 350,
    DOUBLE_P = 351,
    DROP = 352,
    EACH = 353,
    ELSE = 354,
    ENABLE_P = 355,
    ENCODING = 356,
    ENCRYPTED = 357,
    END_P = 358,
    ESCAPE = 359,
    EXCEPT = 360,
    EXCLUDING = 361,
    EXCLUSIVE = 362,
    EXECUTE = 363,
    EXISTS = 364,
    EXPLAIN = 365,
    EXTERNAL = 366,
    EXTRACT = 367,
    FALSE_P = 368,
    FETCH = 369,
    FIRST_P = 370,
    FLOAT_P = 371,
    FOR = 372,
    FORCE = 373,
    FOREIGN = 374,
    FORWARD = 375,
    FREEZE = 376,
    FROM = 377,
    FULL = 378,
    FUNCTION = 379,
    GLOBAL = 380,
    GRANT = 381,
    GRANTED = 382,
    GREATEST = 383,
    GROUP_P = 384,
    HANDLER = 385,
    HAVING = 386,
    HEADER_P = 387,
    HOLD = 388,
    HOUR_P = 389,
    IF_P = 390,
    ILIKE = 391,
    IMMEDIATE = 392,
    IMMUTABLE = 393,
    IMPLICIT_P = 394,
    IN_P = 395,
    INCLUDING = 396,
    INCREMENT = 397,
    INDEX = 398,
    INDEXES = 399,
    INHERIT = 400,
    INHERITS = 401,
    INITIALLY = 402,
    INNER_P = 403,
    INOUT = 404,
    INPUT_P = 405,
    INSENSITIVE = 406,
    INSERT = 407,
    INSTEAD = 408,
    INT_P = 409,
    INTEGER = 410,
    INTERSECT = 411,
    INTERVAL = 412,
    INTO = 413,
    INVOKER = 414,
    IS = 415,
    ISNULL = 416,
    ISOLATION = 417,
    JOIN = 418,
    KEY = 419,
    LANCOMPILER = 420,
    LANGUAGE = 421,
    LARGE_P = 422,
    LAST_P = 423,
    LEADING = 424,
    LEAST = 425,
    LEFT = 426,
    LEVEL = 427,
    LIKE = 428,
    LIMIT = 429,
    LISTEN = 430,
    LOAD = 431,
    LOCAL = 432,
    LOCALTIME = 433,
    LOCALTIMESTAMP = 434,
    LOCATION = 435,
    LOCK_P = 436,
    LOGIN_P = 437,
    MATCH = 438,
    MAXVALUE = 439,
    MINUTE_P = 440,
    MINVALUE = 441,
    MODE = 442,
    MONTH_P = 443,
    MOVE = 444,
    NAMES = 445,
    NATIONAL = 446,
    NATURAL = 447,
    NCHAR = 448,
    NEW = 449,
    NEXT = 450,
    NO = 451,
    NOCREATEDB = 452,
    NOCREATEROLE = 453,
    NOCREATEUSER = 454,
    NOINHERIT = 455,
    NOLOGIN_P = 456,
    NONE = 457,
    NOSUPERUSER = 458,
    NOT = 459,
    NOTHING = 460,
    NOTIFY = 461,
    NOTNULL = 462,
    NOWAIT = 463,
    NULL_P = 464,
    NULLIF = 465,
    NUMERIC = 466,
    OBJECT_P = 467,
    OF = 468,
    OFF = 469,
    OFFSET = 470,
    OIDS = 471,
    OLD = 472,
    ON = 473,
    ONLY = 474,
    OPERATOR = 475,
    OPTION = 476,
    OR = 477,
    ORDER = 478,
    OUT_P = 479,
    OUTER_P = 480,
    OVERLAPS = 481,
    OVERLAY = 482,
    OWNED = 483,
    OWNER = 484,
    PARTIAL = 485,
    PASSWORD = 486,
    PLACING = 487,
    POSITION = 488,
    PRECISION = 489,
    PRESERVE = 490,
    PREPARE = 491,
    PREPARED = 492,
    PRIMARY = 493,
    PRIOR = 494,
    PRIVILEGES = 495,
    PROCEDURAL = 496,
    PROCEDURE = 497,
    QUOTE = 498,
    READ = 499,
    REAL = 500,
    REASSIGN = 501,
    RECHECK = 502,
    REFERENCES = 503,
    REINDEX = 504,
    RELATIVE_P = 505,
    RELEASE = 506,
    RENAME = 507,
    REPEATABLE = 508,
    REPLACE = 509,
    RESET = 510,
    RESTART = 511,
    RESTRICT = 512,
    RETURNING = 513,
    RETURNS = 514,
    REVOKE = 515,
    RIGHT = 516,
    ROLE = 517,
    ROLLBACK = 518,
    ROW = 519,
    ROWS = 520,
    RULE = 521,
    SAVEPOINT = 522,
    SCHEMA = 523,
    SCROLL = 524,
    SECOND_P = 525,
    SECURITY = 526,
    SELECT = 527,
    SEQUENCE = 528,
    SERIALIZABLE = 529,
    SESSION = 530,
    SESSION_USER = 531,
    SET = 532,
    SETOF = 533,
    SHARE = 534,
    SHOW = 535,
    SIMILAR = 536,
    SIMPLE = 537,
    SMALLINT = 538,
    SOME = 539,
    STABLE = 540,
    START = 541,
    STATEMENT = 542,
    STATISTICS = 543,
    STDIN = 544,
    STDOUT = 545,
    STORAGE = 546,
    STRICT_P = 547,
    SUBSTRING = 548,
    SUPERUSER_P = 549,
    SYMMETRIC = 550,
    SYSID = 551,
    SYSTEM_P = 552,
    TABLE = 553,
    TABLESPACE = 554,
    TEMP = 555,
    TEMPLATE = 556,
    TEMPORARY = 557,
    THEN = 558,
    TIME = 559,
    TIMESTAMP = 560,
    TO = 561,
    TRAILING = 562,
    TRANSACTION = 563,
    TREAT = 564,
    TRIGGER = 565,
    TRIM = 566,
    TRUE_P = 567,
    TRUNCATE = 568,
    TRUSTED = 569,
    TYPE_P = 570,
    UNCOMMITTED = 571,
    UNENCRYPTED = 572,
    UNION = 573,
    UNIQUE = 574,
    UNKNOWN = 575,
    UNLISTEN = 576,
    UNTIL = 577,
    UPDATE = 578,
    USER = 579,
    USING = 580,
    VACUUM = 581,
    VALID = 582,
    VALIDATOR = 583,
    VALUES = 584,
    VARCHAR = 585,
    VARYING = 586,
    VERBOSE = 587,
    VIEW = 588,
    VOLATILE = 589,
    WHEN = 590,
    WHERE = 591,
    WITH = 592,
    WITHOUT = 593,
    WORK = 594,
    WRITE = 595,
    YEAR_P = 596,
    ZONE = 597,
    WITH_CASCADED = 598,
    WITH_LOCAL = 599,
    WITH_CHECK = 600,
    IDENT = 601,
    FCONST = 602,
    SCONST = 603,
    BCONST = 604,
    XCONST = 605,
    Op = 606,
    ICONST = 607,
    PARAM = 608,
    POSTFIXOP = 609,
    UMINUS = 610,
    TYPECAST = 611
};

#endif   /* KEYWORDS_H */
