#!/usr/local/bin/perl
#
# MFlow.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package MFlow;

@MFlow::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "objectlabel", },
	{ fName => "parent_id" },
	{ fName => "rt_status" },
	{ fName => "object_id" },
	{ fName => "type"},
	{ fName => "status_date"},
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $currpage = $self->_hiddenvar ("_currpage");
	if (($currpage eq 'sflowl') and ($curraction eq 'search')) { $curraction = 'searchs'; }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail eq 'launch') {
		my $basedir = $conf->{_BASEDIR};
		my $context = $conf->{contextid};
		my $cmd = "/usr/local/bin/perl $basedir/mains/launch.pl ";
		$cmd .= "--context=$context --basedir=$basedir --mode=daemon --detach=1 --flow=-1";
		#$cmd .= " >> /dev/null 2>> /dev/null";
		system ("echo $cmd >> /tmp/err");
		$cmd .= " >> /tmp/err 2>> /tmp/err";
		
		system($cmd);
		sleep 1;
	}
	if ($actiondetail eq 'change') {
		my $i = 0;
		my $query = $dbh->newquery();
		$query->iwflowsstatusinitial();
		my $ret = 0;
		$ret = $dbh->executefinish($query);
		$ret = 0;
		while (my $object_id = $cgi->param("object_id_$i")) {
			my $old_rt_status = $cgi->param("old_rt_status_$i");
			my $rt_status = $cgi->param("rt_status_$i");
			my $sched_id = $cgi->param("sched_id_$i");
			my $system_pid = $cgi->param("system_pid_$i");
			$i++;
#			next unless (($object_id > 0);
			if ($old_rt_status ne $rt_status) {
				$query = $dbh->newquery({ object_id => $object_id, rt_status => $rt_status, system_pid => $system_pid, sched_id => $sched_id});
				$query->uwflowsstatus();
				$ret = $dbh->executefinish($query);
				last unless ($ret > 0);
			}
		}
		if ($ret > 0) { $dbh->commit(); }
		else {$dbh->rollback(); }
	}

	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	$self->{search1} = undef unless ($self->{search1} =~ /^[-[:digit:]]*$/);
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "objects.id", "=", $self->{search1} ]; }
	if ($self->{search2}) {
		$cond->[++$icond] = [ [ "objects.name", "objects.objectlabel" ], "like", $self->{search2} ];
	}
	if ($self->{search3}) { $cond->[++$icond] = [ "wflowsstatus.rt_status", "like", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("wflowsstatus", $cond, "isobject");
	
	my $query = $dbh->newquery({ object_id => $self->{search1}, objectlabel => $self->{search2}, rt_status => $self->{search3} });
	$query->swflowsstatuslist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay) || [];
	$self->{list1count} = $query->hrowcount();

	# monitoring refreshing
	$self->_monitorvar("refresh", $cgi->param("refreshinterval"));
	$query->clear();
	$query->swflowsstatuslistmonitor();
	my $nomonitor = {
		object_id => -1 , parent_id => -1, name => 'monitor', sched_id => 'monitor',
		type => 'job monitor', objectlabel => 'Job Monitor',
		rt_status => 'notrunning', 'online' => object_status => 'online'
	};

	my $r = $self->_monitorvar("_data_", $dbh->hexecfetchrow($query, 1) || $nomonitor);
	if ($r) { push @{$self->{_list1}}, $r; }
	if ($r->{system_pid}) {
		kill 0, $r->{system_pid};
		if (($! != 0) and ($! != 1)) { # NOT OK or Operation not permitted
			$r->{rt_status} = 'notrunning';
		}
	}

	foreach my $f (@{$self->{_list1}}) {
		$f->{parent_id} = $f->{object_id} unless ($f->{parent_id} > 0);
		my $row;
		$query->clear({ object_id => $f->{object_id} });
		$query->sflowlasterrorscount();
		$row = $dbh->hexecfetchrownop($query);
		$f->{lasterrorscount} = $row->{errorscount};
=over
		$query->clear({ object_id => $f->{object_id} });
		$query->sflowerrorscount();
		$row = $dbh->hexecfetchrownop($query);
		$f->{errorscount} = $row->{errorscount};
=cut
	}

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_editv {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	my $flow_id;
	my $subflow_id;
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	# elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	# else {
		my $idstr = $cgi->param("_objectidforvar");
		$idstr ||= $cgi->param("_objectid");
		$self->_hiddenvar ("_objectidforvar", $idstr);
#		$idstr =~ s/-/;/g;
#		$idstr =~ s/;;/;-/g;
#		$idstr =~ s/^;/-/;
		$flow_id = $idstr;
		$subflow_id = $idstr;
		$flow_id =~ s/^([-[:digit:]]+);.*/$1/;
		$subflow_id =~ s/^[-[:digit:]]+;([-[:digit:]]+)$/$1/;
		$self->_datavar("object_id", $flow_id) unless ($self->_datavar("object_id"));
	# }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query = $dbh->newquery({ object_id => $flow_id });
	$query->sflowlist ();
	my $row = $dbh->hexecfetchrow($query, 1);
	$self->{_data} = $row || {};

	if ($flow_id != $subflow_id) {	
		$query = $dbh->newquery({ object_id => $subflow_id });
		$query->ssubflowlist ();
		$row = $dbh->hexecfetchrow($query, 1);
		$self->{_subflow} = $row; # || {};
		#print "SUBFLOW = $subflow_id ", join ("<BR> - ", %{$row}), "\n";
	}

	$query = $dbh->newquery({ object_id => [ -1, $subflow_id ] });
	$query->swvarslist ();
	$row = $dbh->hexecfetchall($query, 1);
	$self->{_varlist} = $row || [];

	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_vedits {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

        $self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

	my $query = $dbh->newquery({ object_id => $object_id });
	$query->sflowlist();
	my $flow = $dbh->hexecfetchrownop($query);

	my $ret;
	my $subflows = $self->getmysubflows($cgi, $dbh);
	if ($ret = $dbh->updatemysubflows($subflows)) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_veditv {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");
	my $ret;
	for (my $i = 0;  my $varName = $cgi->param("varid_$i"); $i++) {
		next unless ($cgi->param("checked_$i"));
		my $varValue = $cgi->param("varvalue_$i");
		my $dataType = $cgi->param("datatype_$i");
		my $varCat = $cgi->param("specialvar_$i");
		my $objId = $cgi->param("object_id_$i");

		#print "UPDATING VAR varid => $varName, varvalue => $varValue, datatype => $dataType, specialvar => $varCat, object_id => $objId<BR>";
		my $query = $dbh->newquery({varid => $varName, varvalue => $varValue, datatype => $dataType, specialvar => $varCat, object_id => $objId});
		$query->uwvars();
		$ret = $dbh->executefinish($query);
		unless ($ret > 0) { $query->iwvars(); $ret = $dbh->executefinish($query); }
		last unless ($ret > 0);
	}

	if ($ret) { $dbh->commit(); }
	else { $dbh->rollback(); }
	return $ret;
}
	
1;
