#!/usr/local/bin/perl
#
# LContainer.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package LContainer;

@LContainer::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;

	my $object_id = $cgi->param("_objectid");
	return undef unless $object_id;
	$self->_hiddenvar ("_objectid", $object_id);

#	print "OBJECT ID = ", $object_id;
	my $query = $dbh->newquery({ object_id => $object_id });
	$query->sconnectorlist();
	my $connector = $dbh->hexecfetchrownop($query, 1);
	foreach my $field (keys %{$connector}) { $self->_datavar($field, $connector->{$field}); }
	if ($self->{search1}) {
		$query = $dbh->newquery({object_id => $connector->{userid}});
		$query->suserslist();
		my $userid = $dbh->hexecfetchrownop($query, 1);
		$query = $dbh->newquery({object_id => $connector->{parent_id}});
		$query->sserverlist();
		my $server = $dbh->hexecfetchrownop($query, 1);

		my $db = { connector => $connector, user => $userid, _ATTRS => {}, server => $server, _FLOWDIR => $conf->flowdir() };
		my $attrlist = $self->_getmyattributes($dbh);
		foreach my $attr (@$attrlist) {
			$db->{_ATTRS}{$attr->{attrdefid}} = $attr->{attrvalue};
		}
		my $drv = eval { refDBI->ExtConnect($db); };
		if ($@) { print "$@"; die $@; }
		$self->{_list1} = $drv->listtables(undef, $self->{search1});
		$self->{list1count} = $#{$self->{_list1}} + 1;
		foreach my $cont (@{$self->{_list1}}) {
			$cont->{name} = $cont->{externalname};
			$query = $query->new({ name => $cont->{externalname}, parent_id => $connector->{object_id} });
			$query->scontainerlist();
			my $cont_oid = $dbh->hexecfetchrownop($query);
			$cont->{object_id} = $cont_oid->{object_id} if ($cont_oid);
			$cont->{ name } =~ s/[^[:alnum:]]/_/g;
			$cont->{ name } = "Unnamed____" unless ($cont->{ name });
			$cont->{ name } = "A_" . $cont->{ name } unless ($cont->{ name } =~ /^[[:alpha:]]/);

			$cont->{Remarks} .= "\n$cont_oid->{comments}";
		}
	}
}

sub meth_import {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $object_id = $cgi->param("_objectid");
	my $connectorid = $object_id;
	return undef unless $object_id;
	$self->_hiddenvar ("_objectid", $object_id);

	my $query = $dbh->newquery({ object_id => $object_id });
	$query->sconnectorlist();
	my $connector = $dbh->hexecfetchrownop($query, 1);
	foreach my $field (keys %{$connector}) { $self->_datavar($field, $connector->{$field}); }

	my %datatypelist;
	if ($self->_datavar("driverid")) {
		$query = $dbh->newquery( { "driverid" => $self->_datavar("driverid") });
		$query->sdatatypelist();
		if ($self->{_datatypelist} = $dbh->hexecfetchall($query)) {
			foreach my $dtypes (@{$self->{_datatypelist}}) { $datatypelist{$dtypes->{datatypeid}} = $dtypes->{stdname}; }
		}
	}

	my $actiondetail = $cgi->param("_actiondetail");
	my @containers;
	if ($actiondetail ne 'selected') {
		my $container = $self->getSelectedContainer($cgi, $dbh);
		my $containerfields = $self->describeContainer($dbh, $conf, $connector, $container);

		if ($containerfields and ($#$containerfields > 0)) {
			$container->{_fields_} = $containerfields;
			$container->{parent_id} = $connector->{object_id};
			$containers[0] = $container;
		}
	}
	else {
		my $i = -1;
		my $j = -1;
		while (1) {
			$i++;
			my @pagefileds = qw(object_id name externalname type owner remarks checked update);
			last unless (my $extname = $cgi->param("externalname_$i"));
			next unless ($cgi->param("checked_$i"));

			my $container = {
				object_id    => $cgi->param("object_id_$i"),
				parent_id    => $connector->{object_id},
				name    => $cgi->param("name_$i"),
				externalname    => $cgi->param("externalname_$i"),
				externaltype    => $cgi->param("type_$i"),
				type    => "container",
				externalschema    => $cgi->param("owner_$i"),
				remarks    => $cgi->param("remarks_$i"),
				flowdirection => "inout",
				update    => $cgi->param("update_$i"),
				status    => 'online',
				currentuser => $self->_hiddenvar("_userid"), 
				comments => $cgi->param("remarks_$i"),
			};
			my $containerfields;
			eval { $containerfields = $self->describeContainer($dbh, $conf, $connector, $container); };

			if ($containerfields and ($#$containerfields > 0)) {
				$j++;
				$container->{_fields_} = $containerfields;
				$containers[$j] = $container;
			}
		}
	}

	my $message = "";
	foreach my $container (@containers) {

		my $ifld = -1;
		my $fldmsg;
		$message .= "<BR>Importing the structure of the container $container->{name}/$container->{externalname}";
		$message .= " Internal Id is $container->{object_id}" if ($container->{object_id});
		my $updateexisting = $container->{update};
		my $fields = $container->{_fields_};
		foreach my $fld (@$fields) {
			if ($fld->{datatypeid} && $datatypelist{$fld->{datatypeid}}) {
				$fld->{datatypeid} = $datatypelist{$fld->{datatypeid}};
			}
		}
		if ($updateexisting) {
			$container->{parent_id} = $connectorid;
			my $ret = $self->updateContainer($cgi, $dbh, $container);
			if ($ret and ($ret > 0)) {
				$message .= "<BR><FONT COLOR= \"BLUE\"><B> ==== Container updated ====</B></FONT>";
				foreach my $fld (@$fields) {
					$ifld++;
					$fldmsg = " while updating $fld->{name}/$fld->{externalname} (order = $ifld)";
					$fld->{parent_id} = $container->{object_id};
					if ($fld->{object_id}) { $self->updateField($cgi, $dbh, $fld); }
					else { $ret = $self->createField ($cgi, $dbh, $fld); }
					last unless ($ret and ($ret > 0));
				}
				if ($ret and ($ret > 0)) { $message .= "<BR><FONT COLOR= \"BLUE\"><B> $ifld field(s) successfully updated</B></FONT>"; }
				else { $message .= "<BR><FONT COLOR= \"RED\"><B> Failed $fldmsg </B></FONT>", $dbh->errstr(); }
			}
			else {
				$message .= "<BR><FONT COLOR= \"RED\"><B> Failed to update the container</B></FONT>, reason : ", $dbh->errstr();
			}
			$dbh->commit() if ($ret);
		}
		else {
			$container->{parent_id} = $connectorid;
			my $ret = $self->createContainer($cgi, $dbh, $container);
			if ($ret and ($ret > 0)) {
				$message .= "<BR><FONT COLOR= \"BLUE\"><B> ==== Container created ====</B></FONT>";
				foreach my $fld (@$fields) {
					$ifld++;
					$fldmsg = " while creating $fld->{name}/$fld->{externalname} (order = $ifld)";
					$fld->{parent_id} = $container->{object_id};
					$ret = $self->createField ($cgi, $dbh, $fld);
					last unless ($ret and ($ret > 0));
				}
				if ($ret and ($ret > 0)) { $message .= "<BR><FONT COLOR= \"BLUE\"><B> $ifld field(s) successfully created</B></FONT>"; }
				else { $message .= "<BR><FONT COLOR= \"RED\"><B> Failed $fldmsg </B></FONT>", $dbh->errstr(); }
			}
			else {
				$message .= "<BR><FONT COLOR= \"RED\"><B> Failed to create the container</B></FONT>, reason : ", $dbh->errstr();
			}
			$dbh->commit() if ($ret);
		}
	}
	$self->_systemvar("_INFO", $message);
	$self->_systemvar("_redirect", "lcontainer");

}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;


	$self->_datavar("object_id", $dbh->nextseq("objects"));
	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->icontainer();
		$ret = $dbh->executefinish($query);
		if ($ret > 0) { $self->_updateattributes(); }
		if ($ret > 0) { $dbh->commit(); }
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ucontainer();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dcontainer();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
