/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/tools/desc/GeneratorDescriptor.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */

package com.postgres.replic.tools.desc;

import java.sql.*;
import java.util.*;

public abstract class GeneratorDescriptor {

    public static final int T_NO = -1;
    protected boolean print;
    protected Connection conn;
    protected boolean debug;
    protected boolean verbose;
    private static final String FILL_SEP = "_";
    private final static int [] fillChar = {14, 6, 4};

    public String getLine(String table, String column) throws Exception {
        return null;
    }

    public String getLine(String table) throws Exception {
        return null;
    }

    public boolean tableOnly() {
        return false;
    }

    protected Connection getConnection(){
        return conn;
    }

    public String getHeader() {
        return "";
    }

    public void setDebug(boolean debug){
        this.debug = debug;
    }

    public boolean getDebug(){
        return debug;
    }

    public void setVerbose(boolean verbose){
        this.verbose = verbose;
    }

    public boolean getVerbose(){
        return verbose;
    }

    public String getFiller(String table) {
         String filler = "";
         StringTokenizer tok = new StringTokenizer(table, FILL_SEP);
         ArrayList list = new ArrayList();
         while (tok.hasMoreElements()) {
             list.add(tok.nextToken().trim());
         }

         int max = Math.min(list.size(), 3);

         for (int i=0; i<max; i++) {
            String add = i == 0 ? "" : FILL_SEP;
            String token = (String) list.get(i);
            int len = Math.min(fillChar[max-1], token.length());
         	filler += add + token.substring(0, len);
            //System.out.println("::getFiller: token.substring(0, len)="+token.substring(0, len)+"; len="+len);
         }
         return filler;
    }
}
