/*
 * Group.java
 *
 * Created on 30 de julio de 2002, 17:31
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class Group extends DBObject {
    int user_list[] = null;
    Vector users = null;
    
    
    /** Creates a new instance of Group */
    public Group(DBObject owner, long oid) {
        super(owner);
        search(oid);
    }
    public Group(DBObject owner) {
        super(owner);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("DROP GROUP ");
        retorno.append(getName());
        retorno.append(";\n");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append("CREATE GROUP ");
        retorno.append(getName());
        retorno.append(";\n");
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public boolean search(long _oid) {
        boolean retorno = false;
        try{
            initialize();
            PreparedStatement prep = getConnection().prepareStatement("SELECT OID, * FROM PG_GROUP WHERE OID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                setOID(rs.getLong("OID"));
                setName(rs.getString("GRONAME"));
                setUsers(rs.getArray("GROLIST"));
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
        }
        return retorno;;
    }
    
    public void initialize(){
        super.initialize();
        user_list = null;
        users = null;
    }
    
    // ------ SET AND GET --------
    private int getUserIndex(User _user){
        int retorno = -1;
        for(int i=0; (i<users.size()) && (retorno == -1); i++){
            if(_user.getOID() == ((User) users.get(i)).getOID()){
                retorno = i;
            }
        }
        return retorno;
    }
    private void verifyUsers(){
        if ((users == null) && (user_list != null)){
            users = new Vector();
            for(int i=0; i< user_list.length; i++){
                long uoid  = user_list[i];
                users.add(new User(this, uoid));
            }
        } else if(users == null) {
            users = new Vector();
        }
    }
    
    public Vector getUsers(){
        verifyUsers();
        return users;
    }
    public dataSource getUsersTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Valid Until");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        
        Vector temp = getUsers();
        for(int i=0; i < temp.size(); i++){
            User usr = (User) temp.get(i);
            Vector elem = new Vector();
            elem.add(usr.getName());
            if(usr.getValidLimit() != null){
                elem.add(pgclibrary.utilities.Utilities.formatDate(usr.getValidLimit()));
            } else {
                elem.add("");
            }
            dsve.addElement(elem);
        }
        return dsve;
    }
    
    public void addUser(User _user){
        verifyUsers();
        if ((_user != null) && getUserIndex(_user) < 0){
            users.add(_user);
        }
    }
    public void removeUser(User _user){
        verifyUsers();
        if (_user != null){
            int ind = getUserIndex(_user);
            if(ind >= 0){
                users.remove(ind);
            }
        }
    }
    
    private void setUsers(Array _users ){
        try{
            user_list = (int[]) _users.getArray();
        } catch (SQLException e){
            user_list = null;
        }
    }
}
