/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class MainConnection
implements Serializable {
    public static final String defaultDriver = "org.postgresql.Driver";
    public static final String defaultURI = "jdbc:postgresql://localhost:5432/prueba1";
    private String driver = null;
    private String URI = null;
    private String userName = null;
    private String password = null;
    private Connection connection = null;
    private Statement statement = null;
    private Vector error_text = new Vector();
    private long error_code = 0L;
    private double database_version = -1.0;

    public MainConnection() {
    }

    public MainConnection(String _driver, String _URI, String _userName, String _password) {
        this.error_text = new Vector();
        this.error_code = 0L;
        if (_driver != null && _URI != null && _userName != null && _password != null) {
            this.driver = new String(_driver);
            this.URI = new String(_URI);
            this.userName = new String(_userName);
            this.password = new String(_password);
            Properties props = new Properties();
            ((Hashtable)props).put("user", this.userName);
            ((Hashtable)props).put("password", this.password);
            this.connect(props);
        }
    }

    public boolean changePassword(String _newPassword) {
        boolean retorno = false;
        this.error_text = new Vector();
        this.error_code = 0L;
        if (_newPassword != null && _newPassword.length() > 0) {
            Properties props = new Properties();
            ((Hashtable)props).put("user", this.userName);
            ((Hashtable)props).put("password", this.password);
            ((Hashtable)props).put("OCINewPassword", _newPassword);
            retorno = this.connect(props);
            if (retorno) {
                this.password = _newPassword;
            }
        } else {
            this.error_text.add("Ths password is incorrect or the database is not accesible.");
        }
        return retorno;
    }

    private boolean connect(Properties props) {
        boolean retorno = false;
        Connection temp = null;
        if (this.driver != null && this.URI != null && this.userName != null && this.password != null) {
            try {
                Class.forName(this.driver);
                temp = DriverManager.getConnection(this.URI, props);
                temp.setAutoCommit(true);
                SQLWarning sqlw = temp.getWarnings();
                if (sqlw != null && sqlw.getErrorCode() == 28002) {
                    this.error_text.add("Incorrect password.");
                    this.error_code = sqlw.getErrorCode();
                }
            }
            catch (Exception e) {
                this.error_text.add(e.getMessage());
                temp = null;
            }
        }
        if (temp != null) {
            this.connection = temp;
            try {
                this.statement = this.connection.createStatement(1004, 1008);
                retorno = true;
            }
            catch (Exception e) {
                this.error_text.add(e.getMessage());
                this.connection = null;
                retorno = false;
            }
        }
        return retorno;
    }

    public MainConnection(String _userName, String _password) {
        this(defaultDriver, defaultURI, _userName, _password);
    }

    public MainConnection(MainConnection _mainConnection) {
        this(_mainConnection.getDriver(), _mainConnection.getURI(), _mainConnection.getUserName(), _mainConnection.getPassword());
    }

    public Vector getError() {
        return this.error_text;
    }

    public long getErrorCode() {
        return this.error_code;
    }

    public String getUserName() {
        return this.userName;
    }

    private String getPassword() {
        return this.password;
    }

    public Connection getConnection() throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("The connection has not be initialized");
        }
        return this.connection;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getURI() {
        return this.URI;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public Statement getStatementReadOnly() throws SQLException {
        Statement st = null;
        st = this.getConnection().createStatement(1004, 1007);
        return st;
    }

    public Statement getStatement() throws SQLException {
        Statement st = null;
        st = this.getConnection().createStatement(1004, 1007);
        return st;
    }

    public Statement getStatement(int tipo, int concur) throws SQLException {
        Statement st = null;
        st = this.getConnection().createStatement(tipo, concur);
        return st;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.statement != null) {
            return this.statement.executeUpdate(sql);
        }
        return 0;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.statement != null) {
            return this.statement.executeQuery(sql);
        }
        return null;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("Connection nor initialized");
        }
        return this.getConnection().prepareStatement(sql, 1004, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int tipo, int concur) throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("The connection is not initialized");
        }
        return this.getConnection().prepareStatement(sql, tipo, concur);
    }

    public void close() {
        if (this.isConnected()) {
            try {
                this.statement.close();
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static boolean isQuery(String _query) {
        String tmp = _query.toUpperCase();
        return tmp.indexOf("SELECT") >= 0 && tmp.indexOf("UPDATE") < 0 && tmp.indexOf("DELETE") < 0 && tmp.indexOf("GRANT") < 0 && tmp.indexOf("REVOKE") < 0 && tmp.indexOf("INSERT") < 0;
    }

    public String getDatabaseName() {
        String retorno = new String();
        if (this.isConnected()) {
            StringTokenizer stok = new StringTokenizer(this.getURI(), "/");
            while (stok.hasMoreTokens()) {
                retorno = stok.nextToken();
            }
        }
        return retorno;
    }

    public String getProductName() {
        String retorno = new String();
        try {
            if (this.isConnected()) {
                retorno = this.getConnection().getMetaData().getDatabaseProductName() + " " + this.getConnection().getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return retorno;
    }

    public String getDriverVersion() {
        String retorno = new String();
        try {
            if (this.isConnected()) {
                retorno = this.getConnection().getMetaData().getDriverVersion();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return retorno;
    }

    public double getDatabaseVersion() {
        if (this.database_version < 0.0) {
            try {
                StringTokenizer stk;
                if (this.isConnected() && (stk = new StringTokenizer(this.getConnection().getMetaData().getDatabaseProductVersion(), ".")).hasMoreTokens()) {
                    long acum = 1L;
                    this.database_version = Integer.parseInt(stk.nextToken());
                    while (stk.hasMoreTokens()) {
                        String next = stk.nextToken();
                        acum = (long)((double)acum * Math.pow(10.0, next.length()));
                        if (next.length() <= 0) continue;
                        int tmp = Integer.parseInt(next);
                        this.database_version += (double)tmp / (double)acum;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.database_version;
    }

    public String getURL() {
        String retorno = new String();
        try {
            if (this.isConnected()) {
                retorno = this.getConnection().getMetaData().getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return retorno;
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

