/*
 * TableColumn.java
 *
 * Created on 31 de julio de 2002, 09:20
 */

package pgclibrary.objects;
import java.util.*;
import java.sql.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class TableColumn extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = new String();
    private String description = null;
    
    public TableColumn(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        return new String();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append(getName());
        retorno.append(" ");
        
        if(getColumnType() != null){
            retorno.append(getColumnType().getName().toUpperCase());
            retorno.append(" ");
            if(getColumnType().getSize() < 0){
                retorno.append("(");
                retorno.append(getSize());
                retorno.append(") ");
            }
        }
        if(!allowNulls()){
            retorno.append("NOT NULL ");
        }
        if ((getDefaultValue() != null) && (getDefaultValue().trim().length() > 0)){
            retorno.append("DEFAULT ");
            retorno.append(getDefaultValue());
        }
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the ATTNUM.
     * @param _attnum ATTTNUM to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            
            ResultSet rs = getConnection().getQueryGenerator().getTableColumn(getOwner().getName(), _name);
            if((rs != null) && (rs.next())){
                setName(rs.getString("COLUMN_NAME"));
                setColumnNumber(rs.getInt("COLUMN_NUMBER"));
                setSize(rs.getInt("COLUMN_SIZE"));
                setAllowNulls(!rs.getBoolean("COLUMN_NOTNULL"));
                setColumnType(AttributeType.searchObject(rs.getString("TYPE_NAME")));
                setDefaultValue(rs.getString("DEFAULT_VALUE"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        col_number = 0;
        size = 0;
        allow_nulls = false;
        column_type = null;
        default_value = new String();
        description = null;
    }
    
    // ---------SET AND GET-------------
    private void setDefaultValue(String _value){
        if(_value != null){
            default_value = _value;
        } else {
            default_value = new String();
        }
    }
    public String getDefaultValue(){
        return default_value;
    }
    
    private void setColumnNumber(int _col_number){
        col_number = _col_number;
    }
    public int getColumnNumber(){
        return col_number;
    }
    
    private void setSize(int _size){
        size = _size;
    }
    public int getSize(){
        if(size > 0){
            return size;
        } else {
            return column_type.getSize();
        }
    }
    
    private void setAllowNulls(boolean _allow_nulls){
        allow_nulls = _allow_nulls;
    }
    public boolean allowNulls(){
        return allow_nulls;
    }
    
    public AttributeType getColumnType(){
        return column_type;
    }
    private void setColumnType(AttributeType _column_type){
        column_type = _column_type;
    }
    
    public String getDescription(){
        if(description == null){
            description = getConnection().getQueryGenerator().getColumnDescription(getOwner().getName(), getName());
        }
        return description;
    }
    public void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
    
    protected String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON COLUMN " + getOwner().getName() + "." 
                + getName() + " IS '" + getDescription() + "'; \n"; 
        }
        return retorno;
    }
    
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
}
