/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "indexlistviewitem.h"
#include "indexitempopup.h"
#include "../../../utils/stringutils.h"
#include "../../../utils/debugger.h"
#include "../../../utils/converter.h"
#include "../../common/constants.h"

#include <iostream.h>

	IndexListViewItem::IndexListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBIndex(), DBMasterManagerRef()
	{
	} // end constructor

	IndexListViewItem::IndexListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBIndex(), DBMasterManagerRef()
	{
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void IndexListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "IndexListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new IndexItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
	
	/**
 	 * Used to update the description.
   */			    	
	void IndexListViewItem::updateDescription()
	{
		string strMethodName = "IndexListViewItem::updateDescription";

		Debugger::entered(strMethodName);
				
 		// format string to appear on description
 		string strOutputDesc = "<h1>Index</h1><hr><p><strong>Name</strong><br>"
 													 + StringUtils::htmlstr(getIndexName()) + "</p>"
 													 "<p><strong>Comment</strong><br>";
 		if (getIndexComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);
 		} // end if no comment
 		else
 		{
 			strOutputDesc += StringUtils::htmlstr(getIndexComment());
 		} // end else comment exists
			
 		strOutputDesc += "</p><p><strong>Unique</strong><br>";
 		if (isUnique())
 		{
 			strOutputDesc += Constants::YES;
 		} // end if unique
 		else
 		{
 			strOutputDesc += Constants::NO;			
 		} // end else not unique
 		strOutputDesc += "</p><p><strong>Primary</strong><br>";						
 		if (isPrimary())
 		{
 			strOutputDesc += Constants::YES;
 		} // end if primary
 		else
 		{
 			strOutputDesc += Constants::NO;			
 		} // end else not primary
 		strOutputDesc += "</p>";
 		// build list of indexed columns
 		strOutputDesc += "<p><strong>Column(s)</strong><br>";
 		for (int nIdx = 0; nIdx < getNumberOfColumns(); nIdx++)
 		{
 			if (nIdx == 0)
 			{
 				strOutputDesc += getIndexedColumn(nIdx);
 			} // end if first column
 			else
 			{
 				strOutputDesc += ", " + getIndexedColumn(nIdx); 			
 			} // end else not first column 											
 		} // end for more columns
 		strOutputDesc += "</p>";
			
 		Debugger::logTrace(strMethodName, "HTML generated: " + strOutputDesc);
				
 		m_qstrDescription = strOutputDesc.c_str();
	
 		Debugger::exited(strMethodName);
	} // end updateDescription
				