/*
	pgjobsagent.cpp

	Main entry point of the agent daemon.
	Starts and stops the master agent.

	Project: pgjobs
	Author: Zlatko Michailov
	Created:  2-Oct-2003
	Updated: 28-Oct-2003
	Updated:  5-May-2004
	Updated: 14-Jun-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



//--------------------------------------------------------------------------------

#include <signal.h>
#include <unistd.h>
#include "masteragent.h"



//--------------------------------------------------------------------------------

static MasterAgent TheMasterAgent;



//--------------------------------------------------------------------------------

static void ProcessTerm( int signo )
{
	// Stop the master agent
	TheMasterAgent.Stop();

	// Wait for the master agent to finish
	TheMasterAgent.WaitUntilFinished();

	// Down.
	exit( 0 );
}



int main()
{
	// Install a handler for TERM signal
	signal( SIGTERM, ProcessTerm );

	// Start the master agent
	if ( TheMasterAgent.Start() )
	{
		// Sleep forever: any positive
		// number works.
		for ( ;; )
		{
			sleep( 3600 );
		}
	}

	// If this code is reached, the master agent
	// did not start properly.
	return -1;
}
