<?
/* mymarket.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */

function is_logged_in() {
/* this function will return true if the user has logged in.  a user is logged
 * in if the $SESSION["user"] is set (by the login.php page) and also if the
 * remote IP address matches what we saved in the session ($SESSION["ip"])
 * from login.php -- this is not a robust or secure check by any means, but it
 * will do for now */

	global $SESSION, $REMOTE_ADDR;
	return isset($SESSION)
		&& isset($SESSION["user"])
		&& isset($SESSION["ip"])
		&& $SESSION["ip"] == $REMOTE_ADDR;
}

function load_user_profile() {
/* load up the user's details */

	global $SESSION;
	
	$username = $SESSION["user"]["username"];
        $qid = db_query("SELECT firstname, lastname, usertype, priv,
				fiscalcode, address, number, city, state, zip_code,
				phone, fax, mobilephone, email, authdata, acceptadvert, notes
			FROM users
			WHERE username = '$username'
			");
	return db_fetch_array($qid, 0);
}

function require_login() {
/* this function checks to see if the user is logged in.  if not, it will show
 * the login screen before allowing the user to continue */

	global $CFG, $SESSION;
	if (! is_logged_in()) {
		$SESSION["wantsurl"] = qualified_me();
		redirect("$CFG->wwwroot/login.php");
	}
}

function require_priv($priv) {
/* this function checks to see if the user has the privilege $priv.  if not,
 * it will display an Insufficient Privileges page and stop */

	global $CFG, $SESSION;

	if ($SESSION["user"]["priv"] != $priv) {
		include("$CFG->templatedir"."insufficient_privileges.ihtml");
		die;
	}
}

function has_priv($priv) {
/* returns true if the user has the privilege $priv */

	global $SESSION;
	return $SESSION["user"]["priv"] == $priv;
}

function build_category_tree(&$output, &$preselected, $parent=1, $indent="") {
/* recursively go through the category tree, starting at a parent, and
 * drill down, printing options for a selection list box.  preselected
 * items are marked as being selected.  this is not an efficient algorithm
 * because it has to issue one query per category!!  it's only used because it
 * is easy to understand.
 */

	$qid = db_query("SELECT id, name FROM categories WHERE parent_id = '$parent' ORDER BY on_special, name");

	$numr = db_num_rows($qid);
	for ($i=0;$i<$numr;$i++) {
		$cat =  db_fetch_object($qid, $i);
		$selected = in_array($cat->id, $preselected) ? "selected" : "";
		$output .= "<option value=\"" . ov($cat->id) . "\" $selected>" . $indent . ov($cat->name);
		if ($cat->id != $parent) {
			build_category_tree($output, $preselected, $cat->id, $indent."&nbsp;&nbsp;");
		}
	}
}

function build_category_navigator(&$output, $parent=1, $indent="..") {
/* recursively go through the category tree, starting at a parent, and
 * drill down, printing options for a selection list box.
 * this is not an efficient algorithm because it has to issue
 * one query per category!!  it's only used because it is easy to understand.
 */
	global $CFG;

        $qid = db_query("SELECT id, name FROM categories WHERE parent_id = '$parent' AND id <> 1 ORDER BY on_special, name");

        $numr = db_num_rows($qid);
        for ($i=0;$i<$numr;$i++) {
                $cat =  db_fetch_object($qid, $i);
		$output .= $indent . "<div class=normal>" . $cat->name . "</div>" . "^" . $CFG->wwwroot . "/shopping/?" . getenv("QUERY_STRING") . "&id=" . $cat->id . "^main" . "\n";
                if ($cat->id != $parent) {
                        build_category_navigator($output, $cat->id, $indent.".");
                }
        }
}

function generate_password($maxlen=10) {
/* returns a randomly generated password of length $maxlen.  inspired by
 * http://www.phpbuilder.com/columns/jesus19990502.php3 */

	global $CFG;

	$fillers = "1234567890!@#$%&*-_=+^";
	$wordlist = file($CFG->wordlist);

	srand((double) microtime() * 1000000);
	$word1 = trim($wordlist[rand(0, count($wordlist) - 1)]);
	$word2 = trim($wordlist[rand(0, count($wordlist) - 1)]);
	$filler1 = $fillers[rand(0, strlen($fillers) - 1)];

	return substr($word1 . $filler1 . $word2, 0, $maxlen);
}

function err(&$errorvar) {
/* if $errorvar is set, then print an error marker << */

	if (isset($errorvar)) {
		echo "<font color=#ff0000>&lt;&lt;</font>";
	}
}

function err2(&$errorvar) {
/* like err(), but prints the marker >> */

	if (isset($errorvar)) {
		echo "<font color=#ff0000>&gt;&gt;</font>";
	}
}

function username_exists($username) {
/* returns the true if the username exists */

	$qid = db_query("SELECT 1 FROM users WHERE username = '$username'");
	return db_num_rows($qid);
}

//function email_exists($email) {
///* returns true the email address exists */
///*
//	$qid = db_query("SELECT 1 FROM users WHERE email = '$email'");
//	return db_num_rows($qid);
//}

function reset_user_password($username) {
/* resets the password for the user with the username $username, and sends it
 * to him/her via email */

	global $CFG;
	global $SESSION;

	/* load up the user record */
	$qid = db_query("SELECT username, priv, firstname, lastname, email FROM users WHERE username = '$username'");
	$user = db_fetch_object($qid, 0);
	if ($user->priv == "admin" || !($SESSION["user"]["priv"] == "admin")) {
		return 1;
	}

	/* reset the password */
	$newpassword = generate_password();
	$qid = db_query("UPDATE users SET password = '" . md5($newpassword) ."' WHERE username = '$username'");

	/* email the user with the new account information */
	$var = new Object;
	$var->username = $user->username;
	$var->fullname = $user->firstname . " " . $user->lastname;
	$var->newpassword = $newpassword;
	$var->support = $CFG->support;
	$var->myname = $CFG->myname;

	$emailbody = read_template($CFG->templatedir.$SESSION["lang"]."/reset_password.ihtml", $var);

	mail(
		"$var->fullname <$user->email>",
		$CFG->myname . " Account Information",
		$emailbody,
		"From: $var->support");

	return 0;
}

function get_category_tree($id=1) {
/* returns a tree of the product categories, starting from the top to the
 * category specified by $id */

	global $CFG;

	$qid = db_query("SELECT parent_id, name FROM categories WHERE id = '$id' ORDER BY on_special, name");
	if (db_num_rows($qid)) {
		list($parent, $name) = db_fetch_row($qid, 0);
		$name = "<a href='$CFG->wwwroot/shopping/?id=$id'>$name</a>";
	} else {
		$parent = 1;
		$name = "";
	}

	if ($parent > 1) {		
		return print_category_tree($parent) . " &gt; " . $name;

	} elseif ($id > 1) {
		return "<a href='$CFG->wwwroot/shopping/?id=1'>Top</a> &gt; " . $name;

	} elseif ($id == 1) {
		return "<a href='$CFG->wwwroot/shopping/?id=1'>Top</a>";
	}
}

function print_category_tree($id=false) {
/* prints the category tree by calling get_category_tree */

	echo get_category_tree($id);
}

function get_cart_items() {
/* return a $qid of all the items in the shopping cart */

	global $SESSION, $CART;

	$in_clause = $CART->get_productid_list();
	if (empty($in_clause)) {
		return false;
	}

	return db_query ("SELECT * FROM products WHERE id IN ($in_clause)"); }

//function chop_ccnum($ccnum) {
///* this function returns the the first and last 4 digits of the credit card number
// * and the expiry date.  it is mainly used when we want to display the credit
// * card number on the screen etc. but we don't want to reveal the whole thing
// */
// 
//	return substr($ccnum, 0, 4) . "..." . substr($ccnum, -4);
//}

function save_orderinfo(&$frm) {
/* this function saves the order information into the session variable
 * $SESSION["orderinfo"].  it is used in the purchase confirmation stage */

	global $SESSION;	

	$order = new Object();
	$order->customer = $frm["customer"];
	$order->contact = $frm["contact"];
	$order->address = $frm["address"];
	$order->number = $frm["number"];
	$order->city = $frm["city"];
	$order->state = $frm["state"];
	$order->zip_code = $frm["zip_code"];
	$order->creditcard = $frm["creditcard"];
	$order->expiry = $frm["expiry"];
	$order->comments = $frm["comments"];
	
	$SESSION["orderinfo"] = $order;
}

function load_orderinfo() {
/* this function is the counterpart to save_orderinfo.  it is used to
 * retrieve the order information in the complete order page */

	global $SESSION;	

	if (empty($SESSION["orderinfo"])) {
		return false;
	} else {
		return $SESSION["orderinfo"];
	}
}

function clear_orderinfo() {
/* this function is called to clear the orderinfo session variable, it should
 * be used after an order was successfully completed */

	global $SESSION;
	unset($SESSION["orderinfo"]);
}

function star() {
	echo "<font color=\"#ff0000\">*</font>";
}

function return_star() {
	return "<font color=\"#ff0000\">*</font>";
}

function get_brand($brand_id) {
// returns the brand associated with the given brand_id

	$qid = db_query("
	SELECT name FROM brands WHERE id = $brand_id
	");
	$arr = db_fetch_array($qid, 0);
	return $arr[0];
}

function get_iva($iva_id) {
// returns the iva associated with the given iva_id

	$qid = db_query("
	SELECT iva FROM iva WHERE id = $iva_id
	");
	$arr = db_fetch_array($qid, 0);
	return $arr[0];
}

function validate_username($username, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$stripped_username = str_replace(" ", "", $username);

	if (empty($username) || empty($stripped_username)) {
		$errors->username = true;
		$msg .= "<li>".$empty_username;
	} else if (strlen($username) > $SESSION["username_length"]) {
		$errors->username = true;
		$msg .= "<li>".$username_too_long;
	} else if (strlen($username) < $SESSION["username_length_min"]) {
		$errors->username = true;
		$msg .= "<li>".$username_too_short;
	} else {
		eregi ("[[:alnum:]]+", $username, $matched_username);
		if ($username != $matched_username[0]) {
			$errors->username = true;
			$msg .= "<li>".$not_valid_username;
		}
	}
}

function validate_password($password, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$stripped_password = str_replace(" ", "", $password);
	eregi ("[a-z0-9]{32}", $password, $matched_password);

	// md5("") = d41d8cd98f00b204e9800998ecf8427e
	if ($password == "d41d8cd98f00b204e9800998ecf8427e") {
		$errors->password = true;
		$msg .= "<li>".$empty_password;
	}
	if (empty($password) || strlen($password) != 32
		|| empty($stripped_password) || strlen($stripped_password) != 32
		|| $password != $matched_password[0]) {
		$errors->password = true;
		$msg = $please_enable_javascript.$msg;
	}
}

function validate_firstname($firstname, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($firstname)) {
		$errors->firstname = true;
		$msg .= "<li>".$empty_firstname;
	} else if (strlen($firstname) > $SESSION["firstname_length"]) {
		$errors->firstname = true;
		$msg .= "<li>".$firstname_too_long;
	}
}

function validate_ragionesociale($ragionesociale, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($ragionesociale)) {
		$errors->firstname = true;
		$msg .= "<li>".$empty_ragionesociale;
	} else if (strlen($ragionesociale) > $SESSION["firstname_length"]) {
		$errors->firstname = true;
		$msg .= "<li>".$ragionesociale_too_long;
	}
}

function validate_name($name, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($name)) {
		$errors->name = true;
		$msg .= "<li>".$empty_name;
	} else if (strlen($name) > $SESSION["name_length"]) {
		$errors->name = true;
		$msg .= "<li>".$name_too_long;
	}
}

function validate_lastname($lastname, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($lastname)) {
		$errors->lastname = true;
		$msg .= "<li>".$empty_lastname;
	} else if (strlen($lastname) > $SESSION["lastname_length"]) {
		$errors->lastname = true;
		$msg .= "<li>".$lastname_too_long;
	}
}

function validate_customer($customer, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($customer)) {
		$errors->customer = true;
		$msg .= "<li>".$empty_customer;
	} else if (strlen($customer) > $SESSION["firstname_length"] + $SESSION["lastname_length"] + 1) {
		$errors->customer = true;
		$msg .= "<li>".$customer_too_long;
	}
}

function validate_fiscalcode($fiscalcode, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$even["0"] = 1;
	$even["1"] = 0;
	$even["2"] = 5;
	$even["3"] = 7;
	$even["4"] = 9;
	$even["5"] = 13;
	$even["6"] = 15;
	$even["7"] = 17;
	$even["8"] = 19;
	$even["9"] = 21;
	$even["A"] = 1;
	$even["B"] = 0;
	$even["C"] = 5;
	$even["D"] = 7;
	$even["E"] = 9;
	$even["F"] = 13;
	$even["G"] = 15;
	$even["H"] = 17;
	$even["I"] = 19;
	$even["J"] = 21;
	$even["K"] = 2;
	$even["L"] = 4;
	$even["M"] = 18;
	$even["N"] = 20;
	$even["O"] = 11;
	$even["P"] = 3;
	$even["Q"] = 6;
	$even["R"] = 8;
	$even["S"] = 12;
	$even["T"] = 14;
	$even["U"] = 16;
	$even["V"] = 10;
	$even["W"] = 22;
	$even["X"] = 25;
	$even["Y"] = 24;
	$even["Z"] = 23;

	$odd["0"] = 0;
	$odd["1"] = 1;
	$odd["2"] = 2;
	$odd["3"] = 3;
	$odd["4"] = 4;
	$odd["5"] = 5;
	$odd["6"] = 6;
	$odd["7"] = 7;
	$odd["8"] = 8;
	$odd["9"] = 9;
	$odd["A"] = 0;
	$odd["B"] = 1;
	$odd["C"] = 2;
	$odd["D"] = 3;
	$odd["E"] = 4;
	$odd["F"] = 5;
	$odd["G"] = 6;
	$odd["H"] = 7;
	$odd["I"] = 8;
	$odd["J"] = 9;
	$odd["K"] = 10;
	$odd["L"] = 11;
	$odd["M"] = 12;
	$odd["N"] = 13;
	$odd["O"] = 14;
	$odd["P"] = 15;
	$odd["Q"] = 16;
	$odd["R"] = 17;
	$odd["S"] = 18;
	$odd["T"] = 19;
	$odd["U"] = 20;
	$odd["V"] = 21;
	$odd["W"] = 22;
	$odd["X"] = 23;
	$odd["Y"] = 24;
	$odd["Z"] = 25;

	if (empty($fiscalcode)) {
		$errors->fiscalcode = true;
		$msg .= "<li>".$empty_fiscalcode;
	} else if (strlen($fiscalcode) != $SESSION["fiscalcode_length"]) {
		$errors->fiscalcode = true;
		$msg .= "<li>".$bad_fiscalcode_length;
	} else {
		$fiscalcode = strtoupper($fiscalcode);
		eregi ("[A-Z]{6}[0-9]{2}[A-Z]{1}[0-9]{2}[A-Z]{1}[0-9]{3}[A-Z]{1}",
			$fiscalcode, $matched_fiscalcode);
		if ($fiscalcode != $matched_fiscalcode[0]) {
			$errors->fiscalcode = true;
			$msg .= "<li>".$not_valid_fiscalcode;
		} else {
			$total = 0;
			for($i=0;$i<15;$i+=2) {
				$total += $even["$fiscalcode[$i]"];
			}
			for($i=1;$i<14;$i+=2) {
				$total += $odd["$fiscalcode[$i]"];
			}
			$check = chr($total-26*(int)($total/26)+65);
			if ($check != $fiscalcode[15]) {
				$errors->fiscalcode = true;
				$msg .= "<li>".$not_valid_fiscalcode;
			}
		}
	}
}

function validate_partitaiva($partitaiva, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($partitaiva)) {
		$errors->fiscalcode = true;
		$msg .= "<li>".$empty_partitaiva;
	} else if (strlen($partitaiva) != $SESSION["partitaiva_length"]) {
		$errors->fiscalcode = true;
		$msg .= "<li>".$bad_partitaiva_length;
	} else {
		eregi ("[0-9]{11}", $partitaiva, $matched_partitaiva);
		if ($partitaiva != $matched_partitaiva[0]) {
			$errors->fiscalcode = true;
			$msg .= "<li>".$not_valid_partitaiva;
		}
	}
}

function validate_address($address, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($address)) {
		$errors->address = true;
		$msg .= "<li>".$empty_address;
	} else if (strlen($address) > $SESSION["address_length"]) {
		$errors->address = true;
		$msg .= "<li>".$address_too_long;
	}
}

function validate_number($number, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($number) > $SESSION["number_length"]) {
		$errors->number = true;
		$msg .= "<li>".$number_too_long;
	}
}

function validate_city($city, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($city)) {
		$errors->city = true;
		$msg .= "<li>".$empty_city;
	} else if (strlen($city) > $SESSION["city_length"]) {
		$errors->city = true;
		$msg .= "<li>".$city_too_long;
	}
}

function validate_state($state, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($state)) {
		$errors->state = true;
		$msg .= "<li>".$empty_state;
	} else if (strlen($state) > $SESSION["state_length"]) {
		$errors->state = true;
		$msg .= "<li>".$state_too_long;
	}
}

function validate_zip_code($zip_code, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if ($zip_code == "") {
		$errors->zip_code = true;
		$msg .= "<li>".$empty_zip_code;
	} else if ((string) ((int) $zip_code) != "$zip_code") {
		$errors->zip_code = true;
		$msg .= "<li>".$zip_code_notint;
	} else if ($zip_code <= 0) {
		$errors->zip_code = true;
		$msg .= "<li>".$zip_code_is_zero;
	} else if (strlen($zip_code) <> $SESSION["zip_code_length"]) {
		$errors->zip_code = true;
		$msg .= "<li>".$zip_code_length_is_wrong;
	}
}

function validate_phone($phone, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($phone)) {
		$errors->phone = true;
		$msg .= "<li>".$empty_phone;
	} else if (strlen($phone) > $SESSION["phone_length"]) {
		$errors->phone = true;
		$msg .= "<li>".$phone_too_long;
	} else if (strlen($phone) < $SESSION["phone_length_min"]) {
		$errors->phone = true;
		$msg .= "<li>".$phone_too_short;
	} else {
		$phone = ereg_replace (" ", "", $phone);
		$phone = ereg_replace ("\+", "", $phone);
		$phone = ereg_replace ("\(", "", $phone);
		$phone = ereg_replace ("\)", "", $phone);
		$phone = ereg_replace ("\/", "", $phone);
		eregi ("[0-9]+", $phone, $matched_phone);
		if ($phone != $matched_phone[0]) {
			$errors->phone = true;
			$msg .= "<li>".$not_valid_phone;
		}
	}
}

function validate_contact($contact, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($contact)) {
		$errors->contact = true;
		$msg .= "<li>".$empty_contact;
	} else if (strlen($contact) > $SESSION["phone_length"]) {
		$errors->contact = true;
		$msg .= "<li>".$contact_too_long;
	} else if (strlen($contact) < $SESSION["phone_length_min"]) {
		$errors->contact = true;
		$msg .= "<li>".$contact_too_short;
	} else {
		$contact = ereg_replace (" ", "", $contact);
		$contact = ereg_replace ("\+", "", $contact);
		$contact = ereg_replace ("\(", "", $contact);
		$contact = ereg_replace ("\)", "", $contact);
		eregi ("[0-9]+", $contact, $matched_contact);
		if ($contact != $matched_contact[0]) {
			$errors->contact = true;
			$msg .= "<li>".$not_valid_contact;
		}
	}
}

function validate_fax($fax, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($fax) > $SESSION["fax_length"]) {
		$errors->fax = true;
		$msg .= "<li>".$fax_too_long;
	} else if (strlen($fax) > 0 && strlen($fax) < $SESSION["fax_length_min"]) {
		$errors->fax = true;
		$msg .= "<li>".$fax_too_short;
	} else {
		$fax = ereg_replace (" ", "", $fax);
		$fax = ereg_replace ("\+", "", $fax);
		$fax = ereg_replace ("\(", "", $fax);
		$fax = ereg_replace ("\)", "", $fax);
		eregi ("[0-9]+", $fax, $matched_fax);
		if ($fax != $matched_fax[0]) {
			$errors->fax = true;
			$msg .= "<li>".$not_valid_fax;
		}
	}
}

function validate_mobilephone($mobilephone, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($mobilephone) > $SESSION["mobilephone_length"]) {
		$errors->mobilephone = true;
		$msg .= "<li>".$mobilephone_too_long;
	} else if (strlen($mobilephone) > 0 && strlen($mobilephone) < $SESSION["mobilephone_length_min"]) {
		$errors->mobilephone = true;
		$msg .= "<li>".$mobilephone_too_short;
	} else {
		$mobilephone = ereg_replace (" ", "", $mobilephone);
		$mobilephone = ereg_replace ("\+", "", $mobilephone);
		$mobilephone = ereg_replace ("\(", "", $mobilephone);
		$mobilephone = ereg_replace ("\)", "", $mobilephone);
		eregi ("[0-9]+", $mobilephone, $matched_mobilephone);
		if ($mobilephone != $matched_mobilephone[0]) {
			$errors->mobilephone = true;
			$msg .= "<li>".$not_valid_mobilephone;
		}
	}
}

function validate_email($email, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($email)) {
		$errors->email = true;
		$msg .= "<li>".$empty_email;
	} else if (strlen($email) > $SESSION["email_length"]) {
		$errors->email = true;
		$msg .= "<li>".$email_too_long;
	} else {
		eregi ("(^[a-z0-9\.\_-]{1,})\@([a-z0-9\.-]{1,})\.([a-z]{2,3})$", $email, $matched_email);
		if ($email != $matched_email[0]) {
			$errors->email = true;
			$msg .= "<li>".$not_valid_email;
		}
	}
}

function validate_notes($notes, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($notes) > $SESSION["notes_length"]) {
		$errors->notes = true;
		$msg .= "<li>".$notes_too_long;
	}
}

function validate_message($message, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($message)) {
		$errors->message = true;
		$msg .= "<li>".$empty_message;
	} else if (strlen($message) > $SESSION["message_length"]) {
		$errors->message = true;
		$msg .= "<li>".$message_too_long;
	}
}

function validate_ournotes($ournotes, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($ournotes) > $SESSION["ournotes_length"]) {
		$errors->ournotes = true;
		$msg .= "<li>".$ournotes_too_long;
	}
}

function validate_comments($comments, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($comments) > $SESSION["comments_length"]) {
		$errors->comments = true;
		$msg .= "<li>".$comments_too_long;
	}
}

function validate_category_name($category_name, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$stripped_category_name = str_replace(" ", "", $category_name);

	if (empty($category_name) || empty($stripped_category_name)) {
		$errors->category_name = true;
		$msg .= "<li>".$empty_category_name;
	} else if (strlen($category_name) > $SESSION["category_name_length"]) {
		$errors->category_name = true;
		$msg .= "<li>".$category_name_too_long;
	}
}

function validate_category_description($category_description, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($category_description) > $SESSION["category_description_length"]) {
		$errors->category_description = true;
		$msg .= "<li>".$category_description_too_long;
	}
}

function validate_brand_name($brand_name, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$stripped_brand_name = str_replace(" ", "", $brand_name);

	if (empty($brand_name) || empty($stripped_brand_name)) {
		$errors->brand_name = true;
		$msg .= "<li>".$empty_brand_name;
	} else if (strlen($brand_name) > $SESSION["brand_name_length"]) {
		$errors->brand_name = true;
		$msg .= "<li>".$brand_name_too_long;
	}
}

function validate_brand_description($brand_description, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($brand_description) > $SESSION["brand_description_length"]) {
		$errors->brand_description = true;
		$msg .= "<li>".$brand_description_too_long;
	}
}

function validate_product_id($product_id, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (empty($product_id)) {
		$errors->product_id = true;
		$msg .= "<li>".$product_id_is_empty;
	} else {
		if ($product_id != str_replace(" ", "", $product_id)) {
			$errors->product_id = true;
			$msg .= "<li>".$product_id_wspace;
		}
		if ($product_id != str_replace("&", "", $product_id)) {
			$errors->product_id = true;
			$msg .= "<li>".$product_id_wampersand;
		}
		if ($product_id != str_replace("?", "", $product_id)) {
			$errors->product_id = true;
			$msg .= "<li>".$product_id_wquestionm;
		}
		if (strlen($product_id) > $SESSION["product_id_length"]) {
			$errors->product_id = true;
			$msg .= "<li>".$product_id_too_long;
		}
	}
}

function product_id_exists($product_id, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$qid = db_query("
	SELECT id FROM products WHERE id = '$product_id'
	");

	if (db_num_rows($qid) > 0) {
		$errors->product_exists = true;
		$msg .= "<li>".$the_product_id.$product_id.$already_exists;
	}
}

function validate_product_name($product_name, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	$stripped_product_name = str_replace(" ", "", $product_name);

	if (empty($product_name) || empty($stripped_product_name)) {
		$errors->product_name = true;
		$msg .= "<li>".$empty_product_name;
	} else if (strlen($product_name) > $SESSION["product_name_length"]) {
		$errors->product_name = true;
		$msg .= "<li>".$product_name_too_long;
	}
}

function validate_price($price, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if ($price == "") {
		$errors->price = true;
		$msg .= "<li>".$empty_price;
	} else if ($SESSION["price_must_be_integer"] && (string) ((int) $price) != "$price") {
		$errors->price = true;
		$msg .= "<li>".$price_notint;
	} else if (!$SESSION["price_must_be_integer"] && (string) ((float) $price) != "$price") {
		$errors->price = true;
		$msg .= "<li>".$price_notfloat;
	} else if ($price <= 0) {
		$errors->price = true;
		$msg .= "<li>".$price_is_zero;
	}
}

function validate_iva($iva, &$errors, &$msg) {

	global $CFG;
	include ($CFG->global);

	if ($iva != "") {
		eregi ("[0-9]{0,}[.]{0,1}[0-9]{0,}", $iva, $matched_iva);
		if ($iva != $matched_iva[0] || $iva == ".") {
			$errors->iva = true;
			$msg .= "<li>".$not_valid_iva;
		} else if ($iva < 0 || $iva > 100) {
			$errors->iva = true;
			$msg .= "<li>".$iva_not_between_0_and_100;
		}
	}
}

function validate_discount($discount, $discqty, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if ($discount.$discqty != "") {
		if (($discount != 0) && ($discount == "" || $discqty == "")) {
			$errors->discount = true;
			$errors->discqty = true;
			$msg .= "<li>".$discount_not_completely_defined;
		}
		if ($discount != "") {
			eregi ("[0-9]{0,}[.]{0,1}[0-9]{0,}", $discount, $matched_discount);
			if ($discount != $matched_discount[0] || $discount == ".") {
				$errors->discount = true;
				$msg .= "<li>".$not_valid_discount;
			} else if ($discount < 0 || $discount > 100) {
				$errors->discount = true;
				$msg .= "<li>".$discount_not_between_0_and_100;
			}
		}
		if ($discqty != "" && ((string) ((int) $discqty) != "$discqty")) {
			$errors->discqty = true;
			$msg .= "<li>".$discqty_notint;
		} else if ($discqty < 0) {
			$errors->discqty = true;
			$msg .= "<li>".$discqty_is_negative;
		} else if ($discqty > $SESSION["discqtymax"]) {
			$errors->discqty = true;
			$msg .= "<li>".$discqty_is_too_large;
		}
	}
}

function validate_searched_discount($discount, &$errors, &$msg) {

	eregi ("[0-9]{0,}[.]{0,1}[0-9]{0,}", $discount, $matched_discount);
	if ($discount != $matched_discount[0] || $discount == ".") {
		$errors->discount = true;
		$msg .= "<li>".$not_valid_discount;
	} else if ($discount < 0 || $discount > 100) {
		$errors->discount = true;
		$msg .= "<li>".$discount_not_between_0_and_100;
	}
}

function validate_searched_discqty($discqty, &$errors, &$msg) {

	if ($discqty != "" && ((string) ((int) $discqty) != "$discqty")) {
		$errors->discqty = true;
		$msg .= "<li>".$discqty_notint;
	} else if ($discqty < 0) {
		$errors->discqty = true;
		$msg .= "<li>".$discqty_is_negative;
	} else if ($discqty > $SESSION["discqtymax"]) {
		$errors->discqty = true;
		$msg .= "<li>".$discqty_is_too_large;
	}
}

function validate_weight($weight, &$errors, &$msg) {

	global $CFG, $SESSION;
	global $weightunity;
	include ($CFG->global);

	if ($weight == "") {
		$errors->weight = true;
		$msg .= "<li>".$empty_weight;
	} else {
		eregi ("[0-9]{0,}[.]{0,1}[0-9]{0,}", $weight, $matched_weight);
		if ($weight != $matched_weight[0] || $weight == ".") {
			$errors->weight = true;
			$msg .= "<li>".$not_valid_weight;
		} else if ($weight <= 0) {
			$errors->weight = true;
			$msg .= "<li>".$weight_is_zero;
		} else if ($weight > $SESSION["weightmax"]) {
			$errors->weight = true;
			$msg .= "<li>".$weight_over_max;
		}
	}
}

function validate_on_special($on_special, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

/*
	if ($on_special == "") {
		$errors->on_special = true;
		$msg .= "<li>".$on_special_empty;
	} else if ((string) ((int) $on_special) != "$on_special") {
*/
	if ((string) ((int) $on_special) != "$on_special" && $on_special != "") {
		$errors->on_special = true;
		$msg .= "<li>".$on_special_notint;
	}
}

function validate_product_description($product_description, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($product_description) > $SESSION["product_description_length"]) {
		$errors->product_description = true;
		$msg .= "<li>".$product_description_too_long;
	}
}

function validate_product_extended_description($product_extended_description, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($product_extended_description) > $SESSION["product_extended_description_length"]) {
		$errors->product_extended_description = true;
		$msg .= "<li>".$product_extended_description_too_long;
	}
}

function validate_priv($priv, &$errors, &$msg) {

	global $CFG, $SESSION;
	include ($CFG->global);

	if (strlen($priv) > $SESSION["priv_length"]) {
		$errors->priv = true;
		$msg .= "<li>".$priv_too_long;
	}
	eregi ("[[:alnum:]]+", $priv, $matched_priv);
	if ($priv != $matched_priv[0]) {
		$errors->priv = true;
		$msg .= "<li>".$not_valid_priv;
	}
}

?>
