.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE VIEW" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE VIEW \- Constructs a virtual table
.SH SYNOPSIS
.sp
.nf
CREATE VIEW \fIview\fR AS SELECT \fIquery\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIview\fB\fR
The name of a view to be created.
.TP
\fB\fIquery\fB\fR
An SQL query which will provide the columns and rows of the view.

Refer to the SELECT statement for more information
about valid arguments.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
The message returned if the view is successfully created.
.TP
\fBERROR: Relation '\fIview\fB' already exists\fR
This error occurs if the view specified already exists in the database.
.TP
\fBNOTICE create: attribute named "\fIcolumn\fB" has an unknown type\fR
The view will be created having a column with an unknown type
if you do not specify it. For example, the following command gives
a warning:
.sp
.nf
CREATE VIEW vista AS SELECT 'Hello World'
	
.sp
.fi
whereas this command does not:
.sp
.nf
CREATE VIEW vista AS SELECT text 'Hello World'
	
.sp
.fi
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE VIEW\fR will define a view of a table.
This view is not physically materialized. Specifically, a query
rewrite retrieve rule is automatically generated to support
retrieve operations on views.
.SS "NOTES"
.PP
Currently, views are read only.
.PP
Use the \fBDROP VIEW\fR statement to drop views.
.SH "USAGE"
.PP
Create a view consisting of all Comedy films:
.sp
.nf
CREATE VIEW kinds AS
    SELECT *
    FROM films
    WHERE kind = 'Comedy';

SELECT * FROM kinds;

 code  |           title           | did | date_prod  |  kind  | len
-------+---------------------------+-----+------------+--------+-------
 UA502 | Bananas                   | 105 | 1971-07-13 | Comedy | 01:22
 C_701 | There's a Girl in my Soup | 107 | 1970-06-11 | Comedy | 01:36
(2 rows)
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for the
\fBCREATE VIEW\fR statement:
.sp
.nf
CREATE VIEW \fIview\fR [ \fIcolumn\fR [, ...] ]
    AS SELECT \fIexpression\fR [ AS \fIcolname\fR ] [, ...]
    FROM \fItable\fR [ WHERE \fIcondition\fR ]
    [ WITH [ CASCADE | LOCAL ] CHECK OPTION ]
   
.sp
.fi
.PP
The optional clauses for the full SQL92 command are:
.TP
\fBCHECK OPTION\fR
This option is to do with updatable views.
All INSERTs and UPDATEs on the view will be
checked to ensure data satisfy the view-defining
condition. If they do not, the update will be rejected.
.TP
\fBLOCAL\fR
Check for integrity on this view.
.TP
\fBCASCADE\fR
Check for integrity on this view and on any dependent
view. CASCADE is assumed if neither CASCADE nor LOCAL is specified.
.PP
