/*-------------------------------------------------------------------------
 *
 * FILE
 *    uuid_generate_time.c
 *
 * DESCRIPTION
 *    generate a time-base uuid
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 */
#include "util.h"

#include <uuid.h>

int uuid_generate_time(uuid_p p)
{
	static unsigned char node_mac[6];
	static int has_init = 0;
	
	uuid_u32_t clock_mid;

	if (!has_init) {
		if (get_if_mac(IF_NUMBER, node_mac) < 0) {
			get_random_buffer(node_mac, 6);
			/*
			 * Set multicast bit, to prevent conflicts
			 * with IEEE 802 addresses obtained from
			 * network cards
			 */
			node_mac[0] |= 0x80;
		}
		has_init = 1;
	}
	get_clock(&clock_mid, &(p->time_low), &(p->clock_seq));

	p->clock_seq |= 0x8000;
	p->time_mid = (uuid_u16_t) clock_mid;
	p->time_hi_and_version = (clock_mid >> 16) | 0x1000;

	memcpy(p->node, node_mac, 6);

	return (0);
}
