/* Written by Morgoth DBMA, morgothdbma@o2.pl
This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: mmsystem.h */
#ifndef __MORGOTHDBMA_MMSYSTEM_H__
#define __MORGOTHDBMA_MMSYSTEM_H__
struct mem_list
{
 void* ptr;
 struct mem_list* next;
};

struct dmem_list
{
 void* ptr;
 char* file;
 int line;
 int count;
 struct dmem_list* next;
};
#include "gtkdialogs.h"
#include "consoleout.h"

#define HERE __FILE__,__LINE__

void add_to_memlist(void* ptr);
void print_memlist();
void del_from_memlist(void* ptr);
void* mmalloc(int siz);
void* mrealloc(void*, int siz);
void mfree(void** ptr);
void add_to_special_memlist(struct mem_list** hp, void* ptr);
void print_special_memlist(struct mem_list* h);
void del_from_special_memlist(struct mem_list** hp, void* ptr);
void* smalloc(struct mem_list** hp, int siz);
void sfree(struct mem_list** hp, void** ptr);
void shred_memlist();
void shred_special_memlist(struct mem_list**);

void* dsmalloc(struct dmem_list** hp, int siz, char* file, int line);
void dsfree(struct dmem_list** hp, void** ptr, char* file, int line);
void dshred_special_memlist(struct dmem_list**, char* file, int line);
void dadd_to_special_memlist(struct dmem_list** hp, void* ptr, char* file, int line, int size);
void dprint_special_memlist(struct dmem_list* h, char* file, int line);
void ddel_from_special_memlist(struct dmem_list** hp, void* ptr, char* file, int line);

void* dmmalloc(int siz, char* file, int line);
void* dmrealloc(void*, int siz, char* file, int line);
void dmfree(void** ptr, char* file, int line);
void dmhred_memlist(char* file, int line);
void dadd_to_memlist(void* ptr, char* file, int line, int size);
void dprint_memlist(char* file, int line);
void ddel_from_memlist(void* ptr, char* file, int line);
void dshred_memlist(char* file, int line);
#endif

