/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: sqlparser.c */
#include "sqlparser.h"
#include "common.h"
struct parser_data parser[NUM_PARSE_STRINGS] = {
{ 0,  "ABORT" },
{ 0,  "ABORT TRANSACTION" },
{ 0,  "ABORT WORK" },
{ 0,  "ACCESS" },
{ 0,  "ACCESS EXCLUSIVE" },
{ 0,  "ACCESS EXCLUSIVE MODE" },
{ 0,  "ACCESS SHARE" },
{ 0,  "ACCESS SHARE MODE" },
{ 0,  "ACCESSSHARE" },
{ 0,  "ADD" },
{ 0,  "ADD COLUMN" },
{ 0,  "ADD CONSTRAINT" },
{ 0,  "ADD USER" },
{ 0,  "AFTER" },
{ 0,  "AFTER DELETE" },
{ 0,  "AFTER DELETE ON" },
{ 0,  "AFTER INSERT" },
{ 0,  "AFTER INSERT ON" },
{ 0,  "AFTER INSERT OR" },
{ 0,  "AFTER UPDATE" },
{ 0,  "AFTER UPDATE ON" },
{ 0,  "AFTER UPDATE OR" },
{ 0,  "AGGREGATE" },
{ 0,  "ALIGNMENT" },
{ 0,  "ALL" },
{ 0,  "ALL ON" },
{ 0,  "ALTER" },
{ 0,  "ALTER ADD" },
{ 0,  "ALTER ADD CONSTRAINT" },
{ 0,  "ALTER COLUMN" },
{ 0,  "ALTER GROUP" },
{ 0,  "ALTER TABLE" },
{ 0,  "ALTER USER" },
{ 0,  "ANALYZE" },
{ 0,  "AS" },
{ 0,  "AS ON" },
{ 0,  "AS ON DELETE" },
{ 0,  "AS ON SELECT" },
{ 0,  "AS ON UPDATE" },
{ 0,  "AS SELECT ALL" },
{ 0,  "AS SELECT DISTINCT" },
{ 0,  "AS SELECT DISTINCT ALL" },
{ 0,  "AS SELECT DISTINCT ONLY" },
{ 0,  "AS SELECT ONLY" },
{ 0,  "BACKWARD" },
{ 0,  "BACKWARD ALL" },
{ 0,  "BACKWARD ALL FROM" },
{ 0,  "BACKWARD ALL IN" },
{ 0,  "BACKWARD FOR" },
{ 0,  "BACKWARD FROM" },
{ 0,  "BACKWARD IN" },
{ 0,  "BACKWARD NEXT" },
{ 0,  "BACKWARD NEXT FROM" },
{ 0,  "BACKWARD NEXT IN" },
{ 0,  "BACKWARD PRIOR" },
{ 0,  "BACKWARD PRIOR FROM" },
{ 0,  "BACKWARD PRIOR IN" },
{ 0,  "BASETYPE" },
{ 0,  "BEFORE" },
{ 0,  "BEFORE DELETE" },
{ 0,  "BEFORE DELETE ON" },
{ 0,  "BEFORE DELETE OR" },
{ 0,  "BEFORE INSERT" },
{ 0,  "BEFORE INSERT ON" },
{ 0,  "BEFORE INSERT OR" },
{ 0,  "BEFORE UPDATE" },
{ 0,  "BEFORE UPDATE ON" },
{ 0,  "BEFORE UPDATE OR" },
{ 0,  "BEGIN" },
{ 0,  "BEGIN TRANSACTION" },
{ 0,  "BEGIN WORK" },
{ 0,  "BINARY" },
{ 0,  "BINARY CURSOR" },
{ 0,  "BINARY INSTENSIVE SCROLL" },
{ 0,  "BINARY INSTENSIVE SCROLL CURSOR" },
{ 0,  "BINARY INSTENSIVE SCROLL CURSOR FOR" },
{ 0,  "BINARY INSTENSIVE SCROLL CURSOR FOR SELECT" },
{ 0,  "BINARY INTENSIVE" },
{ 0,  "BINARY INTENSIVE CURSOR" },
{ 0,  "BINARY INTENSIVE CURSOR FOR" },
{ 0,  "BINARY INTENSIVE CURSOR FOR SELECT" },
{ 0,  "BINARY SCROLL" },
{ 0,  "BINARY SCROLL CURSOR" },
{ 0,  "BINARY SCROLL CURSOR FOR" },
{ 0,  "BINARY SCROLL CURSOR FOR SELECT" },
{ 0,  "BINARY SCROLL INTENSIVE" },
{ 0,  "BINARY SCROLL INTENSIVE CURSOR" },
{ 0,  "BINARY SCROLL INTENSIVE CURSOR FOR" },
{ 0,  "BINARY SCROLL INTENSIVE CURSOR FOR SELECT" },
{ 0,  "BY" },
{ 0,  "CACHE" },
{ 0,  "CACHE CYCLE" },
{ 0,  "CASCADE" },
{ 0,  "CHECK" },
{ 0,  "CLOSE" },
{ 0,  "CLUSTER" },
{ 0,  "COLUMN" },
{ 0,  "COMMENT" },
{ 0,  "COMMENT ON" },
{ 0,  "COMMENT ON AGGREGATE" },
{ 0,  "COMMENT ON COLUMN" },
{ 0,  "COMMENT ON DATABASE" },
{ 0,  "COMMENT ON FUNCTION" },
{ 0,  "COMMENT ON INDEX" },
{ 0,  "COMMENT ON OPERATOR" },
{ 0,  "COMMENT ON RULE" },
{ 0,  "COMMENT ON SEQUENCE" },
{ 0,  "COMMENT ON TABLE" },
{ 0,  "COMMENT ON TRIGGER" },
{ 0,  "COMMENT ON TYPE" },
{ 0,  "COMMENT ON VIEW" },
{ 0,  "COMMIT" },
{ 0,  "COMMIT TRANSACTION" },
{ 0,  "COMMIT WORK" },
{ 0,  "COMMITED" },
{ 0,  "COMMUTATOR" },
{ 0,  "CONSTRAINT" },
{ 0,  "CONSTRAINT CHECK" },
{ 0,  "CONSTRAINT DEFAULT" },
{ 0,  "CONSTRAINT FOREIGN KEY" },
{ 0,  "CONSTRAINT NOT" },
{ 0,  "CONSTRAINT NOT NULL" },
{ 0,  "CONSTRAINT NOT NULL DEFAULT" },
{ 0,  "CONSTRAINT NOT NULL FOREIGN KEY" },
{ 0,  "CONSTRAINT NOT NULL FOREIGN KEY REFERENCES" },
{ 0,  "CONSTRAINT NOT NULL PRIMARY KEY" },
{ 0,  "CONSTRAINT NOT NULL UNIQUE" },
{ 0,  "CONSTRAINT NOT NULL UNIQUE DEFAULT" },
{ 0,  "CONSTRAINT NOT NULL UNIQUE FOREIGN KEY" },
{ 0,  "CONSTRAINT NOT NULL UNIQUE FOREIGN KEY REFERENCES" },
{ 0,  "CONSTRAINT NOT NULL UNIQUE PRIMARY KEY" },
{ 0,  "CONSTRAINT PRIMARY KEY" },
{ 0,  "CONSTRAINT UNIQUE" },
{ 0,  "CONSTRAINT UNIQUE DEFAULT" },
{ 0,  "CONSTRAINT UNIQUE FOREIGN KEY" },
{ 0,  "CONSTRAINT UNIQUE FOREIGN KEY REFERENCES" },
{ 0,  "CONSTRAINT UNIQUE NOT NULL" },
{ 0,  "CONSTRAINT UNIQUE NOT NULL DEFAULT" },
{ 0,  "CONSTRAINT UNIQUE NOT NULL FOREIGN KEY" },
{ 0,  "CONSTRAINT UNIQUE NOT NULL FOREIGN KEY REFERENCES" },
{ 0,  "CONSTRAINT UNIQUE NOT NULL PRIMARY KEY" },
{ 0,  "CONSTRAINT UNIQUE PRIMARY KEY" },
{ 0,  "CONSTRAINTS" },
{ 0,  "CONSTRAINTS ALL" },
{ 0,  "COPY" },
{ 0,  "COPY BINARY" },
{ 0,  "COPY BINARY FROM" },
{ 0,  "COPY BINARY TO" },
{ 0,  "COPY FROM" },
{ 0,  "COPY TO" },
{ 0,  "CREATE" },
{ 0,  "CREATE AGGREGATE" },
{ 0,  "CREATE DATABASE" },
{ 0,  "CREATE FUNCTION" },
{ 0,  "CREATE GROUP" },
{ 0,  "CREATE INDEX" },
{ 0,  "CREATE LANGUAGE" },
{ 0,  "CREATE OPERATOR" },
{ 0,  "CREATE PROCEDURAL" },
{ 0,  "CREATE PROCEDURAL LANGUAGE" },
{ 0,  "CREATE PROCEDURAL TRUSTED" },
{ 0,  "CREATE PROCEDURAL TRUSTED LANGUAGE" },
{ 0,  "CREATE RULE" },
{ 0,  "CREATE SEQUENCE" },
{ 0,  "CREATE TABLE" },
{ 0,  "CREATE TABLE AS" },
{ 0,  "CREATE TABLE AS SELECT" },
{ 0,  "CREATE TABLE AS SELECT ALL" },
{ 0,  "CREATE TABLE AS SELECT DISTINCT" },
{ 0,  "CREATE TABLE AS SELECT DISTINCT ALL" },
{ 0,  "CREATE TABLE AS SELECT DISTINCT ONLY" },
{ 0,  "CREATE TABLE AS SELECT ONLY" },
{ 0,  "CREATE TEMP" },
{ 0,  "CREATE TEMP TABLE" },
{ 0,  "CREATE TEMPRARY" },
{ 0,  "CREATE TEMPRARY TABLE" },
{ 0,  "CREATE TRIGGER" },
{ 0,  "CREATE TRUSTED" },
{ 0,  "CREATE TRUSTED LANGUAGE" },
{ 0,  "CREATE TRUSTED PROCEDURAL" },
{ 0,  "CREATE TRUSTED PROCEDURAL LANGUAGE" },
{ 0,  "CREATE TYPE" },
{ 0,  "CREATE UNIQUE" },
{ 0,  "CREATE UNIQUE INDEX" },
{ 0,  "CREATE USER" },
{ 0,  "CREATE VIEW" },
{ 0,  "CREATEDB" },
{ 0,  "CREATEUSER" },
{ 0,  "CROSS" },
{ 0,  "CROSS JOIN" },
{ 0,  "CURRENT_DATE" },
{ 0,  "CURRENT_TIME" },
{ 0,  "CURRENT_TIMESTAMP" },
{ 0,  "CURRENT_USER" },
{ 0,  "CURSOR" },
{ 0,  "CURSOR FOR" },
{ 0,  "CURSOR FOR SELECT" },
{ 0,  "CURSOR FOR UPDATE" },
{ 0,  "CYCLE CACHE" },
{ 0,  "CYCLE INCREMENT" },
{ 0,  "CYCLE MAXVALUE" },
{ 0,  "CYCLE MINVALUE" },
{ 0,  "CYCLE START" },
{ 0,  "DATABASE" },
{ 0,  "DECLARE" },
{ 0,  "DEFAULT" },
{ 0,  "DEFAULT NULL" },
{ 0,  "DEFAULT VALUES" },
{ 0,  "DEFERRABLE" },
{ 0,  "DELETE CASCADE" },
{ 0,  "DELETE FROM" },
{ 0,  "DELETE FROM ONLY" },
{ 0,  "DELETE ON" },
{ 0,  "DELETE RESTRICT" },
{ 0,  "DELETE SET" },
{ 0,  "DELETE SET DEFAULT" },
{ 0,  "DELETE SET NULL" },
{ 0,  "DELIMETER" },
{ 0,  "DELIMETERS" },
{ 0,  "DESTINCT" },
{ 0,  "DO" },
{ 0,  "DO INSTEAD" },
{ 0,  "DO INSTEAD NOTHING" },
{ 0,  "DO NOTHING" },
{ 0,  "DROP" },
{ 0,  "DROP AGGREGATE" },
{ 0,  "DROP DATABASE" },
{ 0,  "DROP DEFAULT" },
{ 0,  "DROP FUNCTION" },
{ 0,  "DROP GROUP" },
{ 0,  "DROP INDEX" },
{ 0,  "DROP LANGUAGE" },
{ 0,  "DROP OPERATOR" },
{ 0,  "DROP PROCEDURAL" },
{ 0,  "DROP PROCEDURAL LANGUAGE" },
{ 0,  "DROP RULE" },
{ 0,  "DROP SEQUENCE" },
{ 0,  "DROP TABLE" },
{ 0,  "DROP TRIGGER" },
{ 0,  "DROP TYPE" },
{ 0,  "DROP USER" },
{ 0,  "DROP VIEW" },
{ 0,  "EACH" },
{ 0,  "EACH ROW" },
{ 0,  "EACH ROW EXECUTE" },
{ 0,  "EACH ROW EXECUTE PROCEDURE" },
{ 0,  "EACH STATEMENT" },
{ 0,  "EACH STATEMENT EXECUTE" },
{ 0,  "EACH STATEMENT EXECUTE PROCEDURE" },
{ 0,  "ELEMENT" },
{ 0,  "ENCODING" },
{ 0,  "END" },
{ 0,  "END TRANSACTION" },
{ 0,  "END WORK" },
{ 0,  "EST5EDT" },
{ 0,  "EXCEPT" },
{ 0,  "EXCEPT ALL" },
{ 0,  "EXCLUSIVE" },
{ 0,  "EXCLUSIVE MODE" },
{ 0,  "EXECUTE" },
{ 0,  "EXECUTE PROCEDURE" },
{ 0,  "EXPLAIN" },
{ 0,  "EXPLAIN VERBOSE" },
{ 0,  "EXTERNALLENGTH" },
{ 0,  "FETCH" },
{ 0,  "FETCH BACKWARD" },
{ 0,  "FETCH BACKWARD ALL" },
{ 0,  "FETCH BACKWARD ALL FROM" },
{ 0,  "FETCH BACKWARD ALL IN" },
{ 0,  "FETCH BACKWARD FROM" },
{ 0,  "FETCH BACKWARD IN" },
{ 0,  "FETCH BACKWARD NEXT" },
{ 0,  "FETCH BACKWARD NEXT FROM" },
{ 0,  "FETCH BACKWARD NEXT IN" },
{ 0,  "FETCH BACKWARD PRIOR" },
{ 0,  "FETCH BACKWARD PRIOR FROM" },
{ 0,  "FETCH BACKWARD PRIOR IN" },
{ 0,  "FETCH FORWARD" },
{ 0,  "FETCH FORWARD ALL" },
{ 0,  "FETCH FORWARD ALL FROM" },
{ 0,  "FETCH FORWARD ALL IN" },
{ 0,  "FETCH FORWARD FROM" },
{ 0,  "FETCH FORWARD IN" },
{ 0,  "FETCH FORWARD NEXT" },
{ 0,  "FETCH FORWARD NEXT FROM" },
{ 0,  "FETCH FORWARD NEXT IN" },
{ 0,  "FETCH FORWARD PRIOR" },
{ 0,  "FETCH FORWARD PRIOR FROM" },
{ 0,  "FETCH FORWARD PRIOR IN" },
{ 0,  "FETCH RELATIVE" },
{ 0,  "FETCH RELATIVE ALL" },
{ 0,  "FETCH RELATIVE ALL FROM" },
{ 0,  "FETCH RELATIVE ALL IN" },
{ 0,  "FETCH RELATIVE FROM" },
{ 0,  "FETCH RELATIVE IN" },
{ 0,  "FETCH RELATIVE NEXT" },
{ 0,  "FETCH RELATIVE NEXT FROM" },
{ 0,  "FETCH RELATIVE NEXT IN" },
{ 0,  "FETCH RELATIVE PRIOR" },
{ 0,  "FETCH RELATIVE PRIOR FROM" },
{ 0,  "FETCH RELATIVE PRIOR IN" },
{ 0,  "FINALFUNC" },
{ 0,  "FOR" },
{ 0,  "FOR EACH" },
{ 0,  "FOR EACH ROW" },
{ 0,  "FOR EACH ROW EXECUTE" },
{ 0,  "FOR EACH ROW EXECUTE PROCEDURE" },
{ 0,  "FOR EACH STATEMENT" },
{ 0,  "FOR EACH STATEMENT EXECUTE" },
{ 0,  "FOR EACH STATEMENT EXECUTE PROCEDURE" },
{ 0,  "FOR READ ONLY" },
{ 0,  "FOR SELECT" },
{ 0,  "FOR UPDATE" },
{ 0,  "FORCE" },
{ 0,  "FOREIGN" },
{ 0,  "FOREIGN KEY" },
{ 0,  "FOREIGN KEY NOT NULL" },
{ 0,  "FOREIGN KEY NOT NULL REFERENCES" },
{ 0,  "FOREIGN KEY REFERENCES" },
{ 0,  "FOREIGN KEY UNIQUE" },
{ 0,  "FOREIGN KEY UNIQUE NOT NULL" },
{ 0,  "FOREIGN KEY UNIQUE NOT NULL REFERENCES" },
{ 0,  "FOREIGN KEY UNIQUE REFERENCES" },
{ 0,  "FROM" },
{ 0,  "FROM GROUP" },
{ 0,  "FROM ONLY" },
{ 0,  "FROM PUBLIC" },
{ 0,  "FULL" },
{ 0,  "FUNCTION" },
{ 0,  "GRANT" },
{ 0,  "GRANT ALL" },
{ 0,  "GRANT ALL ON" },
{ 0,  "GRANT DELETE" },
{ 0,  "GRANT DELETE ON" },
{ 0,  "GRANT INSERT" },
{ 0,  "GRANT INSERT ON" },
{ 0,  "GRANT RULE" },
{ 0,  "GRANT RULE ON" },
{ 0,  "GRANT SELECT" },
{ 0,  "GRANT SELECT ON" },
{ 0,  "GRANT UPDATE" },
{ 0,  "GRANT UPDATE ON" },
{ 0,  "GROUP" },
{ 0,  "GROUP BY" },
{ 0,  "HANDLER" },
{ 0,  "HASH" },
{ 0,  "HASHES" },
{ 0,  "HAVING" },
{ 0,  "IMMEDIATE" },
{ 0,  "IMPLICIT" },
{ 0,  "IMPLICIT TRIGGER" },
{ 0,  "IN" },
{ 0,  "IN ACCESS" },
{ 0,  "IN ACCESS EXCLUSIVE MODE" },
{ 0,  "IN ACCESS SHARE MODE" },
{ 0,  "IN EXCLUSIVE" },
{ 0,  "IN EXCLUSIVE MODE" },
{ 0,  "IN GROUP" },
{ 0,  "IN ROW" },
{ 0,  "IN ROW EXCLUSIVE MODE" },
{ 0,  "IN ROW SHARE MODE" },
{ 0,  "IN SHARE" },
{ 0,  "IN SHARE MODE" },
{ 0,  "INCREMENT" },
{ 0,  "INDEX" },
{ 0,  "INHERITS" },
{ 0,  "INITCOND" },
{ 0,  "INITIALLY" },
{ 0,  "INITIALLY DEFERRED" },
{ 0,  "INITIALLY IMMEDIATE" },
{ 0,  "INNER" },
{ 0,  "INNER JOIN" },
{ 0,  "INPUT" },
{ 0,  "INSERT" },
{ 0,  "INSERT INTO" },
{ 0,  "INSERT ON" },
{ 0,  "INSTEAD" },
{ 0,  "INSTEAD NOTHING" },
{ 0,  "INTENSIVE" },
{ 0,  "INTENSIVE BINARY" },
{ 0,  "INTENSIVE BINARY CURSOR" },
{ 0,  "INTENSIVE BINARY CURSOR FOR" },
{ 0,  "INTENSIVE BINARY CURSOR FOR SELECT" },
{ 0,  "INTENSIVE BINARY SCROLL" },
{ 0,  "INTENSIVE BINARY SCROLL CURSOR" },
{ 0,  "INTENSIVE BINARY SCROLL CURSOR FOR" },
{ 0,  "INTENSIVE BINARY SCROLL CURSOR FOR SELECT" },
{ 0,  "INTENSIVE CURSOR" },
{ 0,  "INTENSIVE CURSOR FOR" },
{ 0,  "INTENSIVE CURSOR FOR SELECT" },
{ 0,  "INTENSIVE SCROLL" },
{ 0,  "INTENSIVE SCROLL CURSOR" },
{ 0,  "INTENSIVE SCROLL CURSOR FOR" },
{ 0,  "INTENSIVE SCROLL CURSOR FOR SELECT" },
{ 0,  "INTERNALLENGTH" },
{ 0,  "INTERSECT" },
{ 0,  "INTO" },
{ 0,  "INTO TABLE" },
{ 0,  "INTO TEMP" },
{ 0,  "INTO TEMP TABLE" },
{ 0,  "INTO TEMPORARY" },
{ 0,  "INTO TEMPORARY TABLE" },
{ 0,  "IS" },
{ 0,  "IS NULL" },
{ 0,  "JOIN" },
{ 0,  "KEY" },
{ 0,  "KEY DEFAULT" },
{ 0,  "KEY DEFAULT NULL" },
{ 0,  "KEY DEFAULT NULL REFERENCES" },
{ 0,  "KEY NOT NULL" },
{ 0,  "KEY NOT NULL DEFAULT" },
{ 0,  "KEY NOT NULL REFERENCES" },
{ 0,  "KEY NOT NULL UNIQUE REFERENCES" },
{ 0,  "KEY REFERENCES" },
{ 0,  "KEY UNIQUE" },
{ 0,  "KEY UNIQUE NOT NULL" },
{ 0,  "KEY UNIQUE NOT NULL REFERENCES" },
{ 0,  "KEY UNIQUE REFERENCES" },
{ 0,  "LANCOMPILER" },
{ 0,  "LANGUAGE" },
{ 0,  "LANGUAGE 'C'" },
{ 0,  "LEFT" },
{ 0,  "LEFT JOIN" },
{ 0,  "LEFT OUTER JOIN" },
{ 0,  "LEFTARG" },
{ 0,  "LIMIT" },
{ 0,  "LIMIT ALL" },
{ 0,  "LIMIT ALL  OFFSET" },
{ 0,  "LISTEN" },
{ 0,  "LOAD" },
{ 0,  "LOCAL" },
{ 0,  "LOCATION" },
{ 0,  "LOCK" },
{ 0,  "LOCK TABLE" },
{ 0,  "MATCH" },
{ 0,  "MATCH FULL" },
{ 0,  "MATCH PARTIAL" },
{ 0,  "MAXVALUE" },
{ 0,  "MINVALUE" },
{ 0,  "MODE" },
{ 0,  "MOVE" },
{ 0,  "MOVE BACKWARD" },
{ 0,  "MOVE BACKWARD ALL" },
{ 0,  "MOVE BACKWARD ALL FROM" },
{ 0,  "MOVE BACKWARD ALL IN" },
{ 0,  "MOVE BACKWARD FROM" },
{ 0,  "MOVE BACKWARD IN" },
{ 0,  "MOVE BACKWARD NEXT" },
{ 0,  "MOVE BACKWARD NEXT FROM" },
{ 0,  "MOVE BACKWARD NEXT IN" },
{ 0,  "MOVE BACKWARD PRIOR" },
{ 0,  "MOVE BACKWARD PRIOR FROM" },
{ 0,  "MOVE BACKWARD PRIOR IN" },
{ 0,  "MOVE FORWARD" },
{ 0,  "MOVE FORWARD ALL" },
{ 0,  "MOVE FORWARD ALL FROM" },
{ 0,  "MOVE FORWARD ALL IN" },
{ 0,  "MOVE FORWARD FROM" },
{ 0,  "MOVE FORWARD IN" },
{ 0,  "MOVE FORWARD NEXT" },
{ 0,  "MOVE FORWARD NEXT FROM" },
{ 0,  "MOVE FORWARD NEXT IN" },
{ 0,  "MOVE FORWARD PRIOR" },
{ 0,  "MOVE FORWARD PRIOR FROM" },
{ 0,  "MOVE FORWARD PRIOR IN" },
{ 0,  "MOVE RELATIVE" },
{ 0,  "MOVE RELATIVE ALL" },
{ 0,  "MOVE RELATIVE ALL FROM" },
{ 0,  "MOVE RELATIVE ALL IN" },
{ 0,  "MOVE RELATIVE FROM" },
{ 0,  "MOVE RELATIVE IN" },
{ 0,  "MOVE RELATIVE NEXT" },
{ 0,  "MOVE RELATIVE NEXT FROM" },
{ 0,  "MOVE RELATIVE NEXT IN" },
{ 0,  "MOVE RELATIVE PRIOR" },
{ 0,  "MOVE RELATIVE PRIOR FROM" },
{ 0,  "MOVE RELATIVE PRIOR IN" },
{ 0,  "NATURAL" },
{ 0,  "NATURAL JOIN" },
{ 0,  "NEGATOR" },
{ 0,  "NO" },
{ 0,  "NOCREATEDB" },
{ 0,  "NOCREATEUSER" },
{ 0,  "NOT" },
{ 0,  "NOT DEFERRABLE" },
{ 0,  "NOT NULL" },
{ 0,  "NOTHING" },
{ 0,  "NOTIFY" },
{ 0,  "NULL" },
{ 0,  "NULL AS" },
{ 0,  "NULL DEFAULT" },
{ 0,  "NZST13NZDT" },
{ 0,  "OFFSET" },
{ 0,  "OIDS" },
{ 0,  "ON" },
{ 0,  "ON AGGREGATE" },
{ 0,  "ON COLUMN" },
{ 0,  "ON DATABASE" },
{ 0,  "ON DELETE" },
{ 0,  "ON DELETE CASCADE" },
{ 0,  "ON DELETE DO NOTHING" },
{ 0,  "ON DELETE RESTRICT" },
{ 0,  "ON DELETE SET DEFAULT" },
{ 0,  "ON DELETE SET NULL" },
{ 0,  "ON FUNCTION" },
{ 0,  "ON INDEX" },
{ 0,  "ON OPERATOR" },
{ 0,  "ON RULE" },
{ 0,  "ON SELECT" },
{ 0,  "ON SEQUENCE" },
{ 0,  "ON TABLE" },
{ 0,  "ON TRIGGER" },
{ 0,  "ON TYPE" },
{ 0,  "ON UPDATE" },
{ 0,  "ON UPDATE CASCASE" },
{ 0,  "ON UPDATE DO NOTHING" },
{ 0,  "ON UPDATE RESTRICT" },
{ 0,  "ON UPDATE SET DEFAULT" },
{ 0,  "ON UPDATE SET NULL" },
{ 0,  "ON VIEW" },
{ 0,  "ONLY" },
{ 0,  "OPERATOR" },
{ 0,  "OR" },
{ 0,  "OR DELETE" },
{ 0,  "OR INSERT" },
{ 0,  "OR UPDATE" },
{ 0,  "ORDER" },
{ 0,  "ORDER BY" },
{ 0,  "OUTER" },
{ 0,  "OUTER JOIN" },
{ 0,  "OUTPUT" },
{ 0,  "OWNER" },
{ 0,  "OWNER TO" },
{ 0,  "PARTAIL" },
{ 0,  "PASSEDBYNAME" },
{ 0,  "PASSWORD" },
{ 0,  "PRIMARY" },
{ 0,  "PRIMARY KEY" },
{ 0,  "PRIMARY KEY NOT NULL" },
{ 0,  "PRIMARY KEY NOT NULL DEFAULT" },
{ 0,  "PRIMARY KEY UNIQUE" },
{ 0,  "PRIMARY KEY UNIQUE NOT NULL" },
{ 0,  "PROCEDURAL" },
{ 0,  "PROCEDURAL LANGUAGE" },
{ 0,  "PROCEDURAL TRUSTED LANGUAGE" },
{ 0,  "PROCEDURAL TRUSTED" },
{ 0,  "PST8PDT" },
{ 0,  "RECIEVE" },
{ 0,  "REFERENCES" },
{ 0,  "REINDEX" },
{ 0,  "REINDEX DATABASE" },
{ 0,  "REINDEX INDEX" },
{ 0,  "REINDEX TABLE" },
{ 0,  "RELATIVE" },
{ 0,  "RELATIVE ALL" },
{ 0,  "RELATIVE ALL FROM" },
{ 0,  "RELATIVE ALL IN" },
{ 0,  "RELATIVE FROM" },
{ 0,  "RELATIVE IN" },
{ 0,  "RELATIVE NEXT" },
{ 0,  "RELATIVE NEXT FROM" },
{ 0,  "RELATIVE NEXT IN" },
{ 0,  "RELATIVE PRIOR" },
{ 0,  "RELATIVE PRIOR FROM" },
{ 0,  "RELATIVE PRIOR IN" },
{ 0,  "RENAME" },
{ 0,  "RENAME COLUMN" },
{ 0,  "RENAME TO" },
{ 0,  "RESET" },
{ 0,  "RESTRICT" },
{ 0,  "RETURNS" },
{ 0,  "REVOKE" },
{ 0,  "REVOKE DELETE" },
{ 0,  "REVOKE DELETE ON" },
{ 0,  "REVOKE INSERT" },
{ 0,  "REVOKE INSERT ON" },
{ 0,  "REVOKE SELECT" },
{ 0,  "REVOKE SELECT ON" },
{ 0,  "REVOKE UPDATE" },
{ 0,  "REVOKE UPDATE ON" },
{ 0,  "RIGHT" },
{ 0,  "RIGHT JOIN" },
{ 0,  "RIGHT OUTER JOIN" },
{ 0,  "RIGHTARG" },
{ 0,  "ROLLBACK" },
{ 0,  "ROLLBACK TRANSACTION" },
{ 0,  "ROLLBACK WORK" },
{ 0,  "ROW" },
{ 0,  "ROW EXCLUSIVE" },
{ 0,  "ROW EXCLUSIVE MODE" },
{ 0,  "ROW EXECUTE" },
{ 0,  "ROW EXECUTE PROCEDURE" },
{ 0,  "ROW SHARE" },
{ 0,  "ROW SHARE MODE" },
{ 0,  "RULE" },
{ 0,  "RULE ON" },
{ 0,  "SCROLL" },
{ 0,  "SCROLL BINARY" },
{ 0,  "SCROLL BINARY CURSOR" },
{ 0,  "SCROLL BINARY CURSOR FOR" },
{ 0,  "SCROLL BINARY CURSOR FOR SELECT" },
{ 0,  "SCROLL BINARY INTENSIVE" },
{ 0,  "SCROLL BINARY INTENSIVE CURSOR" },
{ 0,  "SCROLL BINARY INTENSIVE CURSOR FOR" },
{ 0,  "SCROLL BINARY INTENSIVE CURSOR FOR SELECT" },
{ 0,  "SCROLL CURSOR" },
{ 0,  "SCROLL INSTENSIVE BINARY" },
{ 0,  "SCROLL INSTENSIVE BINARY CURSOR" },
{ 0,  "SCROLL INSTENSIVE BINARY CURSOR FOR" },
{ 0,  "SCROLL INSTENSIVE BINARY CURSOR FOR SELECT" },
{ 0,  "SCROLL INTENSIVE CURSOR" },
{ 0,  "SCROLL INTENSIVE CURSOR FOR" },
{ 0,  "SCROLL INTENSIVE CURSOR FOR SELECT" },
{ 0,  "SELECT" },
{ 0,  "SELECT ALL" },
{ 0,  "SELECT ALL DISTINCT" },
{ 0,  "SELECT DISTINCT" },
{ 0,  "SELECT DISTINCT ALL" },
{ 0,  "SELECT DISTINCT ONLY" },
{ 0,  "SELECT INTO" },
{ 0,  "SELECT ON" },
{ 0,  "SELECT ONLY" },
{ 0,  "SELECT ONLY DISTINCT" },
{ 0,  "SEND" },
{ 0,  "SEQUENCE" },
{ 0,  "SET" },
{ 0,  "SET DEFAULT" },
{ 0,  "SFUNC" },
{ 0,  "SHARE" },
{ 0,  "SHARE MODE" },
{ 0,  "SORT1" },
{ 0,  "SORT2" },
{ 0,  "START" },
{ 0,  "STATEMENT" },
{ 0,  "STATEMENT EXECUTE" },
{ 0,  "STATEMENT EXECUTE PROCEDURE" },
{ 0,  "STORAGE" },
{ 0,  "STYPE" },
{ 0,  "SYSID" },
{ 0,  "TABLE" },
{ 0,  "TABLE AS" },
{ 0,  "TABLE AS SELECT" },
{ 0,  "TABLE AS SELECT ALL" },
{ 0,  "TABLE AS SELECT DISTINCT" },
{ 0,  "TABLE AS SELECT DISTINCT ALL" },
{ 0,  "TABLE AS SELECT DISTINCT ONLY" },
{ 0,  "TABLE AS SELECT ONLY" },
{ 0,  "TEMP" },
{ 0,  "TEMP TABLE" },
{ 0,  "TEMPLATE" },
{ 0,  "TEMPORARY" },
{ 0,  "TEMPORARY TABLE" },
{ 0,  "TIME" },
{ 0,  "TIME ZONE" },
{ 0,  "TIME ZONE DEFAULT" },
{ 0,  "TIME ZONE EST5EDT" },
{ 0,  "TIME ZONE LOCAL" },
{ 0,  "TIME ZONE NZST13NZDT" },
{ 0,  "TIME ZONE PST8PDT" },
{ 0,  "TO" },
{ 0,  "TO DEFAULT" },
{ 0,  "TO GROUP" },
{ 0,  "TO PUBLIC" },
{ 0,  "TRANSACTION" },
{ 0,  "TRIGGER" },
{ 0,  "TRUNCATE" },
{ 0,  "TRUSTED" },
{ 0,  "TRUSTED LANGUAGE" },
{ 0,  "TRUSTED PROCEDURAL" },
{ 0,  "TRUSTED PROCEDURAL LANGUAGE" },
{ 0,  "TYPE" },
{ 0,  "UNION" },
{ 0,  "UNIQUE" },
{ 0,  "UNIQUE DEFAULT" },
{ 0,  "UNIQUE FOREIGN KEY" },
{ 0,  "UNIQUE FOREIGN KEY REFERENCES" },
{ 0,  "UNIQUE NOT NULL" },
{ 0,  "UNIQUE NOT NULL DEFAULT" },
{ 0,  "UNIQUE NOT NULL FOREIGN KEY" },
{ 0,  "UNIQUE NOT NULL FOREIGN KEY REFERENCES" },
{ 0,  "UNIQUE NOT NULL PRIMARY KEY" },
{ 0,  "UNIQUE PRIMARY KEY" },
{ 0,  "UNLISTEN" },
{ 0,  "UNTIL" },
{ 0,  "UPDATE" },
{ 0,  "UPDATE CASCADE" },
{ 0,  "UPDATE DO NOTHING" },
{ 0,  "UPDATE NO ACTION" },
{ 0,  "UPDATE ON" },
{ 0,  "UPDATE ONLY" },
{ 0,  "UPDATE OR" },
{ 0,  "UPDATE RESTRICT" },
{ 0,  "UPDATE SET DEFAULT" },
{ 0,  "UPDATE SET NULL" },
{ 0,  "USER" },
{ 0,  "USING" },
{ 0,  "USING DELIMETERS" },
{ 0,  "VACUUM" },
{ 0,  "VACUUM ANALYZE" },
{ 0,  "VACUUM ANALYZE VERBOSE" },
{ 0,  "VACUUM VERBOSE" },
{ 0,  "VACUUM VERBOSE ANALYZE" },
{ 0,  "VALID" },
{ 0,  "VALID UNTIL" },
{ 0,  "VALUES" },
{ 0,  "VARIABLE" },
{ 0,  "VERBOSE" },
{ 0,  "VIEW" },
{ 0,  "VIEW AS" },
{ 0,  "VIEW AS SELECT" },
{ 0,  "VIEW AS SELECT ALL" },
{ 0,  "VIEW AS SELECT DISTINCT" },
{ 0,  "VIEW AS SELECT DISTINCT ALL" },
{ 0,  "VIEW AS SELECT DISTINCT ONLY" },
{ 0,  "VIEW AS SELECT ONLY" },
{ 0,  "WHERE" },
{ 0,  "WITH" },
{ 0,  "WITH ENCODING" },
{ 0,  "WITH LOCATION" },
{ 0,  "WITH NULL" },
{ 0,  "WITH NULL AS" },
{ 0,  "WITH OIDS" },
{ 0,  "WITH PASSWORD" },
{ 0,  "WITH SYSID" },
{ 0,  "WITH TEMPLATE" },
{ 0,  "WORK" },
{ 0,  "ZONE" },
{ 0,  "ZONE DEFAULT" },
{ 0,  "ZONE EST5EDT" },
{ 0,  "ZONE LOCAL" },
{ 0,  "ZONE NZST13NZDT" },
{ 0,  "ZONE PST8PDT" }
};

INT get_last_words(CHAR* target, CHAR* from, INT count)
{
 INT i,l,offset,cnt;
 debug("%s:%d get_last_words(%s,%s,%d)", __FILE__,__LINE__,target?target:"null",from?from:"null",count);
 l = strlen(from);
 i = l-1;
 offset=0;
 strcpy(target,"");
 cnt = count-1;
 while (i>0 && count)
   {
    if ((from[i]<'A' || from[i]>'Z') && from[i]!=' ' && from[i]!='\n') { strcpy(target,""); return -1; }
    if (from[i]==' ' || from[i]=='\n') { count--; offset=1; }
    i--;
   }
 if (offset && i) i++;
 while (from[i]==' ' || from[i]=='\n') i++;
 strcpy(target, from+i);
 offset=i;
 l = strlen(target);
 if (target[l-1]==' ' || target[l-1]=='\n') target[l-1] = 0;
 l = strlen(target);
 count=0;
 for (i=0;i<l;i++) if (target[i]==' ') count++;
 if (count<cnt) { strcpy(target,""); return -1; }
 return offset;
}


INT auto_complete(CHAR* str, CHAR*** table)
{
 INT count,i,j, len;
 debug("%s:%d auto_complete(%s, %p)", __FILE__,__LINE__,str?str:"null",table);
 count = 0;
 *table = NULL;
 len = strlen(str);
 for (i=0;i<NUM_PARSE_STRINGS;i++) if (!strncmp(parser[i].keyword,str,len)) count++;
 if (!count) { *table = NULL; return 0; }
 *table = (CHAR**)malloc(count*sizeof(CHAR*));
 if (!(*table)) fatal_here(HERE, "cannot allocate memory.");
 j = 0;
 for (i=0;i<NUM_PARSE_STRINGS;i++)
   {
    if (!strncmp(parser[i].keyword,str,len))
      {
       (*table)[j] = (CHAR*)malloc((strlen(parser[i].keyword)+1)*sizeof(CHAR));
       if (!((*table)[j])) fatal_here(HERE, "cannot allocate memory, (I,J)=(%d,%d)",i,j);
       strcpy((*table)[j], parser[i].keyword);
       j++;
      }
   }
 return count;
}

