<?php

/**************************************************
Program name:	buildsql_tbl_addfield.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Builds SQL string from the data entered
		on tbl_addnewfield2page.php
		
Create Date:	6/29/01 

Modified Date(s):	

Notes:
**************************************************/

unset($sql_query);

for ($i = 0; $i < $num_newfields; $i++) {

	// Unset $query.  New ALTER line for every column to add
	unset($query);

	// Field Name and Type
	$query .= $cfgQuotes.$field_name[$i].$cfgQuotes." ".$field_type[$i]." ";

	// Add parenthesis for length if value was entered
	if (!empty($field_length[$i])) {
		$query .= "(".stripslashes($field_length[$i]).") ";
	}

	// Add NULL or NOT NULL
	$query .= "$field_null[$i] " ;

	// Build ALTER statement	
	unset($alter_query);		
	$alter_query .= "ALTER TABLE ".dq($table)." ADD ".$query."; \n";


	// Add FK constraint query

	if ($fk_field[$i] != "--none--") {
			$fkquery .= " ALTER TABLE ". $table ." ADD CONSTRAINT "."fk_".$field_name[$i]." FOREIGN KEY (".dq($field_name[$i]).") REFERENCES ".stripslashes($fk_field[$i]);
	
			if (!empty($match_type[$i])) {
				$fkquery .= " ".$match_type[$i];
			}

			if (!empty($on_delete[$i])) {
				$fkquery .= " ON DELETE ".$on_delete[$i];
			}

			if (!empty($on_update[$i])) {
				$fkquery .= " ON UPDATE ".$on_update[$i];
			}

			if (!empty($deferrable_type[$i])) {
				$fkquery .= " ".$deferrable_type[$i];
			}
			
			$fkquery .= "; \n";
	
	}

	// Add CHECK constraint query
	if (!empty($col_constraint[$i])) {
			$checkquery .= " ALTER TABLE ". $table ." ADD CONSTRAINT "."check_".$field_name[$i]." CHECK (".$col_constraint[$i]."); \n";
	}	


	// Build ALTER statement for DEFAULT value (must be separate ALTER statement)
	#if (!empty($field_default[$i]) && $version >= 7.0 ) {
	if (!empty($field_default[$i]) ) {
		$field_default[$i] = stripslashes($field_default[$i]);
		$query_default = "ALTER TABLE ".$cfgQuotes.$table.$cfgQuotes." ALTER ".$cfgQuotes.$field_name[$i].$cfgQuotes." SET DEFAULT ".squotes($field_default[$i])."; \n";
	}

	// Build UPDATE statement to update rows with Default Value
	#if ((!empty($field_default[$i])) && ($version >= 7.0) && (trim($field_null[$i]) == "NOT NULL")) {
	if ((!empty($field_default[$i])) && (trim($field_null[$i]) == "NOT NULL")) {
		$query_updatedefault = "UPDATE ".$cfgQuotes.$table.$cfgQuotes." SET ".$cfgQuotes.$field_name[$i].$cfgQuotes." = ".squotes($field_default[$i])."; \n";
	}


	// Should there just be one index, where Unique overrides INDex checkbox
	// SQL for CREATE INDEX
	unset($index_query);
	If (count($field_index[$i])) {
		$index_query .= "CREATE INDEX ".$cfgQuotes.$field_name[$i]."_".$table."_key".$cfgQuotes." ON ".$cfgQuotes.$table.$cfgQuotes."(".$cfgQuotes.$field_name[$i].$cfgQuotes."); \n";
	}

	// SQL for CREATE UNIQUE INDEX
	If (count($field_unique[$i])) {
		$index_query .= "CREATE UNIQUE INDEX ".$cfgQuotes.$field_name[$i]."_".$table."_ukey".$cfgQuotes." ON ".$cfgQuotes.$table.$cfgQuotes."(".$cfgQuotes.$field_name[$i].$cfgQuotes."); \n";
	}

#	if (!empty($index_query)) {
#		$index_query = ereg_replace("; $", "", $index_query);
#	}

	
	// Send all 4 queries as $sql_query string to sqlresuls.php.
	$sql_query .= $alter_query . $fkquery . $checkquery . $query_default . $query_updatedefault . $index_query ;


//end of FOR loop
}


?>
