/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Relation;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.jdbc.TriggerResultSet;

public class TriggerData
extends NativeStruct
implements org.postgresql.pljava.TriggerData {
    private Relation m_relation;
    private TriggerResultSet m_old;
    private TriggerResultSet m_new;

    private /* synthetic */ void finit$() {
        this.m_old = null;
        this.m_new = null;
    }

    public ResultSet getNew() throws SQLException {
        if (this.m_new != null) {
            return this.m_new;
        }
        if (this.isFiredByDelete() || this.isFiredForStatement()) {
            return null;
        }
        Tuple tuple = this.isFiredByInsert() ? this.getTriggerTuple() : this.getNewTuple();
        this.m_new = new TriggerResultSet(this.relation().getTupleDesc(), tuple, this.isFiredAfter());
        return this.m_new;
    }

    public ResultSet getOld() throws SQLException {
        if (this.m_old != null) {
            return this.m_old;
        }
        if (this.isFiredByInsert() || this.isFiredForStatement()) {
            return null;
        }
        this.m_old = new TriggerResultSet(this.relation().getTupleDesc(), this.getTriggerTuple(), true);
        return this.m_old;
    }

    public Tuple getTriggerReturnTuple() throws SQLException {
        Object[] objectArray;
        if (this.isFiredForStatement() || this.isFiredAfter()) {
            return null;
        }
        if (this.m_new != null && (objectArray = this.m_new.getChangeIndexesAndValues()) != null) {
            Tuple tuple = (Tuple)objectArray[0];
            int[] nArray = (int[])objectArray[1];
            Object[] objectArray2 = (Object[])objectArray[2];
            return this.relation().modifyTuple(tuple, nArray, objectArray2);
        }
        if (this.isFiredByUpdate()) {
            return this.getNewTuple();
        }
        return this.getTriggerTuple();
    }

    public String getTableName() throws SQLException {
        return this.relation().getName();
    }

    public Relation getRelation() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Relation relation = this._getRelation();
                Object var3_3 = null;
                return relation;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public Tuple getTriggerTuple() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Tuple tuple = this._getTriggerTuple();
                Object var3_3 = null;
                return tuple;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public Tuple getNewTuple() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Tuple tuple = this._getNewTuple();
                Object var3_3 = null;
                return tuple;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public String[] getArguments() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                String[] stringArray = this._getArguments();
                Object var3_3 = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public String getName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                String string = this._getName();
                Object var3_3 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredAfter() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredAfter();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredBefore() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredBefore();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredForEachRow() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredForEachRow();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredForStatement() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredForStatement();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredByDelete() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredByDelete();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredByInsert() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredByInsert();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public boolean isFiredByUpdate() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isFiredByUpdate();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    private final Relation relation() throws SQLException {
        if (this.m_relation == null) {
            this.m_relation = this.getRelation();
        }
        return this.m_relation;
    }

    private native Relation _getRelation() throws SQLException;

    private native Tuple _getTriggerTuple() throws SQLException;

    private native Tuple _getNewTuple() throws SQLException;

    private native String[] _getArguments() throws SQLException;

    private native String _getName() throws SQLException;

    private native boolean _isFiredAfter() throws SQLException;

    private native boolean _isFiredBefore() throws SQLException;

    private native boolean _isFiredForEachRow() throws SQLException;

    private native boolean _isFiredForStatement() throws SQLException;

    private native boolean _isFiredByDelete() throws SQLException;

    private native boolean _isFiredByInsert() throws SQLException;

    private native boolean _isFiredByUpdate() throws SQLException;

    public TriggerData() {
        this.finit$();
    }
}

