/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan
extends NativeStruct {
    static final int DEFAULT_INITIAL_CAPACITY = 29;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final PlanCache s_planCache;
    private final Object m_key;

    private ExecutionPlan(Object object) {
        this.m_key = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        ExecutionPlan executionPlan = s_planCache.put(this.m_key, this);
        if (executionPlan == null) return;
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                executionPlan._invalidate();
                return;
            }
            finally {
                Object var3_3 = null;
            }
        }
    }

    public Portal cursorOpen(String string, Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Portal portal = this._cursorOpen(string, objectArray);
                Object var5_5 = null;
                return portal;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isCursorPlan();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public int execute(Object[] objectArray, int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                int n2 = this._execute(objectArray, n);
                Object var5_5 = null;
                return n2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutionPlan prepare(String string, Oid[] oidArray) throws SQLException {
        Object object = oidArray == null ? string : new PlanKey(string, oidArray);
        ExecutionPlan executionPlan = (ExecutionPlan)s_planCache.remove(object);
        if (executionPlan != null) return executionPlan;
        executionPlan = new ExecutionPlan(object);
        Object object2 = Backend.THREADLOCK;
        synchronized (object2) {
            try {
                executionPlan._prepare(string, oidArray);
                return executionPlan;
            }
            finally {
                ExecutionPlan executionPlan2 = null;
            }
        }
    }

    private native Portal _cursorOpen(String var1, Object[] var2) throws SQLException;

    private native boolean _isCursorPlan() throws SQLException;

    private native int _execute(Object[] var1, int var2) throws SQLException;

    private native void _prepare(String var1, Oid[] var2) throws SQLException;

    private native void _invalidate();

    static {
        int n = Backend.getStatementCacheSize();
        s_planCache = new PlanCache(n < 11 ? 11 : n);
    }

    static final class PlanKey {
        private final int m_hashCode;
        private final String m_stmt;
        private final Oid[] m_argTypes;

        PlanKey(String string, Oid[] oidArray) {
            this.m_stmt = string;
            this.m_hashCode = string.hashCode() + 1;
            this.m_argTypes = oidArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PlanKey)) {
                return false;
            }
            PlanKey planKey = (PlanKey)object;
            if (!planKey.m_stmt.equals(this.m_stmt)) {
                return false;
            }
            Oid[] oidArray = this.m_argTypes;
            Oid[] oidArray2 = planKey.m_argTypes;
            int n = oidArray2.length;
            if (oidArray.length != n) {
                return false;
            }
            while (--n >= 0) {
                if (oidArray2[n].equals(oidArray[n])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    static final class PlanCache
    extends LinkedHashMap {
        private final int m_cacheSize;

        public PlanCache(int n) {
            super(29, 0.75f, true);
            this.m_cacheSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > this.m_cacheSize) {
                Object object = Backend.THREADLOCK;
                synchronized (object) {
                    try {
                        ((ExecutionPlan)entry.getValue())._invalidate();
                    }
                    finally {
                        Object var3_3 = null;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }
}

