/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.postgresql.pljava.jdbc.AbstractResultSet;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class ObjectResultSet
extends AbstractResultSet {
    private boolean m_wasNull = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public void clearWarnings() throws SQLException {
    }

    public Array getArray(int columnIndex) throws SQLException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Array)this.getValue(columnIndex, clazz);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        return c == null ? null : c.getAsciiStream();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BigDecimal)this.getValue(columnIndex, clazz);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedFeatureException("getBigDecimal(int, int)");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Blob b = this.getBlob(columnIndex);
        return b == null ? null : b.getBinaryStream();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        return bytes == null ? null : new BlobValue(bytes);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean b;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (b = (Boolean)this.getValue(columnIndex, clazz)) == null ? false : b;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Number b = this.getNumber(columnIndex);
        return b == null ? (byte)0 : b.byteValue();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (byte[])this.getValue(columnIndex, clazz);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        return c == null ? null : c.getCharacterStream();
    }

    public Clob getClob(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return str == null ? null : new ClobValue(str);
    }

    public Date getDate(int columnIndex) throws SQLException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Date)this.getValue(columnIndex, clazz);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Date)this.getValue(columnIndex, clazz, cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number d = this.getNumber(columnIndex);
        return d == null ? 0.0 : d.doubleValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number f = this.getNumber(columnIndex);
        return f == null ? 0.0f : f.floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number i = this.getNumber(columnIndex);
        return i == null ? 0 : i.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number l = this.getNumber(columnIndex);
        return l == null ? 0L : l.longValue();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    public final Object getObject(int columnIndex) throws SQLException {
        Object value = this.getObjectValue(columnIndex);
        this.m_wasNull = value == null;
        return value;
    }

    public final Object getObject(int columnIndex, Map map) throws SQLException {
        Object value = this.getObjectValue(columnIndex, map);
        this.m_wasNull = value == null;
        return value;
    }

    public Ref getRef(int columnIndex) throws SQLException {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Ref)this.getValue(columnIndex, clazz);
    }

    public short getShort(int columnIndex) throws SQLException {
        Number s = this.getNumber(columnIndex);
        return s == null ? (short)0 : s.shortValue();
    }

    public String getString(int columnIndex) throws SQLException {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)this.getValue(columnIndex, clazz);
    }

    public Time getTime(int columnIndex) throws SQLException {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Time)this.getValue(columnIndex, clazz);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Time)this.getValue(columnIndex, clazz, cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Timestamp)this.getValue(columnIndex, clazz);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Timestamp)this.getValue(columnIndex, clazz, cal);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedFeatureException("ResultSet.getUnicodeStream");
    }

    public URL getURL(int columnIndex) throws SQLException {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (URL)this.getValue(columnIndex, clazz);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedFeatureException("Refresh row");
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.updateObject(columnIndex, (Object)new ClobValue(new InputStreamReader(x, "US-ASCII"), length));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBlob(columnIndex, (Blob)new BlobValue(x, length));
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObject(columnIndex, (Object)(x ? Boolean.TRUE : Boolean.FALSE));
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Byte(x));
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateClob(columnIndex, (Clob)new ClobValue(x, length));
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Double(x));
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Float(x));
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Long(x));
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.updateObject(columnIndex, null);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Short(x));
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public boolean wasNull() {
        return this.m_wasNull;
    }

    protected final Number getNumber(int columnIndex) throws SQLException {
        Object value = this.getObjectValue(columnIndex);
        boolean bl = this.m_wasNull = value == null;
        if (this.m_wasNull || value instanceof Number) {
            return (Number)value;
        }
        throw new SQLException("Cannot derive a Number from an object of class " + value.getClass().getName());
    }

    protected final Object getValue(int columnIndex, Class cls) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null || cls.isInstance(value)) {
            return value;
        }
        throw new SQLException("Cannot derive a value of class " + cls.getName() + " from an object of class " + value.getClass().getName());
    }

    protected Object getValue(int columnIndex, Class cls, Calendar cal) throws SQLException {
        if (cal == null || cal == Calendar.getInstance()) {
            return this.getValue(columnIndex, cls);
        }
        throw new UnsupportedFeatureException("Obtaining date, time, or timestamp using explicit Calendar");
    }

    protected Object getObjectValue(int columnIndex, Map typeMap) throws SQLException {
        if (typeMap == null) {
            return this.getObjectValue(columnIndex);
        }
        throw new UnsupportedFeatureException("Obtaining values using explicit Map");
    }

    protected abstract Object getObjectValue(int var1) throws SQLException;
}

