/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIParameterMetaData;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIPreparedStatement
extends SPIStatement
implements PreparedStatement {
    private static final Object s_undef = new Object();
    private final String m_statement;
    private final int m_paramCount;
    private final ArrayList m_paramList;
    private ExecutionPlan m_plan;
    private int[] m_sqlTypes;
    private Oid[] m_typeIds;

    public SPIPreparedStatement(SPIConnection conn, String statement, int paramCount) {
        super(conn);
        this.m_statement = statement;
        this.m_paramCount = paramCount;
        this.m_paramList = new ArrayList(this.m_paramCount);
    }

    public void close() {
        if (this.m_plan != null) {
            this.m_plan.invalidate();
            this.m_plan = null;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    public void setNull(int columnIndex, int sqlType) throws SQLException {
        this.setObject(columnIndex, null, sqlType);
    }

    public void setBoolean(int columnIndex, boolean value) throws SQLException {
        this.setObject(columnIndex, (Object)(value ? Boolean.TRUE : Boolean.FALSE), 16);
    }

    public void setByte(int columnIndex, byte value) throws SQLException {
        this.setObject(columnIndex, (Object)new Byte(value), -6);
    }

    public void setShort(int columnIndex, short value) throws SQLException {
        this.setObject(columnIndex, (Object)new Short(value), 5);
    }

    public void setInt(int columnIndex, int value) throws SQLException {
        this.setObject(columnIndex, (Object)new Integer(value), 4);
    }

    public void setLong(int columnIndex, long value) throws SQLException {
        this.setObject(columnIndex, (Object)new Long(value), -5);
    }

    public void setFloat(int columnIndex, float value) throws SQLException {
        this.setObject(columnIndex, (Object)new Float(value), 6);
    }

    public void setDouble(int columnIndex, double value) throws SQLException {
        this.setObject(columnIndex, (Object)new Double(value), 8);
    }

    public void setBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 3);
    }

    public void setString(int columnIndex, String value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 12);
    }

    public void setBytes(int columnIndex, byte[] value) throws SQLException {
        this.setObject(columnIndex, (Object)value, -3);
    }

    public void setDate(int columnIndex, Date value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 91);
    }

    public void setTime(int columnIndex, Time value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 92);
    }

    public void setTimestamp(int columnIndex, Timestamp value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 93);
    }

    public void setAsciiStream(int columnIndex, InputStream value, int length) throws SQLException {
        try {
            this.m_paramList.add(new ParamEntry(columnIndex, 2005, new ClobValue(new InputStreamReader(value, "US-ASCII"), length)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    public void setUnicodeStream(int columnIndex, InputStream value, int arg2) throws SQLException {
        throw new UnsupportedFeatureException("PreparedStatement.setUnicodeStream");
    }

    public void setBinaryStream(int columnIndex, InputStream value, int length) throws SQLException {
        this.setObject(columnIndex, (Object)new BlobValue(value, length), 2004);
    }

    public void clearParameters() throws SQLException {
        this.m_paramList.clear();
    }

    public void setObject(int columnIndex, Object value, int sqlType, int scale) throws SQLException {
        this.setObject(columnIndex, value, sqlType);
    }

    public void setObject(int columnIndex, Object value, int sqlType) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.m_paramCount) {
            throw new SQLException("Illegal parameter index");
        }
        this.m_paramList.add(new ParamEntry(columnIndex - 1, sqlType, value));
    }

    public void setObject(int columnIndex, Object value) throws SQLException {
        if (value == null) {
            throw new SQLException("Can't assign null unless the SQL type is known");
        }
        this.setObject(columnIndex, value, SPIConnection.getTypeForClass(value.getClass()));
    }

    private int[] getSqlTypes() {
        if (this.m_sqlTypes != null) {
            return this.m_sqlTypes;
        }
        int top = this.m_paramList.size();
        int[] types = new int[this.m_paramCount];
        Arrays.fill(types, 12);
        int idx = 0;
        while (idx < top) {
            ParamEntry pe = (ParamEntry)this.m_paramList.get(idx);
            types[pe.getIndex()] = pe.getSqlType();
            ++idx;
        }
        this.m_sqlTypes = types;
        return types;
    }

    public boolean execute() throws SQLException {
        Object[] values = null;
        ArrayList params = this.m_paramList;
        int top = params.size();
        if (top < this.m_paramCount) {
            throw new SQLException("Not all parameters have been set");
        }
        if (top > 0) {
            values = new Object[this.m_paramCount];
            Arrays.fill(values, s_undef);
            int idx = 0;
            while (idx < top) {
                ParamEntry pe = (ParamEntry)params.get(idx);
                int pIdx = pe.getIndex();
                if (values[pIdx] != s_undef) {
                    throw new SQLException("Parameter with index " + (idx + 1) + " was set more than once");
                }
                values[pIdx] = pe.getValue();
                ++idx;
            }
        }
        if (this.m_plan == null) {
            if (this.m_typeIds == null && top > 0) {
                int[] types = new int[top];
                Oid[] typeIds = new Oid[top];
                int idx = 0;
                while (idx < top) {
                    ParamEntry pe = (ParamEntry)params.get(idx);
                    int pIdx = pe.getIndex();
                    types[pIdx] = pe.getSqlType();
                    typeIds[pIdx] = pe.getTypeId();
                    ++idx;
                }
                this.m_sqlTypes = types;
                this.m_typeIds = typeIds;
            }
            this.m_plan = ExecutionPlan.prepare(this.m_statement, this.m_typeIds);
            this.m_plan.makeDurable();
        }
        boolean result = this.executePlan(this.m_plan, values);
        params.clear();
        return result;
    }

    public boolean execute(String statement) throws SQLException {
        throw new UnsupportedFeatureException("Can't execute other statements using a prepared statement");
    }

    public void addBatch() throws SQLException {
        this.internalAddBatch(this.m_paramList.clone());
        this.m_paramList.clear();
    }

    public void addBatch(String statement) throws SQLException {
        throw new UnsupportedFeatureException("Can't add batch statements to a prepared statement");
    }

    public void setCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        this.setObject(columnIndex, (Object)new ClobValue(value, length), 2005);
    }

    public void setRef(int columnIndex, Ref value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2006);
    }

    public void setBlob(int columnIndex, Blob value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2004);
    }

    public void setClob(int columnIndex, Clob value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2005);
    }

    public void setArray(int columnIndex, Array value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2003);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    public void setDate(int columnIndex, Date value, Calendar cal) throws SQLException {
        if (cal == null || cal == Calendar.getInstance()) {
            this.setObject(columnIndex, (Object)value, 91);
        }
        throw new UnsupportedFeatureException("Setting date using explicit Calendar");
    }

    public void setTime(int columnIndex, Time value, Calendar cal) throws SQLException {
        if (cal == null || cal == Calendar.getInstance()) {
            this.setObject(columnIndex, (Object)value, 92);
        }
        throw new UnsupportedFeatureException("Setting time using explicit Calendar");
    }

    public void setTimestamp(int columnIndex, Timestamp value, Calendar cal) throws SQLException {
        if (cal == null || cal == Calendar.getInstance()) {
            this.setObject(columnIndex, (Object)value, 93);
        }
        throw new UnsupportedFeatureException("Setting time using explicit Calendar");
    }

    public void setNull(int columnIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(columnIndex, sqlType);
    }

    public void setURL(int columnIndex, URL value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 70);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new SPIParameterMetaData(this.getSqlTypes());
    }

    protected int executeBatchEntry(Object batchEntry) throws SQLException {
        int ret = -2;
        this.m_paramList.clear();
        this.m_paramList.addAll((ArrayList)batchEntry);
        if (this.execute()) {
            this.getResultSet().close();
        } else {
            int updCount = this.getUpdateCount();
            if (updCount >= 0) {
                ret = updCount;
            }
        }
        return ret;
    }

    public static class ParamEntry {
        private final int m_columnIndex;
        private final int m_sqlType;
        private final Object m_value;

        ParamEntry(int columnIndex, int sqlType, Object value) {
            this.m_columnIndex = columnIndex;
            this.m_sqlType = sqlType;
            this.m_value = value;
        }

        int getIndex() {
            return this.m_columnIndex;
        }

        int getSqlType() {
            return this.m_sqlType;
        }

        Oid getTypeId() {
            Oid id;
            Oid oid = id = this.m_sqlType == 1111 ? Oid.forJavaClass(this.m_value.getClass()) : Oid.forSqlType(this.m_sqlType);
            if (id == null) {
                id = Oid.forSqlType(12);
            }
            return id;
        }

        Object getValue() {
            return this.m_value;
        }
    }
}

