/* $PostgresPy: if/include/py.h,v 1.13 2004/07/20 15:20:20 flaw Exp $
 *
 * † Instrument:
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Python utility macros and definitions.
 */
#ifndef POSTGRESPY_PY_H
#define POSTGRESPY_PY_H "py.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef PyObject * PyObj;
#define PyObj(OB) ((PyObj)OB)

#define PyMapItem(ob,str)	(PyMapping_HasKeyString(ob,str)? \
									 PyMapping_GetItemString(ob,str):(PyObj)NULL)
#define PySeqItem(ob,num)	PySequence_GetItem(ob,num)
#define PyAttr(ob,str)	(PyObject_HasAttrString(ob,str)? \
								PyObject_GetAttrString(ob,str):(PyObj)NULL)

#define PySetAttr(ob,str,v) PyObject_SetAttrString(ob,str,v)

#define PyErrSetAttr(att,ob) PySetAttr(PyErr_Occurred(),att,ob)

#define PYSTR(str)	PyString_FromString(str)
#define PYSTRF(...)	PyString_FromFormat(__VA_ARGS__)
#define PYFLOAT(i)	PyFloat_FromDouble(i)
#define PYINT(i)		PyInt_FromLong(i)
#define PYLONG(L)		PyLong_FromLong(L)
#define PYLLONG(L)	PyLong_FromLongLong(L)
#define PYULONG(L)	PyLong_FromUnsignedLong(L)
#define PYULLONG(L)	PyLong_FromUnsignedLongLong(L)


#define PYASSTR(str)		PyString_AS_STRING(str)
#define PYASINT(i)		PyInt_AS_LONG(i)
#define PYASDOUBLE(i)	PyFloat_AS_DOUBLE(i)

#define PySPEC(OB,...) FMACRO(if(OB) {			\
	PyObj obrepr = PyObject_Repr(OB);			\
	printf(												\
		"\nPython Object %s@%p\n"					\
		"	Type: %s@%p\n"								\
		"	Repr: %s\n"									\
		"	Reference Count: %d\n",					\
		#OB, OB,											\
		(OB)->ob_type->tp_name, (OB)->ob_type, \
		PyString_AS_STRING(obrepr),				\
		(OB)->ob_refcnt  );							\
	printf("-> "__VA_ARGS__);						\
	Py_DECREF(obrepr);								\
} else { puts(#OB" is <NULL>\n"); }				\
	puts(__LOCATION__"\n");							\
)

#if defined(FMACRO) && defined(DMACRO)
#define DECREF(ob) FMACRO(DMACRO(PySPEC(ob, "Decrement\n");); Py_DECREF(ob);)
#define INCREF(ob) FMACRO(DMACRO(PySPEC(ob, "Increment\n");); Py_INCREF(ob);)
#define XDECREF(ob) FMACRO(if(ob) DECREF(ob);)
#define XINCREF(ob) FMACRO(if(ob) INCREF(ob);)

#define RETURN_NONE FMACRO(INCREF(Py_None); return(Py_None);)

inline PyObj PyATTR(PyObj ob, char *str)
{ PyObj pyattr = PyAttr(ob,str); XDECREF(pyattr); return(pyattr); }

inline PyObj PyMapITEM(PyObj ob, char *str)
{ PyObj pyitem = PyMapItem(ob,str); XDECREF(pyitem); return(pyitem); }
#endif

inline char _PyCFunctionErr_NoKeywordsAllowed(char *_func, PyObj KW)
{	if (KW == NULL) return 0;
	PyErr_Format(PyExc_TypeError,
		"%s does not take keyword arguments", _func);
	return 1;
}
#define PyCFunctionErr_NoKeywordsAllowed(KW) \
	_PyCFunctionErr_NoKeywordsAllowed(__func__, KW)

#ifdef __cplusplus
}
#endif
#endif /* !POSTGRESPY_PY_H */
