# regress.sh
# rserv regression test script
# (c) 2000 Thomas Lockhart, PostgreSQL Inc.

dir="../bin"

dropdb master
dropdb slave

createdb master
createdb slave

$dir/MasterInit master
$dir/SlaveInit slave

psql -c "create table t1 (i int, t text, d timestamp default text 'now');" master
$dir/MasterAddTable master t1 d

psql -c "create table t1 (i int, t text, d timestamp default text 'now');" slave
$dir/SlaveAddTable slave t1 d

psql -c "insert into t1 values (1, 'one');" master
psql -c "insert into t1 values (2, 'two');" master

$dir/Replicate master slave
$dir/MasterSync master `GetSyncID --noverbose slave`

psql -c "insert into t1 values (3, 'three');" master
psql -c "insert into t1 values (4, 'four');" master

$dir/Replicate master slave
$dir/MasterSync master `GetSyncID --noverbose slave`

exit
