#include <arpa/inet.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <netinet/ether.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <pcap.h>
#include <syslog.h>

#include <unistd.h>
#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>

using namespace std;


#include "ip.h"
#include "dns.h"
#include "prio.h"

EXEC SQL INCLUDE sqlca;

void	SQLConnect(char *connectionInfo)
{
	EXEC SQL BEGIN DECLARE SECTION;
	char	*connection;
	EXEC SQL END DECLARE SECTION;

	connection = connectionInfo;

	EXEC SQL CONNECT TO :connection;
	if(sqlca.sqlcode) {
		cerr << "connect Error # " << sqlca.sqlerrm.sqlerrml << " '" << sqlca.sqlerrm.sqlerrmc << "'" << endl;
		exit(0);
	}
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}

bool	SQlSaveRecord(CRecord *cr, string interfaceName)
{
	struct in_addr kk;
	EXEC SQL BEGIN DECLARE SECTION;
	int	f_src_ip_serial;
	int	f_dst_ip_serial;
	int	f_port_src;
	int 	f_port_dst;
	int	f_protocol_number;
	int 	f_volume;
	int	f_packets;
	char	f_lastUpdate[30];
	char  f_firstUpdate[30];
	const char	*f_interface;	
	EXEC SQL END DECLARE SECTION;

	f_port_src = cr->port_src_m;
	f_src_ip_serial = cr->srcSerial_m;
	f_port_dst = cr->port_dst_m;
	f_dst_ip_serial = cr->dstSerial_m;
	f_protocol_number = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	timevalToDate(&cr->lastUpdate_m, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_m, f_firstUpdate);
	f_interface = interfaceName.c_str();

	EXEC SQL BEGIN;
	EXEC SQL INSERT INTO usage (src_ip_serial, dst_ip_serial,
		port_src, port_dst, 
		protocol_number, 
		first_seen, last_seen, packets,
		volume, interface)
			VALUES (:f_src_ip_serial, :f_dst_ip_serial,
				:f_port_src, :f_port_dst,
				:f_protocol_number, 
				:f_firstUpdate, :f_lastUpdate,
				:f_packets,
				:f_volume,
				:f_interface);
	if (sqlca.sqlcode != 0) {//  && sqlca.sqlerrm.sqlerrml != 69) {
		syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into usage Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		return false;
	}
	EXEC SQL COMMIT;
	return true;
}

int	SQLGetDNS(string resolvedName, const struct in_addr& ip)
{
	int		retCode= 0;
	EXEC SQL BEGIN DECLARE SECTION;
	int 	f_serial;
	char	f_hostname[512];
	char	f_ip_address[16];

	const char	*q_hostname;
	const char	*q_ip_address;
	EXEC SQL END DECLARE SECTION;

	q_hostname = resolvedName.c_str();
	q_ip_address = inet_ntoa(ip);



	for (;;) {
		EXEC SQL BEGIN;
		EXEC SQL SELECT serial, hostname, ip
				INTO :f_serial, :f_hostname, :f_ip_address
				FROM dnsentry 
				WHERE hostname = :q_hostname AND ip = :q_ip_address;
		
		if (sqlca.sqlcode == 0) {
			retCode = f_serial;
			break;
		} else if (sqlca.sqlcode != ECPG_NOT_FOUND) {
			syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "select from dnsentry Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
			EXEC SQL ROLLBACK;
			break;
		} else {
			EXEC SQL INSERT INTO dnsentry  (hostname, ip)
					VALUES (:q_hostname, :q_ip_address);

			if (sqlca.sqlcode != 0) {
				syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into dnsentry Error %d message '%s'",
						sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
				return 0;
			}
			// continue on to do select to get serial and return it.
		}
		EXEC SQL COMMIT;
	}
	return retCode;
}

