/*
 * marshall.c,v 1.1 2003/07/17 14:10:45 myui Exp
 *
 * [Caution!]
 * 	This function is a prototype and yet beta stage, additinal.
 * Should not use with serious matters.
 * 
 * ----------------------
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 * 	  products derived from this software without specific prior written
 *    permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License (see COPYING.GPL), in which case the provisions 
 * of the GPL are required INSTEAD OF the above restrictions.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
 
//#define __DEBUG__

#include <stdlib.h>				/* malloc() */
#include <string.h>				/* strcmp() */
//#include <glib.h>				/* glib */
#include <libxml/tree.h>		/* libxml */
#include "stack/stack.h"		/* stack */

#include "postgres.h"
#include "fmgr.h"
#include "executor/spi.h"
#include "lib/stringinfo.h"		/* for makeStringInfo() */

#define KIND_ROOT       0
#define KIND_ELEMENT    1
#define KIND_TEXT       2
#define KIND_COMMENT    3
#define KIND_PI         4
#define KIND_ATTRIBUTE  5
#define KIND_NAMESPACE  6
#define KIND_DUMMY		-1

#define DEFAULT_CHARSET "EUC-JP"

#define _SPI_CONN() connected=(SPI_connect()==SPI_ERROR_CONNECT)
#define _SPI_FIN() if(!connected)SPI_finish()

#define XPFREE(P)	if(P!=NULL) pfree(P);

int exec_query(char *);
Datum toxml(PG_FUNCTION_ARGS);

typedef enum
{
	FIRSTCHILD,		// 0
    NEXTSIBLING,	// 1
	NEXTNODE,		// 2
	DUALNODE		// 3
} evalMethod;

//char *retCharSet;

/**
 * exec_query
 *		-- internal function
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
int
exec_query(char *query)
{
	int ret;

#ifdef __DEBUG__
	elog(NOTICE, "Query:%s", query);
#endif
	if ((ret = SPI_exec(query, 0)) < 0) {
		switch (ret) {
		  case -1:
			  elog(ERROR, "[SPI_ERROR_CONNECT] %s", query);break;
		  case -2:
			  elog(ERROR, "[SPI_ERROR_COPY] %s", query);break;
		  case -3:
			  elog(ERROR, "[SPI_ERROR_OPUNKNOWN] %s", query);break;
		  case -4:
			  elog(ERROR, "[SPI_ERROR_UNCONNECTED] %s", query);break;
		  case -5:
			  elog(ERROR, "[SPI_ERROR_CURSOR] %s", query);break;
		  case -6:
			  elog(ERROR, "[SPI_ERROR_ARGUMENT] %s", query);break;
		  case -7:
			  elog(ERROR, "[SPI_ERROR_PARAM] %s", query);break;
		  case -8:
			  elog(ERROR, "[SPI_ERROR_TRANSACTION] %s", query);break;
		  case -9:
			  elog(ERROR, "[SPI_ERROR_NOATTRIBUTE] %s", query);break;
		  case -10:
			  elog(ERROR, "[SPI_ERROR_NOOUTFUNC] %s", query);break;
		  case -11:
			  elog(ERROR, "[SPI_ERROR_TYPUNKNOWN] %s", query);break;
		  default:
			  elog(ERROR, "[SPI_ERROR_OTHER] %s", query);
		}
	}
#ifdef __DEBUG__
	elog(NOTICE, "[Result:%d]", ret);
#endif

	return ret;
}

PG_FUNCTION_INFO_V1(toxml);
Datum
toxml(PG_FUNCTION_ARGS)
{
   	int32 node_id = PG_GETARG_INT32(0);
    char *buf;
    char *res;
    char *child, *next, *name, *value;
    int kind;
	int i;
	int proc; 	/* for spi */
	int size;
    evalMethod eval=DUALNODE;
    evalMethod preEval=DUALNODE;
    /* Stack */
	Stack *ST_nextnode;
    /* libxml2 */
    xmlDocPtr doc;
    xmlNodePtr tree=NULL;
    xmlNodePtr subtree=NULL;
    xmlNodePtr ST_tree;
	/* result */
	text *result;
	StringInfo str = makeStringInfo();
	bool connected;
	char *retCharSet;
	
	if (fcinfo->nargs > 1)
		retCharSet = DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	else
		retCharSet = DEFAULT_CHARSET;			
	
	_SPI_CONN();
	
	/* select node-flagment */
	appendStringInfo(str,
				"SELECT "
				    "xn2.id,"						// 1 - nodeid
				    "xn2.kind,"						// 2 - kind
				    "xn2.parent,"					// 3 - parent
				    "xn2.child,"					// 4 - child
				    "xn2.next,"						// 5 - next
				    "convert(Q.name,'UTF-8'),"		// 6 - name
				    "convert(xn2.value,'UTF-8') "	// 7 - value
				"FROM "
				    "xml_node xn1,"
				    "xml_node xn2 left join (SELECT "
				                                "%d as kind,"
				                                "tagid,"
				                                "name "
				                            "FROM "
				                                "xml_tag "
				                            "UNION ALL "
				                            "SELECT "
				                                "%d as kind,"
				                                "tagid,"
				                                "name "
				                            "FROM "
				                                "xml_attribute "
				                            "UNION ALL "
				                            "SELECT "
				                                "%d as kind,"
				                                "tagid,"
				                                "name "
				                            "FROM "
				                                "xml_namespace "
				                            "UNION ALL "
				                            "SELECT "
				                                "%d as kind,"
				                                "tagid,"
				                                "name "
				                            "FROM "
				                                "xml_pi "
				                            ") as Q "
				                        "on xn2.tagid = Q.tagid and xn2.kind = Q.kind "
				"WHERE "
				    "xn1.id = %d AND "
				    "_int_flagment(xn2.dewey,xn1.dewey) "
				"ORDER BY "
				    "xn2.dewey",
				KIND_ELEMENT,KIND_ATTRIBUTE,KIND_NAMESPACE,KIND_PI,node_id
			);
	// to be fixed to use cursor..
	exec_query(str->data);
#ifdef __DEBUG__
	elog(NOTICE,"%s",str->data);
#endif
	XPFREE(str->data);
		
	//pfree(node_id);

	if((proc=SPI_processed)<0)
	{
        SPI_finish();
		elog(ERROR, "toXML: SPI_connect returned");
	}

	/* prepare create document */
	doc = xmlNewDoc("1.0");

    ST_nextnode = stack_create();

	for(i=0;i<proc;i++)
	{
		buf = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 2);
		kind = atoi(buf);
		XPFREE(buf);

		if(i==0)
		{
			switch(kind)
			{
				case KIND_ROOT:
				    tree = xmlNewDocNode(doc, NULL, "root", NULL);
					break;					
				case KIND_ELEMENT:
					name = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 6);
				    tree = xmlNewDocNode(doc, NULL, name, NULL);
                    XPFREE(name);
					break;
				case KIND_PI:
					name = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 6);
					value = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 7);
					initStringInfo(str);
					appendStringInfo(str,"<?%s %s?>",name,(value==NULL)? "" : value );
					/* return text */
					result = DatumGetTextP(DirectFunctionCall1(textin, 
															CStringGetDatum(str->data)));
					XPFREE(str->data);
					XPFREE(name);
					XPFREE(value);
					PG_RETURN_TEXT_P(result);
				case KIND_TEXT:
				case KIND_COMMENT:
					value = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 7);
					// return text
					result = DatumGetTextP(DirectFunctionCall1(textin, 
															CStringGetDatum(value)));
					XPFREE(value);
					PG_RETURN_TEXT_P(result);
				case KIND_ATTRIBUTE:
				case KIND_NAMESPACE:
					/**
					 * not yet supported ...
					 * return like aaa="hoge" or <result aaa="hoge"/> ?
					 **/
					SPI_finish();
					PG_RETURN_NULL();
					//break;
				default:
					buf=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
					elog(ERROR, "toXML: node %s --- Node-type is invalid",buf);
					XPFREE(buf);
					SPI_finish();
			}
			doc->children=tree;
		}
		else
		{
        	//node_id = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
        	//parent = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 3);

            if(eval==FIRSTCHILD)
            {
            	switch(kind)
            	{
					case KIND_ELEMENT:
                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                    	tree = xmlNewChild(tree, NULL, name, NULL);
                        XPFREE(name);
                    	break;
                    case KIND_PI:
                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                        subtree = xmlNewPI(name,value);
                        tree = xmlAddChild(tree,subtree);
                        XPFREE(name);
                        XPFREE(value);
                        break;
                    case KIND_TEXT:
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    	subtree = xmlNewText(value);
                        tree = xmlAddChild(tree,subtree);
                        XPFREE(value);
                    	break;
                    case KIND_COMMENT:
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    	subtree = xmlNewComment(value);
                        tree = xmlAddChild(tree,subtree);
                        //curNode = tree;
                        XPFREE(value);
                    	break;
					case KIND_ATTRIBUTE:
					case KIND_NAMESPACE:					
                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
						//initStringInfo(str);
						//appendStringInfo(str,"xmlns:%s",name);
						//buf = g_strdup_printf("xmlns:%s",prefix);
                        xmlSetProp(tree, name, value);
                        //g_free(buf);
                        XPFREE(name);
                        XPFREE(value);
                        eval = preEval;
                        continue;
					default:
						buf=SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 1);
						elog(ERROR, "toXML: node %s --- Node-type is invalid",buf);
						XPFREE(buf);
						SPI_finish();
                }
            }
            else if(eval==NEXTSIBLING)
            {
            	if(kind==KIND_ATTRIBUTE || kind==KIND_NAMESPACE)
            	{
                	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    xmlSetProp(tree, name, value);
                    XPFREE(name);
                    XPFREE(value);
                    eval = preEval;
                    continue;
            	}
            	
            	switch(kind)
            	{
					case KIND_ELEMENT:
                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                        subtree = xmlNewNode (NULL,name);
                        XPFREE(name);
                    	break;
                    case KIND_PI:
                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                        subtree = xmlNewPI(name,value);
                        XPFREE(name);
                        XPFREE(value);
                        break;
                    case KIND_TEXT:
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    	subtree = xmlNewText(value);
                        XPFREE(value);
                    	break;
                    case KIND_COMMENT:
                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    	subtree = xmlNewComment(value);
                        XPFREE(value);
                    	break;
					default:
						buf=SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 1);
						elog(ERROR, "toXML: node %s --- Node-type is invalid",buf);
						XPFREE(buf);
						SPI_finish();
                }

                tree = xmlAddSibling(tree,subtree);
            }
            else if(eval==NEXTNODE)
            {
            	if(kind==KIND_ATTRIBUTE || kind==KIND_NAMESPACE)
            	{
                	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
                	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
                    xmlSetProp(tree, name, value);
                    XPFREE(name);
                    XPFREE(value);
                    eval = preEval;
                    continue;
            	}
            	
                if(ST_nextnode->used > 0)
                {
	            	ST_tree =  stack_pop(ST_nextnode);

	            	switch(kind)
	            	{
						case KIND_ELEMENT:
	                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
	                        subtree = xmlNewNode (NULL,name);
	                        XPFREE(name);
	                    	break;
	                    case KIND_PI:
	                    	name = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 6);
	                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
	                        subtree = xmlNewPI(name,value);
	                        XPFREE(name);
	                        XPFREE(value);
	                        break;
	                    case KIND_TEXT:
	                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
	                    	subtree = xmlNewText(value);
	                        //XPFREE(value);
	                    	break;
	                    case KIND_COMMENT:
	                    	value = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 7);
	                    	subtree = xmlNewComment(value);
	                        XPFREE(value);
	                    	break;
						default:
							buf=SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 1);
							elog(ERROR, "toXML: node %s --- Node-type is invalid",buf);
							XPFREE(buf);
							SPI_finish();
	                }
	                
	                tree = xmlAddSibling(ST_tree,subtree);
                }
            }
		}

		/* prepare for tree moving */
		next = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 5);

		if((child = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 4)) != NULL)
		{
            eval = FIRSTCHILD;
        }
		else if(next != NULL)
		{
			eval = NEXTSIBLING;
		}
        else
        {
			eval = NEXTNODE;
		}

		preEval = eval;

		/* push NEXTNODE-stack */
		if(eval==FIRSTCHILD && next != NULL)
		{
#ifdef __DEBUG__
			elog(NOTICE,"stack trace\n%p\n",&(*tree));
#endif
			stack_push_pointer(ST_nextnode, &(*tree));
		}

		// for loop
		XPFREE(child);
		XPFREE(next);

#ifdef __DEBUG__
        xmlDocDumpMemoryEnc(doc,(xmlChar **)&res,&size,retCharSet);
        elog(NOTICE,"Doc ---\n%s\n",res);
#endif //__DEBUG__

    }

	/* clean up */
	_SPI_FIN();
	stack_destroy(ST_nextnode);
	xmlDocDumpMemoryEnc(doc,(xmlChar **)&res,&size,retCharSet);
	xmlFreeDoc(doc);

	result = DatumGetTextP(DirectFunctionCall1(textin, CStringGetDatum(res)));
	if(res!=NULL) free(res);
	if (fcinfo->nargs == 2) XPFREE(retCharSet);
	PG_RETURN_TEXT_P(result);
}

