/**
 - _int_add.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 */

--
-- Create Function of Int4 arrays for XPath
--

-- Adjust this setting to control where the operators, functions, and
-- opclasses get created.
SET search_path = public;
SET autocommit TO 'on';

-- _int_child
--DROP FUNCTION _int_child(_int4, _int4);

CREATE or REPLACE FUNCTION _int_child(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_child(_int4, _int4) IS 'child';

-- _int_descendant
--DROP FUNCTION _int_descendant(_int4, _int4);
CREATE or REPLACE FUNCTION _int_descendant(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_descendant(_int4, _int4) IS 'descendant';

-- _int_descendant-or-self
--DROP FUNCTION _int_descendant_or_self(_int4, _int4);

CREATE or REPLACE FUNCTION _int_descendant_or_self(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_descendant_or_self(_int4, _int4) IS 'descendant-or-self';

-- _int_following_sibling
--DROP FUNCTION _int_following_sibling(_int4, _int4);

CREATE or REPLACE FUNCTION _int_following_sibling(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_following_sibling(_int4, _int4) IS 'following-sibling';

-- _int_following
--DROP FUNCTION _int_following(_int4, _int4);

CREATE or REPLACE FUNCTION _int_following(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_following(_int4, _int4) IS 'following';

-- _int_parent
--DROP FUNCTION _int_parent(_int4, _int4);

CREATE or REPLACE FUNCTION _int_parent(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_parent(_int4, _int4) IS 'parent';

-- _int_ancestor
--DROP FUNCTION _int_ancestor(_int4, _int4);

CREATE or REPLACE FUNCTION _int_ancestor(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ancestor(_int4, _int4) IS 'ancestor';

-- _int_ancestor-or-self
--DROP FUNCTION _int_ancestor_or_self(_int4, _int4);

CREATE or REPLACE FUNCTION _int_ancestor_or_self(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ancestor_or_self(_int4, _int4) IS 'ancestor-or-self';

-- _int_preceding
--DROP FUNCTION _int_preceding(_int4, _int4);

CREATE or REPLACE FUNCTION _int_preceding(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_preceding(_int4, _int4) IS 'preceding';

-- _int_preceding_sibling
--DROP FUNCTION _int_preceding_sibling(_int4, _int4);

CREATE or REPLACE FUNCTION _int_preceding_sibling(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_preceding_sibling(_int4, _int4) IS 'preceding-sibling';

/*

create database test_axis1;

create table test1(
	"order" _int4
);

insert into test1("order") values('{-1}');
insert into test1("order") values('{-1,3,4}');
insert into test1("order") values('{0,3}');
insert into test1("order") values('{0,3,1}');
insert into test1("order") values('{0,3,2}');
insert into test1("order") values('{0,3,3}');
insert into test1("order") values('{0,3,1,1}');
insert into test1("order") values('{0,3,1,2}');
insert into test1("order") values('{0,3,1,1,1}');
insert into test1("order") values('{0}');
insert into test1("order") values('{0,1}');
insert into test1("order") values('{0,1,1}');
insert into test1("order") values('{0,1,2}');
insert into test1("order") values('{0,1,3}');
insert into test1("order") values('{0,1,3,1}');
insert into test1("order") values('{0,1,2,0}');
insert into test1("order") values('{0,1,2,1}');
insert into test1("order") values('{0,1,2,2}');
insert into test1("order") values('{0,1,2,1,0}');
insert into test1("order") values('{0,1,2,1,1}');
insert into test1("order") values('{0,1,2,1,2}');
insert into test1("order") values('{0,1,2,1,3}');
insert into test1("order") values('{0,1,2,2,2}');
insert into test1("order") values('{0,2}');
insert into test1("order") values('{0,2,1}');
insert into test1("order") values('{0,2,2}');
insert into test1("order") values('{0,2,3}');
insert into test1("order") values('{0,2,1,1}');
insert into test1("order") values('{0,2,1,2}');
insert into test1("order") values('{0,2,1,1,1}');
insert into test1("order") values('{0,3,1,1,1}');


order
{-1}
{-1,3,4}
{0}
{0}
{0,1}
{0,1,1}
{0,1,2}
{0,1,2,0}
{0,1,2,1}
{0,1,2,1,0}
{0,1,2,1,1}
{0,1,2,1,2}
{0,1,2,1,3}
{0,1,2,2}
{0,1,2,2,2}
{0,1,3}
{0,1,3,1}
{0,2}
{0,2,1}
{0,2,1,1}
{0,2,1,1,1}
{0,2,1,2}
{0,2,2}
{0,2,3}
{0,3}
{0,3}
{0,3,1}
{0,3,1}
{0,3,1,1}
{0,3,1,1}
{0,3,1,1,1}
{0,3,1,1,1}
{0,3,1,1,1}
{0,3,1,2}
{0,3,1,2}
{0,3,2}
{0,3,2}
{0,3,3}
{0,3,3}

select * from test1 where _int_child("order",'{0,1,2}');
select * from test1 where _int_descendant("order",'{0,1,2}');
select * from test1 where _int_descendant_or_self("order",'{0,1,2}');
select * from test1 where _int_following_sibling("order",'{0,1,2,1,1}');
select * from test1 where _int_following("order",'{0,1,2,1}');
select * from test1 where _int_parent("order",'{0,1,2,1}');
select * from test1 where _int_ancestor("order",'{0,1,2,1}');
select * from test1 where _int_ancestor_or_self("order",'{0,1,2,1}');
select * from test1 where _int_preceding("order",'{0,1,2,2}');
select * from test1 where _int_preceding_sibling("order",'{0,1,2,1,3}');

select * from test1 where _int_dependant("order",'{0,1,2}');
select "order",last("order") from test1;
select * from test1 where _int_ndim_eq("order",3,1);
select * from test1 where _int_ge("order",'{0,1,2}');
select * from test1 where _int_lt("order",'{0,1,2}');

-----------------------
truncate test1;

insert into test1("order") values('{1}');
insert into test1("order") values('{1,1}');
insert into test1("order") values('{1,2}');
insert into test1("order") values('{1,1,1}');
insert into test1("order") values('{1,1,2}');
insert into test1("order") values('{1,1,2,1}');
insert into test1("order") values('{1,1,3}');


-- after in document order
select * from test1 where _int_gt("order",'{1,1,2}');
select * from test1 where "order" > '{1,1,2}';

-- after or same in document order
select * from test1 where _int_ge("order",'{1,1,2}');
select * from test1 where "order" >= '{1,1,2}';

-- before in document order
select * from test1 where _int_lt("order",'{1,1,2}');
select * from test1 where "order" < '{1,1,2}';

-- before or same in document order
select * from test1 where _int_le("order",'{1,1,2}');
select * from test1 where "order" <= '{1,1,2}';

select * from test1 where "order" > '{0,2,2}' order by "order";
select * from test1 where "order" >= '{0,2,2}' order by "order";
select * from test1 where "order" < '{0,2,2}' order by "order";
select * from test1 where "order" <= '{0,2,2}' order by "order";

select _int_lt('{0,3,1}','{0,3}')
SELECT
    '{0,3,1}'::_int4 < '{0,3}'::_int4

select intarray_abs_cmp('{0,3}','{0,3,1}')
select intarray_abs_cmp('{0,3}','{0,3,1,5}')
select intarray_abs_cmp('{0,3}','{0,3}')
select intarray_abs_cmp('{0,3}','{0}')
select intarray_abs_cmp('{0,3}','{-1}')
select intarray_abs_cmp('{0,3}','{1}')
select intarray_abs_cmp('{0,3}','{1,3,1}')
select intarray_abs_cmp('{0,3}','{0,2}')
select intarray_abs_cmp('{0,3}','{0,4}')
select intarray_abs_cmp('{0,3}','{0,4,3}')
select intarray_abs_cmp('{0,3}','{100}')


SELECT "order" FROM test1 ORDER BY "order";
SELECT "order" FROM test1 ORDER BY "order" desc


-----------------------

drop table test1;
drop database test_axis1;

*/

-- last
--DROP FUNCTION last(_int4);

CREATE or REPLACE FUNCTION last(_int4) RETURNS int4
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION last(_int4) IS 'extract last value of int array';

-- nextSibling
CREATE or REPLACE FUNCTION nextSibling(_int4) RETURNS _int4
	AS '$libdir/_int', 'next_sibling' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION nextSibling(_int4) IS 'calculate next sibling';

-- previousSibling
CREATE or REPLACE FUNCTION previousSibling(_int4) RETURNS _int4
	AS '$libdir/_int', 'previous_sibling' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION previousSibling(_int4) IS 'calculate previous sibling';

-- _int_to_numstr
--DROP FUNCTION _int_to_numstr(_int4);

CREATE or REPLACE FUNCTION _int_to_numstr(_int4) RETURNS text
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_to_numstr(_int4) IS '_int4 to num_string';

-- _int_dependant
--DROP FUNCTION _int_dependant(_int4, _int4);

CREATE or REPLACE FUNCTION _int_dependant(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_dependant(_int4, _int4) IS 'dependant';

-- _int_flagment
--DROP FUNCTION _int_flagment(_int4, _int4);

CREATE or REPLACE FUNCTION _int_flagment(_int4, _int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_flagment(_int4, _int4) IS 'flagment';

CREATE or REPLACE FUNCTION _int_vdim(_int4, int4) RETURNS INTEGER
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_vdim(_int4, int4) IS 'get nth value of int array';

-- _int_ndim_eq
--DROP FUNCTION _int_ndim_eq(_int4, int4, int4);

CREATE or REPLACE FUNCTION _int_ndim_eq(_int4, int4, int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ndim_eq(_int4, int4, int4) IS 'nth array equals';

---------------------------------------

-- _int_ge
-- DROP FUNCTION _int_ge(_int4,_int4);

CREATE or REPLACE FUNCTION _int_ge(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_ge(_int4,_int4) IS 'Is Greater or Equal in Document Order';

-- _int_gt
-- DROP FUNCTION _int_gt(_int4,_int4);

CREATE or REPLACE FUNCTION _int_gt(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_gt(_int4,_int4) IS 'Is Greater in Document Order';

-- _int_lt
-- DROP FUNCTION _int_le(_int4,_int4);

CREATE or REPLACE FUNCTION _int_le(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_le(_int4,_int4) IS 'Is Less or Equal in Document Order';

-- _int_le
-- DROP FUNCTION _int_lt(_int4,_int4);

CREATE or REPLACE FUNCTION _int_lt(_int4,_int4) RETURNS bool
	AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

COMMENT ON FUNCTION _int_lt(_int4,_int4) IS 'Is Less in Document Order';

-- create the support function too
CREATE or REPLACE FUNCTION intarray_abs_cmp(_int4, _int4) RETURNS INTEGER
   AS '$libdir/_int' LANGUAGE 'c' IMMUTABLE STRICT;

---------------------------

DROP OPERATOR < (_int4, _int4);
CREATE OPERATOR < (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_lt,
	COMMUTATOR = '>', NEGATOR = '>=',
	RESTRICT = scalarltsel, JOIN = scalarltjoinsel
);

DROP OPERATOR <= (_int4, _int4);
CREATE OPERATOR <= (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_le,
	COMMUTATOR = '>=', NEGATOR = '>',
	RESTRICT = scalarltsel, JOIN = scalarltjoinsel
);

DROP OPERATOR >= (_int4, _int4);
CREATE OPERATOR >= (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_ge,
	COMMUTATOR = '<=', NEGATOR = '<',
	RESTRICT = scalargtsel, JOIN = scalargtjoinsel
);

DROP OPERATOR > (_int4, _int4);
CREATE OPERATOR > (
	LEFTARG = _int4, RIGHTARG = _int4, PROCEDURE = _int_gt,
	COMMUTATOR = '<', NEGATOR = '<=',
	RESTRICT = scalargtsel, JOIN = scalargtjoinsel
);

-----------------------------------------------

-- now we can make the operator class
CREATE OPERATOR CLASS intarray_abs_ops
    DEFAULT FOR TYPE _int4 USING btree AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       intarray_abs_cmp(_int4, _int4);

/*
CREATE INDEX xml_ndoe_dewey ON xml_node
   USING btree(dewey intarray_abs_ops);
*/

-- vacuum analyze;