#!/bin/bash

# check user
if [ `id -u` -ne 0 ];then
        echo 'This command in only executed by root'
    exit 1
fi

echo
echo "Please specify version number of the package."
read VERSION

if [ -z "$VERSION" ]
then
    echo "[ERROR] version number is not specified!"
    echo
    exit 1
fi

echo
echo "Making distribution.."
echo

find . -name "*~" -type f -print | xargs rm -rf 
find . -name "CVS" -type d -print | xargs rm -rf
find . -name "*.o" -type f -print | xargs rm -rf
find . -name "*.so.?*" -type f -print | xargs rm -rf
find . -name ".*" -type f -print | xargs rm -rf

find . -name "*.sh" -print | xargs chmod +x

rm -rf xpsql*.tar.gz

DISTDIR=`pwd | xargs basename`
cd ..
tar czf ./${DISTDIR}/xpsql-${VERSION}.tar.gz ./${DISTDIR}

echo "package xpsql-${VERSION}.tar.gz is created."
echo
sleep 1
echo "done!"
echo
