/**
 - xpsql.h,v 1.1 2003/07/17 14:10:45 myui Exp
 */

#ifndef __XPSQL__
#define __XPSQL__

#include "postgres.h"            /* for DatumGetInt32 */
#include "fmgr.h"                /* for PG_GETARG_DATUM */

// NODE-TYPE and NUMBER BINDING
#define KIND_ROOT       0
#define KIND_ELEMENT    1
#define KIND_TEXT       2
#define KIND_COMMENT    3
#define KIND_PI         4
#define KIND_ATTRIBUTE  5
#define KIND_NAMESPACE  6
#define KIND_DUMMY        -1

// xpsql Revision Code
#define __XPSQL_REVISION__ "0.9"

/* Initial buffer size is setted to 8K(8092) byte */
#define XBUFSIZE 8192

#define SUCCESS (0==0)
#define FAILURE (0!=0)
#define SQL_QUERY_SUCCESS  0
#define SQL_QUERY_FAILURE -1

#define GET_STR(vcharp) DatumGetCString(DirectFunctionCall1(varcharout, PointerGetDatum(vcharp)))

int exec_query(char *);
int execp_query(char *, int, Oid *, Datum *, char *);
static int va_exec_query(char *query_str, ...);
Datum h_replace(PG_FUNCTION_ARGS);
Datum xml_tagid(PG_FUNCTION_ARGS);
Datum xml_attid(PG_FUNCTION_ARGS);
Datum xml_nsid(PG_FUNCTION_ARGS);
Datum xml_piid(PG_FUNCTION_ARGS);
Datum get_tagid(PG_FUNCTION_ARGS);
Datum get_attid(PG_FUNCTION_ARGS);
Datum get_nsid(PG_FUNCTION_ARGS);
Datum get_piid(PG_FUNCTION_ARGS);
Datum addchildelement(PG_FUNCTION_ARGS);
Datum addchildpi(PG_FUNCTION_ARGS);
Datum addchildtext(PG_FUNCTION_ARGS);
Datum addchildcomment(PG_FUNCTION_ARGS);
Datum setattribute(PG_FUNCTION_ARGS);
Datum setnamespace(PG_FUNCTION_ARGS);
Datum appendchild(PG_FUNCTION_ARGS);
Datum insertbefore(PG_FUNCTION_ARGS);
Datum stringvalue(PG_FUNCTION_ARGS);
Datum toxml(PG_FUNCTION_ARGS);
Datum trg_xorder(PG_FUNCTION_ARGS);

typedef struct
{
    char *ident;    // identifier
    void *splan;    // entity
} EPlan;

/* select plan */
static EPlan *sPlans = NULL;        // array of plans
static int    n_sPlans = 0;         // count plans

static EPlan *find_plan(char *, EPlan **, int *);
static void create_plan(EPlan **, char *, int, Oid *);

#ifdef _Bool
#define bool _Bool
#else
#ifndef C_H
typedef char bool;
#endif//C_H
#endif//_Bool

#endif/* __XPSQL__ */
