#!/usr/sbin/dtrace -qs

/*
 * Usage      : txn_time.d <pid>
 * Description: Measure processing time for each transaction
 * Author     : Robert Lor
 */

BEGIN
{

	endtime = timestamp + (5 * 1000000000ull);
}

postgresql$1:::transaction-start
{
	self->ts  = timestamp;
}

postgresql$1:::transaction-commit
/self->ts/
{
	@commit[arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

postgresql$1:::transaction-abort
/self->ts/
{
	@abort[arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

END
{
        printf("********** Committed Transactions **********");
        printf("\n%15s %15s\n","Tx Id", "Time (ns)");
        printa("%15d %@15d\n",@commit);
        printf("\n********** Aborted Transactions **********");
        printf("\n%15s %15s\n","Tx Id", "Time (ns)");
        printa("%15d %@15d\n",@abort);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
        exit(0);
}
