#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Inventory invoicing module
#
#======================================================================

package IS;


sub new {
  my ($type, $countrycode) = @_;

  $self = {};

  if ($countrycode) {
    if (-f "locale/$countrycode/Num2text") {
      require "locale/$countrycode/Num2text";
    } else {
      use SL::Num2text;
    }
  } else {
    use SL::Num2text;
  }

  bless $self, $type;

}


sub invoice_details {
  my ($self, $myconfig, $form) = @_;

  $form->{duedate} = $form->{invdate} unless ($form->{duedate});

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT date '$form->{duedate}' - date '$form->{invdate}'
                 AS duedate
		 FROM defaults|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

 # if(!$form->{terms}){
	  ($form->{terms}) = $sth->fetchrow_array;
 # }
  $sth->finish;
  $dbh->disconnect;

  my $tax = 0;

  foreach my $i (1 .. $form->{rowcount}) {
    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});

    if ($form->{"qty_$i"} != 0) {

      # add number, description and qty to $form->{number}, ....
      push(@{ $form->{runningnumber} }, $i);
      push(@{ $form->{number} }, qq|$form->{"partnumber_$i"}|);
      push(@{ $form->{bin} }, qq|$form->{"bin_$i"}|);
      push(@{ $form->{description} }, qq|$form->{"description_$i"}|);
      push(@{ $form->{qty} }, $form->format_amount($myconfig, $form->{"qty_$i"}));
      push(@{ $form->{unit} }, qq|$form->{"unit_$i"}|);


      push(@{ $form->{sellprice} }, $form->{"sellprice_$i"});
      push(@{ $form->{lastcost} }, $form->format_amount(\%myconfig,($form->{"lastcost_$i"}), 2));

      # listprice
      push(@{ $form->{listprice} }, $form->{"listprice_$i"});
      push(@{ $form->{partnotes} }, $form->{"partnotes_$i"});
#$form->dberror($form->{partnotes});
      push(@{ $form->{part_ordnumber} }, $form->{"part_ordnumber_$i"});
      push(@{ $form->{ord_parts_id} }, $form->{"ord_parts_id_$i"});
      push(@{ $form->{ord_parts_qty} }, $form->{"ord_parts_qty_$i"});
      push(@{ $form->{last_parts_qty} }, $form->{"last_parts_qty_$i"});
      push(@{ $form->{po_details} }, $form->{"po_details_$i"});
      push(@{ $form->{partnumber} }, $form->{"partnumber_$i"});
      push(@{ $form->{delivery_date} }, $form->{"delivery_date_$i"});
      push(@{ $form->{remark2} }, $form->{"remark2_$i"});

      my $sellprice = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      my ($dec) = ($sellprice =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;

      my $discount = $form->round_amount($sellprice * $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100, $decimalplaces);

      # keep a netprice as well, (sellprice - discount)
      $form->{"netprice_$i"} = $sellprice - $discount;
      push(@{ $form->{netprice} }, ($form->{"netprice_$i"} != 0) ? $form->format_amount($myconfig, $form->{"netprice_$i"}, $decimalplaces) : " ");


      my $linetotal = $form->round_amount($form->{"qty_$i"} * $form->{"netprice_$i"}, 2);

      $discount = ($discount != 0) ? $form->format_amount($myconfig, $discount * -1, $decimalplaces) : " ";
      $linetotal = ($linetotal != 0) ? $linetotal : " ";

      push(@{ $form->{discount} }, $discount);

      $form->{total} += $linetotal;

      push(@{ $form->{linetotal} }, $form->format_amount($myconfig, $linetotal, 2));

      my $taxrate = 0;
      my ($taxamount, $taxbase) = (0,0);

      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      if ($form->{taxincluded}) {
	# calculate tax
	$taxamount = $linetotal * ($taxrate / (1 + $taxrate));
	$taxbase = $linetotal - $taxamount;
      } else {
        $taxamount = $linetotal * $taxrate;
	$taxbase = $linetotal;
      }

      if ($taxamount != 0) {
	foreach my $item (split / /, $form->{"taxaccounts_$i"}) {
	  $taxaccounts{$item} += $taxamount * $form->{"${item}_rate"} / $taxrate;
	  $taxbase{$item} += $taxbase;
	}
      }
    }
  }


  foreach my $item (sort keys %taxaccounts) {
    if ($form->round_amount($taxaccounts{$item}, 2) != 0) {
      push(@{ $form->{taxbase} }, $form->format_amount($myconfig, $taxbase{$item}, 2));
      $tax += $taxamount = $form->round_amount($taxaccounts{$item}, 2);
      push(@{ $form->{tax} }, $form->format_amount($myconfig, $taxamount));
      push(@{ $form->{taxdescription} }, $form->{"${item}_description"});
      push(@{ $form->{taxrate} }, $form->format_amount($myconfig, $form->{"${item}_rate"} * 100));
      push(@{ $form->{taxnumber} }, $form->{"${item}_taxnumber"});
    }
  }


  for my $i (1 .. $form->{paidaccounts}) {
    $form->{paid} += $form->parse_amount($myconfig, $form->{"paid_$i"});
  }

  $form->{subtotal} = $form->format_amount($myconfig, $form->{total}, 2);
  $tax = 0 if $form->{taxincluded};
  $form->{invtotal} = $form->{total} + $tax;
  $form->{total} = $form->format_amount($myconfig, $form->{invtotal} - $form->{paid}, 2, "-");
  $form->{invtotal} = $form->format_amount($myconfig, $form->{invtotal}, 2, "-");

  $form->{paid} = $form->format_amount($myconfig, $form->{paid}, 2);

  # myconfig variables
  map { $form->{$_} = $myconfig->{$_} } (qw(company address tel fax signature businessnumber));
  $form->{username} = $myconfig->{name};

}


sub customer_details {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|SELECT customernumber, name, addr1, addr2, addr3, addr4,
	         phone as customerphone, fax as customerfax, contact,
                 shiptoname, shiptoaddr1, shiptoaddr2, shiptoaddr3, shiptoaddr4,
		 shiptocontact, shiptophone, shiptofax,terms as terms11
	         FROM customer
	         WHERE id = $form->{customer_id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}
sub last_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|select lastinvnumber from (SELECT id,invnumber as lastinvnumber
	         FROM ar 
	         WHERE invoice='t' and transtype='$form->{transtype}' order by id desc limit 2) as foo order by id DESC|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
# $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}

sub post_invoice {
  my ($self, $myconfig, $form) = @_;
 #$form->{transno} +=1;

  # connect to database, turn off autocommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $sth, $uid, $null);
  my $exchangerate = 0;

  if ($form->{id}) {

    &reverse_invoice($dbh, $form,$myconfig->{dbname});

  } else {
    # create AR entry
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO ar (invnumber, employee_id)
                VALUES ('$uid', (SELECT id FROM employee
		                 WHERE login = '$form->{login}') )|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    # retrieve id
    $query = qq|SELECT id FROM ar WHERE invnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
  }


  map { $form->{$_} =~ s/'/\\'/g } (qw(invnumber shippingpoint notes));

  my ($netamount, $invoicediff) = (0, 0);
  my ($amount, $linetotal, $lastincomeaccno);

  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, 'buy');
  }

  $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});
  
  foreach my $i (1 .. $form->{rowcount}) {
    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});
    
    if ($form->{"qty_$i"} != 0) {

      map { $form->{"${_}_$i"} =~ s/'/\\'/g } (qw(partnumber description unit));
      
      # undo discount formatting
      $form->{"discount_$i"} = $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100;

      $form->{"inventory_accno_$i"} *= 1;
      $form->{"expense_accno_$i"} *= 1;
     
      my ($allocated, $taxrate) = (0, 0);
      my $taxamount;
      
      # keep entered selling price
      my $fxsellprice = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      
      my ($dec) = ($fxsellprice =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;
      
      # deduct discount
      my $discount = $form->round_amount($fxsellprice * $form->{"discount_$i"}, $decimalplaces);
      $form->{"sellprice_$i"} = $fxsellprice - $discount;
      
      # add tax rates
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      # round linetotal to 2 decimal places
      $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2);
      
      
      
      
      
      
      
      
      
 if ($form->{"taxincluded_$i"}) {
#     map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};
#	$tax = $linetotal * ($taxrate / (1 + $taxrate)) *-1;
#	$linetotal+=$tax;
#	$taxtotal=$linetotal;
	
	
	$taxamount = $linetotal * ($taxrate / (1 + $taxrate));
	$form->{"sellprice_$i"} = $form->{"sellprice_$i"} * (1 / (1 + $taxrate));
	$taxtotal+=$linetotal;
	$linetotal=$linetotal-$taxamount;
	
      } else {
	$taxamount = $linetotal * $taxrate;
      $taxtotal +=$linetotal+$taxamount;
     }

      $netamount += $linetotal;
      
      if ($taxamount != 0) {
	map { $form->{amount}{$form->{id}}{$_} += $taxamount * $form->{"${_}_rate"} / $taxrate } split / /, $form->{"taxaccounts_$i"};
      }
    
    
      # add amount to income, $form->{amount}{trans_id}{accno}
      $amount = $form->{"sellprice_$i"} * $form->{"qty_$i"} * $form->{exchangerate};
      
      $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2) * $form->{exchangerate};
      $linetotal = $form->round_amount($linetotal, 2);
      
      # this is the difference from the inventory
      $invoicediff += ($amount - $linetotal);
		      
      $form->{amount}{$form->{id}}{$form->{"income_accno_$i"}} += $linetotal;
      
      $lastincomeaccno = $form->{"income_accno_$i"};
      

      # adjust and round sellprice
      $form->{"sellprice_$i"} = $form->round_amount($form->{"sellprice_$i"} * $form->{exchangerate}, $decimalplaces);
      
      if ($form->{"inventory_accno_$i"} || $form->{"assembly_$i"}) {
        # adjust parts onhand quantity, this should go into a trigger
	$form->update_balance($dbh,
			      "parts",
			      "onhand",
			      qq|id = $form->{"id_$i"}|,
			      $form->{"qty_$i"} * -1);
     
        if ($form->{"assembly_$i"}) {
	  # record assembly item as allocated
	  &process_assembly($dbh, $form, $form->{"id_$i"}, $form->{"qty_$i"});
	} else {
	  $allocated = &cogs($dbh, $form, $form->{"id_$i"}, $form->{"qty_$i"});
	}
      }
 $lastcost=$form->round_amount($form->{"lastcost_$i"} , 4);
    $form->{"taxincluded_$i"} *= 1;
  
      # save detail record in invoice table
      $query = qq|INSERT INTO invoice (trans_id, parts_id, description, qty,
                  sellprice, fxsellprice, discount, allocated, assemblyitem,
		  unit,delivery_date ,remark2,part_ordnumber,lastcost,taxincluded,tax)
		  VALUES ($form->{id}, $form->{"id_$i"},
		  '$form->{"description_$i"}', $form->{"qty_$i"},
		  $form->{"sellprice_$i"}, $fxsellprice,
		  $form->{"discount_$i"}, $allocated, 'f',
		  '$form->{"unit_$i"}','$form->{"delivery_date_$i"}','$form->{"remark2_$i"}','$form->{"part_ordnumber_$i"}',$lastcost,'$form->{"taxincluded_$i"}',$taxamount)|;
		#  $form->dberror($query);
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

   ($ttype, $ordnumber) = split /:/, $form->{"part_ordnumber_$i"};
     	$form->update_field($dbh,
			      "oe",
			      "status",
			      qq|transtype= '$ttype' and ordnumber = '$ordnumber'|,
			      2);

      
    }
  }


  my ($tax, $paiddiff) = (0, 0);
  
  $netamount = $form->round_amount($netamount, 2);
 
  
  #$form->dberror($taxtotal);
       # map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

	########newly add for better tax calculation
        if ($taxtotal != 0) {
	if( !$form->{taxincluded}){
	map { $form->{amount}{$form->{id}}{$_} = ($taxtotal) *  $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_vc"} ;
	}else{
	map { $form->{amount}{$form->{id}}{$_} = ($taxtotal) *  $form->{"${_}_rate"} / (1 + $form->{"${_}_rate"})} split / /, $form->{"taxaccounts_vc"} ;
	}
      }

  
  
  
  
  # figure out rounding errors for total amount vs netamount + taxes
 if ($form->{taxincluded}) {
    
    $amount = $form->round_amount($netamount * $form->{exchangerate}, 2);
    $paiddiff += $amount - $netamount * $form->{exchangerate};
    $netamount = $amount;
    
    foreach my $item (split / /, $form->{taxaccounts}) {
      $form->{amount}{$form->{id}}{$item} = $form->round_amount($form->{amount}{$form->{id}}{$item} * $form->{exchangerate}, 2);
      $amount = $form->round_amount($form->{amount}{$form->{id}}{$item}, 2);
      $tax += $amount;
#      $netamount -= $amount;
    }

    
    ####sales account 
    $invoicediff += $paiddiff;
    ######## this only applies to tax included
    if ($lastincomeaccno) {
      $form->{amount}{$form->{id}}{$lastincomeaccno} += $invoicediff;
    foreach my $item (split / /, $form->{taxaccounts_vc}) {
      $form->{amount}{$form->{id}}{$lastincomeaccno} -= $form->{amount}{$form->{id}}{$item};
     $tax -= $form->{amount}{$form->{id}}{$item};

    }      
    }

  } else {
    $amount = $form->round_amount($netamount * $form->{exchangerate}, 2);
    $paiddiff = $amount - $netamount * $form->{exchangerate};
    $netamount = $amount;
    foreach my $item (split / /, $form->{taxaccounts}) {
      $form->{amount}{$form->{id}}{$item} = $form->round_amount($form->{amount}{$form->{id}}{$item}, 2);
      $amount = $form->round_amount($form->{amount}{$form->{id}}{$item} * $form->{exchangerate}, 2);
      $paiddiff += $amount - $form->{amount}{$form->{id}}{$item} * $form->{exchangerate};
      $form->{amount}{$form->{id}}{$item} = $form->round_amount($amount, 2);
      $tax += $form->{amount}{$form->{id}}{$item};
    }
   

  }
  
  
  
  
  
  
#     $form->dberror($amount." ".$netamount);

    #for cash sales
   if($form->{subtype}){
	# $form->dberror($netamount);
	 $form->{paid_1}=$netamount+$tax;
	 $form->{AR_paid_1}=$form->{"AR_paid"}.'---';
	 $form->{datepaid_1}=$form->{"invdate"};
	 $form->{source_1}=$form->{"source"};
	    
 }
 
  $form->{datepaid} = $form->{invdate};
  
  # total payments, don't move we need it here
  for my $i (1 .. $form->{paidaccounts}) {
    $form->{"paid_$i"} = $form->parse_amount($myconfig, $form->{"paid_$i"});
    $form->{paid} += $form->{"paid_$i"};
    $form->{datepaid} = $form->{"datepaid_$i"} if ($form->{"datepaid_$i"});
  }
  
  
  $form->{amount}{$form->{id}}{$form->{AR}} = $netamount + $tax;

  if ($form->{paid} != 0) {
    $form->{paid} = $form->round_amount($form->{paid} * $form->{exchangerate} + $paiddiff, 2);
  }
  
  # reverse AR
  $form->{amount}{$form->{id}}{$form->{AR}} *= -1;


  # update exchangerate
  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    $form->update_exchangerate($dbh, $form->{currency}, $form->{invdate}, $form->{exchangerate}, 0);
  }
    
  foreach my $trans_id (keys %{$form->{amount}}) {
    foreach my $accno (keys %{ $form->{amount}{$trans_id} }) {
      if (($form->{amount}{$trans_id}{$accno} = $form->round_amount($form->{amount}{$trans_id}{$accno}, 2)) != 0) {
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
	            transdate,source,project,sub)
		    VALUES ($trans_id, (SELECT id FROM chart
		                        WHERE accno = '$accno'),
		    $form->{amount}{$trans_id}{$accno}, '$form->{invdate}','$form->{"source_$i"}','$form->{project}','$form->{subb}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }
    }
  }

  # deduct payment differences from paiddiff
  for my $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"} != 0) {
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{exchangerate}, 2);
      $paiddiff -= $amount - $form->{"paid_$i"} * $form->{exchangerate};
    }
  }


  # record payments and offsetting AR
  for my $i (1 .. $form->{paidaccounts}) {
    
    if ($form->{"paid_$i"} != 0) {
      my ($accno) = split /--/, $form->{"AR_paid_$i"};
      $form->{"datepaid_$i"} = $form->{invdate} unless ($form->{"datepaid_$i"});
      $form->{datepaid} = $form->{"datepaid_$i"};

      # record AR
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{exchangerate} + $paiddiff, 2);

      if ($form->{amount}{$form->{id}}{$form->{AR}} != 0) {
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
	            transdate,source,project,sub)
		    VALUES ($form->{id}, (SELECT id FROM chart
					WHERE accno = '$form->{AR}'),
		    $amount, '$form->{"datepaid_$i"}','$form->{"source_$i"}','$form->{project}','$form->{subb}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }

      # record payment
      $form->{"paid_$i"} *= -1;

      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
                  VALUES ($form->{id}, (SELECT id FROM chart
		                      WHERE accno = '$accno'),
		  $form->{"paid_$i"}, '$form->{"datepaid_$i"}',
		  '$form->{"source_$i"}','$form->{project}','$form->{subb}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

      
      $exchangerate = 0;

      if ($form->{currency} eq $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = 1;
      } else {
	$exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'buy');
	
	$form->{"exchangerate_$i"} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{"exchangerate_$i"});
      }
      
      
      # exchangerate difference
      $form->{fx}{$accno}{$form->{"datepaid_$i"}} += $form->{"paid_$i"} * ($form->{"exchangerate_$i"} - 1) + $paiddiff;


      # gain/loss
      $amount = $form->{"paid_$i"} * $form->{exchangerate} - $form->{"paid_$i"} * $form->{"exchangerate_$i"};
      if ($amount > 0) {
	$form->{fx}{$form->{fxgain_accno}}{$form->{"datepaid_$i"}} += $amount;
      } else {
	$form->{fx}{$form->{fxloss_accno}}{$form->{"datepaid_$i"}} += $amount;
      }

      $paiddiff = 0;

      # update exchange rate
      if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
	$form->update_exchangerate($dbh, $form->{currency}, $form->{"datepaid_$i"}, $form->{"exchangerate_$i"}, 0);
      }
    }
  }

  
  # record exchange rate differences and gains/losses
  foreach my $accno (keys %{$form->{fx}}) {
    foreach my $transdate (keys %{ $form->{fx}{$accno} }) {
      if (($form->{fx}{$accno}{$transdate} = $form->round_amount($form->{fx}{$accno}{$transdate}, 2)) != 0) {

	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
	            transdate, cleared, fx_transaction,project,sub)
		    VALUES ($form->{id},
		           (SELECT id FROM chart
		            WHERE accno = '$accno'),
		    $form->{fx}{$accno}{$transdate}, '$transdate', '1', '1','$form->{project}','$form->{subb}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }
    }
  }
 

  $amount = $netamount + $tax;
  
  # set values which could be empty to 0
  $form->{terms} *= 1;
  $form->{taxincluded} *= 1;
  my $datepaid = ($form->{paid}) ? qq|'$form->{datepaid}'| : "NULL";
  my $duedate = ($form->{duedate}) ? qq|'$form->{duedate}'| : "NULL";
  # fill in subject if there is none
  $form->{subject} = qq|$form->{label} $form->{invnumber}| unless $form->{subject};
  # if there is a message stuff it into the notes
  $form->{notes} .= qq|\r
\r
[email]\r
To: $form->{email}\r
Subject: $form->{subject}\r
\r
Message: $form->{message}\r| if $form->{message};

  # save AR record
  $query = qq|UPDATE ar set
              invnumber = '$form->{invnumber}',
	      ordnumber = '$form->{ordnumber}',
	      invoiceto = '$form->{invoiceto}',
              transdate = '$form->{invdate}',
              customer_id = $form->{customer_id},
              rowcount =$form->{rowcount}-1,
              amount = $amount,
              netamount = $netamount,
              paid = $form->{paid},
	      datepaid = $datepaid,
	      duedate = $duedate,
	      invoice = '1',
	      salesperson = '$form->{salesperson}',
	      shippingpoint = '$form->{shippingpoint}',
	      terms = $form->{terms},
	      notes = '$form->{notes}',
	      taxincluded = '$form->{taxincluded}',
	      transno = '$form->{transno}',
	      batch = '$form->{batch}',
	      transtype = '$form->{transtype}',
	      subtransno = '$form->{subtransno}',
	      project = '$form->{project}',
	      subb = '$form->{subb}',
	      curr = '$form->{currency}'
              WHERE id = $form->{id}
             |;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $rc = $dbh->commit;
  $dbh->disconnect;
$form->{transno}++;
 $form->{callback} .= "&invdate=$form->{invdate}&transtype=$form->{transtype}&batch=$form->{batch}&transno=$form->{transno}&subtransno=$form->{subtransno}";
  $rc;

}


sub process_assembly {
  my ($dbh, $form, $id, $totalqty) = @_;

  my $query = qq|SELECT a.parts_id, a.qty, p.assembly,
                 p.partnumber, p.description, p.unit,
                 p.inventory_accno_id, p.income_accno_id,
		 p.expense_accno_id
                 FROM assembly a, parts p
		 WHERE a.parts_id = p.id
		 AND a.id = $id|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    my $allocated = 0;
    
    $ref->{inventory_accno_id} *= 1;
    $ref->{expense_accno_id} *= 1;

    map { $ref->{$_} =~ s/'/\\'/g } (qw(partnumber description unit));
    
    # multiply by number of assemblies
    $ref->{qty} *= $totalqty;
    
    if ($ref->{assembly}) {
      &process_assembly($dbh, $form, $ref->{parts_id}, $ref->{qty});
      next;
    } else {
      if ($ref->{inventory_accno_id}) {
	$allocated = &cogs($dbh, $form, $ref->{parts_id}, $ref->{qty});
      }
    }

    # save detail record for individual assembly item in invoice table
    $query = qq|INSERT INTO invoice (trans_id, description, parts_id, qty,
                sellprice, fxsellprice, allocated, assemblyitem, unit)
		VALUES
		($form->{id}, '$ref->{description}',
		$ref->{parts_id}, $ref->{qty}, 0, 0, $allocated, 't',
		'$ref->{unit}')|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
	 
  }

  $sth->finish;

}


sub cogs {
  my ($dbh, $form, $id, $totalqty) = @_;
    
  #my $query = qq|SELECT i.id, i.qty, i.allocated, i.sellprice,
  #                      (SELECT c.accno FROM chart c
#			 WHERE p.inventory_accno_id = c.id)
#			 AS inventory_accno,
#			(SELECT c.accno FROM chart c
#			 WHERE p.income_accno_id = c.id)
#			 AS income_accno,
#			(SELECT c.accno FROM chart c
#			 WHERE p.expense_accno_id = c.id)
#			 AS expense_accno
#		  FROM invoice i, parts p
#		  WHERE i.parts_id = p.id
#		  AND i.parts_id = $id
#		  AND i.qty < 0
#		  AND (i.qty + i.allocated) < 0
#		  ORDER BY id|;

  my $query = qq|SELECT i.id, i.trans_id, (i.qty) as qty, i.sellprice,i.allocated, 
                        (SELECT c.accno FROM chart c
			 WHERE p.inventory_accno_id = c.id)
			 AS inventory_accno,
			(SELECT c.accno FROM chart c
			 WHERE p.expense_accno_id = c.id)
			 AS expense_accno
		  FROM invoice i, parts p
		  WHERE i.parts_id = p.id
		  AND i.parts_id = $id
		  AND (i.qty + i.allocated) < 0
		  ORDER BY trans_id|;



my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $allocated = 0;
  my $qty;
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
#	  $form->dberror($query.'<br><br>'. $totalqty.' '.$ref->{qty}.' '.$ref->{allocated});
   if (($qty = (($ref->{qty} * -1) - $ref->{allocated})) > $totalqty) {
      $qty = $totalqty;
    }
    $form->update_balance($dbh,
			  "invoice",
			  "allocated",
			  qq|id = $ref->{id}|,
			  $qty);

    # total expenses and inventory
    # sellprice is the cost of the item
    $linetotal = $form->round_amount($ref->{sellprice} * $qty, 2);

    # add to expense
    $form->{amount}{$form->{id}}{$ref->{expense_accno}} += -$linetotal;

    # deduct inventory
    $form->{amount}{$form->{id}}{$ref->{inventory_accno}} -= -$linetotal;

    # add allocated
    $allocated += -$qty;

    last if (($totalqty -= $qty) <= 0);
  }

  $sth->finish;

  $allocated;
  
}



sub reverse_invoice {
  my ($dbh, $form,$dbname) = @_;
  
  # reverse inventory items
  my $query = qq|SELECT i.id, i.parts_id,
                 i.qty, i.assemblyitem, p.assembly,i.lastcost,
		 p.inventory_accno_id
                 FROM invoice i, parts p
		 WHERE i.parts_id = p.id
		 AND i.trans_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    if ($ref->{inventory_accno_id} || $ref->{assembly}) {
 	# update parts table
    	#$query = qq|UPDATE parts SET
	#avgcost = ((avgcost * (onhand)) - ( $ref->{qty} *$ref->{lastcost}))/(onhand-($ref->{qty}))
	#            WHERE id = $ref->{parts_id}|;
	#$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
	
	
      # if the invoice item is not an assemblyitem adjust parts onhand
      unless ($ref->{assemblyitem}) {
	# adjust onhand in parts table
	$form->update_balance($dbh,
			      "parts",
			      "onhand",
			      qq|id = $ref->{parts_id}|,
			      $ref->{qty});
      }

      # loop if it is an assembly
      next if ($ref->{assembly});
      
      # adjust allocated
#      $query = qq|SELECT id, allocated
#                  FROM invoice
#		  WHERE parts_id = $ref->{parts_id}
#		  AND qty < 0
#		  AND allocated > 0
#		  ORDER BY id DESC|;
       $query = qq|SELECT id, trans_id, allocated
                  FROM invoice
		  WHERE parts_id = $ref->{parts_id}
		  AND allocated > 0
		  ORDER BY trans_id DESC|;
 
my $ith = $dbh->prepare($query);
      $ith->execute || $form->dberror($query);
      while (my $inhref = $ith->fetchrow_hashref(NAME_lc)) {
	  $qty = $ref->{qty};
	if (( $ref->{qty} - $inhref->{allocated}) > 0) {
	  $qty = $inhref->{allocated};
	} #else {
	#}
#$form->dberror($qty);
	
	# update invoice
	$form->update_balance($dbh,
			      "invoice",
			      "allocated",
			      qq|id = $inhref->{id}|,
			      $qty * -1);

        last if (($ref->{qty} -= $qty) <= 0);
      }
      $ith->finish;
    }
  }
  
  $sth->finish;
  
  # delete acc_trans
  $query = qq|DELETE FROM acc_trans
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 

  # delete invoice entries
  $query = qq|DELETE FROM invoice
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 
 # $form->dberror($query);
}



sub delete_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check for other foreign currency transactions
  $form->delete_exchangerate($dbh) if ($form->{currency} ne $form->{defaultcurrency});
 
  &reverse_invoice($dbh, $form,$myconfig->{dbname});
  
  # delete AR record
  my $query = qq|DELETE FROM ar
                 WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}



sub retrieve_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  if ($form->{id}) {
    # get default accounts and last invoice number
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                d.curr AS currencies
		FROM defaults d|;
  } else {
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
		       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                d.invnumber, d.curr AS currencies, current_date AS invdate
                FROM defaults d|;
  }
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;


  if ($form->{id}) {

    &get_customer("", $myconfig, $form);

    # retrieve invoice
    $query = qq|SELECT invnumber, ordnumber, transdate AS invdate, paid,
                shippingpoint, terms, notes, duedate, taxincluded,invoiceto,salesperson,
		curr AS currency
		FROM ar
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;

    # get exchangerate
    $form->{exchangerate} = $form->get_exchangerate($dbh, $form->{currency}, $form->{invdate}, "buy");

    # retrieve individual items
    $query = qq|SELECT (SELECT c.accno FROM chart c
                       WHERE p.inventory_accno_id = c.id)
                       AS inventory_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.income_accno_id = c.id)
		       AS income_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.expense_accno_id = c.id)
		       AS expense_accno,
                p.partnumber, i.description, i.qty, i.fxsellprice AS sellprice,i.parts_id,
		i.discount, i.parts_id AS id, i.unit, p.assembly, p.bin,p.notes as partnotes,i.delivery_date,remark2,part_ordnumber,i.lastcost,i.taxincluded
		FROM invoice i, parts p
		WHERE i.parts_id = p.id
		AND i.trans_id = $form->{id}
		AND NOT i.assemblyitem = '1'
		ORDER BY i.id|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
		$j++;

      # get taxes
      $query = qq|SELECT c.accno
                  FROM chart c, partstax pt
		  WHERE pt.chart_id = c.id
		  AND pt.parts_id = $ref->{id}|;
      my $sth = $dbh->prepare($query);
      $sth->execute || $form->dberror($query);
 #$form->dberror($query);
      $ref->{taxaccounts} = "";
      my $taxrate = 0;

      while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{taxaccounts} .= "$ptref->{accno} ";
	$taxrate += $form->{"$ptref->{accno}_rate"};
      }
  ($transtype,$part_ordnumber) = split(/:/, $ref->{part_ordnumber});

          #get Sales order
    $query = qq|select ordnumber as part_ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where vendor_id=0 and oe.id=orderitems.trans_id and ordnumber='$part_ordnumber' and transtype='$transtype' and parts_id=$ref->{id} |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
 #   if($j >1){
#$form->dberror($query);
#}
     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{ord_parts_id} = "$ptref->{ord_parts_id} ";
	$ref->{ord_parts_qty}= "$ptref->{ord_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

          #get last qty
    $query = qq|select part_ordnumber, parts_id as last_parts_id,sum(qty) as last_parts_qty from ar,invoice where  ar.id=invoice.trans_id and part_ordnumber='$ref->{part_ordnumber}' and parts_id=$ref->{id} and trans_id<$form->{id}  group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

#$form->dberror($query);
     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{last_parts_id} = "$ptref->{last_parts_id} ";
	$ref->{last_parts_qty} = "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

      $sth->finish;
      chop $ref->{taxaccounts};

      push @{ $form->{invoice_details} }, $ref;


    }
    $sth->finish;

  } else {

    $form->{shippingpoint} = $myconfig->{shippingpoint};

    # up invoice number by 1
    $form->{invnumber}++;

    # save the new number
    $query = qq|UPDATE defaults
                SET invnumber = '$form->{invnumber}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  }

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}


sub get_customer {
 my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
  my $duedate = ($form->{invdate}) ? "date '$form->{invdate}'" : "current_date";
  my $term = ($form->{terms} ne '') ? "$form->{terms}" : "c.terms";
 # get customer
  my $query = qq|SELECT c.discount, c.creditlimit, $term as terms,c.customernumber,c.customercode,name,
                 c.email, c.taxincluded, salesperson as salesperson,
	         $duedate + $term AS duedate,
		 c.creditlimit - (SELECT SUM(a.amount - a.paid)
		                  FROM ar a
				  WHERE a.customer_id = $form->{customer_id}
		                 ) AS creditremaining
                 FROM customer c
	         WHERE c.id = $form->{customer_id}|;
  my $sth = $dbh->prepare($query);

  $sth->execute || $form->dberror($query);
# $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);

  # if there are no transactions creditlimit - sum returns an empty string
  $ref->{creditremaining} = $ref->{creditlimit} unless $ref->{creditremaining};
  
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;

  # get taxes we charge for this customer
  $query = qq|SELECT c.accno
              FROM chart c, customertax ct
	      WHERE ct.chart_id = c.id
	      AND ct.customer_id = $form->{customer_id}|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  
  my $customertax = ();
  while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
    $customertax{$ref->{accno}} = 1;
  }
  $sth->finish;
    
  # get tax rates and description
  $query = qq|SELECT c.accno, c.description, t.rate, t.taxnumber
	      FROM chart c, tax t
	      WHERE c.id = t.chart_id
	      AND c.link LIKE '%CT_tax%'
	      ORDER BY accno|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  $form->{taxaccounts} = "";
  $form->{taxaccounts_vc} = "";
  while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
      $form->{"$ref->{accno}_rate"} = $ref->{rate};
      $form->{"$ref->{accno}_description"} = $ref->{description};
      $form->{"$ref->{accno}_taxnumber"} = $ref->{taxnumber};
      $form->{taxaccounts} .= "$ref->{accno} ";
    if ($customertax{$ref->{accno}}) {
      $form->{"$ref->{accno}_rate_vc"} = $ref->{rate};
      $form->{"$ref->{accno}_description_vc"} = $ref->{description};
      $form->{"$ref->{accno}_taxnumber_vc"} = $ref->{taxnumber};
      $form->{taxaccounts_vc} .= "$ref->{accno} ";
    }
  }
  $sth->finish;
  chop $form->{taxaccounts};

  $dbh->disconnect;
  
}

sub get_customerid {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);


  # get customer
  my $query = qq|select id as customer_id2 from customer where customernumber = '$form->{AR}'|;
  my $sth = $dbh->prepare($query);

  $sth->execute || $form->dberror($query);
#$form->dberror($form->{selectAR});
  $ref = $sth->fetchrow_hashref(NAME_lc);

  
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;

 

  $dbh->disconnect;
  
}

sub retrieve_orders {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
 
  my $query;

  my $query = qq|SELECT o.id, o.ordnumber, o.transdate as orddate, o.reqdate,
                 o.amount, ct.name, o.netamount, o.$form->{vc}_id,status
	         FROM oe o, $form->{vc} ct
	         WHERE o.$form->{vc}_id = ct.id and status=1 |;
	      
  my $ordnumber = $form->like(lc $form->{ordnumber});

  my $sortorder = join ', ', $form->sort_columns(qw(transdate ordnumber name));
  $sortorder = $form->{sort} unless $sortorder;
  
  $query .= " AND lower(ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= qq| AND $form->{vc}_id = $form->{"$form->{vc}_id"}| if ($form->{"$form->{vc}_id"});
  $query .= " AND transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND transdate <= '$form->{transdateto}'" if $form->{transdateto};
 $query .= " AND transtype = '$form->{ttype}'" if $form->{ttype};
 $query .= " AND status = '$form->{status}'" if $form->{status};
   $query .= " ORDER by $sortorder";
  
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $oe = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{OE} }, $oe;
  }

  $sth->finish;
  $dbh->disconnect;
  
}

sub retrieve_item2 {
  my ( $myconfig, $form,$dbh,$i) = @_;

  
  my $where = "NOT obsolete = '1'";

  if ($form->{"partnumber_$i"}) {
   my $partnumber =  lc $form->{"partnumber_$i"}."%";
  #     my $partnumber = $form->like(lc $form->{"partnumber_$i"});
 $where .= " AND lower(partnumber) LIKE '$partnumber'";
  }
  if ($form->{"description_$i"}) {
    my $description = $form->like(lc $form->{"description_$i"});
    $where .= " AND lower(description) LIKE '$description'";
  }
  if ($form->{"id_$i"}) {
    $where .= " AND p.id =".$form->{"id_$i"};
  }
  if ($form->{"description_$i"}) {
    $where .= " ORDER BY description";
  } else {
    $where .= " ORDER BY partnumber";
  }
  
  
  my $query = qq|SELECT p.id, p.partnumber, p.description, p.sellprice,p.lastcost,
                        p.listprice,
                        (SELECT accno FROM chart c
			WHERE p.inventory_accno_id = c.id)
			AS inventory_accno,
			(SELECT accno FROM chart c
			WHERE p.income_accno_id = c.id)
			AS income_accno,
			(SELECT accno FROM chart c
			WHERE p.expense_accno_id = c.id)
			AS expense_accno,
		 p.unit, p.assembly, p.bin, p.onhand, p.makemodel,taxincluded
                 FROM parts p
	         WHERE combo='f' and  $where|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 # if($i >1){
#$form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # get taxes for part
    $query = qq|SELECT c.accno
                FROM chart c, partstax pt
		WHERE c.id = pt.chart_id
		AND pt.parts_id = $ref->{id}|;
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    $ref->{taxaccounts} = "";
    while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
      $ref->{taxaccounts} .= "$ptref->{accno} ";
    }
    $sth->finish;
    chop $ref->{taxaccounts};

    # get makemodel
    if ($ref->{makemodel}) {
      $query = qq|SELECT name
		  FROM makemodel
		  WHERE parts_id = $ref->{id}|;
      $sth = $dbh->prepare($query);
      $sth->execute || $form->dberror($query);
      
      $ref->{makemodel} = "";
      while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{makemodel} .= "$ptref->{name}:";
      }
      $sth->finish;
      chop $ref->{makemodel};
   }
   


  push @{ $form->{item_list} }, $ref;

  }


  $sth->finish;
}

sub retrieve_item {
  my ($self, $myconfig, $form) = @_;


  # connect to database
  my $dbh = $form->dbconnect($myconfig);
    my $i = $form->{rowcount};
	  &retrieve_item2($myconfig, $form,$dbh,$i);

  $dbh->disconnect;

}



sub retrieve_assemblies {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $where = '1 = 1';
  
  if ($form->{partnumber}) {
    my $partnumber = $form->like(lc $form->{partnumber});
    $where .= " AND lower(partnumber) LIKE '$partnumber'";
  }
  
  if ($form->{description}) {
    my $description = $form->like(lc $form->{description});
    $where .= " AND lower(description) LIKE '$description'";
  }
  $where .= " AND NOT obsolete = '1'";

  # retrieve assembly items
  my $query = qq|SELECT id, partnumber, description, bin, onhand, rop
                 FROM parts
 		 WHERE $where
		 AND assembly = '1'|;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{assembly_items} }, $ref;
  }
  $sth->finish;

  $dbh->disconnect;
  
}


sub restock_assemblies {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);
  
  for my $i (1 .. $form->{rowcount}) {

    $form->{"qty_$i"} *= 1;
    if ($form->{"qty_$i"} != 0) {
      &adjust_inventory($dbh, $form, $form->{"id_$i"}, $form->{"qty_$i"});
    }

  }
  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}




sub adjust_inventory {
  my ($dbh, $form, $id, $qty) = @_;

  my $query = qq|SELECT p.id, p.inventory_accno_id, p.assembly, a.qty
		 FROM parts p, assembly a
		 WHERE a.parts_id = p.id
		 AND a.id = $id|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    my $allocate = $qty * $ref->{qty};

    if ($ref->{assembly}) {
      &adjust_inventory($dbh, $form, $ref->{id}, $allocate);
    }


    # is it a service item, then loop
    $ref->{inventory_accno_id} *= 1;
    unless ($ref->{inventory_accno_id}) {
      next unless $ref->{assembly};
    }


    $allocate *= -1;
    
    # adjust parts onhand
    $form->update_balance($dbh,
			  "parts",
			  "onhand",
			  qq|id = $ref->{id}|,
			  $allocate);

  }

  $sth->finish;

  # update assembly
  $form->update_balance($dbh,
			"parts",
			"onhand",
			qq|id = $id|,
			$qty);


}

sub get_poqty {
  my ($self, $myconfig, $form) = @_;
 my $dbh = $form->dbconnect($myconfig);
$i=$form->{i};
     #get Sales order
  if(!$form->{"id"}){
     $query = qq|select max(id) as id from ap  |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
	$form->{"nid"}=1;
     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"nid"} .= "$ptref->{id} ";
      }

  }else{
		$form->{"nid"}=$form->{"id"};
  }
    ($transtype,$part_ordnumber) = split(/:/, $form->{"part_ordnumber_$i"});

    $query = qq|select ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where vendor_id=0 and oe.id=orderitems.trans_id and ordnumber='$part_ordnumber' and transtype='$transtype' and parts_id=$form->{"id_$i"}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
   #   }
 #  $form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"ord_parts_id_$i"} = "$ptref->{ord_parts_id} ";
	$form->{"ord_parts_qty_$i"} = "$ptref->{ord_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

          #get last qty
    $query = qq|select part_ordnumber , parts_id as last_parts_id,sum(qty) as last_parts_qty from ar,invoice where  ar.id=invoice.trans_id and part_ordnumber='$form->{"part_ordnumber_$i"}' and parts_id=$form->{"id_$i"} and trans_id< $form->{"nid"} group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
#$form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"last_parts_id_$i"} .= "$ptref->{last_parts_id} ";
	$form->{"last_parts_qty_$i"} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";

 }
       $sth->finish;

}
 
 
sub all_price {
  my ($self, $myconfig, $form,$i) = @_;
  
  $form->{"partnumber_$i"} =~ s/'/''/;
  # $form->{"partnumber_$i"} =~ s/"/""/;
   # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|select ar.transdate,invoice.sellprice 
  		from parts,invoice,ar,customer 
		where ar.id=invoice.trans_id and customer.id=ar.customer_id and parts.id=parts_id
		and customernumber='$form->{AR}' and parts.id=$form->{"id_$i"}
		order by transdate desc,ar.id limit 3|;

  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($form->{"id_$i"});
  while (my $ca = $sth->fetchrow_hashref(NAME_lc)) {
   # $form->dberror($query);
    push @{ $form->{"ALLPRICE_$i"} }, $ca;
  }
  $form->{"partnumber_$i"} =~ s/''/'/;
  $sth->finish;
  $dbh->disconnect;
  
}

sub import_item {
  my ($self, $myconfig, $form) = @_;
  
   
  $where="";
	     $where .= " AND transtype like '$form->{ttype}%'" if $form->{ttype};
	     $where .= " AND ordnumber = '$form->{onumber}'" if $form->{onumber};
	     $where .= " AND oe.id = '$form->{oid}'" if $form->{oid};
	  #   $where .= " AND oe.$form->{vc}_id = '".$form->{"o$form->{vc}_id"}."'" if $form->{"o$form->{vc}_id"};

    
  my $dbh = $form->dbconnect($myconfig);
  my $query = qq|select * from parts,oe,orderitems where oe.id=orderitems.trans_id and parts.id=orderitems.parts_id $where|;

  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
#$i=$form->{rowcount};
	#  $form->dberror($query) if $form->{rowcount} >	1;
  while (my $ca = $sth->fetchrow_hashref(NAME_lc)) {
   $form->{"id_$form->{rowcount}"}=$ca->{parts_id};
 #  $form->{"partnumber_$form->{rowcount}"}=$ca->{partnumber};
  $form->{"qty_$form->{rowcount}"}=$ca->{qty};
  $form->{"part_ordnumber_$form->{rowcount}"}=$form->{ttype}.":".$ca->{ordnumber};
#  $form->{"listprice_$form->{rowcount}"}=$ca->{listprice};
#$form->{"sellprice_$form->{rowcount}"} = $ca->{sellprice};

$sellprice = $ca->{sellprice};
#$form->dberror($sellprice);
   &retrieve_item2($myconfig, $form,$dbh,$form->{rowcount});
   
   $i=$form->{rowcount};
   	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };
   $form->{"sellprice_$form->{rowcount}"}=$sellprice;
#$form->dberror($form->{"sellprice_$form->{rowcount}"});

	#pop @{$form->{item_list}};
	delete  $form->{item_list};
	
#$form->dberror($ca->{parts_id});
	$form->{rowcount}++;   
  }
	#$form->{rowcount}--;  
	$sth->finish;
  $dbh->disconnect;

}


 
 sub get_poqty_ap {
  my ($self, $myconfig, $form) = @_;
 my $dbh = $form->dbconnect($myconfig);
$i=$form->{i};
     #get Sales order
  if(!$form->{"id"}){
     $query = qq|select max(id) as id from ap  |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
	$form->{"nid"}=1;
     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"nid"} .= "$ptref->{id} ";
      }

  }else{
		$form->{"nid"}=$form->{"id"};
  }
  
    ($transtype,$part_ordnumber) = split(/:/, $form->{"part_ordnumber_$i"});

    
    $query = qq|select ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where customer_id=0 and oe.id=orderitems.trans_id and ordnumber='$part_ordnumber' and transtype='$transtype' and parts_id=$form->{"id_$i"}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
   #   }
#$form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"ord_parts_id_$i"} = "$ptref->{ord_parts_id} ";
	$form->{"ord_parts_qty_$i"} = "$ptref->{ord_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

          #get last qty
    $query = qq|select part_ordnumber , parts_id as last_parts_id,sum(qty)*-1 as last_parts_qty from ap,invoice where  ap.id=invoice.trans_id and part_ordnumber='$form->{"part_ordnumber_$i"}' and parts_id=$form->{"id_$i"} and trans_id< $form->{"nid"} group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
#$form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$form->{"last_parts_id_$i"} .= "$ptref->{last_parts_id} ";
	$form->{"last_parts_qty_$i"} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";

      $sth->finish;
 }
 

}
1;


