 
#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package salessummary;


sub update_quantity {
  my ($self, $myconfig, $form) = @_;
#$form->dberror($form->{"diff_1"});
  # connect to database
  my $dbh = $form->dbconnect($myconfig);
	    for $x (1 ..  $form->{row}) {
		    my $query = qq| update parts set onhand=onhand-($form->{"diff_$x"}) where id=$form->{"parts_id_$x"}; ;
		      |;
		      
		      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

	    }
  #$sth->finish;


  $dbh->disconnect;
}

sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");

   ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(customer_id) LIKE '$source'";
  }
  
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(description) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $glwhere .= " AND transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND transdate <= '$form->{dateto}'";
  }
  
    if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
 
  
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( partnumber description qty subtotal1 qtykg ));
  my %ordinal = ( partnumber => 6,
                  description => 4,
		  subtotal1 => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq|SELECT parts_id,partnumber,description,sum(qty) as qty ,sum(qtykg) as qtykg,sum(subtotal1) as subtotal1 from invoice_listing where $glwhere
  		 group by partnumber,description,parts_id
	         ORDER BY $form->{sort}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

sub all_transactions3 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");

   ($vendorno, $form->{vendor1}) = split(/--/, $form->{vendorno});
  if ($form->{vendor1}) {
    my $source = $form->like(lc $form->{vendor1});
    $glwhere .= " AND lower(vendor_id) LIKE '$source'";
  }
  
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(description) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $glwhere .= " AND transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND transdate <= '$form->{dateto}'";
  }
  
    if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
 
  
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( partnumber description qty subtotal1 qtykg ));
  my %ordinal = ( partnumber => 6,
                  description => 4,
		  subtotal1 => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq|SELECT parts_id,partnumber,description,sum(qty)*-1 as qty ,sum(qtykg)*-1 as qtykg,sum(subtotal1)*-1 as subtotal1 from vendor_listing where $glwhere
  		 group by partnumber,description,parts_id
	         ORDER BY $form->{sort}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}



sub all_transactions2 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $dtwhere, $dt1where) = ("1 = 1", "select 0 as parts_id ,0 as bf", "1 = 1");

   ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(customer_id) LIKE '$source'";
  }
  
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(description) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $dt1where .= " AND transdate >= '$form->{datefrom}'";
    $dtwhere = "select parts_id ,sum(sin-sout+adjust) as bf from sl where  transdate < '$form->{datefrom}' group by parts_id ";
  }
  if ($form->{dateto}) {
    $dt1where .= " AND transdate <= '$form->{dateto}'";
  }
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}
    if ($form->{make}) {
    my $make = $form->like(lc ":".$form->{make});
    $glwhere .= " AND pid IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND pid IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
 
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( partnumber description qty subtotal1 qtykg ));
  my %ordinal = ( partnumber => 6,
                  description => 4,
		  subtotal1 => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq| select pid as parts_id,partnumber,description,bf,sin,sout,adjust,parts.onhand,lastcost from (select * from (
select * from (
	select * from (
			 select * from (select parts_id as pid,sum(sin-sout+adjust) as qty from sl group by parts_id) as q1
			 full outer join
			($dtwhere) as q2  
			 on (q1.pid=q2.parts_id)
		) as q1
		full outer join
		(select parts_id  ,sum(sin) as sin from sl where $dt1where group by parts_id) as q3
		 on (q1.pid=q3.parts_id)
	) as q1
		full outer join  
		(select parts_id ,sum(sout) as sout from sl where $dt1where group by parts_id) as q4
		 on (q1.pid=q4.parts_id)

) as q1
	full outer join  
	(select parts_id ,sum(adjust) as adjust from sl where $dt1where group by parts_id) as q5
	 on (q1.pid=q5.parts_id)
	 ) as q1,parts where parts.id=q1.pid and $glwhere and parts.inventory_accno_id>0 order by partnumber
	 
	 
	 
	        |;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

1;
