/*-------------------------------------------------------------------------
 *
 * replicate_com.h
 *	  Primary include file for replicate server .c files
 *
 * This should be the first file included by replicate modules.
 *
 *-------------------------------------------------------------------------
 */
#ifndef REPLICATE_COM_H
#define	REPLICATE_COM_H 1

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif
#ifndef _INTTYPES_H
#include <inttypes.h>
#endif
#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

/* default values */
#define DEFAULT_PGLB_PORT	(6001)
#define DEFAULT_PGLB_RECOVERY_PORT	(6101)
#define DEFAULT_PGLB_LIFECHECK_PORT	(6201)
#define DEFAULT_CLUSTER_PORT	(5432)
#define DEFAULT_CLUSTER_RECOVERY_PORT	(7101)
#define DEFAULT_CLUSTER_LIFECHECK_PORT	(7201)
#define DEFAULT_PGRP_PORT	(8001)
#define DEFAULT_PGRP_RECOVERY_PORT	(8101)
#define DEFAULT_PGRP_LIFECHECK_PORT	(8201)
#define DEFAULT_PGRP_RLOG_PORT	(8301)
#define MAX_DB_SERVER	(32)
/**************************
*                         *
*   Packet ID definition  *
*                         *
***************************/
/*=========================
	Replication packet id
===========================*/
#define	CMD_SYS_REPLICATE	'R'
/*-------------------------
	Simple Query
--------------------------*/
#define CMD_STS_SET_SESSION_AUTHORIZATION	'S'
#define	CMD_STS_TRANSACTION	'T'
#define	CMD_STS_TEMP_TABLE	'E'
#define	CMD_STS_QUERY	'Q'
#define	CMD_STS_OTHER	'O'

#define CMD_TYPE_VACUUM	'V'
#define CMD_TYPE_ANALYZE	'A'
#define CMD_TYPE_REINDEX	'N'
#define CMD_TYPE_SELECT	'S'
#define CMD_TYPE_EXPLAIN	'X'
#define CMD_TYPE_SET	'T'
#define CMD_TYPE_RESET	't'
#define CMD_TYPE_INSERT	'I'
#define CMD_TYPE_DELETE	'D'
#define CMD_TYPE_EXECUTE	'U'
#define CMD_TYPE_UPDATE	'U'
#define CMD_TYPE_BEGIN	'B'
#define CMD_TYPE_COMMIT	'E'
#define CMD_TYPE_ROLLBACK	'R'
#define CMD_TYPE_SAVEPOINT	's'
#define CMD_TYPE_ROLLBACK_TO_SAVEPOINT	'r'
#define CMD_TYPE_RELEASE_SAVEPOINT	'l'
#define CMD_TYPE_SESSION_AUTHORIZATION_BEGIN	'a'
#define CMD_TYPE_SESSION_AUTHORIZATION_END	'b'
#define CMD_TYPE_OTHER	'O'

/*----------------------------
	Copy Command
------------------------------*/
#define	CMD_STS_COPY	'C'

#define CMD_TYPE_COPY	'C'
#define CMD_TYPE_COPY_DATA	'd'
#define CMD_TYPE_COPY_DATA_END	'e'

/*----------------------------
	Large Object
------------------------------*/
#define	CMD_STS_LARGE_OBJECT	'L'

#define CMD_TYPE_LO_CREATE	'C'
#define CMD_TYPE_LO_OPEN	'O'
#define CMD_TYPE_LO_WRITE	'W'
#define CMD_TYPE_LO_LSEEK	'S'
#define CMD_TYPE_LO_CLOSE	'X'
#define CMD_TYPE_LO_UNLINK	'U'

/*=========================
	System call packet id
===========================*/
#define CMD_SYS_CALL		'S'

#define	CMD_STS_NOTICE	'N'
#define	CMD_STS_RESPONSE	'R'
#define	CMD_STS_TRANSACTION_ABORT	'A'
#define	CMD_STS_QUERY_SUSPEND	'P'
#define	CMD_STS_QUERY_DONE	'D'

#define CMD_TYPE_COMMIT_CONFIRM	'c'
#define CMD_TYPE_QUERY_CONFIRM	'q'
#define CMD_TYPE_DEADLOCK_DETECT	'd'
#define CMD_TYPE_FRONTEND_CLOSED	'x'

#define PGR_TRANSACTION_SOCKET	(0)
#define PGR_QUERY_SOCKET	(1)

#define	DATA_FREE	(0)
#define	DATA_INIT	(1)
#define	DATA_USE	(2)
#define	DATA_STOP	(3)
#define	DATA_TOP	(10)
#define	DATA_END	(11)
#define	DATA_TEMP_USE	(13)
#define	DATA_NEW	(14)
#define	DATA_ACCEPT	(20)
#define	DATA_ERR_NOTICE	(98)
#define	DATA_ERR	(99)
#define HOSTNAME_MAX_LENGTH     (128)
#define DBNAME_MAX_LENGTH       (128)
#define USERNAME_MAX_LENGTH     (128)
#define TABLENAME_MAX_LENGTH     (128)
#define PATH_MAX_LENGTH        (256)
#define MAX_SERVER_NUM         (128)
#define MAX_RETRY_TIMES	(3)
#define MAX_SOCKET_QUEUE	(10000)
#define TRANSACTION_ERROR_RESULT	"TRANSACTION_ERROR"
#define REPLICATE_SERVER_SHM_KEY (1020)
/* target -> replicate */
#define RECOVERY_PREPARE_REQ	(1)
/* replicate  -> master */
#define RECOVERY_PGDATA_REQ	(2)
/* master -> replicate */
#define RECOVERY_PGDATA_ANS	(3)
/* replicate -> target */
#define RECOVERY_PREPARE_ANS	(4)
/* target -> replicate */
#define RECOVERY_START_REQ	(5)
/* replicate  -> master */
#define RECOVERY_FSYNC_REQ	(6)
/* master -> replicate */
#define RECOVERY_FSYNC_ANS	(7)
/* replicate -> target */
#define RECOVERY_START_ANS	(8)
/* target -> replicate */
#define RECOVERY_FINISH	(9)
#define RECOVERY_ERROR_OCCUPIED	(100)
#define RECOVERY_ERROR_CONNECTION	(101)
#define RECOVERY_ERROR_ANS	(200)
#define REPLICATION_SERVER_INFO_TAG "Replicate_Server_Info"
#define HOST_NAME_TAG	"Host_Name"
#define PORT_TAG	"Port"
#define RECOVERY_PORT_TAG	"Recovery_Port"
#define LIFECHECK_PORT_TAG  "LifeCheck_Port"
#define RSYNC_PATH_TAG	"Rsync_Path"
#define RSYNC_OPTION_TAG	"Rsync_Option"
#define STATUS_LOG_FILE_TAG	"Status_Log_File"
#define ERROR_LOG_FILE_TAG	"Error_Log_File"
#define RECOVERY_INIT	(0)
#define RECOVERY_PREPARE_START	(1)
#define RECOVERY_START	(2)
#define RECOVERY_ERROR	(99)

/* response mode */
#define PGR_FAST_MODE	(0)
#define PGR_NORMAL_MODE	(1)
#define PGR_RELIABLE_MODE	(2)

#define RECOVERY_TIMEOUT	(600)
#ifndef COMPLETION_TAG_BUFSIZE
#define	COMPLETION_TAG_BUFSIZE (128)
#endif

/* replicate log type */
#define FROM_R_LOG_TYPE	(1)
#define FROM_C_DB_TYPE	(2)
#define CONNECTION_SUSPENDED_TYPE	(3)

#define PGR_SYSTEM_COMMAND_FUNC	"PGR_SYSTEM_COMMAND_FUNCTION"
#define PGR_STARTUP_REPLICATION_SERVER_FUNC_NO	(1)
#define PGR_CHANGE_REPLICATION_SERVER_FUNC_NO	(2)
#define PGR_SET_CURRENT_TIME_FUNC_NO	(3)
#define PGR_NOTICE_DEADLOCK_DETECTION_FUNC_NO	(4)
#define PGR_TRANSACTION_CONFIRM_ANSWER_FUNC_NO	(5)
#define PGR_QUERY_CONFIRM_ANSWER_FUNC_NO	(6)
#define PGR_RELIABLE_MODE_DONE_FUNC_NO		(7)
#define PGR_NOTICE_ABORT_FUNC_NO		(8)
#define PGR_GET_OID_FUNC_NO		(9)
#define PGR_SET_OID_FUNC_NO		(10)
#define PGR_CMD_ARG_NUM	(10)
#define PGR_LOCK_CONFLICT_NOTICE_CMD	"PGR_LOCK_CONFLICT_NOTICE_CMD"
#define PGR_DEADLOCK_DETECT_NOTICE_CMD	"PGR_DEADLOCK_DETECT_NOTICE_CMD"
#define PGR_QUERY_DONE_NOTICE_CMD		"PGR_QUERY_DONE_NOTICE_CMD"
#define PGR_QUERY_ABORTED_NOTICE_CMD	"PGR_QUERY_ABORTED_NOTICE_CMD"
#define PGR_RETRY_LOCK_QUERY_CMD	"PGR_RETRY_LOCK_QUERY_CMD"
#define PGR_NOT_YET_REPLICATE_NOTICE_CMD	"PGR_NOT_YET_REPLICATE_NOTICE_CMD"
#define PGR_ALREADY_REPLICATED_NOTICE_CMD	"PGR_ALREADY_REPLICATED_NOTICE_CMD"
#define PGR_NOT_YET_COMMIT		(0)
#define PGR_ALREADY_COMMITTED	(1)

#define COPYBUFSIZ	(4096)
#define MAX_WORDS	(24)
#define MAX_WORD_LETTERS	(48)
#define PGR_MESSAGE_BUFSIZE	(256)
#define INT_LENGTH	(12)
#define PGR_MAX_COUNTER	(0x0FFFFFFF)
#define PGR_GET_OVER_FLOW_FILTER	(0xF0000000)
#define PGR_GET_DATA_FILTER	(0x0FFFFFFF)
#define PGR_SET_OVER_FLOW	(0x10000000)
#define PGR_MIN_COUNTER (0x0000000F)

#define STRCMP(x,y)	(strncmp(x,y,strlen(y)))

/* life check target */
#define SYN_TO_LOAD_BALANCER	(0)
#define SYN_TO_CLUSTER_DB		(1)
#define SYN_TO_REPLICATION_SERVER	(2)
#define LIFE_CHECK_TRY_COUNT	(2)
#define LIFE_CHECK_STOP		(0)
#define LIFE_CHECK_START	(1)

#ifndef HAVE_UNION_SEMUN
union semun {
	int val;
	struct semid_ds *buf;
	unsigned short int *array;
	struct seminfo *__buf;
};
#endif

typedef struct ReplicateHeaderType
{
	char cmdSys;	/*
					R: replication
					S: system call
					C: cascade connection
					L: replication log
					*/
	char cmdSts;	/*
					-- with replication --
						S: session in set session authorization
						E: session in temp table
						C: session in copy
						L: session in large object
						T: session in transaction
						Q: session in simple query
						O: session in others
					-- with system call -- 
						N: notice 
						R: response 
						A: transaction abort
						P: query suspend
						D: query done
					-- with cascade connection -- 
						U: to upper
						L: to lower
					-- with replication log -- 
						q: delete query log
						t: delete transaction log
						r: update query log
						u: update transaction log
					*/
	char cmdType;	/*
					-- with replication --
						-- session in simple query --
						V: vacuum
						A: analyze
						N: reindex
						S: select
						X: explain
						T: set
						t: reset
						I: insert
						D: delete
						U: update/execute
						O: others
						-- session in transaction --
						B: begin
						E: commit/end
						R: rollback
						-- session in set session authorization --
						a: session authorization begin
						b: session authorization end
						-- session in copy --
						C: copy
						d: copy data
						e: copy data end
						-- session in large object --
						C: create lo
						O: open lo
						W: write lo
						S: lseek lo
						X: close lo
						U: unlink lo
					-- with system call -- 
						c: confrim commit done
						q: confrim query done
						d: detect deadlock
						x: front end closed
					-- with cascade connection -- 
						A: add cascade
						D: delete cascade
						F: update all
					*/
	char rlog;		/*
					-- kind of replication log --
						1: send from replication log
						2: send from cluster db (should be retry)
						3: connection suspended
					*/
	uint16_t port;
	uint16_t pid;
	uint32_t query_size;
	char from_host[HOSTNAME_MAX_LENGTH];
	char dbName[DBNAME_MAX_LENGTH];
	char userName[USERNAME_MAX_LENGTH];
	struct timeval tv;
	uint32_t query_id;
	uint32_t request_id;
	uint32_t replicate_id;
} ReplicateHeader;

typedef struct RecoveryPacketType
{
	uint16_t packet_no;	/*	
					1:start recovery prepare
					2:ask pgdata
					3:ans pgdata
					4:send master info
					5:start queueing query
					6:requst fsync
					7:ready to fsync
					8:pepared master
					9:finished rsync
					*/
	uint16_t max_connect;
	uint16_t port;
	uint16_t recoveryPort;
	char hostName[HOSTNAME_MAX_LENGTH];
	char pg_data[PATH_MAX_LENGTH]; 
	char userName[USERNAME_MAX_LENGTH];
} RecoveryPacket;

typedef struct
{
	char table[128];
	int rec_no;
	char key[128];
	char value[128];
	char * last;
	char * next;
} ConfDataType;

typedef struct ReplicateServerInfoType
{
	uint32_t useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	uint16_t portNumber;
	uint16_t recoveryPortNumber;
	uint16_t lifecheckPortNumber;
	uint16_t RLogPortNumber;
	uint32_t sock;
	uint32_t rlog_sock;
	uint32_t replicate_id;
	uint16_t response_mode;
} ReplicateServerInfo;

typedef struct ReplicateNowType
{
	int useFlag;
	int use_seed;
	int use_time;
	int offset_sec;
	int offset_usec;
	struct timeval tp;
} ReplicateNow;

typedef struct ClusterDBInfoType
{
	int status;
} ClusterDBInfo;

typedef struct
{
	uint32_t arg1;
	uint32_t arg2;
	uint32_t arg3;
	char * buf;
} LOArgs;

/*
 * cluster server table
 */
typedef struct {
	uint32_t useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	uint16_t port;
	uint16_t recoveryPort;
	uint16_t lifecheckPort;
	uint32_t hostNum;
}HostTbl;

/*
 * host table for recovery request and
 * load balancer table
 */
typedef struct {
	uint32_t useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	uint16_t port;
	uint16_t recoveryPort;
	uint16_t lifecheckPort;
	int sock;
	int recovery_sock;
} RecoveryTbl;

typedef struct MapTableType
{
	uint32_t *useFlag;
	char *hostName;
	uint16_t  *port;
	uint16_t  *lifecheckPort;
	int sock;
	int status;
	int rec_no;
	pid_t pid;
} MapTable;

/* for watch dog */
typedef struct {
	int SynSemID;
	int MapTableShmid;
	int LifeCheckStartShmid;
	char * LifeCheckStartFlag;
	MapTable * Map_Table;
	int LifeCheckTimeOut;
}PGR_WatchDog_Info;

typedef struct {
	ConfDataType * ConfData_Top;
	ConfDataType * ConfData_End;
	uint16_t LifeCheck_Port_Number;
	uint16_t Recovery_Port_Number;
}PGR_ConfData_Info;

/* for logs */
typedef struct {
	FILE * StatusFp;
	FILE * LogFp;
	char * PGRStatusFileName;
	char * PGRLogFileName;
	int Log_Print;
	int Debug_Print;
}PGR_Log_Info;

/* PGCluster global */
typedef struct {
	PGR_ConfData_Info ConfData_Info;
	PGR_Log_Info Log_Info;
}PGR_Com_Info;

/* in backend/libpq/replicate_com.c */
extern int PGR_Create_Socket_Connect(int * fdP, char * hostName , unsigned short portNumber);
extern void PGR_Close_Sock(int * sock);
extern int PGR_Create_Socket_Bind(int * fdP, char * hostName , unsigned short portNumber);
extern int PGR_Create_Acception(int fd, int * sockP, char * hostName , unsigned short portNumber);
extern int PGR_Free_Conf_Data(void);
extern int PGR_Get_Conf_Data(char * dir , char * fname);
extern void PGRset_recovery_packet_no(RecoveryPacket * packet, int packet_no);
extern unsigned int PGRget_ip_by_name(char * host);
extern void PGRsem_unlock( int semid, int sem_num );
extern void PGRsem_lock( int semid, int sem_num );
extern void PGRwrite_log_file(FILE * fp, const char * fmt,...);
extern void show_debug(const char * fmt,...);
extern void show_error(const char * fmt,...);
extern void PGR_Init_Com_Info(PGR_Com_Info * com_info);

/* in backend/libpq/watch_dog.c */
extern int PGRsyn_init(void);
extern void PGRsyn_quit(void);
extern int PGRmap_to_cluster_tbl(HostTbl * ptr);
extern int PGRmap_to_replication_server_tbl(ReplicateServerInfo * ptr);
extern int PGRmap_to_load_balancer_tbl(RecoveryTbl * ptr);
extern pid_t PGR_ACK_Main(uint16_t port);
extern pid_t PGR_SYN_Main(int syn_target, void * status_tbl);
extern void PGRset_start_life_check(void);
extern void PGRexit_life_check(int sig);
extern void PGRquit_lifecheck_child(int sig);
extern void PGRchild_wait(int sig);

#endif /* REPLICATE_COM_H */
