#!/bin/sh

#############
## Purpose ##
#############

# This script prepares a .tar archive with pgScript files and module.mk files.
# This archive must be untarred into the pgadmin folder of pgAdmin.

#############
## Options ##
#############

# Extensions to include as sources
EXTENSIONS_SRC=( "*.hh" "*.h" "*.cpp" "*.cc" )
# Extensions to include in the distribution
EXTENSIONS_DST=( "*.yy" "*.ll" )

###############
## Functions ##
###############

function scan_directory
{
	for dir in `find "$1" -type d`; do
		# Ignore CVS directories
		if test `expr match "$dir" '.*CVS.*'` -eq 0 \
			-a `expr match "$sub" '.*autom4te.cache.*'` -eq 0 \
			-a `expr match "$sub" '.*deps.*'` -eq 0
		then
			echo -n "+ Exploring $dir... "
			EXTRA_DIST='$(srcdir)/'"${dir#.*\/}/module.mk"
			# Additional files to include in the distribution
			for ext in "${EXTENSIONS_DST[@]}"
			do
				for sub in `find "$dir" -maxdepth 1 -type f -name "$ext"`; do
					EXTRA_DIST="$EXTRA_DIST \\\\\\n\\t"'$(srcdir)/'"${sub#.*\/}"
				done
			done
			FRAGMENT="${dir#.*\/}"
			pgadmin3_SOURCES=""
			SUBDIRS=""
			# Add immediate subdirectories to the SUBDIRS list
			for sub in `find "$dir" -maxdepth 1 -type d`; do
				if test $sub != $dir -a `expr match "$sub" '.*CVS.*'` -eq 0 \
					-a `expr match "$sub" '.*autom4te.cache.*'` -eq 0 \
					-a `expr match "$sub" '.*deps.*'` -eq 0
				then
					SUBDIRS="$SUBDIRS\n"'include $(srcdir)/'"${sub#.*\/}/module.mk"
				fi
			done
			# Extensions to include
			for ext in "${EXTENSIONS_SRC[@]}"
			do
				for sub in `find "$dir" -maxdepth 1 -name "$ext"`; do
					pgadmin3_SOURCES="$pgadmin3_SOURCES \\\\\\n\\t"'$(srcdir)/'"${sub#.*\/}"
				done
			done
			# Write module.mk in the current explored directory
			echo '#######################################################################' > $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '# pgAdmin III - PostgreSQL Tools' >> $dir/module.mk
			echo '# $Id: pgadmin.sh,v 1.6 2008/07/27 16:25:05 pgunittest Exp $' >> $dir/module.mk
			echo '# Copyright (C) 2002 - 2008, The pgAdmin Development Team' >> $dir/module.mk
			echo '# This software is released under the Artistic Licence' >> $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '# module.mk - pgadmin/'"$FRAGMENT"'/ Makefile fragment' >> $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '#######################################################################' >> $dir/module.mk
			echo "" >> $dir/module.mk
			echo -e "pgadmin3_SOURCES +=$pgadmin3_SOURCES" >> $dir/module.mk
			echo "" >> $dir/module.mk
			echo -e "EXTRA_DIST += \\" >> $dir/module.mk
			echo -e "\t$EXTRA_DIST" >> $dir/module.mk
			echo -e "$SUBDIRS" >> $dir/module.mk
			echo "done"
		fi
	done	
}

##################
## Main program ##
##################

echo "Prepares an archive that needs to be untarred into pgAdmin."
echo "Usage: $0"
echo ""

THISDIR=`dirname $0`
PREVDIR="$PWD"

echo -n "cd $THISDIR... "
cd "$THISDIR"
echo "done"
echo ""

# Scan directories and builds module.mk files

scan_directory "include/pgscript"
scan_directory "pgscript"

# Export files for pgAdmin3

echo "+ Tarring and gzipping..."
tar --exclude="Makefile*" --exclude="*cvs*" --exclude="config*" \
	--exclude="stamp*" --exclude="CVS" -cvf pgAdmin3.tar \
	pgscript include/pgscript

gzip -f pgAdmin3.tar
echo "+ Tarred and gzipped"

# Delete temporary module.mk files

echo -n "+ Deleting module.mk files... "
for src in `find "./" -name "*module.mk"`; do
	rm -f $src
done
echo "done"

echo ""
echo -n "cd $PREVDIR... "
cd "$PREVDIR"
echo "done"
