#!/bin/sh

BASE_PATH=`pwd`
ORG_PGPORT=`psql -tA -c "SHOW port" postgres`

## setup test dbcluster
export PGDATA=$BASE_PATH/results/pgdata
export PGPORT=$(($ORG_PGPORT + 1))

mkdir -p $BASE_PATH/results/fini

## start postgres
pg_ctl -w -t 3600 start > $BASE_PATH/results/fini/pg_start.log 2>&1

## uninstall
psql -f uninstall_stats_info.sql -d contrib_regression_stats > $BASE_PATH/results/fini/uninstall.log 2>&1

psql -f ../target_db/uninstall_target_db.sql -d contrib_regression_target1 >> $BASE_PATH/results/fini/uninstall.log 2>&1
psql -f ../target_db/uninstall_target_db.sql -d contrib_regression_target2 >> $BASE_PATH/results/fini/uninstall.log 2>&1
psql -f ../target_db/uninstall_target_db.sql -d contrib_regression_target3 >> $BASE_PATH/results/fini/uninstall.log 2>&1

psql -c "\d statsinfo.*" -d contrib_regression_stats

psql -c "\d targetdb.*" -d contrib_regression_target1
psql -c "\d targetdb.*" -d contrib_regression_target2
psql -c "\d targetdb.*" -d contrib_regression_target3

## uninstall error check
grep -i error $BASE_PATH/results/fini/uninstall.log
if [ $? -eq 1 ]; then
	echo "error was not found."
fi
grep -i fatal $BASE_PATH/results/fini/uninstall.log
if [ $? -eq 1 ]; then
	echo "fatal was not found."
fi

## stop postgres
pg_ctl stop > $BASE_PATH/results/fini/pg_stop.log 2>&1
