/* $Id: error.c,v 1.8 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * imp/src/error.c,v 1.4 2004/12/15 12:57:52 flaw
 * if/src/error.c,v 1.4 2004/09/28 15:34:07 flaw
 *//*
 * Postgres error Python exception
 */
#include <postgres.h>
#include <utils/elog.h>
#include <utils/memutils.h>
#include <pypg/postgres.h>
#include <pypg/environment.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/externs.h>
#include <pypg/error.h>

PyObj
PyErr_FromErrorData(ErrorData *ed)
{
	PyObj ob, rob, exc, args, kw;

	ob = PyInt_FromLong(ed->sqlerrcode);
	if (ob == NULL) return(NULL);

	exc = Py_Call(PyPgErrorLookup, ob);
	if (exc == NULL)
	{
		DECREF(ob);
		return(NULL);
	}

	kw = PyDict_New();
	PyDict_SetItemString(kw, "code", ob);
	Py_DECREF(ob);

	args = PyTuple_New(1);
	ob = PyString_FromString(ed->message);
	PyTuple_SET_ITEM(args, 0, ob);

	if (ed->hint)
	{
		ob = PyString_FromString(ed->hint);
		PyDict_SetItemString(kw, "hint", ob);
		Py_DECREF(ob);
	}

	if (ed->context)
	{
		ob = PyString_FromString(ed->context);
		PyDict_SetItemString(kw, "context", ob);
		Py_DECREF(ob);
	}

	if (ed->detail)
	{
		ob = PyString_FromString(ed->detail);
		PyDict_SetItemString(kw, "detail", ob);
		Py_DECREF(ob);
	}

	rob = PyObject_Call(exc, args, kw);
	Py_DECREF(args);
	Py_DECREF(kw);

	return(rob);
}

void
PyErr_SetPgError(void)
{
	ErrorData *ed;
	PyObj exc, err;
	MemoryContextSwitchTo(TopMemoryContext);
	ed = CopyErrorData();
	FlushErrorState();
	err = PyErr_FromErrorData(ed);
	if (err != NULL)
	{
		exc = PyObject_GetAttrString(err, "__class__");
		PyErr_SetObject(exc, err);
		Py_DECREF(exc);
	}
	FreeErrorData(ed);
}
/*
 * vim: ts=3:sw=3:noet:
 */
